function results= Stochastic_Copula_MLE(u,v,copula)
%estimates various copulas with a stochastically time-varying parameter by
%efficient importance sampling.
% Input: T)wo uniform data series u and v.
%        a choice variable for which copula to estimate:
%        1 = Gumbel copula
%        2 = Clayton copula
%        3 = Normal Copula
%        4 = Frank Copula
%        5 = rotated Gumbel Copula
%        6 = rotated Clayton Copula
% Output: Name of the chosen model, parameter estimates, standard errors
% calculated as the root of the inverse of the Hessian, value of the
% log-likelihood function, approximate p-value of the LR-test against
% parameter constancy (in fact the simulted critical values should be used,
% but they are very close to the ones of the chi square distribution), the
% path of the latent dependence process, and the Hessian matrix

%Hans Manner, Louvain-la-Neuve, 22.9.2008
N=100;
options = optimset('LargeScale','off','display','off');

if copula == 1
    [theta,logl,exitflag,output,grad,hessian] = fminunc(@(theta)LL_Gumbel_EIS(u,v,theta,N), [-0.05 0.98 0.05],options);
    [theta1 loglres] = fminunc(@(theta)MLEFnGumbel(u,v,theta), 1.5,options);
    LR=2*(loglres-logl);
    pval=1-chi2cdf(LR,1);
    [f path]=LL_Gumbel_EIS(u,v,theta,N);
    model='Gumbel';
elseif copula == 2
    [theta,logl,exitflag,output,grad,hessian] = fminunc(@(theta)LL_Clayton_EIS(u,v,theta,N), [0.01 0.98 0.1],options);
    %[theta1,logl] = fmincon(@(theta)LL_Clayton_EIS(u,v,theta,N),[-0.05 0.97 0.1],[],[],[],[],[-0.3 0.95 0.01],[0.3 0.999 0.2],[],options);
    [theta1 loglres] = fminunc(@(theta)MLEFnClayton(u,v,theta), 1.5,options);
    LR=2*(loglres-logl);
    pval=1-chi2cdf(LR,1);
    [f path]=LL_Clayton_EIS(u,v,theta,N);
    model='Clayton';
elseif copula == 3
    [theta,logl,exitflag,output,grad,hessian] = fminunc(@(theta)LL_Normal_EIS(u,v,theta,N), [0.02 0.9 0.1],options);%
   
    [theta1 loglres] = fminunc(@(theta)MLEFnNormal(u,v,theta), -0.5,options);
    LR=2*(loglres-logl);
    pval=1-chi2cdf(LR,1);
    [f path]=LL_Normal_EIS(u,v,theta,N);
    model='Normal';
elseif copula == 4
    [theta,logl,exitflag,output,grad,hessian] = fminunc(@(theta)LL_Frank_EIS(u,v,theta,N), [0.0043 0.9990 0.5243],options);
    [theta1 loglres] = fminunc(@(theta)MLEFnFrank(u,v,theta), 4,options);
    LR=2*(loglres-logl);
    pval=1-chi2cdf(LR,1);
    [f path]=LL_Frank_EIS(u,v,theta,N);
    model='Frank';
elseif copula == 5
    u=1-u;
    v=1-v;
    [theta,logl,exitflag,output,grad,hessian] = fminunc(@(theta)LL_Gumbel_EIS(u,v,theta,N), [0.05 0.9	0.1],options);
    [theta1 loglres] = fminunc(@(theta)MLEFnGumbel(u,v,theta), 1.5,options);
    LR=2*(loglres-logl);
    pval=1-chi2cdf(LR,1);
    [f path]=LL_Gumbel_EIS(u,v,theta,N);
    model='rotated Gumbel';
elseif copula == 6
    u=1-u;
    v=1-v;
    [theta,logl,exitflag,output,grad,hessian] = fminunc(@(theta)LL_Clayton_EIS(u,v,theta,N), [0.0518 0.9458 0.2140],options);  
    [theta1 loglres] = fminunc(@(theta)MLEFnClayton(u,v,theta), 1.5,options);
    LR=2*(loglres-logl);
    pval=1-chi2cdf(LR,1);
    [f path]=LL_Clayton_EIS(u,v,theta,N);
    model='rotated Clayton';

end;
    
results.model=model;
results.theta = theta;
results.stderr = sqrt(diag(inv(hessian)))';
results.logl = -logl;   
results.LRpval = pval;
results.path=path;
results.hessian=hessian;
    
    
    