function results=SV_MLE_EIS(r,model)
%estimates a standard stochastic volatility model by efficient importance
%sampling with the method by Liesenfeld and Richard (2003). The EIS code is
%basically a copy of their Gauss code.
%Don't forget to multiply returns by 100!
%If you want filtered variance set the variable "filtered" equal to one. 
%normal sv: model=1
%Student sv: model =2
tic;
N=50;  %this may be varied, but usually 30 is enough (maybe not!)
T=rows(r);

options = optimset('LargeScale','off','display','off');
if model ==1
[theta,logl,exitflag,output,grad,hessian] = fminunc(@(theta)LL_SV_EIS(r,theta,N), [0.02 0.97 0.2],options);


% end;
[f path]=LL_SV_EIS(r,theta,N);
elseif model==2
[theta,logl,exitflag,output,grad,hessian] = fminunc(@(theta)LL_SV_STUDENT_EIS(r,theta,N), [-0.0054 0.9731 0.2078 5],options);
% 
% if filtered ==1
%     filtered_path=zeros(T+1,1);
% for t=2:T+1
%     filtered_path(t)=SV_filter_Student(r(1:t-1),theta,N);
%     
% end;
% results.variances=filtered_path(1:T);
%end;
[f path]=LL_SV_STUDENT_EIS(r,theta,N);

  
end;
results.theta=theta;
results.stderr = sqrt(diag(inv(hessian)))';
results.logl=-logl;
results.hessian=hessian;
%
results.path=path;

