function F = PdfNormal(u,v,theta)

%Returns the pdf of the Normal Copula for the uniform random variables u and
%v. 
u(u>0.999999999999999)=0.999999999999999;  %this avoid numerical problems when u or v is equal to 0 or 1 (not a problem very often)
v(v>0.999999999999999)=0.999999999999999;

u(u<0.000000000000000000000001)=0.000000000000000000000001;  
v(v<0.000000000000000000000001)=0.000000000000000000000001;

utilde = norminv(u,0,1);
vtilde = norminv(v,0,1);
a = 1./(sqrt(1-theta.^2));
b=theta./(1-theta.^2);
c=(theta.^2)./(2-2*theta.^2);

F = a.*exp( b.*utilde.*vtilde-c.*(utilde.^2+vtilde.^2) );




 