function F = PdfGumbel(u,v,alpha)

%Returns the pdf of the Gumbel Copula for the uniform random variables u and
%v. 

utilde = -log(u);
vtilde = -log(v);
w = utilde.^alpha + vtilde.^alpha;
beta = 1./alpha;
cdf = exp(-(w.^beta));
pdf = ((utilde.*vtilde).^(alpha-1)).*((w.^beta)+alpha-1)./(w.^(2-beta))./(u.*v);

F = pdf.*cdf;
F(isnan(F))=1;


