function F = PdfFrank(u,v,theta)

%Returns the pdf of the Frank Copula for the uniform random variable u and
%v. 

numerator = exp((1+u+v).*(theta)).*(((-1)+exp(theta))).*(theta); 
denominator = (exp(theta)+exp((u+v).*theta)-exp(theta+u.*theta)-exp(theta+v.*theta)).^2;

F = numerator./denominator; 



 