function [f path] = LL_SV_STUDENT_EIS(r, theta, N)
%gives the value of the negative log-likelihood function of an AR(1)
%stochastic volatility model with Student t errors using efficient importance sampling
%Basically a translation of the Gauss program by Roman Liesenfeld!
%Hans Manner, Louvain-la-Neuve, 9.9.2008

r=r-mean(r);   %demean
iterations=6;  %number of iterations used to draw trajectories

    seed=100;

ga=theta(1);
de=theta(2);
nu=theta(3);

df=theta(4);
%penalty for parameter values at the boundary
if abs(ga) >0.2||abs(de)>0.9999||nu<0.0001
    f=10000;
else
    
T=rows(r);


%Step 0: generate trajectories of theta_t from the natural sampler
la=zeros(T+1,N);                %"la" is the underlying process for the copula dependence parameter
randn('state',seed);            
crn=randn(T+1,N);               %always use the same random number when optimizing. otherwise it will not be a smooth function
eps=nu*crn;
la(1,:)=ga/(1-de);

for j=2:T+1
    la(j,:)=ga+de*la(j-1,:)+eps(j,:);       
end;



for jj=1:iterations
%Step t: solve back-recursive problem by LS
lnxsi=zeros(N,1);
a1=zeros(T,1);
a2=zeros(T,1);

ap=zeros(T,1);
q=zeros(T,1);
av=zeros(T,1);

for t=T:-1:1
    
    x=[ones(N,1) la(t+1,:)' la(t+1,:).^2']; 
    y=(-0.5*la(t+1,:)+log((1+(r(t).^2.*exp(-la(t+1,:)))./(df)).^(-(df+1)/2)))'+lnxsi;%df-2 is used in the paper, but does not work
    
    est=inv(x'*x)*x'*y;
    a1(t)=est(2);
    a2(t)=est(3);
    E1=ga+de*la(t,:);
    V2=(nu^2)/(1-2*(nu^2)*est(3));
    E2=V2*((E1/(nu^2))+est(2));%-0.5
    
    lnxsi=(0.5*(((E2.^2)/V2)-((E1.^2)/(nu^2))))';
    
    ap(t)=V2*((ga/(nu^2))+est(2));%-0.5
    q(t)=(V2/(nu^2))*de;
    av(t)=V2;
%     %calculate the R^2
%     yhat = x*est;
%     resid = y - yhat;
%     sigu = resid'*resid;
%     ym = y - mean(y);
%     rsqr1 = sigu;
%     rsqr2 = ym'*ym;
%     R2 = 1.0 - rsqr1/rsqr2; % r-squared  (seems to be always one)
    
end;

%Step T+1: draw N trajectories of lambda from m-function (including
%iteration steps)
for j=2:T+1
    la(j,:)=ap(j-1)+q(j-1)*la(j-1,:)+sqrt(av(j-1)).*crn(j,1:N);
end;
end;%(here the iteration ends)


%now calculate the average of the log-likelihood

mu1s=(la(2:T+1,:)-sqrt(av*ones(1,N)).*crn(2:T+1,:)).^2;
mu0s=(ga+de*la(1:T,:)).^2;

lnxsi=0.5*((mu1s./(av*ones(1,N)))-(mu0s/(nu^2)));

a=gammaln((df+1)/2)-gammaln(df/2)-0.5*log(df*pi)-0.5*log(nu^2)+0.5*log(av);

b=-0.5*la(2:T+1,:)-0.5*(df+1)*log((1+(r.^2*ones(1,N).*exp(-la(2:T+1,:)))./(df)))...%df-2 is used in the paper, but does not work
   -(a1*ones(1,N)).*la(2:T+1,:)-(a2*ones(1,N)).*(la(2:T+1,:).^2)+lnxsi;

lng=a*ones(1,N)+b;

scal1=mean(lng);    %these lines because mean of log is not equal to log of mean???
scal2=mean(scal1);
lngs=(-scal2+lng);
tg1=log(mean(exp(sum(lngs))));
f=T*scal2+tg1;
f=-f;

% LL=sum(lng);
% f=-mean(LL);
path=mean(exp(la(2:T+1,:)'));

end;