function [f path]=LL_Frank_EIS(u,v,theta,N)
%computes the log-likelihood of the stochastic Frank copula by efficient
%importance sampling using results from Liesenfeld and Richard (2003)
%seed is the variable for the random number generation, so as to use the
%same one always
iterations=5;  %number of iterations used to draw trajectories

seed=100;

ga=theta(1);     %set parameters ("ga" is the intercept, "de" the AR coefficient and "nu" the error standard deviation
de=theta(2);
nu=theta(3);
%nu=0.82*sqrt(1-de);
%nu=0.1;
%ga=thetabar-de*thetabar;

T=rows(u);

    
ap=zeros(T,1);     %initialize parameters for importance sampler
q=zeros(T,1);
av=zeros(T,1);

%penalty for parameter values at the boundary or rather extrem values to
%ensure stability of numerical procedures
if abs(ga>1)||abs(de)>0.999999||nu<0.001||nu>1
    f=10000;
else


%Step 0: generate trajectories of theta_t from the natural sampler
la=zeros(T+1,N);                %"la" is the underlying process for the copula dependence parameter
randn('state',seed);            
crn=randn(T+1,N);               %always use the same random number when optimizing. otherwise it will not be a smooth function
eps=nu*crn;
la(1,:)=ga/(1-de);

for j=2:T+1
    la(j,:)=ga+de*la(j-1,:)+eps(j,:);       
end;



for jj=1:iterations
%Step t: solve back-recursive problem by LS
lnxsi=zeros(N,1);         
a1=zeros(T,1);
a2=zeros(T,1);

for t=T:-1:1
    
    x=[ones(N,1) la(t+1,:)' la(t+1,:).^2']; 
    y=log(PdfFrank(u(t),v(t),la(t+1,:)))'+lnxsi;     %here I simply inserted the log of the Frank pdf as dependent variable
    
    est=inv(x'*x)*x'*y;
    a1(t)=est(2);
    a2(t)=est(3);

    E1=ga+de*la(t,:);              %parameters for the xsi function
    V2=(nu^2)/(1-2*(nu^2)*est(3));
    E2=V2*((E1/(nu^2))+est(2));%-0.5
    
    lnxsi=(0.5*(((E2.^2)/V2)-((E1.^2)/(nu^2))))';%-0.5*log(nu^2)+0.5*log(V2)
    
    ap(t)=V2*((ga/(nu^2))+est(2));%-0.5
    q(t)=(V2/(nu^2))*de;
    av(t)=V2;
%     %calculate the R^2
%     yhat = x*est;
%     resid = y - yhat;
%     sigu = resid'*resid;
%     ym = y - mean(y);
%     rsqr1 = sigu;
%     rsqr2 = ym'*ym;
%     R2(t) = 1.0 - rsqr1/rsqr2; % r-squared  (seems to be always one)
    
end;

% mean(R2)


%Step T+1: draw N trajectories of lambda from m-function (including
%iteration steps)
for j=2:T+1
    la(j,:)=ap(j-1)+q(j-1)*la(j-1,:)+sqrt(av(j-1)).*crn(j,1:N);    %data drawn from the importance sampler m
end;
    if mean(mean(isnan(la)))>0   %activate this part when there are numerical problems creating many warnings
        f=10000;
        return
    end;

end;%(here the iteration ends)


%now calculate the average of the log-likelihood

mu1s=(la(2:T+1,:)-sqrt(av*ones(1,N)).*crn(2:T+1,:)).^2;   %parameters for xsi
mu0s=(ga+de*la(1:T,:)).^2;

lnxsi=0.5*((mu1s./(av*ones(1,N)))-(mu0s/(nu^2)));



%now calculate the average of the log-likelihood
CL=zeros(T,N);
for i=1:N
numerator = exp((1+u+v).*(la(2:T+1,i))).*(((-1)+exp(la(2:T+1,i)))).*(la(2:T+1,i)); 
denominator = (exp(la(2:T+1,i))+exp((u+v).*la(2:T+1,i))-exp(la(2:T+1,i)+u.*la(2:T+1,i))-exp(la(2:T+1,i)+v.*la(2:T+1,i))).^2;

CL(:,i) = log(numerator./denominator)-(a1).*la(2:T+1,i)-(a2).*(la(2:T+1,i).^2)-0.5*log(nu^2)+0.5*log(av)+lnxsi(:,i); 

end;
scal1=mean(CL);    %these lines because mean of log is not equal to log of mean
scal2=mean(scal1);
lngs=-scal2+CL;
tg1=log(mean(exp(sum(lngs))));
f=T*scal2+tg1;

f=-f;   %this is the output
path=mean(la(2:T+1,:)')';

end;













