#include <ctype.h>
#include <io.h>
#include <malloc.h>
#include <math.h>
#include <mem.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#pragma intrinsic

extern char *AppName    = "HRSPrep";
extern char *AppTitle   = "HRS Input Preperation";
extern char *AboutTitle = "HRS Prep";
extern char *AboutDate  = "Oct 2000";


struct persdata
{ int   caseid;
  int   vint;
  int   ed;
  int   enjoysp;
  int   hlthage;
  int   lftage;
  int   fretage;
  float earnings[50];
  };

struct srmdata
{ int    obs;
  int    race;
  struct persdata wifevars;
  struct persdata husbvars;
  double weight;
  };

struct respdata
{ int    caseid;
  int    matchid;
  int    vint;
  int    gender;
  int    race;
  int    ed;
  int    enjoysp;
  int    hlthage;
  int    lftsurv;
  int    lftage;
  int    fretage;
  int    ftwork[5];
  int    survage[5];
  int    windfallflag;
  int    penstartdate[5];
  int    penenddate[5];
  int    penhours[3];
  int    ncpensyear;
  float  ncpensamt;
  float  pencontrib;
  float  earnings[101];
  float  ssearnings[101];
  float  penaccrual[101];
  double weight;
  struct
  { char married;
    char sameSpouse;
    char goodCareer;
    char goodAge;
    char goodEarnings;
    char goodSSstatus;
    char goodFTyears;
    char goodSSearn;
    char goodPens;
    char spouseIntv;
    char goodSpouse;
    } goodobs;
  };


  /* routines in winshell.c */
void  wnprintf(char *, ...);
void  eprintf(char *, ...);
void  wnscanf(char *, char *, ...);
void  getPassword(char *);
void  pause(void);
void  checkMessages(void);
void  error(char *);

  /* routines in hrsprep */
void  mainprog(void);
void  getRespVars(struct respdata *);
void  getEarnings(struct respdata *);
float ncpencalc(int, int, int, int, float *);
void  getPensions(struct respdata *);
void  initPensions(void);
void  combineSpouses(struct respdata *, struct srmdata *, int *);
void  pensCalc(void *);
int   pensComp(const void *, const void *);
float medianCalc(float *, int);
int   medianComp(const void *, const void *);
void  sscalc(int, struct respdata *, struct respdata *, int *, float *, float *, float *);
float getSocialSecurityPIA(int, int, int, float *, int, int, int, float *);
float getSocialSecurityPV(int, int, int, int, float, float,
        int, int, int, float, float);
void  printTabs(struct respdata *, int, struct srmdata*);
void  writeData(int, struct srmdata *);
float wagecalc(int, int, int, int, int);
void  getSSrec(int, int *, int *, float *);
void  initSSdata(int *, unsigned char *);
void  encrypt(int, char *, char *);
void  getSurvivalRates(int, int, float *);
int   eval(int, int);
int   evals(int, char *);
void  dictinit(int (*)[2], char (*)[12]);
int   dictcomp(const void *, const void *);


char  rec[52238];
int   printcaseid = 99999;

/*---------------------------------------------------------------------------
			 MAINPROG
			 creates the input data for the structural estimation
  ---------------------------------------------------------------------------*/

void mainprog()
{ int   recno, nobs;

  static struct respdata respvars[12652];
  static struct srmdata srmvars[10000];

  FILE *infile;
  int handle;

  infile = fopen("g:\\hrs92-00.dat", "rb");
  handle = fileno(infile);

  for (recno = 0; recno < 12652; recno++)
  { if (recno % 250 == 0)
    eprintf(".");

    read(handle, rec, 52238);
    /* memset(&rec[37148], 0, 15089);      ** zeros out 2000 variables */

    if (respvars->caseid == printcaseid)
    wnprintf("\n%d", recno);

    getRespVars(&respvars[recno]);
    getEarnings(&respvars[recno]);
    /* respvars[recno].goodobs.goodPens = 1;  ******************/

    checkMessages();
    }

  fclose(infile);

  getPensions(respvars);
  combineSpouses(respvars, srmvars, &nobs);

  wnprintf("\n\nNumber of couple observations: %d", nobs);

  printTabs(respvars, nobs, srmvars);
  pause();
  writeData(nobs, srmvars);

  }



/*---------------------------------------------------------------------------
			 GET RESP VARS
			 gets the variables for each respondent
  ---------------------------------------------------------------------------*/

void getRespVars(
  struct respdata *respvars)

{ int   surv;
  int   age, curage;
  int   birthmonth, birthyear;
  int   race;
  int   intv, moved;
  int   famresp, finresp, resptype;
  int   marstat, marend, prevmar, newsp, samesp;
  int   intvyear, intvmonth;
  int   srret, enjoysp;
  int   curjob, longjob, pensjob, secondpensjob;
  int   everworked, nlfperiod;
  int   selfempl, nhours;
  int   year, startyear, endyear;
  int   firstyear, lastyear, allyears, ftyears;
  int   jobno, gtype, govtjob;
  int   hlthage, healthchange;
  int   yearcount, ftcount, lftsurv, lftage, fretage;
  int   sempl;
  int   ssdisab1, ssdisab2, ssdisab3, ssdisab4, ssdisab5, disability;

  int   pastft[101];
  int   survey[5], survage[5], health[5];
  int   work[5], hours[5], ftwork[5], ssdisab[5];

  respvars->goodobs.married     = 1;
  respvars->goodobs.sameSpouse  = 1;
  respvars->goodobs.goodCareer  = 1;
  respvars->goodobs.goodAge     = 1;

  respvars->caseid  = eval(1, 1);
  respvars->matchid = eval(1, 3);

  birthmonth = eval(1, 42);
  birthyear  = eval(1, 44);

  if (birthyear > 1992)
  { birthyear = eval(2, 214);

    if (birthyear < 1900 || birthyear > 1992)
    { curage = eval(1, 46);

      if (0 < curage && curage < 99)
      birthyear = 1992 - curage;
      else
      { curage = eval(2, 104);

        if (0 < curage && curage < 99)
        birthyear = 1994 - curage;
        }
      }
    }

  if (birthmonth < 1 || birthmonth > 12)
  { birthmonth = eval(2, 212);

    if (birthmonth < 0)
    birthmonth = 99;
    }

  respvars->vint = birthyear;

  respvars->gender = eval(1, 47);

  race = eval(1, 48);

  if      (race == 2) respvars->race = 2;            /* black    */
  else if (race == 5) respvars->race = 3;            /* hispanic */
  else                respvars->race = 1;            /* white    */

  respvars->ed = eval(1, 207);

  srret = eval(1, 4901);           /* K1: self-reported retirement status */

  if (srret == 1)
  enjoysp = eval(1, 4926);         /* K11d: enjoys retirement with spouse */
  else enjoysp = eval(1, 5013);    /* K21d: enjoys retirement with spouse */

  if (enjoysp == 1)                /* very important category */
  respvars->enjoysp = 1;
  else respvars->enjoysp = 0;


  /* check to see what waves are available */

  survey[0] = 1;

  intv = evals(2, "W2MODEIW");     /* 94 interview */
  moved = eval(2, 109);            /* why moved out: 11 = deceased */

  if (intv > 0 && moved != 11)
  survey[1] = 1;
  else survey[1] = 0;

  famresp = eval(3, 376);          /* 96 interview */
  finresp = eval(3, 377);

  if (famresp > 0 || finresp > 0)
  survey[2] = 1;
  else survey[2] = 0;

  resptype = eval(4, 644);         /* 98 interview: family/financial type */

  if (resptype > 0)
  survey[3] = 1;
  else survey[3] = 0;

  famresp = eval(5, 759);          /* 2000 interview */
  finresp = eval(5, 760);

  if (famresp > 0 || finresp > 0)
  survey[4] = 1;
  else survey[4] = 0;

  if (respvars->caseid == printcaseid)
  wnprintf(" %1d%1d%1d%1d%1d", survey[0], survey[1], survey[2], survey[3], survey[4]);


  /* check to insure continuous marriage */

  marstat = eval(1, 225);        /* A10: 1992 marital status */

  if ((2 <= marstat && marstat <= 6) || marstat == 9)
  { respvars->goodobs.married = 0;
    respvars->goodobs.sameSpouse = 0;
    }
  else
  { prevmar = eval(1, 239);      /* A11: married before ? */
    marend = eval(1, 243);       /* A15: year previous marriage started */

    if (prevmar == 2 && (birthyear + 35 < marend && marend <= 1993))
    respvars->goodobs.sameSpouse = 0;
    }

  marstat = eval(2, 200);        /* A1: 1994 marital status */

  if (marstat == 0 || (2 <= marstat && marstat <= 6) || marstat == 9)
  respvars->goodobs.sameSpouse = 0;
  else
  { newsp = eval(2, 112);        /* New spouse */

    if (newsp == 1)
    respvars->goodobs.sameSpouse = 0;
    }

  marstat  = evals(3, "E256A");    /* 1996 marital status */

  if (marstat == 0 || (3 <= marstat && marstat <= 6) || marstat >= 8)
  respvars->goodobs.sameSpouse = 0;
  else
  { resptype = eval(3, 220);      /* R1/R2 */

    if (resptype == 1)
    { samesp = eval(3, 226);      /* CS4: same spouse? */

      if (samesp == 5)
      respvars->goodobs.sameSpouse = 0;
      }
    }

  marstat  = eval(4, 547);        /* 1998 marital status */

  if (marstat == 0 || marstat >= 4)
  respvars->goodobs.sameSpouse = 0;
  else
  { resptype = eval(4, 475);      /* R1/R2 */

    if (resptype == 1)
    { samesp = eval(4, 502);      /* CS4: same spouse? */

      if (samesp == 5)
      respvars->goodobs.sameSpouse = 0;
      }
    }

  marstat  = eval(5, 758);        /* 2000 marital status */

  if (marstat == 0 || marstat >= 4)
  respvars->goodobs.sameSpouse = 0;
  else
  { resptype = eval(5, 506);      /* R1/R2 */

    if (resptype == 1)
    { samesp = eval(5, 543);      /* CS4: same spouse? */

      if (samesp == 5)
      respvars->goodobs.sameSpouse = 0;
      }
    }

  if (respvars->caseid == printcaseid)
  wnprintf(" %1d", respvars->goodobs.sameSpouse);

  /* check to see if worked full time after 50 and half of years since 40 */

  memset(pastft, 0, 101 * sizeof(int));

  curjob = eval(1, 2717);

  if (curjob == 1 || curjob == 2)  /* Current job: Section F questions */
  { selfempl = eval(1, 2718);

	 if (selfempl == 2)
	 selfempl = 1;
	 else selfempl = 0;

	 startyear = eval(1, 2816 +  18 * selfempl);
	 nhours    = eval(1, 2722 + 100 * selfempl);

	 if (max(1920, birthyear) <= startyear && startyear <= 1993
     && (nhours <= 0 || nhours > 30))
	 for (year = startyear; year <= 1992; year++)
	 pastft[year - birthyear] = 1;
    }

  everworked = eval(1, 3401);       /* ever worked             */
  nlfperiod = eval(1, 3404);        /* worked in last 20 years */

  if ((curjob < 1 || curjob > 2) && (everworked == 1 && nlfperiod == 2))
  { selfempl = eval(1, 3405);       /* Last job: Section G questions */

	 if (selfempl == 2)
	 selfempl = 1;
	 else selfempl = 0;

	 startyear = eval(1, 3418 + 24 * selfempl);
	 endyear   = eval(1, 3403);
	 nhours    = eval(1, 3408 + 25 * selfempl);

	 if (max(1910, birthyear) <= startyear && startyear <= 1993
     && 1910 <= endyear && endyear <= 1993 && (nhours <= 0 || nhours > 30))
	 for (year = startyear; year <= endyear; year++)
    pastft[year - birthyear] = 1;
    }

  longjob = eval(1, 3601);

  if (longjob == 1)          /* previous 5 year job */
  { startyear = eval(1, 3604);
	 endyear = eval(1, 3607);
	 nhours = eval(1, 3608);

	 if (max(1920, birthyear)  <= startyear && startyear <= 1993
	  && 1920 <= endyear && endyear <= 1993 && (nhours <= 0 || nhours > 30))
	 for (year = startyear; year <= endyear; year++)
    pastft[year - birthyear] = 1;

    pensjob = eval(1, 3702);

    if (pensjob == 1)                /* H23: Any other jobs with pensions? */
    { startyear = eval(1, 3704);     /* H25: When did you start this job? */
	   endyear   = eval(1, 3705);     /* H26: And when did you leave? */

	   if (max(1920, birthyear) <= startyear && startyear <= 1993
	    && 1920 <= endyear && endyear <= 1993)
	   for (year = startyear; year <= endyear; year++)
      pastft[year - birthyear] = 1;

      secondpensjob = eval(1, 3801);  /* H35: more than one pension job? */

      if (secondpensjob == 2)
      { startyear = eval(1, 3704);     /* H25: When did you start this job? */
	     endyear   = eval(1, 3705);     /* H26: And when did you leave? */

	     if (max(1920, birthyear) <= startyear && startyear <= 1993
	      && 1920 <= endyear && endyear <= 1993)
	     for (year = startyear; year <= endyear; year++)
        pastft[year - birthyear] = 1;
        }
      }
    }

  for (gtype = 0; gtype < 2; gtype++)      /* 0:state/loc  1:fed */
  { govtjob = eval(1, 3940 + 5 * gtype);

	 if (govtjob == 1)
	 for (jobno = 0; jobno < 2; jobno++)
	 { startyear = eval(1, 3941 + 2 * jobno + 5 * gtype);
		endyear   = eval(1, 3942 + 2 * jobno + 5 * gtype);

		if (1910 <= startyear && startyear <= endyear && endyear <= 1993)
		for (year = startyear; year <= endyear; year++)
      pastft[year - birthyear] = 1;
      }
    }

  firstyear = eval(3, 3097);
  lastyear  = eval(3, 3098);

  if (firstyear < 1920 || firstyear > 1996 || lastyear < 1934 || lastyear > 1996)
  { allyears = eval(3, 3100);

	 if (allyears == 1 || allyears == 2)
	 { allyears = eval(3, 3095);     /* full-time & part-time years */

		if (allyears == 2)
		{ firstyear = eval(3, 3091);
		  lastyear  = eval(3,  189);
		  }
		else
		{ ftyears = eval(3, 3094);

		  if (ftyears < 0 || ftyears > 50)
		  { firstyear = eval(3, 3092);
			 lastyear  = eval(3, 3093);
			 }
		  }
		}
	 }

  if (max(1934, birthyear) <= firstyear && firstyear <= lastyear && lastyear <= 1996)
  for (year = firstyear; year <= lastyear; year++)
  pastft[year - birthyear] = 1;

  lftage = -1;

  for (age = 0; age <= 1992 - birthyear; age++)
  if (pastft[age] == 1)
  lftage = age;

  if (lftage >= 50 || (1992 - birthyear < 50 && 1992 - birthyear <= lftage))
  { yearcount = 0;
    ftcount = 0;

    for (age = min(40, 1982 - birthyear); age <= lftage; age++)
    { if (pastft[age] == 1)
      ftcount = ftcount + 1;

      yearcount = yearcount + 1;
      }

    if (2 * ftcount <= yearcount)
    respvars->goodobs.goodCareer = 0;
    }
  else respvars->goodobs.goodCareer = 0;

  if (respvars->caseid == printcaseid)
  wnprintf(" %1d", respvars->goodobs.goodCareer);

  /* get age at times of interviews */

  survage[0] = eval(1, 46);      /* age in 1992 */

  if (survey[1] == 1)
  { survage[1] = eval(2, 104);     /* age in 1994 */

    if (survage[1] == 0 || survage[1] >= 98)
    { intvmonth = eval(2, 56);      /* month of interview, 1994 */
      intvyear = eval(2, 58);       /* year of interview, 1994 */

      if (birthmonth < intvmonth || birthmonth >= 98)
      survage[1] = intvyear - birthyear;
      else survage[1] = intvyear - birthyear - 1;
      }
    }
  else survage[1] = -9;

  /* Pension spike for this respondent is based on years of service, so the */
  /* retirement date must be based on year, not age to get the spike right. */
  if (respvars->caseid == 11424)
  survage[1] = 1994 - birthyear;

  if (survey[2] == 1)
  { intvmonth = eval(3, 391);      /* month of interview, 1996 */
    intvyear = eval(3, 393);       /* year of interview, 1996 */

    if (birthmonth < intvmonth || birthmonth >= 98)
    survage[2] = intvyear - birthyear;
    else survage[2] = intvyear - birthyear - 1;
    }
  else survage[2] = -9;

  if (survey[3] == 1)
  { intvmonth = eval(4, 697);      /* month of interview */
    intvyear = 1998;               /* year of interview */

    if (birthmonth < intvmonth || birthmonth >= 98)
    survage[3] = intvyear - birthyear;
    else survage[3] = intvyear - birthyear - 1;
    }
  else survage[3] = -9;

  if (survey[4] == 1)
  { intvmonth = eval(5, 768);      /* month of interview */
    intvyear = eval(5, 770);       /* year of interview */

    if (birthmonth < intvmonth || birthmonth >= 98)
    survage[4] = intvyear - birthyear;
    else survage[4] = intvyear - birthyear - 1;

    /* Pension spike for this respondent is based on years of service, so the */
    /* retirement date must be based on year, not age to get the spike right. */
    if (respvars->caseid == 23691)
    survage[4] = 2000 - birthyear;
    /* This respondent's birth month and the interview date are both in March. */
    /* The interview date in 1998 is in April.  This fix makes the interview   */
    /* ages two years apart rather than one year apart.                        */
    if (respvars->caseid == 24881)
    survage[4] = intvyear - birthyear;
    }
  else survage[4] = -9;

  if ((survage[0] >= survage[1] && survage[1] > 0)
   || (survage[1] >= survage[2] && survage[2] > 0)
   || (survage[0] >= survage[2] && survage[2] > 0)
   || (survage[2] >= survage[3] && survage[3] > 0)
   || (survage[1] >= survage[3] && survage[3] > 0)
   || (survage[0] >= survage[3] && survage[3] > 0)
   || (survage[3] >= survage[4] && survage[4] > 0)
   || (survage[2] >= survage[4] && survage[4] > 0)
   || (survage[1] >= survage[4] && survage[4] > 0)
   || (survage[0] >= survage[4] && survage[4] > 0))
  respvars->goodobs.goodAge = 0;

  if (respvars->caseid == printcaseid)
  wnprintf(" %1d", respvars->goodobs.goodAge);


  /* get last age worked and first age retired */

  work[0] = eval(1, 2717);       /* F2: 1992 any current work? */

  if (work[0] == 1)
  { sempl = eval(1, 2718);       /* F3: employee or self-employed? */

    if (sempl != 2)              /* not self-employed */
    sempl = 0;
    else sempl = 1;

    hours[0] = eval(1, 2722 + 100 * sempl);  /* F8/F28: usual weekly hours */
    }
  else hours[0] = 0;

  work[1]  = eval(2, 3316);      /* FA2: 1994 any current work? */

  if (work[1] == 1)
  { sempl = eval(2, 3317);       /* FA3: employee or self-employed? */

    if (sempl != 2)              /* not self-employed */
    sempl = 0;
    else sempl = 1;

    hours[1] = eval(2, 3617 + 696 * sempl);  /* FA44/FB17: usual weekly hours */
    }
  else hours[1] = 0;

  work[2]  = eval(3, 2627);      /* G2: 1996 any current work? */

  if (work[2] == 1)
  hours[2] = eval(3, 2736);      /* G44: usual weekly hours */
  else hours[2] = 0;

  work[3]  = eval(4, 3131);      /* G2: any current work? */

  if (work[3] == 1)
  hours[3] = eval(4, 3259);      /* G44: usual weekly hours */
  else hours[3] = 0;

  work[4]  = eval(5, 3381);      /* G2: any current work? */

  if (work[4] == 1)
  hours[4] = eval(5, 3509);      /* G44: usual weekly hours */
  else hours[4] = 0;

  for (surv = 0; surv < 5; surv++)
  { if (survey[surv] == 1)
    { if (work[surv] != 1 || (0 < hours[surv] && hours[surv] < 30))
      ftwork[surv] = 0;
      else if (work[surv] == 1 && (30 <= hours[surv] && hours[surv] <= 95))
      ftwork[surv] = 1;
      else ftwork[surv] = -1;
      }
    else ftwork[surv] = -1;
    }

  lftsurv = -1;
  lftage = 0;
  fretage = 99;

  for (surv = 0; surv < 5; surv++)
  if (ftwork[surv] == 1)
  { lftsurv = surv;
    lftage = survage[surv];
    }

  for (surv = 4; surv > lftsurv; surv--)
  if (ftwork[surv] == 0)
  fretage = survage[surv];


  /* get age of first health problem */

  health[0] = eval(1, 301);      /* B1: health status */
  health[1] = eval(2, 301);      /* B1: health status */
  health[2] = eval(3, 769);      /* B1: health status */
  health[3] = eval(4, 1097);     /* B1: health status */
  health[4] = eval(5, 1226);     /* B1: health status */

  for (surv = 0; surv < 5; surv++)
  { if (health[surv] == 4 || health[surv] == 5)
    health[surv] = 1;
    else health[surv] = 0;
    }

  if (survey[0] == 1 && health[0] == 1
   && ((survey[1] == 1 && health[1] == 1)
    || (survey[2] == 1 && health[2] == 1 && survey[1] == 0)
    || (survey[3] == 1 && health[3] == 1 && survey[1] == 0 && survey[2] == 0)
    || (survey[4] == 1 && health[4] == 1 && survey[1] == 0 && survey[2] == 0 && survey[3] == 0)
    || (survey[1] == 1 && survey[2] == 0 && survey[3] == 0 && survey[4] == 0)))
  { healthchange = eval(1, 302);  /* B2: change in health from last year */

    if (healthchange == 4 || healthchange == 5)
    hlthage = survage[0];
    else hlthage = survage[0] - 1;
    }
  else if (survey[1] == 1 && health[1] == 1
   && ((survey[2] == 1 && health[2] == 1)
    || (survey[3] == 1 && health[3] == 1 && survey[2] == 0)
    || (survey[4] == 1 && health[4] == 1 && survey[2] == 0 && survey[3] == 0)
    || (survey[2] == 0 && survey[3] == 0 && survey[4] == 0)))
  { if (survage[1] - survage[0] >= 2)
    hlthage = survage[1] - 1;
    else hlthage = survage[1];
    }
  else if (survey[2] == 1 && health[2] == 1
   && ((survey[3] == 1 && health[3] == 1)
    || (survey[4] == 1 && health[4] == 1 && survey[3] == 0)
    || (survey[3] == 0 && survey[4] == 0)))
  { if (survage[2] - survage[1] >= 2)
    hlthage = survage[2] - 1;
    else hlthage = survage[2];
    }
  else if (survey[3] == 1 && health[3] == 1
   && ((survey[4] == 1 && health[4] == 1) || survey[4] == 0))
  { if (survage[3] - survage[2] >= 2)
    hlthage = survage[3] - 1;
    else hlthage = survage[3];
    }
  else if (survey[4] == 1 && health[4] == 1)
  { if (survage[4] - survage[3] >= 2)
    hlthage = survage[4] - 1;
    else hlthage = survage[4];
    }
  else hlthage = 99;


  /* check if retirement was due to disability */

  ssdisab3 = eval(1, 4709);       /* J123b: Awarded SSDI benefits? */
  ssdisab4 = eval(1, 4713);       /* J123e: Awarded SSDI on appeal? */

  if (ssdisab3 == 1 || ssdisab4 == 1)
  ssdisab[0] = 1;
  else ssdisab[0] = 0;

  ssdisab1 = eval(2, 5259);     /* J18: Still receiving SSDI benefits? */
  ssdisab3 = eval(2, 5278);     /* J26b: Awarded SSDI benefits? */
  ssdisab4 = eval(2, 5282);     /* J26e: Awarded SSDI on appeal? */

  if (ssdisab1 == 1 || ssdisab3 == 1 || ssdisab4 == 1)
  ssdisab[1] = 1;
  else ssdisab[1] = 0;

  ssdisab1 = eval(3, 3580);      /* GD18: Still receiving SSDI benefits? */
  ssdisab3 = eval(3, 3600);      /* GD26b: Awarded SSDI benefits? */
  ssdisab4 = eval(3, 3604);      /* GD26e: Awarded SSDI on appeal? */

  if (ssdisab1 == 1 || ssdisab3 == 1 || ssdisab4 == 1)
  ssdisab[2] = 1;
  else ssdisab[2] = 0;

  ssdisab1 = eval(4, 4088);     /* GD18: Still receiving SSDI benefits? */
  ssdisab2 = eval(4, 4091);     /* GD18c: Pending SSDI application approved? */
  ssdisab3 = eval(4, 4129);     /* GD26b: Awarded SSDI benefits? */
  ssdisab4 = eval(4, 4133);     /* GD26e: Awarded SSDI on appeal? */

  if (ssdisab1 == 1 || ssdisab2 == 1 || ssdisab3 == 1 || ssdisab4 == 1)
  ssdisab[3] = 1;
  else ssdisab[3] = 0;

  ssdisab1 = eval(5, 4374);     /* GD18aa: Still receiving SSDI benefits? */
  ssdisab2 = eval(5, 4390);     /* GD18ca: Pending SSDI application approved? */
  ssdisab3 = eval(5, 4403);     /* GD18dd: Awarded SSDI on appeal? */
  ssdisab4 = eval(5, 4459);     /* GD26b: Awarded SSDI benefits? */
  ssdisab5 = eval(5, 4463);     /* GD26e: Awarded SSDI on appeal? */

  if (ssdisab1 == 1 || ssdisab2 == 1 || ssdisab3 == 1 || ssdisab4 == 1 || ssdisab5 == 1)
  ssdisab[4] = 1;
  else ssdisab[4] = 0;

  if (lftsurv < 4)
  { if (ssdisab[lftsurv + 1] == 1)
    disability = 1;
    else if (lftsurv < 3)
    { if (ssdisab[lftsurv + 2] == 1)
      disability = 1;
      else disability = 0;
      }

    if (disability == 1 && lftsurv >= 0)
    if (ssdisab[lftsurv] == 1)
    disability = 0;

    if (disability == 1)
    fretage = 99;
    }

  respvars->lftsurv = lftsurv;
  respvars->lftage  = lftage;
  respvars->fretage = fretage;
  respvars->hlthage = hlthage;

  for (surv = 0; surv < 5; surv++)
  { respvars->ftwork[surv] = ftwork[surv];
    respvars->survage[surv] = survage[surv];
    }

  respvars->weight = eval(1, 15);

  }


/*---------------------------------------------------------------------------
			 GET EARNINGS
			 calculates total earnings and social security earnings vectors
  ---------------------------------------------------------------------------*/

void getEarnings(
  struct respdata *respvars)

{ int   age, year;
  int   cohort, gender;
  int   ed, marstat, mar, firstage;
  int   matchcode, qc, offset;
  int   jobno, sjobno, jobmatch;
  int   pens, loc, contribpd;
  int   gtype, govtjob, gjob;
  int   curjob, longjob, pensjob, secondpensjob;
  int   everworked, nlfperiod;
  int   selfempl, hours, weeks;
  int   startdate, enddate, joblength;
  int   minstartdate, maxenddate;
  int   gstartdate, genddate, gjoblength;
  int   nonssstartdate, nonssenddate;
  int   pencoverage, futurepens;
  int   lftjob, lftage, lftyear, lftsscov;
  int   srearningsflag, commonyears;
  int   nonssjob, nonssyears;
  int   exemptyears, allyears;
  int   remainingyears, earningsyears;
  int   firstyear, lastyear, ftyears, lastage;
  int   expersum, lastwageage;
  int   count, maxcount;
  int   foreignborn, yearentered;
  int   windfallflag, ncpensyear;
  int   tenure, experience;
  int   yearcount, ftcount;
  float earnings, nextearnings, lastearnings, lftearnings, earningssr;
  float earningstot, earningsave, earningslim, maxearnings;
  float ssearningstot, ssearningsave;
  float contrib, pencontr, contribpct, contribamt;
  float ssmaximum, ncpensamt;
  float wage, realwage, realwagebase, cumwagegrowth;

  int   exper[101], ten[101], nonss[101];
  float penscontrib[6];
  float ssearnvec[41];
  float srearnings[101], ssearnings[101], impearnings[101];

  struct
  { int   jobind;
    int   startdate;
    int   enddate;
    int   hours;
    float earnings;
    int   sscoverage;
    int   pencoverage;
    int   samejob[5];
    } jobvars[9];

  static int   pencontribloc[6] = { 2911, 3011, 3111, 2937, 3037, 3137};

  static float wageind[46] = {                             45.58,  49.00,  50.24,
	50.13,  57.86,  60.65,  63.76,  64.52,  67.72,  70.74,  73.33,  75.08,  78.78,
	80.67,  82.60,  85.91,  88.46,  91.33,  95.45,  98.82, 101.84, 107.73, 114.61,
  119.83, 127.31, 136.90, 145.39, 154.76, 163.53, 175.45, 189.00, 203.70, 219.91,
  235.10, 255.20, 267.26, 280.70, 292.86, 299.09, 304.85, 312.50, 322.02, 334.24,
  345.35, 353.98, 363.61};
  /* 1947-1992 average weekly earnings           */
  /* Table B41, 1986 ERP and Table B45, 1995 ERP */

  static float wGrowthRate[29] = {
			 4.0,  4.2,  4.8,  5.2,  4.9,  4.9,  4.8,  4.8,  4.9,
	 4.9,  5.0,  5.0,  5.0,  5.0,  4.9,  4.9,  4.9,  4.9,  4.8,
	 4.8,  4.8,  4.8,  4.8,  4.8,  4.7,  4.7,  4.7,  4.7,  4.7};
  /* Wage growth rate, 1992-2020, in Table II.D1, p. 59, in the 1993 */
  /* Annual Report of the Board of Trustees of Social Security    */
  /* static float wGrowthRate[29] = {
			 5.4,  1.3,  3.5,  4.0,  4.1,  4.3,  4.1,  4.2,  4.5,
	 4.7,  4.8,  4.9,  5.1,  5.1,  5.1,  5.1,  5.1,  5.1,  5.1,
	 5.1,  5.1,  5.1,  5.1,  5.1,  5.0,  5.0,  5.0,  5.0,  5.0};
     Wage growth rate, 1992-2020, in Table II.D1, p. 56, in the 1995
     Annual Report of the Board of Trustees of Social Security    */

  static float ssmax[42] = {
			 3600,  3600,  3600,  3600,  4200,  4200,  4200,  4200,  4800,
	4800,  4800,  4800,  4800,  4800,  4800,  6600,  6600,  7800,  7800,
	7800,  7800,  9000, 10800, 13200, 14100, 15300, 16500, 17700, 22900,
  25900, 29700, 32400, 35700, 37800, 39600, 42000, 43800, 45000, 48000,
  51300, 53400, 55500};
  /* Social Security maximum taxable earnings from Ann Statistical Suppl, 1995 */


  respvars->goodobs.goodEarnings = 1;
  respvars->goodobs.goodSSstatus = 1;
  respvars->goodobs.goodFTyears  = 1;
  respvars->goodobs.goodSSearn   = 1;

  cohort = respvars->vint;
  gender = respvars->gender;

  /* get the social security record if available */

  getSSrec(respvars->caseid, &matchcode, &qc, ssearnvec);

  /* This respondent was born in 1927 and was 64 in the first survey. */
  /* He reported current earnings of $5000, but the social security   */
  /* record is zero for 1991.  Since this was his last observation of */
  /* full time work, the reported earnings are substituted for zero.  */
  if (respvars->caseid == 23468)
  ssearnvec[1991 - 1951] = 5000;

  for (age = 0; age <= 100; age++)
  ssearnings[age] = 0;

  if (matchcode == 1)
  for (year = 1951; year < 1992; year++)
  if (cohort <= year && year < cohort + 75)
  ssearnings[year - cohort] = ssearnvec[year - 1951];

  if (respvars->caseid == printcaseid)
  { wnprintf("  %4d %4d", respvars->caseid, respvars->matchid);
    wnprintf("  %4d %2d %1d", cohort, respvars->lftage, matchcode);

    if (matchcode == 1)
    { wnprintf("\nssearn: ");
      for (year = 1952; year < 1992; year++)
      { if (year > 1952 && year % 10 == 2)
        wnprintf("\n        ");

        wnprintf("%6.0f", ssearnvec[year - 1951]);
        }
      }
    }

  /* get wages and tenures of observed jobs */

  for (jobno = 0; jobno < 9; jobno++)
  { jobvars[jobno].jobind      =  0;
    jobvars[jobno].startdate   = -9;
    jobvars[jobno].enddate     = -9;
    jobvars[jobno].earnings    = -9;
    jobvars[jobno].sscoverage  = -9;
    jobvars[jobno].pencoverage = -9;

    for (sjobno = 0; sjobno < 5; sjobno++)
    jobvars[jobno].samejob[sjobno] = -9;
    }

  if (respvars->caseid == printcaseid)
  wnprintf("\n ");

  curjob = eval(1, 2717);

  if (curjob == 1 || curjob == 2)  /* Current job: Section F questions */
  { selfempl = eval(1, 2718);

	 if (selfempl == 2)
	 selfempl = 1;
	 else selfempl = 0;

	 hours = eval(1, 2722 + 100 * selfempl);

    if (hours <= 0 || hours >= 30)
    { if (respvars->caseid != 24429)
      jobvars[0].jobind = 1;
      /* This observation has 40 hours/week, but only 2 weeks/year */

	   startdate = eval(1, 2816 +  18 * selfempl);

	   if (1920 <= startdate && startdate <= 1993)
	   jobvars[0].startdate = startdate;

      jobvars[0].enddate = 1992;

		weeks = eval(1, 2726 + 97 * selfempl);

      if (0 < hours && hours < 95)
      { if (0 < weeks && weeks < 52)
        jobvars[0].hours = hours * weeks;
        else jobvars[0].hours = 52 * hours;
        }
      else
      { if (0 < weeks && weeks < 52)
        jobvars[0].hours = 40 * weeks;
        else jobvars[0].hours = 2080;
        }

		if (selfempl == 0)
		jobvars[0].earnings = wagecalc(1, 2735, 1, hours, weeks)    /* salary */
								   + wagecalc(1, 2739, 0, hours, weeks)   /* hourly     */
								   + wagecalc(1, 2743, 1, hours, weeks)   /* piecework  */
								   + wagecalc(1, 2748, 1, hours, weeks);  /* tips, etc. */
		else
		jobvars[0].earnings = wagecalc(1, 2825, 1, hours, weeks)    /* salary  */
								   + wagecalc(1, 2828, 1, hours, weeks);  /* profits */

      if (respvars->caseid == printcaseid)
      wnprintf("  %4d 1992", startdate);

      jobvars[0].sscoverage = 1;

      if (respvars->caseid == 20897)
      jobvars[0].sscoverage = 0;
      /* current job started in 1987 at 60 hours, yet */
      /* virtually no ss earnings during this period */

		pencoverage = eval(1, 2901 -  63 * selfempl);

		if (selfempl == 0)
		futurepens = eval(1, 2906);     /* will become eligible if remains with employer */
		else futurepens = 0;

		if (pencoverage == 1 || futurepens == 1)
		{ jobvars[0].pencoverage = 1;

        for (pens = 0; pens < 6; pens++)
        { loc = pencontribloc[pens];
          contrib = -9;

          contribpct = eval(1, loc);

          if (contribpct < 99996)
          contrib = contribpct / 100.0;
          else
          { contribamt = eval(1, loc + 1);

            if (contribamt < 99998 && jobvars[0].earnings > 0)
            { contribpd = eval(1, loc + 2);

              switch(contribpd)
              { case  2:  contrib = 100 * (52 * contribamt) / jobvars[0].earnings;    break;
                case  3:  contrib = 100 * (26 * contribamt) / jobvars[0].earnings;    break;
                case  4:  contrib = 100 * (12 * contribamt) / jobvars[0].earnings;    break;
                case  5:  contrib = 100 * ( 4 * contribamt) / jobvars[0].earnings;    break;
                case  6:  contrib = 100 *       contribamt  / jobvars[0].earnings;    break;
                }
              }
            }

          penscontrib[pens] = contrib;
          }

        pencontr = -9;

        for (pens = 0; pens < 6; pens++)
        { if (penscontrib[pens] >= 0)
          { if (pencontr < 0)
            pencontr = penscontrib[pens];
            else pencontr = pencontr + penscontrib[pens];
            }
          }

        if (pencontr < 0)
        pencontr = 5;                /* default contribution rate is 5% */
        }
		else
      { jobvars[0].pencoverage = 0;
        pencontr = -9;
        }
		}
    else
    { if (respvars->caseid == printcaseid)
      wnprintf("           ");
      }
	 }
  else
  { if (respvars->caseid == printcaseid)
     wnprintf("           ");
     }

  everworked = eval(1, 3401);       /* ever worked             */
  nlfperiod = eval(1, 3404);        /* worked in last 20 years */

  if ((curjob < 1 || curjob > 2) && (everworked == 1 && nlfperiod == 2))
  { selfempl = eval(1, 3405);       /* Last job: Section G questions */

	 if (selfempl == 2)
	 selfempl = 1;
	 else selfempl = 0;

	 hours = eval(1, 3408 + 25 * selfempl);

    if (hours <= 0 || hours >= 30)
    { jobvars[1].jobind = 1;

	   startdate = eval(1, 3418 + 24 * selfempl);
	   enddate   = eval(1, 3403);

	   if (1910 <= startdate && startdate <= 1993)
      jobvars[1].startdate = startdate;

	   if (1910 <= enddate && enddate <= 1993)
      jobvars[1].enddate = enddate;

		weeks = eval(1, 3411 + 23 * selfempl);

      if (0 < hours && hours < 95)
      { if (0 < weeks && weeks < 52)
        jobvars[1].hours = hours * weeks;
        else jobvars[1].hours = 52 * hours;
        }
      else
      { if (0 < weeks && weeks < 52)
        jobvars[1].hours = 40 * weeks;
        else jobvars[1].hours = 2080;
        }

		if (selfempl == 0)          /* employee */
		jobvars[1].earnings = wagecalc(1, 3412, 1, hours, weeks);
		else                        /* self-employed */
		jobvars[1].earnings = wagecalc(1, 3436, 1, hours, weeks)    /* salary  */
								   + wagecalc(1, 3439, 1, hours, weeks);  /* profits */

      if (respvars->caseid == printcaseid)
      wnprintf("  %4d %4d", startdate, enddate);

      jobvars[1].sscoverage = 1;

		pencoverage = eval(1, 3430 + 18 * selfempl);

		if (pencoverage == 1)
		jobvars[1].pencoverage = 1;
      else jobvars[1].pencoverage = 0;
		}
    else
    { if (respvars->caseid == printcaseid)
      wnprintf("           ");
      }
	 }
  else
  { if (respvars->caseid == printcaseid)
    wnprintf("           ");
    }

  longjob = eval(1, 3601);

  if (longjob == 1)          /* previous 5 year job */
  { hours = eval(1, 3608);

    if (hours <= 0 || hours >= 30)
    { jobvars[2].jobind = 1;

      startdate = eval(1, 3604);
	   enddate   = eval(1, 3607);

	   if (1920 <= startdate && startdate <= 1993)
      jobvars[2].startdate = startdate;

	   if (1920 <= enddate && enddate <= 1993)
      jobvars[2].enddate = enddate;

		weeks = eval(1, 3609);

      if (0 < hours && hours < 95)
      { if (0 < weeks && weeks < 52)
        jobvars[2].hours = hours * weeks;
        else jobvars[2].hours = 52 * hours;
        }
      else
      { if (0 < weeks && weeks < 52)
        jobvars[2].hours = 40 * weeks;
        else jobvars[2].hours = 2080;
        }

		jobvars[2].earnings = wagecalc(1, 3610, 1, hours, weeks);

      if (respvars->caseid == printcaseid)
      wnprintf("  %4d %4d", startdate, enddate);

      jobvars[2].sscoverage = 1;

      if (respvars->caseid == 23944)
      jobvars[2].sscoverage = 0;
      /* personal service job with acceptable reported */
      /* wages but very low social security earnings */

		pencoverage = eval(1, 3620);

		if (pencoverage == 1)
		jobvars[2].pencoverage = 1;
      else jobvars[2].pencoverage = 0;
		}
    else
    { if (respvars->caseid == printcaseid)
      wnprintf("           ");
      }

    pensjob = eval(1, 3702);

    if (pensjob == 1)          /* pension job */
    { jobvars[3].jobind = 1;

      startdate = eval(1, 3704);
	   enddate   = eval(1, 3705);

	   if (1920 <= startdate && startdate <= 1993)
      jobvars[3].startdate = startdate;

	   if (1920 <= enddate && enddate <= 1993)
      jobvars[3].enddate = enddate;

		jobvars[3].earnings = wagecalc(1, 3706, 1, 40, 52);  /* wage in pension job */

      if (respvars->caseid == printcaseid)
      wnprintf("  %4d %4d", startdate, enddate);

      jobvars[3].sscoverage = 1;
      jobvars[3].pencoverage = 1;

      secondpensjob = eval(1, 3801);         /* H35: second pension job? */

      if (secondpensjob == 2)                /* other pension job */
      { jobvars[4].jobind = 1;

        startdate = eval(1, 3804);
	     enddate   = eval(1, 3805);

	     if (1920 <= startdate && startdate <= 1993)
        jobvars[4].startdate = startdate;

	     if (1920 <= enddate && enddate <= 1993)
        jobvars[4].enddate = enddate;

		  jobvars[4].earnings = wagecalc(1, 3806, 1, 40, 52);  /* wage from second pension */

        if (respvars->caseid == printcaseid)
        wnprintf("  %4d %4d", startdate, enddate);

        jobvars[4].sscoverage = 1;
        jobvars[4].pencoverage = 1;
		  }
	   }
	 }

  for (gtype = 0; gtype < 2; gtype++)      /* 0:state/loc  1:fed */
  { govtjob = eval(1, 3940 + 5 * gtype);

	 if (govtjob == 1)
    for (jobno = 0; jobno < 2; jobno++)
	 { startdate = eval(1, 3941 + 2 * jobno + 5 * gtype);
		enddate   = eval(1, 3942 + 2 * jobno + 5 * gtype);

	   if (1920 <= startdate && startdate <= 1993)
      jobvars[5 + 2 * gtype + jobno].startdate = startdate;

	   if (1920 <= enddate && enddate <= 1993)
      jobvars[5 + 2 * gtype + jobno].enddate = enddate;

      if (jobvars[5 + 2 * gtype + jobno].startdate > -9
       && jobvars[5 + 2 * gtype + jobno].enddate > -9)
      { jobvars[5 + 2 * gtype + jobno].jobind = 1;
        jobvars[5 + 2 * gtype + jobno].sscoverage = 1;
        }
		}
	 }

  if (respvars->caseid == printcaseid)
  { wnprintf("\njobind: "); for (jobno = 0; jobno < 9; jobno++) wnprintf("%6d", jobvars[jobno].jobind);
    wnprintf("\nstartd: "); for (jobno = 0; jobno < 9; jobno++) wnprintf("%6d", jobvars[jobno].startdate);
    wnprintf("\nenddat: "); for (jobno = 0; jobno < 9; jobno++) wnprintf("%6d", jobvars[jobno].enddate);
    wnprintf("\nearnin: "); for (jobno = 0; jobno < 9; jobno++) wnprintf("%6.0f", jobvars[jobno].earnings);
    wnprintf("\nsscove: "); for (jobno = 0; jobno < 9; jobno++) wnprintf("%6d", jobvars[jobno].sscoverage);
    wnprintf("\npencov: "); for (jobno = 0; jobno < 9; jobno++) wnprintf("%6d", jobvars[jobno].pencoverage);
    }


  /* Index self reported earnings to 1992 and enter in earnings vector */

  srearningsflag = 0;
  maxearnings = 0;

  for (age = 0; age <= 100; age++)
  srearnings[age] = 0;

  for (jobno = 4; jobno >= 0; jobno--)
  if (jobvars[jobno].jobind == 1)
  { enddate = jobvars[jobno].enddate;
    earnings = jobvars[jobno].earnings;

    if (enddate > 0 && earnings > 0)
    { if (enddate < 1947)
      earnings = earnings * (wageind[1992 - 1947] / wageind[1947 - 1947])
  	    * pow((wageind[1952 - 1947] / wageind[1947 - 1947]), ((1947 - enddate) / 5.0));
      else earnings = earnings * (wageind[1992 - 1947] / wageind[enddate - 1947]);

      if (earnings > 0.25 * maxearnings && earnings >= 2.15 * jobvars[jobno].hours)
      { if (earnings > maxearnings)         /* $2.12 is half of minimum wage */
        maxearnings = earnings;

        jobvars[jobno].earnings = earnings;
        srearnings[enddate - cohort] = earnings;
        srearningsflag = 1;
        }
      else jobvars[jobno].earnings = -9;
      }
    else jobvars[jobno].earnings = -9;
    }

  if (srearningsflag == 0 && matchcode == 0)
  respvars->goodobs.goodEarnings = 0;

  if (respvars->caseid == printcaseid)
  { wnprintf("\nsrearn: ");
    for (age = 30; age < 70; age++)
    { if (age > 30 && age % 10 == 0)
      wnprintf("\n        ");

      wnprintf("%6.0f", srearnings[age]);
      }
    }


  /* find duplicate jobs in fed & state/local jobs */

  for (jobno = 0; jobno < 5; jobno++)
  if (jobvars[jobno].jobind == 1)
  { startdate = jobvars[jobno].startdate;
    enddate = jobvars[jobno].enddate;

    if (0 < startdate && startdate <= enddate)
    { joblength = enddate - startdate + 1;

      for (govtjob = 5; govtjob < 9; govtjob++)
      if (jobvars[govtjob].jobind == 1)
      { gstartdate = jobvars[govtjob].startdate;
        genddate = jobvars[govtjob].enddate;

        if (0 < gstartdate && gstartdate <= genddate)
        { gjoblength = genddate - gstartdate + 1;
          commonyears = min(enddate, genddate) - max(startdate, gstartdate) + 1;

          if (commonyears >= 0.75 * joblength
           || respvars->caseid == 14850    /* These are farily certain matches even if */
           || respvars->caseid == 23083)   /* common years are slightly less than 75%. */
          jobvars[jobno].samejob[govtjob - 5] = govtjob;

          if (commonyears >= 0.75 * gjoblength)
          jobvars[govtjob].samejob[jobno] = jobno;
          }
        }
      }
    }

  if (respvars->caseid == printcaseid)
  { wnprintf("\nmatch:  ");
    for (jobno = 0; jobno < 9; jobno++)
    wnprintf(" %1d%1d%1d%1d%1d", abs(jobvars[jobno].samejob[0]),
    abs(jobvars[jobno].samejob[1]), abs(jobvars[jobno].samejob[2]),
    abs(jobvars[jobno].samejob[3]), abs(jobvars[jobno].samejob[4]));
    }


  /* find last ft job */

  lftjob = -1;
  lftyear = -1;

  for (jobno = 0; jobno < 9; jobno++)
  { if (jobvars[jobno].jobind == 1)
    if (jobvars[jobno].startdate > lftyear || jobvars[jobno].enddate > lftyear)
    { lftjob = jobno;

      if (jobvars[jobno].enddate > lftyear)
      lftyear = enddate;
      else lftyear = startdate;
      }
    }


  /* Identify non social security jobs */

  nonssstartdate   = -9;
  nonssenddate    = -9;
  exemptyears = -9;

  nonssjob = eval(3, 3102);

  if (nonssjob == 1)
  { nonssstartdate = eval(3, 3103);
    nonssenddate   = eval(3, 3104);
    allyears       = eval(3, 3106);

    if (allyears == 2)
    { nonssstartdate = eval(3, 3091);
      nonssenddate   = 1992;
      }

    if (nonssstartdate < 1920 || nonssenddate < nonssstartdate
     || nonssenddate > 1996)
    { nonssstartdate = -9;
      nonssenddate   = -9;

      exemptyears = eval(3, 3105);

      if (exemptyears < 0 || exemptyears > 50)
	   exemptyears = -9;
      }
    }
  else if (nonssjob == 5)
  nonssjob = 0;
  else nonssjob = -9;

  if (respvars->caseid == printcaseid)
  wnprintf("    %d %d %d %d", nonssjob, nonssstartdate, nonssenddate, exemptyears);

  if (matchcode == 0                /* no social security match */
   || srearningsflag == 0)          /* no self-reported earnings */
  { if (nonssjob != 0)
    { if (nonssstartdate > 0 && nonssenddate > 0)
      { for (govtjob = 5; govtjob < 9; govtjob++)    /* 5-6:state/loc  7-8:fed */
        if (jobvars[govtjob].jobind == 1)
        { startdate = jobvars[govtjob].startdate;
          enddate   = jobvars[govtjob].enddate;

          joblength = enddate - startdate + 1;

          nonssyears = max(startdate, nonssstartdate) - min(enddate, nonssenddate) + 1;

          if (nonssyears >= 0.75 * joblength)
          jobvars[govtjob].sscoverage = 0;
          }
        }
      else if (exemptyears > 0)
      { remainingyears = exemptyears;

        for (govtjob = 5; govtjob < 9; govtjob++)    /* 5-6:state/loc  7-8:fed */
        if (jobvars[govtjob].jobind == 1)
		  { startdate = jobvars[govtjob].startdate;
          enddate   = jobvars[govtjob].enddate;

          if (startdate > 0 && enddate > 0)
          if (govtjob <= 6 || startdate <= 1984)   /* state or fed before 1984 */
          { remainingyears = remainingyears - (enddate - startdate + 1);
            jobvars[govtjob].sscoverage = 0;
            }
          }

        if (remainingyears < exemptyears)
        { if (remainingyears < -5)
          { startdate = jobvars[lftjob].startdate;
            enddate = jobvars[lftjob].enddate;

            if (startdate < 0 || enddate - startdate <= 10)
            respvars->goodobs.goodSSstatus = 0;
            }
          else if (remainingyears > 9)
          respvars->goodobs.goodSSstatus = 0;
          }
        else
        { if (exemptyears < 5)
          { startdate = jobvars[lftjob].startdate;
            enddate = jobvars[lftjob].enddate;

            if (startdate < 0 || enddate - startdate <= 10)
            respvars->goodobs.goodSSstatus = 0;
            }
          else respvars->goodobs.goodSSstatus = 0;
          }
        }
      else
      { for (govtjob = 5; govtjob < 9; govtjob++)    /* 5-6:state/loc  7-8:fed */
        if (jobvars[govtjob].jobind == 1)
		  { startdate = jobvars[govtjob].startdate;

          if (govtjob <= 6 || startdate <= 1984)   /* state or fed before 1984 */
          jobvars[govtjob].sscoverage = 0;
          }
        }

      for (jobno = 0; jobno < 5; jobno++)
      if (jobvars[jobno].jobind == 1)
      { jobmatch = 0;

        for (govtjob = 5; govtjob < 9; govtjob++)
        if (jobvars[govtjob].jobind == 1)
        if (jobvars[jobno].samejob[govtjob - 5] == govtjob)
        { jobmatch = 1;
          jobvars[jobno].sscoverage = jobvars[govtjob].sscoverage;
          }

        if (jobmatch == 0 && nonssjob == 1)
        { startdate = jobvars[govtjob].startdate;
		    enddate   = jobvars[govtjob].enddate;

		    if (1910 <= startdate && startdate <= enddate && enddate <= 1993
           && nonssstartdate > 0 && nonssenddate > 0)
		    { joblength = enddate - startdate + 1;

            commonyears = max(startdate, nonssstartdate) - min(enddate, nonssenddate) + 1;

            if (commonyears >= 0.75 * joblength)
            jobvars[jobno].sscoverage = 0;
            }
          }
        }
      }
    }
  else                              /* with social security match */
  { /* Check whether govt jobs are non social security jobs */

	 for (govtjob = 5; govtjob < 9; govtjob++)
    if (jobvars[govtjob].jobind == 1)
	 { startdate = jobvars[govtjob].startdate;
		enddate   = jobvars[govtjob].enddate;

      if (1910 <= startdate && startdate <= enddate && enddate <= 1993)
      { for (offset = 100; offset >= 0; offset--)
        { if ((enddate - offset) - cohort >= 0)
          if (srearnings[(enddate - offset) - cohort] > 0)
          earningssr = srearnings[(enddate - offset) - cohort];

          if ((enddate + offset) - cohort <= 100)
          if (srearnings[(enddate + offset) - cohort] > 0)
          earningssr = srearnings[(enddate + offset) - cohort];
          }

        if (enddate < 1951)
        ssmaximum = ssmax[1951 - 1951] * (wageind[1992 - 1947] / wageind[1947 - 1947]);
	     else
        { if (enddate <= 1992)
          ssmaximum = ssmax[enddate - 1951] * (wageind[1992 - 1947] / wageind[enddate - 1947]);
          else ssmaximum = ssmax[1992 - 1951];
          }

		  if (earningssr > ssmaximum)
		  earningssr = ssmaximum;

		  earningstot = 0;
        earningsyears = 0;

		  for (year = startdate; year <= enddate; year++)
		  if (1951 <= year && year <= 1991)
		  { if (ssearnings[year - cohort] < ssmax[year - 1951])
          earnings = ssearnings[year - cohort] * (wageind[1992 - 1947] / wageind[year - 1947]);
          else earnings = earningssr;

          earningstot = earningstot + earnings;
          earningsyears = earningsyears + 1;
          }

        if (earningsyears > 0)
        { earningsave = earningstot / earningsyears;

			 if (earningsave < 0.6 * earningssr)
          jobvars[govtjob].sscoverage = 0;
          }
        else if (startdate >= 1992)
        { if (nonssstartdate > 0 && nonssenddate > 0)
          { if (nonssstartdate <= 1992 && nonssenddate >= 1992)
            jobvars[govtjob].sscoverage = 0;
            }
          else if (nonssjob != 0)
          respvars->goodobs.goodSSstatus = 0;
          }
        }
      }

    for (jobno = 0; jobno < 5; jobno++)
    if (jobvars[jobno].jobind == 1)
    { jobmatch = 0;

      for (govtjob = 5; govtjob < 9; govtjob++)
      if (jobvars[govtjob].jobind == 1)
      if (jobvars[jobno].samejob[govtjob - 5] == govtjob)
      { jobmatch = 1;
        jobvars[jobno].sscoverage = jobvars[govtjob].sscoverage;
        }

      if (jobmatch == 0 && nonssjob == 1)
      { startdate = jobvars[govtjob].startdate;
		  enddate   = jobvars[govtjob].enddate;

		  if (1910 <= startdate && startdate <= enddate && enddate <= 1993)
        { for (offset = 100; offset >= 0; offset--)
          { if ((enddate - offset) - cohort > 0)
            if (srearnings[(enddate - offset) - cohort] > 0)
            earningssr = srearnings[(enddate - offset) - cohort];

            if ((enddate + offset) - cohort > 0)
            if (srearnings[(enddate + offset) - cohort] > 0)
            earningssr = srearnings[(enddate + offset) - cohort];
            }

          if (enddate < 1951)
          ssmaximum = ssmax[1951 - 1951] * (wageind[1992 - 1947] / wageind[1947 - 1947]);
	       else
          { if (enddate <= 1992)
            ssmaximum = ssmax[enddate - 1951] * (wageind[1992 - 1947] / wageind[enddate - 1947]);
            else ssmaximum = ssmax[1992 - 1951];
            }

			 if (earningssr > ssmaximum)
			 earningssr = ssmaximum;

		    earningstot = 0;
          earningsyears = 0;

		    for (year = startdate; year <= enddate; year++)
		    if (1951 <= year && year <= 1991)
		    { if (ssearnings[year - cohort] < ssmax[year - 1951])
		      earnings = ssearnings[year - cohort] * (wageind[1992 - 1947] / wageind[year - 1947]);
            else earnings = earningssr;

            earningstot = earningstot + earnings;
            earningsyears = earningsyears + 1;
            }

          if (earningsyears > 0)
          { earningsave = earningstot / earningsyears;

			   if (earningsave < 0.6 * earningssr)
            jobvars[govtjob].sscoverage = 0;
            }
          else if (startdate >= 1992)
          { if (nonssstartdate > 0 && nonssenddate > 0)
            { if (nonssstartdate <= 1992 && nonssenddate >= 1992)
              jobvars[govtjob].sscoverage = 0;
              }
            else respvars->goodobs.goodSSstatus = 0;
            }
          }
        }
      }
    }

  if (respvars->caseid == printcaseid)
  { wnprintf("\nsscove: ");
    for (jobno = 0; jobno < 9; jobno++)
    wnprintf("%6d", jobvars[jobno].sscoverage); wnprintf("    %d", respvars->goodobs.goodSSstatus);
    }


  /* Adjust dates of social security jobs to match social security record */

  for (jobno = 0; jobno < 5; jobno++)
  if (jobvars[jobno].jobind == 1)
  { jobmatch = -1;

    for (govtjob = 5; govtjob < 9; govtjob++)
    if (jobvars[govtjob].jobind == 1)
    { if (jobvars[jobno].samejob[govtjob - 5] == govtjob
       && jobvars[govtjob].samejob[jobno] == jobno)
      jobmatch = govtjob;
      }

    if (jobmatch > 0)
    { startdate = (jobvars[jobno].startdate + jobvars[jobmatch].startdate) / 2;

      if (jobno >= 1)
      enddate = (jobvars[jobno].enddate + jobvars[jobmatch].enddate) / 2;
      else enddate = 1992;

      if (matchcode == 1 && jobvars[jobmatch].sscoverage == 1)
		{ earningstot = 0;
        earningsyears = 0;

		  for (year = startdate; year <= enddate; year++)
		  if (1951 <= year && year <= 1991)
		  { earnings = ssearnings[year - cohort]
                    * (wageind[1992 - 1947] / wageind[year - 1947]);

          earningstot = earningstot + earnings;
          earningsyears = earningsyears + 1;
          }

        if (earningsyears > 0)
        { earningsave = earningstot / earningsyears;
          earningslim = 0.5 * earningsave;

          if (startdate >= 1951)
          { earnings = ssearnings[year - cohort]
                      * (wageind[1992 - 1947] / wageind[year - 1947]);

            minstartdate = min(jobvars[jobno].startdate, jobvars[jobmatch].startdate);

            if (minstartdate < startdate && earnings > earningslim)
		      { startdate = startdate - 1;

              for (year = startdate; year > minstartdate; year--)
              if ( year == startdate)
		        if (1952 < year && year <= 1991)
              { earnings = ssearnings[year - cohort]
                          * (wageind[1992 - 1947] / wageind[year - 1947]);
                lastearnings = ssearnings[(year - 1) - cohort]
                              * (wageind[1992 - 1947] / wageind[year - 1947]);

                if ((earnings > earningslim && lastearnings > 0) || lastearnings > earningslim)
                startdate = year - 1;
                }
              }
            else
            { for (year = startdate; year < min(1990, enddate); year++)
              if (year == startdate)
              { earnings = ssearnings[year - cohort]
                          * (wageind[1992 - 1947] / wageind[year - 1947]);
                nextearnings = ssearnings[(year + 1) - cohort]
                              * (wageind[1992 - 1947] / wageind[year - 1947]);

                if (earnings < earningslim && (nextearnings < earningslim || earnings == 0))
                startdate = year + 1;
                }
              }
            }

          if (enddate <= 1991)
          { earnings = ssearnings[year - cohort]
                      * (wageind[1992 - 1947] / wageind[year - 1947]);

            maxenddate = max(jobvars[jobno].enddate, jobvars[jobmatch].enddate);

            if (maxenddate < enddate && earnings > earningslim)
		      { enddate = enddate + 1;

              for (year = enddate; year < maxenddate; year++)
              if ( year == enddate)
		        if (1951 < year && year <= 1990)
              { earnings = ssearnings[year - cohort]
                          * (wageind[1992 - 1947] / wageind[year - 1947]);
                nextearnings = ssearnings[(year + 1) - cohort]
                              * (wageind[1992 - 1947] / wageind[year - 1947]);

                if ((earnings > earningslim && nextearnings > 0) || nextearnings > earningslim)
                enddate = year + 1;
                }
              }
            else
            { for (year = enddate; year > max(1951, startdate - 1); year--)
              if (year == enddate)
              { earnings = ssearnings[year - cohort]
                          * (wageind[1992 - 1947] / wageind[year - 1947]);
                lastearnings = ssearnings[(year - 1) - cohort]
                              * (wageind[1992 - 1947] / wageind[year - 1947]);

                if (earnings < earningslim && (lastearnings < earningslim || earnings == 0))
                enddate = year - 1;
                }
              }
            }
          }
        }

      if (enddate < startdate)
      jobvars[jobno].jobind = 0;

      jobvars[jobno].startdate = startdate;
      jobvars[jobno].enddate = enddate;
      jobvars[jobno].sscoverage = jobvars[jobmatch].sscoverage;

      jobvars[jobmatch].jobind = 0;
      }
    else
    { if (matchcode == 1 && jobvars[jobno].sscoverage == 1)
	   { startdate = jobvars[jobno].startdate;
	     enddate   = jobvars[jobno].enddate;

		  if (1910 <= startdate && startdate <= enddate && enddate <= 1993)
		  { earningstot = 0;
          earningsyears = 0;

		    for (year = startdate; year <= enddate; year++)
		    if (1951 <= year && year <= 1991)
		    { earnings = ssearnings[year - cohort]
                      * (wageind[1992 - 1947] / wageind[year - 1947]);

            earningstot = earningstot + earnings;
            earningsyears = earningsyears + 1;
            }

          if (earningsyears > 0)
          { earningsave = earningstot / earningsyears;
            earningslim = 0.5 * earningsave;

            if (startdate >= 1951)
            for (year = startdate; year < min(1991, enddate); year++)
            if (year == startdate)
            { earnings = ssearnings[year - cohort]
                        * (wageind[1992 - 1947] / wageind[year - 1947]);
              nextearnings = ssearnings[(year + 1) - cohort]
                            * (wageind[1992 - 1947] / wageind[year - 1947]);

              if (earnings == 0 || (earnings < earningslim && nextearnings < earningslim))
              startdate = year + 1;
              }

            if (enddate <= 1991)
            for (year = enddate; year > max(1951, startdate - 1); year--)
            if (year == enddate)
            { earnings = ssearnings[year - cohort]
                        * (wageind[1992 - 1947] / wageind[year - 1947]);
              lastearnings = ssearnings[(year - 1) - cohort]
                            * (wageind[1992 - 1947] / wageind[year - 1947]);

              if (earnings == 0 || (earnings < earningslim && lastearnings < earningslim))
              enddate = year - 1;
              }
            }

          if (enddate < startdate)
          jobvars[jobno].jobind = 0;

          jobvars[jobno].startdate = startdate;
          jobvars[jobno].enddate = enddate;
          }
        }
      }
    }

  for (govtjob = 5; govtjob < 9; govtjob++)
  if (jobvars[govtjob].jobind == 1)
  { if (matchcode == 1 && jobvars[govtjob].sscoverage == 1)
	 { startdate = jobvars[govtjob].startdate;
	   enddate   = jobvars[govtjob].enddate;

		if (1910 <= startdate && startdate <= enddate && enddate <= 1993)
		{ earningstot = 0;
        earningsyears = 0;

		  for (year = startdate; year <= enddate; year++)
		  if (1951 <= year && year <= 1991)
		  { earnings = ssearnings[year - cohort]
                    * (wageind[1992 - 1947] / wageind[year - 1947]);

          earningstot = earningstot + earnings;
          earningsyears = earningsyears + 1;
          }

        if (earningsyears > 0)
        { earningsave = earningstot / earningsyears;
          earningslim = 0.5 * earningsave;

          if (startdate >= 1951)
          for (year = startdate; year < min(1991, enddate); year++)
          if (year == startdate)
          { earnings = ssearnings[year - cohort]
                      * (wageind[1992 - 1947] / wageind[year - 1947]);
            nextearnings = ssearnings[(year + 1) - cohort]
                          * (wageind[1992 - 1947] / wageind[year - 1947]);

            if (earnings < earningslim && nextearnings < earningslim)
            startdate = year + 1;
            }

          if (enddate <= 1991)
          for (year = enddate; year > max(1951, startdate - 1); year--)
          if (year == enddate)
          { earnings = ssearnings[year - cohort]
                      * (wageind[1992 - 1947] / wageind[year - 1947]);
            lastearnings = ssearnings[(year - 1) - cohort]
                          * (wageind[1992 - 1947] / wageind[year - 1947]);

            if (earnings < earningslim && lastearnings < earningslim)
            enddate = year - 1;
            }
          }

        if (enddate < startdate)
        jobvars[govtjob].jobind = 0;

        jobvars[govtjob].startdate = startdate;
        jobvars[govtjob].enddate = enddate;
        }
      }
    }

  if (respvars->caseid == printcaseid)
  { wnprintf("\njobind: "); for (jobno = 0; jobno < 9; jobno++) wnprintf("%6d", jobvars[jobno].jobind);
    wnprintf("\nstartd: "); for (jobno = 0; jobno < 9; jobno++) wnprintf("%6d", jobvars[jobno].startdate);
    wnprintf("\nenddat: "); for (jobno = 0; jobno < 9; jobno++) wnprintf("%6d", jobvars[jobno].enddate);
    }


  /* construct tenure, experience, and non-social security vectors */

  lftage = 0;
  lftjob = -9;

  for (age = 0; age <= 100; age++)
  { ten[age] = -1;
    exper[age] = -1;
    nonss[age] = 0;
	 }

  for (jobno = 4; jobno >= 0; jobno--)
  if (jobvars[jobno].jobind == 1)
  { startdate = jobvars[jobno].startdate;
    enddate = jobvars[jobno].enddate;

    if (0 < startdate && startdate <= enddate && enddate <= 1993)
    { if (enddate > 1992)
      enddate = 1992;

      if (jobno == 0 || lftage <= enddate - cohort)
      { lftage = enddate - cohort;
        lftjob = jobno;
        }

      for (year = startdate; year <= enddate; year++)
      { age = year - cohort;

        if (0 <= age && age <= 100)
        { ten[age] = year - startdate;

          if (jobvars[jobno].sscoverage == 0)
          nonss[age] = 1;
          else if (jobvars[jobno].sscoverage == 1)
          nonss[age] = 0;
          }
        }
      }
    }

  for (govtjob = 8; govtjob >= 5; govtjob--)
  if (jobvars[govtjob].jobind == 1)
  { startdate = jobvars[govtjob].startdate;
    enddate = jobvars[govtjob].enddate;

    if (0 < startdate && startdate <= enddate && enddate <= 1993)
    { if (enddate > 1992)
      enddate = 1992;

      if (enddate + 1 == lftage + 1)
      enddate = enddate - 1;

      if (lftjob != 0 && lftage < enddate - cohort)
      { lftage = enddate - cohort;
        lftjob = govtjob;
        }

      tenure = 0;

      for (year = startdate; year <= enddate; year++)
      { age = year - cohort;

        if (0 <= age && age <= 100)
        { if (ten[age] < 0)
          { ten[age] = tenure;

            tenure = tenure + 1;

            if (jobvars[govtjob].sscoverage == 0)
            nonss[age] = 1;
            else if (jobvars[govtjob].sscoverage == 1)
            nonss[age] = 0;
            }
          else tenure = 0;
          }
        }
      }
    }

  /* get experience prior to 92 current/last job from 96 survey */

  ed = eval(1, 207);

  if (ed == 17)
  ed = 20;                         /* code for upper tail */

  if (ed < 12)
  firstage = 19;
  else firstage = ed + 7;

  marstat = eval(1, 225);        /* A10: 1992 marital status */

  if (marstat == 1 || marstat == 7 || marstat == 8)
  mar = 1;
  else mar = 0;

  firstyear = eval(3, 3097);
  lastyear  = eval(3, 3098);

  ftyears = -9;

  if (firstyear < 1920 || firstyear > 1996 || lastyear < 1920 || firstyear > 1996)
  { allyears = eval(3, 3100);

	 if (allyears == 1 || allyears == 2)
	 { allyears = eval(3, 3095);     /* full-time & part-time years */

		if (allyears == 2)
		{ firstyear = eval(3, 3091);
		  lastyear  = eval(3,  189);
		  }
		else
		{ ftyears = eval(3, 3094);

		  if (ftyears < 0 || ftyears > 50)
		  { firstyear = eval(3, 3092);
			 lastyear  = eval(3, 3093);
			 }
		  }
		}
	 }

  if (1920 <= firstyear && firstyear <= lastyear && lastyear <= 1996)
  { /* range of full-time years given */

	 for (year = firstyear; year <= min(lastyear, cohort + lftage); year++)
    if (year <= 1992)
	 { age = year - cohort;

		if (firstage <= age && ten[age] < 0)
		ten[age] = 0;
		}
	 }
  else    /* number of full-time years given, but not range */
  { if (ftyears < 0 || ftyears > 50)
	 ftyears = eval(3, 3099);

	 if (0 <= ftyears && ftyears <= 50)
	 { lastyear = eval(3, 189);

      if (lastyear > 1920)
		lastage = (lastyear - cohort) - 1;
      else lastage = 1992 - cohort;

		expersum = 0;

		for (age = 0; age <= lastage; age++)
		if (ten[age] >= 0)
		expersum = expersum + 1;

		if (expersum < ftyears)
		for (age = min(lastage, lftage); age >= firstage; age--)
		if (expersum < ftyears && ten[age] < 0)
		{ ten[age] = 0;
		  expersum = expersum + 1;
		  }
		}
	 else if (matchcode == 1)
	 { firstyear = eval(3, 3091);
		lastyear = eval(3, 189);

		if (firstyear != 9995          /* never */
		 && (gender == 1 || mar == 0)  /* males and nonmarried females only */
		 && (firstyear <= 0 || firstyear >= 9998
        || lastyear <= 0 || firstyear < lastyear))
		{ if (firstyear < cohort + firstage || firstyear >= 9998)
        firstyear = cohort + firstage;

        if (lastyear <= 0 || everworked == 5 || nlfperiod == 1)
        { if (curjob == 1)
          lastyear = 1992;
          else if (everworked == 5)           /* never worked */
          lastyear = 0;
          else
          { lastyear = eval(1, 3403);

            if (lastyear < 1922 || lastyear > 1993)
            { if (nlfperiod == 2)
              lastyear = 1981;
              else lastyear = (int) (firstyear + 0.75 * (1971 - firstyear));
              }
            }
          }

        for (age = firstyear - cohort; age <= min(lastyear - cohort, lftage); age++)
		  if (age <= 1992 - cohort && ten[age] < 0)
		  ten[age] = 0;
		  }
		}
    else
    { firstyear = eval(3, 3091);
      lastyear  = eval(3,  189);

      if (firstyear < 1920 || firstyear > 1996 || lastyear < 1920 || lastyear > 1996
       || firstyear < lastyear)
      respvars->goodobs.goodFTyears = 0;
      }
	 }

  /* if (respvars->goodobs.goodCareer == 1 && respvars->goodobs.goodFTyears == 0
   && eval(3, 3091) != -9999)
   wnprintf("\n%1d %5d %5d   %5d %5d %5d %5d   %5d %5d %5d %5d",
    matchcode, eval(3, 3091), eval(3, 189), eval(3, 3092), eval(3, 3093), eval(3, 3094), eval(3, 3095),
    eval(3, 3097), eval(3, 3098), eval(3, 3099), eval(3, 3100)); */

  exper[firstage] = 0;

  for (age = firstage; age <= 1992 - cohort; age++)
  if (ten[age] >= 0)
  exper[age + 1] = exper[age] + 1;
  else exper[age + 1] = exper[age];

  if (respvars->caseid == printcaseid)
  { wnprintf("    %d %d %d %d", cohort + firstage, firstyear, lastyear, ftyears);
    wnprintf("\nten: ");
    for (year = 1953; year < 1993; year++)
    { if (year > 1953 && year % 20 == 13)
      wnprintf("\n     ");

      if (year > cohort)
      wnprintf("%3d", ten[year - cohort]);
      else wnprintf("   ");
      }
    wnprintf("  lft %d %d", lftjob, lftage);
    wnprintf("\nexp: ");
    for (year = 1953; year < 1993; year++)
    { if (year > 1953 && year % 20 == 13)
      wnprintf("\n     ");

      if (year > cohort)
      wnprintf("%3d", exper[year - cohort]);
      else wnprintf("   ");
      }
    wnprintf("\nnss: ");
    for (year = 1953; year < 1993; year++)
    { if (year > 1953 && year % 20 == 13)
      wnprintf("\n     ");

      if (year > cohort)
      wnprintf("%3d", nonss[year - cohort]);
      else wnprintf("   ");
      }
    }

    
  /* construct earnings history */

  lastwageage  = 0;
  realwagebase = -99;

  srearningsflag = 0;

  for (age = 0; age <= 100; age++)
  impearnings[age] = 0;

  for (jobno = 0; jobno < 5; jobno++)
  if (jobvars[jobno].jobind == 1)
  { startdate = jobvars[jobno].startdate;
    enddate = jobvars[jobno].enddate;
    earnings = jobvars[jobno].earnings;

    if (0 < earnings && 1920 <= startdate && startdate <= enddate && enddate <= 1993)
    { srearningsflag = 1;
      age = enddate - cohort;

      impearnings[age] = jobvars[jobno].earnings;

      if (age > lastwageage)
      { lastwageage = age;

        /* experience/tenure coefficients from e:\mrrc\hrsfamrt\wageanal.log */
	     realwagebase = log(jobvars[jobno].earnings)
          - 0.0171803 * exper[age] + 0.0002839 * exper[age] * exper[age]
		    - 0.0203934 * ten[age]   + 0.0003245 * ten[age] * ten[age];
        }
      }
    }

  if (srearningsflag == 1)
  { for (age = lftage; age >= firstage; age--)
    { if (impearnings[age] > 0)
	   { wage = impearnings[age];

	     realwagebase = log(wage)
          - 0.0171803 * exper[age] + 0.0002839 * exper[age] * exper[age]
		    - 0.0203934 * ten[age]   + 0.0003245 * ten[age] * ten[age];
		  }

	   if (ten[age] >= 0)
	   { year = cohort + age;

	     realwage = exp(realwagebase
          + 0.0171803 * exper[age] - 0.0002839 * exper[age] * exper[age]
		    + 0.0203934 * ten[age]   - 0.0003245 * ten[age] * ten[age]);

		  if (year < 1947)
		  wage = realwage * (wageind[1947 - 1947] / wageind[1992 - 1947])
		    * pow((wageind[1952 - 1947] / wageind[1947 - 1947]), ((year - 1947) / 5.0));
		  else wage = realwage * wageind[year - 1947] / wageind[1992 - 1947];

		  impearnings[age] = wage;
		  }
	   else impearnings[age] = 0;
      }
    }

  if (respvars->caseid == printcaseid)
  { wnprintf("\nsrearn:  ");
    for (year = 1953; year < 1993; year++)
    { if (year > 1953 && year % 10 == 3)
      wnprintf("\n         ");

      if (year > cohort)
      wnprintf("%6.0f", impearnings[year - cohort]);
      else wnprintf("      ");
      }
    }

  /* imputed earnings equal ss earnings unless ss earnings are at the ss */
  /* maximum and sr earnings are higher or job is not in social security */

  if (matchcode == 1)
  { for (year = 1951; year <= 1991; year++)
	 { age = year - cohort;

      if (0 <= age && age <= lftage)
		{ if (nonss[age] == 0)
        { if (ssearnings[age] < ssmax[year - 1951]
		     || impearnings[age] < ssmax[year - 1951])
		    impearnings[age] = ssearnings[age];
          }
        else
        { if (ssearnings[age] > impearnings[age])
          impearnings[age] = ssearnings[age];
          }
        }
		}

    /* if no self-reported earnings, check to see if ss earnings */
    /* are over maximum or if there were non-ss jobs             */

    if (srearningsflag == 0)
    { count = 0;
      maxcount = 0;

      for (year = 1991; year >= 1951; year--)
      if (count < 12 && cohort <= year)
      { age = year - cohort;

        if (age <= lftage)
        { if (ssearnings[age] == ssmax[year - 1951])
          maxcount = maxcount + 1;

          count = count + 1;
          }
        }

      if (count == 0 || 2 * maxcount >= count)
      respvars->goodobs.goodSSearn = 0;

      for (jobno = 0; jobno < 9; jobno++)
      if (jobvars[jobno].sscoverage == 0)
      respvars->goodobs.goodSSearn = 0;

      /* project 1992 earnings */

      if (lftage == 1992 - cohort)
      for (year = 1991; year >= 1952; year--)
      { age = year - cohort;

        if (impearnings[lftage] == 0)
        if (impearnings[age] > impearnings[age - 1])
        impearnings[lftage] = impearnings[age] * (wageind[1992 - 1947] / wageind[year - 1947]);
        }
      }
    }


  /* construct social security earnings history if no record */

  if (matchcode == 0 && srearningsflag == 1)
  { for (age = 0; age <= 100; age++)
    ssearnings[age] = 0;

    for (year = 1951; year < 1992; year++)
    { age = year - cohort;

      if (0 <= age && age <= lftage)
      if (nonss[age] == 0)
      { if (impearnings[age] < ssmax[year - 1951])
        ssearnings[age] = impearnings[age];
        else ssearnings[age] = ssmax[year - 1951];
        }
      }

    /* zero out years before immigrants entered the country */

    foreignborn = eval(1, 204);
    yearentered = eval(1, 206);

	 if (foreignborn == 5 && 1951 <= yearentered && yearentered <= 1992)
	 { for (age = 1951 - cohort; age < yearentered - cohort; age++)
		ssearnings[age] = 0;
		}
    }
  else if (matchcode == 1)
  { for (year = 1951; year <= 1991; year++)
    { age = year - cohort;

      if (lftage < age && age <= 100)
      ssearnings[age] = 0;
      }
    }


  /* determine social security at end of last full-time job */

  if (lftjob >= 0)
  { if (matchcode == 1 && jobvars[lftjob].sscoverage == 0)
    { startdate = jobvars[lftjob].startdate;
      enddate = jobvars[lftjob].enddate;

      earningstot = 0;
      ssearningstot = 0;
      earningsyears = 0;

		for (year = max(startdate, enddate - 5); year <= enddate; year++)
		if (1951 <= year && year <= 1991 && cohort <= year)
		{ age = year - cohort;

        if (impearnings[age] < ssmax[year - 1951])
        earningstot = earningstot + impearnings[age];
        else earningstot = earningstot + ssmax[year - 1951];

        ssearningstot = ssearningstot + ssearnings[age];

        earningsyears = earningsyears + 1;
        }

      if (earningsyears > 0)
      { earningsave = earningstot / earningsyears;
        ssearningsave = ssearningstot / earningsyears;

        if (ssearningsave < 0.6 * earningsave)
        lftsscov = 0;
        else lftsscov = 1;
        }
      else lftsscov = 1;
      }
    else lftsscov = jobvars[lftjob].sscoverage;
    }
  else lftsscov = -9;


  /* assign 1992 social security if necessary */

  if (lftage == 1992 - cohort && lftsscov == 1)
  { if (impearnings[1992 - cohort] < ssmax[1992 - 1951])
    ssearnings[1992 - cohort] = impearnings[1992 - cohort];
    else ssearnings[1992 - cohort] = ssmax[1992 - 1951];
    }

  if (respvars->caseid == printcaseid)
  { wnprintf("\nimpearn: ");
    for (year = 1953; year < 1993; year++)
    { if (year > 1953 && year % 10 == 3)
      wnprintf("\n         ");

      if (year > cohort)
      wnprintf("%6.0f", impearnings[year - cohort]);
      else wnprintf("      ");
      }
    wnprintf("    %d", lftsscov);
    wnprintf("\nssearn:  ");
    for (year = 1953; year < 1993; year++)
    { if (year > 1953 && year % 10 == 3)
      wnprintf("\n         ");

      if (year > cohort)
      wnprintf("%6.0f", ssearnings[year - cohort]);
      else wnprintf("      ");
      }
    }


  /* calculate if subject to windfall elimination or non-covered pension */

  windfallflag = 0;
  ncpensyear = -9;
  ncpensamt = 0;

  for (jobno = 0; jobno < 9; jobno++)
  if (jobvars[jobno].jobind == 1)
  { if (jobno < 5)
    { govtjob = -9;

      for (gjob = 9; gjob >= 5; gjob--)
      if (jobvars[jobno].samejob[gjob - 5] == gjob)
      govtjob = gjob;
      }
    else govtjob = jobno;

    if (jobvars[jobno].sscoverage == 0 && jobvars[jobno].pencoverage == 1)
    { startdate = jobvars[jobno].startdate;
      enddate = jobvars[jobno].enddate;

      if (enddate - startdate >= 5)
      { if (govtjob < 7 || govtjob > 8 || 1984 < startdate || enddate < 1984)
        windfallflag = 1;

        if (jobno < 5)
        if (jobvars[jobno].pencoverage == 1)
        { if (jobno != lftjob)
          { if (matchcode == 1 || srearningsflag == 1)
            ncpensamt = ncpensamt + ncpencalc(cohort, gender, startdate, enddate, impearnings);
            }
          else ncpensyear = startdate;
          }
        }
      }
    }

  if (respvars->caseid == printcaseid)
  wnprintf("    %d %.0f %d", windfallflag, ncpensamt, ncpensyear);


  /* project potential earnings past last full time year */

  if (lftage > 0 && (matchcode == 1 || srearningsflag == 1))
  if (impearnings[lftage] > 0)
  { if (matchcode == 1)
    { startdate = jobvars[lftjob].startdate;
      enddate = jobvars[lftjob].enddate;

      if (enddate - startdate > 1)
      { if (impearnings[lftage - 1] > impearnings[lftage])
        lastwageage = lftage - 1;
        else lastwageage = lftage;
        }
      else if (enddate - startdate == 1)
      { if (lftjob == 0)
        lastwageage = lftage;
        else
        { if (impearnings[lftage - 1] > impearnings[lftage])
          lastwageage = lftage - 1;
          else lastwageage = lftage;
          }
        }
      else lastwageage = lftage;
      }
    else lastwageage = lftage;

    year = cohort + lastwageage;
    wage = impearnings[lastwageage];

	 if (year < 1947)
	 realwage = wage * (wageind[1992 - 1947] / wageind[1947 - 1947])
		* pow((wageind[1952 - 1947] / wageind[1947 - 1947]), ((1947 - year) / 5.0));
	 else realwage = wage * (wageind[1992 - 1947] / wageind[year - 1947]);

    if (ten[lastwageage] >= 0 && exper[lastwageage] >= 0)
	 realwagebase = log(realwage)
      - 0.0171803 * exper[lastwageage] + 0.0002839 * exper[lastwageage] * exper[lastwageage]
		- 0.0203934 * ten[lastwageage]   + 0.0003245 * ten[lastwageage] * ten[lastwageage];
    else realwagebase = log(realwage);

    for (age = lastwageage + 1; age <= 75; age++)
	 { if (ten[lastwageage] >= 0 && exper[lastwageage] >= 0)
      { tenure = ten[lastwageage] + (age - lastwageage);
        experience = exper[lastwageage] + (age - lastwageage);

        realwage = exp(realwagebase
          + 0.0171803 * experience - 0.0002839 * experience * experience
		    + 0.0203934 * tenure     - 0.0003245 * tenure * tenure);
        }

      year = cohort + age;

		if (year < 1947)
		wage = realwage * (wageind[1947 - 1947] / wageind[1992 - 1947])
		  * pow((wageind[1952 - 1947] / wageind[1947 - 1947]), ((year - 1947) / 5.0));
		else if (year <= 1992)
      wage = realwage * wageind[year - 1947] / wageind[1992 - 1947];
      else
      { if (year == 1993)
        cumwagegrowth = 1 + wGrowthRate[1992 - 1992] / 100.0;
        else if (year <= 2020)
        cumwagegrowth = cumwagegrowth * (1 + wGrowthRate[(year - 1) - 1992] / 100.0);
        else cumwagegrowth = cumwagegrowth * (1 + wGrowthRate[2020 - 1992] / 100.0);

        wage = realwage * cumwagegrowth;
        }

      impearnings[age] = wage;

      if (lftsscov == 1)
      if (year > 1951 && ssearnings[lastwageage] > 0)
      { if (year <= 1992)
        ssearnings[age] = min(wage, ssmax[year - 1951]);
        else ssearnings[age] = min(wage, ssmax[1992 - 1951] * (wage / realwage));
        }
      }
    }

  if (respvars->caseid == printcaseid)
  { wnprintf("\nimpearn: ");
    for (year = 1973; year < 2003; year++)
    { if (year > 1973 && year % 10 == 3)
      wnprintf("\n         ");

      if (year > cohort)
      wnprintf("%6.0f", impearnings[year - cohort]);
      else wnprintf("      ");
      }
    wnprintf("\nssearn:  ");
    for (year = 1973; year < 2013; year++)
    { if (year > 1973 && year % 10 == 3)
      wnprintf("\n         ");

      if (year > cohort)
      wnprintf("%6.0f", ssearnings[year - cohort]);
      else wnprintf("      ");
      }
    }


  /* take another look at whether this is a career worker */

  if (lftage >= 50 || (1992 - cohort < 50 && 1992 - cohort <= lftage))
  { if (respvars->goodobs.goodCareer == 1)
    { yearcount = 0;
      ftcount = 0;

      for (age = min(40, 1982 - cohort); age <= lftage; age++)
      { if (impearnings[age] > 0)
        ftcount = ftcount + 1;

        yearcount = yearcount + 1;
        }

      if (2 * ftcount <= yearcount)
      respvars->goodobs.goodCareer = 0;
      }
    else
    { yearcount = 0;
      ftcount = 0;

      lftearnings = impearnings[lftage];

      for (age = min(40, 1982 - cohort); age <= lftage; age++)
      { if (impearnings[age] * (wageind[max(min(lftage + cohort, 1992), 1947) - 1947]
          / wageind[max(min(age + cohort, 1992), 1947) - 1947]) > 0.60 * lftearnings)
        ftcount = ftcount + 1;

        yearcount = yearcount + 1;
        }

      if (2 * ftcount > yearcount)
      respvars->goodobs.goodCareer = 1;
      }
    }
  else respvars->goodobs.goodCareer = 0;


  /* note the starting and stopping dates of pension jobs */

  for (jobno = 0; jobno < 5; jobno++)
  { if (jobvars[jobno].jobind == 1 && jobvars[jobno].pencoverage == 1
     && 1920 <= jobvars[jobno].startdate && jobvars[jobno].enddate <= 1993
     && jobvars[jobno].startdate <= jobvars[jobno].enddate)
    { respvars->penstartdate[jobno] = jobvars[jobno].startdate;

      if (jobno == lftjob)
      respvars->penenddate[jobno] = 9999;
      else respvars->penenddate[jobno] = jobvars[jobno].enddate;

      if (jobno < 3)
      respvars->penhours[jobno] = jobvars[jobno].hours;
      }
    else
    { respvars->penstartdate[jobno] = -9;
      respvars->penenddate[jobno] = -9;

      if (jobno < 3)
      respvars->penhours[jobno] = -9;
      }
    }

  respvars->pencontrib = pencontr;

  respvars->windfallflag = windfallflag;
  respvars->ncpensyear   = ncpensyear;
  respvars->ncpensamt    = ncpensamt;

  for (age = 0; age <= 100; age++)
  { respvars->earnings[age]   = impearnings[age];
    respvars->ssearnings[age] = ssearnings[age];
    }

  }


/*---------------------------------------------------------------------------
			 NON-COVERED PENSION CALC routine
			 calculates pensions for non-covered jobs
  ---------------------------------------------------------------------------*/

float ncpencalc(
  int   cohort,             /* cohort of participant     */
  int   gender,             /* gender of participant     */
  int   hireyear,           /* year of hire              */
  int   endyear,            /* last year of work         */
  float *earnings)          /* vector of annual earnings */

{ int   age, year;
  float pv55, pv62, disc;
  float avewage, pen;

  float surv[120];

  static float cpiind[42] = {
			  26.0,  26.5,  26.7,  26.9,  26.8,  27.2,  28.1,  28.9,  29.1,
	 29.6,  29.9,  30.2,  30.6,  31.0,  31.5,  32.4,  33.4,  34.8,  36.7,
	 38.8,  40.5,  41.8,  44.4,  49.3,  53.8,  56.9,  60.6,  65.2,  72.6,
	 82.4,  90.9,  96.5,  99.6, 103.9, 107.6, 109.6, 113.6, 118.3, 124.0,
	130.7, 136.2, 140.3};
  /* 1951-1992 CPI-U, Table B-59, 1995 ERP */

  static float inflationRate[29] = {
			 2.9,  2.8,  2.8,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,
	 3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,
	 3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0};
  /* CPI inflation rate, 1992-2020, in Table II.D1, p. 59, in the   */
  /* 1993 Annual Report of the Board of Trustees of Social Security */
  /* static float inflationRate[29] = {
			 2.9,  2.8,  2.5,  3.1,  3.2,  3.3,  3.4,  3.5,  3.7,
	 3.9,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,
	 4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0};
     CPI inflation rate, 1992-2020, in Table II.D1, p. 56, in the
     1995 Annual Report of the Board of Trustees of Social Security */

  /* Calculations assume full benefit at age 62 of 1.2% times final salary   */
  /* times years of service.  Benefits can start at 55, reduced actuarially. */
  /* Once started, benefits are adjusted for inflation.                      */

  avewage = 0;

  for (year = endyear - 3; year < endyear; year++)
  avewage = avewage + earnings[year - cohort];

  avewage = avewage / 3;

  pen = 0.012 * avewage * (endyear - hireyear);    /* full pension */

  if (endyear - cohort < 62)                                /* early retirement reduction */
  { getSurvivalRates(cohort, gender, surv);

    pv55 = 0;
    pv62 = 0;
    disc = 1.0;

    for (age = 55; age < 120; age++)
    { if (age >= endyear - cohort)
      pv55 = pv55 + surv[age] * disc;

      if (age >= 62)
      pv62 = pv62 + surv[age] * disc;

      disc = disc / 1.063;
      }

    pen = pen * (pv62 / pv55);
    }

  if (max(endyear, cohort + 55) < 1992)     /* express pension in 1992 $ */
  pen = pen * (cpiind[1992 - 1951] / cpiind[max(endyear, cohort + 55) - 1951]);
  else
  { for (year = 1992; year < max(endyear, cohort + 55); year++)
    { if (year < 2020)
      pen = pen / (1 + 0.01 * inflationRate[year - 1992]);
      else pen = pen / (1 + 0.01 * inflationRate[2020 - 1992]);
      }
    }

  pen = 0.6667 * pen;       /* only 2/3 of pension is used in ss calculations */

  /* wnprintf("\n   %d %d %d %d %d %5.0f %5.0f %5.0f %5.0f",
   gender, cohort, hireyear, endyear, retyear, earnings[endyear - cohort - 3],
    earnings[endyear - cohort - 2], earnings[endyear - cohort - 1], pen); */

  return(pen);
  }


/*---------------------------------------------------------------------------
			 GET PENSIONS
			 calculates pension accruals
  ---------------------------------------------------------------------------*/

int   penscodes[30000][3][4][2];

void getPensions(
  struct respdata *respvars)

{ int   threadno, filenumber;
  int   loc, floc, count, nobs, goodobs, year;
  int   recno, jobno, pennumber, nprevpens;
  int   caseid, matchid, codeid, seqno;
  int   caseidp, codeidp, seqnop;
  int   birthyear, spbirthyear;
  int   startdate, enddate;
  int   gender, hours;
  int   pentype, imppens, flength;
  int   age, curage, tenure, curten;
  int   lrecno, lstartdate, lenddate;
  float earnings, contrib;
  float fbirthyear, fspbirthyear;
  float fstartdate, fenddate;
  float fage, ftenure, fbenage, fyear;
  float qw, generosity, generosity30;
  float annualben, presvalue, age65equiv;
  float ssbase, curben, vestedben, startben;
  float wgrowth, wlinear, wquadr;
  float lastpv, accrual;
  float penvalue, penaccrual, adj, cumearnings;


  void  *arglist[4];
  int   thread[4], vector[200];
  char  filename[16], inrecord[250], zeros[10000];
  float surv[120], genvec[500];
  float generositymat[51][51];

  int   *pendata;
  void  *vpendata;

  static float wageind[46] = {                             45.58,  49.00,  50.24,
	50.13,  57.86,  60.65,  63.76,  64.52,  67.72,  70.74,  73.33,  75.08,  78.78,
	80.67,  82.60,  85.91,  88.46,  91.33,  95.45,  98.82, 101.84, 107.73, 114.61,
  119.83, 127.31, 136.90, 145.39, 154.76, 163.53, 175.45, 189.00, 203.70, 219.91,
  235.10, 255.20, 267.26, 280.70, 292.86, 299.09, 304.85, 312.50, 322.02, 334.24,
  345.35, 353.98, 363.61};
  /* 1947-1992 average weekly earnings           */
  /* Table B41, 1986 ERP and Table B45, 1995 ERP */

  FILE  *partic, *lastjdb, *lastjdc, *prevjdb, *prevjdc;
  FILE  *penfile, *datafile;
  int   handle;


  initPensions();

  /* The current pension for this respondent has a huge decline in present */
  /* at the early retirement age, and continuing declines during early     */
  /* retirement.  It is being treated as miscoded.                         */
  for (pennumber = 0; pennumber < 4; pennumber++)
  penscodes[23067][0][pennumber][0] = 0;

  if (access("pendata.enc", 0) < 0)
  { /* prepare participant files */

    lastjdb = fopen("partic.ldb", "wt");
    lastjdc = fopen("partic.ldc", "wt");
    prevjdb = fopen("partic.pdb", "wt");
    prevjdc = fopen("partic.pdc", "wt");

    for (recno = 0; recno < 12652; recno++)
    { caseid = respvars[recno].caseid;
      matchid = respvars[recno].matchid;

      if (respvars[recno].goodobs.sameSpouse   == 1
       && respvars[recno].goodobs.goodCareer   == 1
       && respvars[recno].goodobs.goodAge      == 1
       && respvars[recno].goodobs.goodEarnings == 1
       && respvars[recno].goodobs.goodSSstatus == 1
       && respvars[recno].goodobs.goodFTyears  == 1
       && respvars[recno].goodobs.goodSSearn   == 1)
      { if (caseid < 20000 && matchid >= 20000)
        { if (matchid == respvars[recno + 1].caseid)
          { goodobs = 1;
            spbirthyear = respvars[recno + 1].vint;
            }
          else goodobs = 0;
          }
        else if (caseid >= 20000 && matchid < 20000)
        { if (matchid == respvars[recno - 1].caseid)
          { goodobs = 1;
            spbirthyear = respvars[recno - 1].vint;
            }
          else goodobs = 0;
          }
        else goodobs = 0;
        }
      else goodobs = 0;

      if (goodobs == 1)
      for (jobno = 0; jobno < 3; jobno++)
      { startdate = respvars[recno].penstartdate[jobno];
        enddate = respvars[recno].penenddate[jobno];

        if (startdate > 0 && enddate > 0)
        { for (pennumber = 0; pennumber < 4; pennumber++)
          if (penscodes[caseid][jobno][pennumber][0] > 0)
          { codeid = penscodes[caseid][jobno][pennumber][0];
            seqno  = penscodes[caseid][jobno][pennumber][1];

            gender = respvars[recno].gender;
            birthyear = respvars[recno].vint;
            hours = respvars[recno].penhours[jobno];

            if (jobno == 0)
            contrib = respvars[recno].pencontrib;
            else contrib = 5;

            if (respvars[recno].penenddate[jobno] < 9999)
            { if (enddate > birthyear + 76)
              enddate = birthyear + 76;

              earnings = respvars[recno].earnings[enddate - birthyear];

              if (codeid < 3000)
              partic = prevjdb;
              else partic = prevjdc;
              }
            else
            { enddate = birthyear + 76;
              earnings = respvars[recno].earnings[1992 - birthyear];

              if (codeid < 3000)
              partic = lastjdb;
              else partic = lastjdc;
              }

            fprintf(partic, "%5d %4d %4d %4d.5 %1d %4d.5 %4d.5 %4d.5 %4d %6.0f 0 %4.2f 0 0 %5d\n",
              caseid, codeid, seqno, spbirthyear, gender, birthyear,
              startdate, enddate, hours, earnings, contrib, recno);

            if (respvars[recno].penenddate[jobno] < 9999)
            { fprintf(partic, "%4d.0 %4d.0", startdate, enddate);

              for (year = startdate; year <= enddate; year++)
              { earnings = respvars[recno].earnings[year - birthyear];

                if (earnings == 0)
                earnings = 1;

                fprintf(partic, " %5.0f", earnings);

                if (year < enddate && (year - startdate) % 12 == 11)
                fprintf(partic, "\n");
                }

              fprintf(partic, " -1.0\n");
              }
            }
          }
        }
      }

    fclose(lastjdb);
    fclose(lastjdc);
    fclose(prevjdb);
    fclose(prevjdc);

    /* run pension provider program */

    for (threadno = 0; threadno < 4; threadno++)
    { thread[threadno] = threadno + 1;

      arglist[threadno] = (void *) &(thread[threadno]);

      _beginthread(pensCalc, 65536, arglist[threadno]);

      if (threadno > 0)
      while(thread[threadno - 1] > 0)
      checkMessages();
      }

    while(thread[3] > 0)
    checkMessages();

    /* get output of pension provider progam */

    penfile = fopen("pendata.cmp", "wb");
    handle = fileno(penfile);

    for (filenumber = 0; filenumber < 2; filenumber++)
    { if (filenumber == 0)
      strcpy(filename, "penout.pdb");
      else strcpy(filename, "penout.pdc");

      datafile = fopen(filename, "rt");

      while(fgets(inrecord, 250, datafile) != NULL)
      { if (strlen(inrecord) >= 15)
        { sscanf(inrecord, "%d %d %d %d %f %f %f %f %f %f %f %d %f %f %f %f %f %f %f %d",
           &caseid, &codeid, &seqno, &gender, &fspbirthyear, &fbirthyear,
           &fstartdate, &fenddate, &earnings, &fage, &ftenure, &pentype, &fbenage,
           &qw, &generosity, &generosity30, &annualben, &presvalue, &age65equiv,
           &recno);

          vector[0] = recno;
          vector[1] = (int) fstartdate;
          vector[2] = (int) fenddate;
          * (float *) &(vector[3]) = presvalue;

          write(handle, vector, 4 * sizeof(int));
          }
        }

      fclose(datafile);
      }

    vector[0] = -1;
    write(handle, vector, sizeof(int));

    for (filenumber = 0; filenumber < 2; filenumber++)
    { if (filenumber == 0)
      strcpy(filename, "penout.ldb");
      else strcpy(filename, "penout.ldc");

      datafile = fopen(filename, "rt");

      if (filenumber == 0)
      strcpy(filename, "partic.ldb");
      else strcpy(filename, "partic.ldc");

      partic = fopen(filename, "rt");

      caseidp   = 0;
      codeidp   = 0;
      seqnop    = 0;
      loc       = 0;
      startdate = 0;
      enddate   = 0;

      while(fgets(inrecord, 250, datafile) != NULL)
      { if (strlen(inrecord) >= 15)
        { sscanf(inrecord, "%d %d %d %f %d %f %f %f %f %d %f %f %f",
           &caseid, &codeid, &seqno, &fyear, &fage, &ftenure, &earnings, &ssbase,
           &curben, &pentype, &vestedben, &startben, &presvalue);

          if (caseid != caseidp || codeid != codeidp || seqno != seqnop)
          { if (2 * (enddate - startdate + 1) != loc - 3)
            vector[2] = startdate + (loc - 3) / 2 - 1;

            write(handle, vector, loc * sizeof(int));

            fgets(inrecord, 250, partic);

            sscanf(inrecord, "%d %d %d %f %d %f %f %f %d %f %f %f %f %f %d",
             &caseidp, &codeidp, &seqnop, &fspbirthyear, &gender, &fbirthyear,
             &fstartdate, &fenddate, &hours, &earnings, &wgrowth, &contrib,
             &wlinear, &wquadr, &recno);

            if (caseid != caseidp || codeid != codeidp || seqno != seqnop)
            error("Error in pension file");

            birthyear = (int) fbirthyear;
            startdate = (int) fstartdate;
            enddate   = (int) fenddate;

            vector[0] = recno;
            vector[1] = startdate;
            vector[2] = enddate;
            loc = 3;

            getSurvivalRates(birthyear, gender, surv);

            lastpv = 0;
            }

          year = (int) fyear;

          if (year <= 1992)
          accrual = presvalue - lastpv;
          else accrual = (surv[1992 - birthyear] / surv[year - birthyear])
                * (presvalue - lastpv * (surv[(year - birthyear) - 1] / surv[year - birthyear]));

          lastpv = presvalue;

          * (float *) &(vector[loc]) = accrual;
          * (float *) &(vector[loc + 1]) = presvalue;
          loc = loc + 2;
          }
        }

      if (2 * (enddate - startdate + 1) != loc - 3)
      vector[2] = startdate + (loc - 3) / 2 - 1;

      write(handle, vector, loc * sizeof(int));

      fclose(datafile);
      fclose(partic);
      }

    vector[0] = -2;
    write(handle, vector, sizeof(int));

	 fclose(penfile);

	 encrypt(1, "pendata.cmp", "pendata.enc");
    }
  else encrypt(0, "pendata.enc", "pendata.cmp");

  /* read in pension information */

  penfile = fopen("pendata.cmp", "rb+");
  handle = fileno(penfile);

  flength = filelength(handle);
  count = flength;

  vpendata = malloc(flength);
  pendata = (int *) vpendata;

  read(handle, pendata, flength);

  rewind(penfile);
  memset(zeros, 0, 10000);

  while (count > 0)
  { if (count >= 10000)
    write(handle, zeros, 10000);
    else write(handle, zeros, count);

    count = count - 10000;
    }

  chsize(handle, 0);
  fclose(penfile);
  unlink("pendata.cmp");

  /* for (loc = 2400; loc < 2800; loc++)
  { if (-2000 < pendata[loc] && pendata[loc] < 30000)
    wnprintf(" %d", pendata[loc]);
    else wnprintf(" %.0f", * (float *) &(pendata[loc]));

    if (loc % 10 == 9) wnprintf("\n");
    } */

  /* initialize pension accrual vectors */

  for (recno = 0; recno < 12652; recno++)
  for (age = 0; age < 101; age++)
  respvars[187].penaccrual[age] = -9e10;

  /* skip to current pensions */

  loc = 0;

  while(loc < flength && pendata[loc] != -1)
  loc = loc + 4;

  loc = loc + 1;
  floc = loc;

  /* process current pensions */

  while(loc < flength && pendata[loc] != -2)
  { recno     = pendata[loc];
    startdate = pendata[loc + 1];
    enddate   = pendata[loc + 2];

    birthyear = respvars[recno].vint;
    earnings  = respvars[recno].earnings[1992 - birthyear];

    /* wnprintf("\n%5d %4d %4d %4d", recno, birthyear, startdate, enddate); */

    pendata[loc] = birthyear;
    loc = loc + 3;

    cumearnings = 0;

    for (year = startdate; year <= enddate; year++)
    { penaccrual = * (float *) &(pendata[loc]);
      loc = loc + 1;

      if (year > startdate)
      { /* adjust to nominal values */

        penaccrual = penaccrual * pow(1.063, year + 0.5 - 1992);

        if (respvars[recno].penaccrual[(year - birthyear) - 1] == (float) -9e10)
        respvars[recno].penaccrual[(year - birthyear) - 1] = penaccrual;
        else respvars[recno].penaccrual[(year - birthyear) - 1] =
                respvars[recno].penaccrual[(year - birthyear) -1] + penaccrual;
        }

      /* replace pension values with generosity ratio */

      presvalue = * (float *) &(pendata[loc]);

      presvalue = presvalue * pow(1.063, -0.5);

      cumearnings = cumearnings + earnings;

      if (cumearnings == 0)
      { wnprintf("\n%d %d %d %d", recno, respvars[recno].caseid, startdate, enddate);
        wnprintf("\n   "); for (jobno = 0; jobno < 5; jobno++) wnprintf("  %4d %4d",
         respvars[recno].penstartdate[jobno], respvars[recno].penenddate[jobno]);
        wnprintf("\n         ");
        for (year = 1953; year < 2003; year++)
        { if (year > 1953 && year % 10 == 3)
          wnprintf("\n         ");

          if (year > birthyear)
          if (respvars[recno].earnings[year - birthyear] == (float) -9e10)
          wnprintf("    -9");
          else wnprintf("%6.0f", respvars[recno].earnings[year - birthyear]);
          else wnprintf("      ");
          }
        pause();
        }
      generosity = presvalue / cumearnings;

      * (float *) &(pendata[loc]) = generosity;
      loc = loc + 1;
      }
    }

  /* process past pensions */

  nprevpens = (floc - 1) / 4;

  qsort(pendata, nprevpens, 4 * sizeof(int), pensComp);

  lrecno = -1;
  lstartdate = -1;
  lenddate = -1;

  for (pennumber = 0; pennumber < nprevpens; pennumber ++)
  { loc = 4 * pennumber;

    recno     =               pendata[loc];
    startdate =               pendata[loc + 1];
    enddate   =               pendata[loc + 2];
    penvalue  = * (float *) &(pendata[loc + 3]);

    birthyear = respvars[recno].vint;

    /* discount to the end of job and pro-rate */

    penaccrual = penvalue * pow(1.063, enddate + 0.5 - 1992) / (enddate - startdate + 1);

    /* find years without pension values */

    if (lrecno != recno || lstartdate != startdate || lenddate != enddate)
    { for (age = 0; age <= 100; age++)
      vector[age] = -1;

      for (year = startdate; year <= enddate; year++)
      if (respvars[recno].penaccrual[year - birthyear] == (float) -9e10)
      vector[year - birthyear] = 1;

      lrecno = recno;
      lstartdate = startdate;
      lenddate = enddate;
      }

    for (year = startdate; year <= enddate; year++)
    { if (vector[year - birthyear] == 1)
      { /* adjust to nominal values */

        if (enddate >= 1947)
        { if (year >= 1947)
          adj = (wageind[year - 1947] / wageind[enddate - 1947]);
          else adj = (wageind[1947 - 1947] / wageind[enddate - 1947])
                     * pow(wageind[1947 - 1947] / wageind[1952 - 1947],
                           ((float)(1947 - year)) / 5.0);
          }
        else adj = pow(wageind[1947 - 1947] / wageind[1952 - 1947],
                       ((float)(enddate - year)) / 5.0);

        if (respvars[recno].penaccrual[year - birthyear] == (float) -9e10)
        respvars[recno].penaccrual[year - birthyear] = penaccrual * adj;
        else respvars[recno].penaccrual[year - birthyear] =
                respvars[recno].penaccrual[year - birthyear] + penaccrual * adj;
        }
      }
    }

  /* form matrix from which to impute generosity for previous pensions */

  for (age = 25; age <= 75; age++)
  for (tenure = 0; tenure <= 50; tenure++)
  { generositymat[age - 25][tenure] = -9;

    loc = floc;
    nobs = 0;

    while(loc < flength && pendata[loc] != -2)
    { birthyear = pendata[loc];
      startdate = pendata[loc + 1];
      enddate   = pendata[loc + 2];
      loc = loc + 3;

      for (year = startdate; year <= enddate; year++)
      { curage = year - birthyear;
        curten = year - startdate;

        if (age == curage && tenure - 2 <= curten && curten <= tenure + 2)
        { if (nobs < 500)
          { genvec[nobs] = * (float *) &(pendata[loc + 1]);
            nobs = nobs + 1;
            }
          else error("Too many generosity observations");
          }

        loc = loc + 2;
        }
      }

    /* if (nobs > 0)
    generositymat[age - 25][tenure] = medianCalc(genvec, nobs);
    if (age % 2 == 1) { if (tenure == 0) wnprintf("\n%2d ", age);
    if (tenure % 2 == 0) if (generositymat[age - 25][tenure] == -9) wnprintf("     ");
    else wnprintf("%5.1f", 100 * generositymat[age - 25][tenure]); } */
    }

  /* impute values for past pensions and flag missing current pensions */

  for (recno = 0; recno < 12652; recno++)
  { birthyear = respvars[recno].vint;
    respvars[recno].goodobs.goodPens = 1;

    for (jobno = 0; jobno < 5; jobno++)
    if (respvars[recno].penstartdate[jobno] >= 0)
    { startdate = respvars[recno].penstartdate[jobno];
      enddate   = respvars[recno].penenddate[jobno];

      if (jobno < 3)
      { caseid = respvars[recno].caseid;

        if (penscodes[caseid][jobno][0][0] > 0)
        imppens = 0;
        else imppens = 1;
        }
      else imppens = 1;

      if (imppens == 1)
      { if (enddate == 9999)
        respvars[recno].goodobs.goodPens = 0;
        else
        { age = enddate - birthyear;
          tenure = enddate - startdate;

          if (age < 25)
          age = 25;
          else if (age > 75)
          age = 75;

          if (tenure > 50)
          tenure = 50;

          generosity = generositymat[age - 25][tenure];

          cumearnings = 0;

          for (year = startdate; year <= enddate; year++)
          { earnings = respvars[recno].earnings[year - birthyear];

		      if (year < 1947)
		      adj = (wageind[1992 - 1947] / wageind[1947 - 1947])
		        * pow((wageind[1952 - 1947] / wageind[1947 - 1947]), ((1947 - year) / 5.0));
		      else if (year <= 1992)
            adj = wageind[1992 - 1947] / wageind[year - 1947];
            else if (year == 1993)
            adj = 1 + 0.054;
            else error("Bad date for past pensions");

            cumearnings = cumearnings + adj * earnings;
            }

          penaccrual = generosity * cumearnings / (enddate - startdate + 1);

          for (year = startdate; year <= enddate; year++)
          if (respvars[recno].penaccrual[year - birthyear] == (float) -9e10)
          { if (year < 1947)
		      adj = (wageind[1947 - 1947] / wageind[1992 - 1947])
		        * pow((wageind[1947 - 1947] / wageind[1952 - 1947]), ((1947 - year) / 5.0));
		      else if (year <= 1992)
            adj = wageind[year - 1947] / wageind[1992 - 1947];
            else if (year == 1993)
            adj = 1.0 / (1 + 0.054);
            else error("Bad date for past pensions");

            respvars[recno].penaccrual[year - birthyear] = penaccrual * adj;
            }
          }
        }
      }

    for (age = 0; age < 101; age++)
    if (respvars[recno].penaccrual[age] == (float) -9e10)
    respvars[recno].penaccrual[age] = 0;

    if (recno == 12652)
    { wnprintf("\n%5d %5d %5d %4d", recno, respvars[recno].caseid,
        respvars[recno].matchid, respvars[recno].vint);
      wnprintf(" %1d %1d %1d", respvars[recno].goodobs.sameSpouse,
        respvars[recno].goodobs.goodCareer, respvars[recno].goodobs.goodPens);
      for (jobno = 0; jobno < 5; jobno++)
      { wnprintf("  %4d %4d", respvars[recno].penstartdate[jobno], respvars[recno].penenddate[jobno]);
        if (jobno < 3) wnprintf(" %d", penscodes[respvars[recno].caseid][jobno][0][0]);
        }
      wnprintf("\n         ");
      for (year = 1953; year < 2003; year++)
      { if (year > 1953 && year % 10 == 3)
        wnprintf("\n         ");

        if (year > birthyear)
        if (respvars[recno].earnings[year - birthyear] == (float) -9e10)
        wnprintf("    -9");
        else wnprintf("%6.0f", respvars[recno].earnings[year - birthyear]);
        else wnprintf("      ");
        }
      wnprintf("\n         ");
      for (year = 1953; year < 2003; year++)
      { if (year > 1953 && year % 10 == 3)
        wnprintf("\n         ");

        if (year > birthyear)
        if (respvars[recno].penaccrual[year - birthyear] == (float) -9e10)
        wnprintf("    -9");
        else wnprintf("%6.0f", respvars[recno].penaccrual[year - birthyear]);
        else wnprintf("      ");
        }
      }

    checkMessages();
    }

  free(vpendata);

  }


/*---------------------------------------------------------------------------
			 INIT PENSIONS
          get the pension code id's and sequence numbers
  ---------------------------------------------------------------------------*/

void initPensions()

{ int   jobno, pennumber, pencases, line, flength;
  int   caseid, codeid, seqno;

  int   pencase[7000][4];

  char  infilename[60], inrecord[132];
  char  zeros[10000];

  FILE  *infile, *datafile;
  int   datahandle;


  if (access("e:\\mrrc\\hrsfamrt\\penpart.enc", 0) < 0)
  { pencases = 0;

    for (jobno = 0; jobno < 3; jobno++)
    { strcpy(infilename, "j:\\HRSPensions\\Input");

      switch(jobno)
      { case  0:  strcat(infilename, "\\Partic-F.all");   break;
        case  1:  strcat(infilename, "\\Partic-G.all");   break;
        case  2:  strcat(infilename, "\\Partic-H.all");   break;
        }

      infile = fopen(infilename, "rt");

      while(fgets(inrecord, 150, infile) != 0)
      { if (strlen(inrecord) >= 15)
        { sscanf(inrecord, "%d %d %d", &caseid, &codeid, &seqno);

          if (0 < caseid && caseid < 30000 && 0 < codeid && codeid < 10000)
          { pencase[pencases][0] = jobno;
            pencase[pencases][1] = caseid;
            pencase[pencases][2] = codeid;
            pencase[pencases][3] = seqno;

            pencases = pencases + 1;
            }
          }

        if (jobno > 0)
        fgets(inrecord, 150, infile);    /* pass over wage line */
        }

      fclose(infile);
      }

    wnprintf("\nNumber of pensions evaluated: %d", pencases);
    pause();

	 datafile = fopen("e:\\mrrc\\hrsfamrt\\penpart.dat", "wb");
	 datahandle = fileno(datafile);

	 write(datahandle, &pencases, sizeof(int));
	 write(datahandle, pencase, pencases * sizeof(int[4]));
    fclose(datafile);

	 encrypt(1, "e:\\mrrc\\hrsfamrt\\penpart.dat", "e:\\mrrc\\hrsfamrt\\penpart.enc");
    }
  else
  { encrypt(0, "e:\\mrrc\\hrsfamrt\\penpart.enc", "e:\\mrrc\\hrsfamrt\\penpart.dat");

	 datafile = fopen("e:\\mrrc\\hrsfamrt\\penpart.dat", "rb");
	 datahandle = fileno(datafile);

	 read(datahandle, &pencases, sizeof(int));
	 read(datahandle, pencase, pencases * sizeof(int[4]));

    fclose(datafile);
    }

  datafile = fopen("e:\\mrrc\\hrsfamrt\\penpart.dat", "wb");
  datahandle = fileno(datafile);

  flength = filelength(datahandle);

  memset (zeros, 0, 10000);

  while (flength > 0)
  { if (flength >= 10000)
    write(datahandle, zeros, 10000);
    else write(datahandle, zeros, flength);

    flength = flength - 10000;
    }

  chsize(datahandle, 0);
  fclose(datafile);

  unlink("e:\\mrrc\\hrsfamrt\\penpart.dat");


  memset(penscodes, 0, sizeof(int[30000][3][4][2]));

  for (line = 0; line < pencases; line++)
  { jobno = pencase[line][0];
    caseid = pencase[line][1];

         if (penscodes[caseid][jobno][0][0] == 0)  pennumber = 0;
    else if (penscodes[caseid][jobno][1][0] == 0)  pennumber = 1;
    else if (penscodes[caseid][jobno][2][0] == 0)  pennumber = 2;
    else if (penscodes[caseid][jobno][3][0] == 0)  pennumber = 3;
    else error("Too many pensions in initPensions");

    penscodes[caseid][jobno][pennumber][0] = pencase[line][2];    /* codeid */
    penscodes[caseid][jobno][pennumber][1] = pencase[line][3];    /* seqno */
    }

  }


/*---------------------------------------------------------------------------
			 PENS CALC routine
			 runs the pension program for a particular participant lists
  ---------------------------------------------------------------------------*/

void pensCalc(
  void *arglist)

{ int   *threadno;
  char  runtype;
  char  pentype[5];
  char  suffix[5];
  char  paramtype[16];
  char  filename[24];

  FILE  *outfile;

  threadno = (int *) arglist;

  switch(*threadno)
  { case  1: strcpy(suffix, "ldb");     break;
    case  2: strcpy(suffix, "ldc");     break;
    case  3: strcpy(suffix, "pdb");     break;
    case  4: strcpy(suffix, "pdc");     break;
    }

  if (*threadno < 3)
  { strcpy(paramtype, "lst");
    runtype = '3';
    }
  else
  { strcpy(paramtype, "prv");
    runtype = '1';
    }

  if (*threadno == 1 || *threadno == 3)
  strcpy(pentype, "DB");
  else strcpy(pentype, "DC");

  strcpy(filename, "calc-");
  strcat(filename, suffix);
  strcat(filename, ".bat");

  outfile = fopen(filename, "w");

  fprintf(outfile, "md calc-%s", suffix);
  fprintf(outfile, "\ncd calc-%s", suffix);
  fprintf(outfile, "\ncopy ..\\partic.%s partic", suffix);
  fprintf(outfile, "\ncopy ..\\param.%s param", paramtype);
  fprintf(outfile, "\ncopy j:\\hrspensions\\program\\Custom\\Dpmi16bi.ovl");
  fprintf(outfile, "\ncopy j:\\hrspensions\\program\\Custom\\Rtm.exe");
  fprintf(outfile, "\nj:\\hrspensions\\program\\Custom\\Calc6c%s %c", pentype, runtype);
  fprintf(outfile,   " partic param penout.dat penout.tab penout.err");
  fprintf(outfile, "\ndel fn*.dat");
  fprintf(outfile, "\ncopy penout.dat ..\\penout.%s", suffix);
  fprintf(outfile, "\ncopy penout.tab ..\\pentab.%s", suffix);
  fprintf(outfile, "\ncopy penout.err ..\\penerr.%s", suffix);
  fprintf(outfile, "\ndel partic");
  fprintf(outfile, "\ndel param");
  fprintf(outfile, "\ndel penout*.*");
  fprintf(outfile, "\ndel Dpmi16bi.ovl");
  fprintf(outfile, "\ndel Rtm.exe");
  fprintf(outfile, "\ncd ..");
  fprintf(outfile, "\nrd calc-%s", suffix);

  fclose(outfile);

  system(filename);

  unlink(filename);

  while (*threadno != 0)
  *threadno = 0;

  _endthread();

  }


/*---------------------------------------------------------------------------
			 PENS COMP routine
			 compare routine for qsort in the getpensions routine
  ---------------------------------------------------------------------------*/

int pensComp(
  const void *elem1,
  const void *elem2)

{ int   *vec1, *vec2;

  vec1 = (int *) elem1;
  vec2 = (int *) elem2;

  if (vec1[0] < vec2[0])           /* recno */
  return(-1);
  else if (vec1[0] == vec2[0])
  { if (vec1[2] > vec2[2])          /* enddate */
    return(-1);
    else if (vec1[2] == vec2[2])
    { if (vec1[1] < vec2[1])        /* startdate */
      return(-1);
      else return(1);
      }
    else return(1);
    }
  else return(1);

  }


/*---------------------------------------------------------------------------
			 MEDIAN CALC
			 calculates the median of a vector of values
  ---------------------------------------------------------------------------*/

float medianCalc(
  float *values,
  int   nobs)

{ float median;

  qsort(values, nobs, sizeof(float), medianComp);

  if (nobs % 2 == 0)
  median = (values[(nobs / 2) - 1] + values[nobs / 2]) / 2;
  else median = values[nobs / 2];

  return(median);

  }


/*---------------------------------------------------------------------------
			 MEDIAN COMP routine
			 compare routine for qsort in the mediancalc routine
  ---------------------------------------------------------------------------*/

int medianComp(
  const void *elem1,
  const void *elem2)

{ if (* (float *) elem1 < * (float *) elem2)
  return(-1);
  else return(1);

  }


/*---------------------------------------------------------------------------
			 COMBINE SPOUSES
			 combine the spouse records into a household record
  ---------------------------------------------------------------------------*/

void combineSpouses(
  struct respdata *respvars,
  struct srmdata  *srmvars,
  int    *nobs)

{ int   recno, type;
  int   count, goodobs, badobs, totobs;
  int   age, year, spouse;
  int   caseid, matchid;
  int   genderp, genders;
  int   yearh, yearw, ssbaseyear, privatess;
  float earningsh, earningsw;
  float discfactor, ssbase;

  float ssaccrualh[75], ssaccrualw[75];

  struct respdata *resp, *respp, *resps, *resph, *respw;
  struct srmdata *srm;

  static float wageind[42] = {
			  57.86,  60.65,  63.76,  64.52,  67.72,  70.74,  73.33,  75.08,  78.78,
	80.67,  82.60,  85.91,  88.46,  91.33,  95.45,  98.82, 101.84, 107.73, 114.61,
  119.83, 127.31, 136.90, 145.39, 154.76, 163.53, 175.45, 189.00, 203.70, 219.91,
  235.10, 255.20, 267.26, 280.70, 292.86, 299.09, 304.85, 312.50, 322.02, 334.24,
  345.35, 353.98, 363.61};
  /* 1951-1992 average weekly earnings           */
  /* Table B41, 1986 ERP and Table B45, 1995 ERP */

  static float wGrowthRate[29] = {
			 4.0,  4.2,  4.8,  5.2,  4.9,  4.9,  4.8,  4.8,  4.9,
	 4.9,  5.0,  5.0,  5.0,  5.0,  4.9,  4.9,  4.9,  4.9,  4.8,
	 4.8,  4.8,  4.8,  4.8,  4.8,  4.7,  4.7,  4.7,  4.7,  4.7};
  /* Wage growth rate, 1992-2020, in Table II.D1, p. 59, in the 1993 */
  /* Annual Report of the Board of Trustees of Social Security    */
  /* static float wGrowthRate[29] = {
			 5.4,  1.3,  3.5,  4.0,  4.1,  4.3,  4.1,  4.2,  4.5,
	 4.7,  4.8,  4.9,  5.1,  5.1,  5.1,  5.1,  5.1,  5.1,  5.1,
	 5.1,  5.1,  5.1,  5.1,  5.1,  5.0,  5.0,  5.0,  5.0,  5.0};
     Wage growth rate, 1992-2020, in Table II.D1, p. 56, in the 1995
     Annual Report of the Board of Trustees of Social Security    */


  privatess = 0;

  for (recno = 0; recno < 12651; recno++)
  { respvars[recno].goodobs.spouseIntv = 0;
    respvars[recno].goodobs.goodSpouse = 0;
    }

  *nobs = 0;

  for (recno = 0; recno < 12651; recno++)
  { respp = &respvars[recno];
    resps = &respvars[recno + 1];

    caseid = respp->caseid;
    matchid = respp->matchid;

    genderp = respp->gender;
    genders = resps->gender;

    if (caseid < 20000 && matchid > 20000
     && matchid == resps->caseid && genderp != genders)
    { respp->goodobs.spouseIntv = 1;

      for (spouse = 0; spouse < 2; spouse++)
      { if (spouse == 0)
        resp = respp;
        else resp = resps;

        if (resp->goodobs.sameSpouse   == 1 && resp->goodobs.goodCareer   == 1
         && resp->goodobs.goodAge      == 1 && resp->goodobs.goodEarnings == 1
         && resp->goodobs.goodSSstatus == 1 && resp->goodobs.goodFTyears  == 1
         && resp->goodobs.goodSSearn   == 1 && resp->goodobs.goodPens     == 1)
        { if (spouse == 0)
          resps->goodobs.goodSpouse = 1;
          else respp->goodobs.goodSpouse = 1;
          }
        }

      if (resps->goodobs.goodSpouse == 1 && respp->goodobs.goodSpouse == 1)
      { if (genderp == 1) resph = respp;
        else              resph = resps;

        if (genders == 1) respw = respp;
        else              respw = resps;

        if (recno == 12652)
        wnprintf("\n%5d %5d", recno, caseid);

        sscalc(privatess, resph, respw, &ssbaseyear, &ssbase, ssaccrualh, ssaccrualw);

        if (recno == 12652)
        { wnprintf("   %4d %6.0f", ssbaseyear, ssbase);
          yearh = resph->vint;
          yearw = respw->vint;
          wnprintf("   %4d %4d", yearh, yearw);
          wnprintf("\n hssearn ");
          for (year = 1953; year < 2003; year++)
          { if (year > 1953 && year % 10 == 3)
            wnprintf("\n         ");

            if (year > yearh)
            wnprintf("%6.0f", resph->ssearnings[year - yearh]);
            else wnprintf("      ");
            }
          wnprintf("\n wssearn ");
          for (year = 1953; year < 2003; year++)
          { if (year > 1953 && year % 10 == 3)
            wnprintf("\n         ");

            if (year > yearw)
            wnprintf("%6.0f", respw->ssearnings[year - yearw]);
            else wnprintf("      ");
            }
          wnprintf("\n sssaccr ");
          for (year = 1953; year < 2003; year++)
          { if (year > 1953 && year % 10 == 3)
            wnprintf("\n         ");

            if (year > yearh)
            wnprintf("%6.0f", ssaccrualh[year - yearh]);
            else wnprintf("      ");
            }
          wnprintf("\n wssaccr ");
          for (year = 1953; year < 2003; year++)
          { if (year > 1953 && year % 10 == 3)
            wnprintf("\n         ");

            if (year > yearw)
            wnprintf("%6.0f", ssaccrualw[year - yearw]);
            else wnprintf("      ");
            }
          }

        srm = &srmvars[*nobs];

        srm->obs = recno;
        srm->race = respp->race;

        srm->husbvars.caseid  = resph->caseid;
        srm->husbvars.vint    = resph->vint;
        srm->husbvars.ed      = resph->ed;
        srm->husbvars.enjoysp = resph->enjoysp;
        srm->husbvars.hlthage = resph->hlthage;
        srm->husbvars.lftage  = resph->lftage;
        srm->husbvars.fretage = resph->fretage;

        srm->wifevars.caseid  = respw->caseid;
        srm->wifevars.vint    = respw->vint;
        srm->wifevars.ed      = respw->ed;
        srm->wifevars.enjoysp = respw->enjoysp;
        srm->wifevars.hlthage = respw->hlthage;
        srm->wifevars.lftage  = respw->lftage;
        srm->wifevars.fretage = respw->fretage;

        if (resph->caseid == printcaseid)
        { wnprintf("\n paccr   ");

          for (year = 1973; year < 2013; year++)
          { if (year > 1973 && year % 10 == 3)
            wnprintf("\n         ");

            if (year > resph->vint)
            wnprintf("%6.0f", resph->penaccrual[year - resph->vint]);
            else wnprintf("      ");
            }

          wnprintf("\n saccr   ");

          for (year = 1973; year < 2013; year++)
          { if (year > 1973 && year % 10 == 3)
            wnprintf("\n         ");

            if (year > resph->vint)
            wnprintf("%6.0f", ssaccrualh[year - resph->vint]);
            else wnprintf("      ");
            }
          }

        if (respw->caseid == printcaseid)
        { wnprintf("\n paccr   ");

          for (year = 1973; year < 2013; year++)
          { if (year > 1973 && year % 10 == 3)
            wnprintf("\n         ");

            if (year > respw->vint)
            wnprintf("%6.0f", respw->penaccrual[year - respw->vint]);
            else wnprintf("      ");
            }

          wnprintf("\n saccr   ");

          for (year = 1973; year < 2013; year++)
          { if (year > 1973 && year % 10 == 3)
            wnprintf("\n         ");

            if (year > respw->vint)
            wnprintf("%6.0f", ssaccrualw[year - respw->vint]);
            else wnprintf("      ");
            }
          }

        for (age = 25; age < 75; age++)
        { /* calculate husband's total earnings and discount */

          earningsh = resph->earnings[age] + resph->penaccrual[age] + ssaccrualh[age];

          yearh = resph->vint + age;

          if (yearh < 1992)
          { if (yearh < 1951)
	         discfactor = wageind[1992 - 1951] / wageind[1951 - 1951];
	         else discfactor = wageind[1992 - 1951] / wageind[yearh - 1951];
	         }
          else
          { discfactor = 1;

	         for (year = 1992; year < yearh; year++)
	         if (year < 2020)
	         discfactor = discfactor / (1 + 0.01 * wGrowthRate[year - 1992]);
	         else discfactor = discfactor / (1 + 0.01 * wGrowthRate[2020 - 1992]);
	         }

          earningsh = earningsh * discfactor;
          ssaccrualh[age] = ssaccrualh[age] * discfactor;

         /* calculate wife's total earnings and discount */

          earningsw = respw->earnings[age] + respw->penaccrual[age] + ssaccrualw[age];

          yearw = respw->vint + age;

          if (yearw < 1992)
          { if (yearw < 1951)
	         discfactor = wageind[1992 - 1951] / wageind[1951 - 1951];
	         else discfactor = wageind[1992 - 1951] / wageind[yearw - 1951];
	         }
          else
          { discfactor = 1;

	         for (year = 1992; year < yearw; year++)
	         if (year < 2020)
	         discfactor = discfactor / (1 + 0.01 * wGrowthRate[year - 1992]);
	         else discfactor = discfactor / (1 + 0.01 * wGrowthRate[2020 - 1992]);
	         }

          earningsw = earningsw * discfactor;
          ssaccrualw[age] = ssaccrualw[age] * discfactor;

          srm->husbvars.earnings[age - 25] = earningsh;
          srm->wifevars.earnings[age - 25] = earningsw;
          }

        if (privatess == 0)
        { for (age = 25; age < 75; age++)
          { if (resph->vint + age < ssbaseyear)
            ssbase = ssbase - ssaccrualh[age];

            if (respw->vint + age < ssbaseyear)
            ssbase = ssbase - ssaccrualw[age];
            }

          srm->husbvars.earnings[25 - 25] = srm->husbvars.earnings[25 - 25] + ssbase / 2;
          srm->wifevars.earnings[25 - 25] = srm->wifevars.earnings[25 - 25] + ssbase / 2;
          }

        srm->weight = respp->weight;

        if (recno < 12652)
        { wnprintf("\n%3d %5d %1d %5d %5d", *nobs, srm->obs, srm->race,
           srm->husbvars.caseid, srm->wifevars.caseid);
          wnprintf("\n  %4d %2d %1d %2d %2d %2d", srm->husbvars.vint,
           srm->husbvars.ed, srm->husbvars.enjoysp, srm->husbvars.hlthage,
           srm->husbvars.lftage, srm->husbvars.fretage);
          for (age = 25; age < 75; age++)
          { if (age % 10 == 5) wnprintf("\n    ");
            wnprintf("%6.0f", srm->husbvars.earnings[age - 25]);
            }
          wnprintf("\n  %4d %2d %1d %2d %2d %2d", srm->wifevars.vint,
           srm->wifevars.ed, srm->wifevars.enjoysp, srm->wifevars.hlthage,
           srm->wifevars.lftage, srm->wifevars.fretage);
          for (age = 25; age < 75; age++)
          { if (age % 10 == 5) wnprintf("\n    ");
            wnprintf("%6.0f", srm->wifevars.earnings[age - 25]);
            }
          }

        *nobs = *nobs + 1;

        checkMessages();
        }
      }
    }


  wnprintf("\n\n               Reasons for deletions of observations");
  wnprintf(  "\n                                               Observations      Observations");
  wnprintf(  "\n                                                 Deleted           Remaining");
  wnprintf("\n\nOriginal observations                                                12652");

  for (type = 0; type < 11; type++)
  { badobs = 0;
    count = 0;

    for (recno = 0; recno < 12652; recno++)
    { goodobs = 1;

      switch(type)
      { case 10:  if (respvars[recno].goodobs.goodSpouse   == 0)  goodobs = 0;
        case  9:  if (respvars[recno].goodobs.goodPens     == 0)  goodobs = 0;
        case  8:  if (respvars[recno].goodobs.goodSSearn   == 0)  goodobs = 0;
        case  7:  if (respvars[recno].goodobs.goodFTyears  == 0)  goodobs = 0;
        case  6:  if (respvars[recno].goodobs.goodSSstatus == 0)  goodobs = 0;
        case  5:  if (respvars[recno].goodobs.goodEarnings == 0)  goodobs = 0;
        case  4:  if (respvars[recno].goodobs.goodAge      == 0)  goodobs = 0;
        case  3:  if (respvars[recno].goodobs.goodCareer   == 0)  goodobs = 0;
        case  2:  if (respvars[recno].goodobs.sameSpouse   == 0)  goodobs = 0;
        case  1:  if (respvars[recno].goodobs.married      == 0)  goodobs = 0;
        }

      if (goodobs == 0)
      badobs = badobs + 1;

      if (goodobs == 1)
      switch(type)
      { case  0:  if (respvars[recno].goodobs.married      == 0)  count++;   break;
        case  1:  if (respvars[recno].goodobs.sameSpouse   == 0)  count++;   break;
        case  2:  if (respvars[recno].goodobs.goodCareer   == 0)  count++;   break;
        case  3:  if (respvars[recno].goodobs.goodAge      == 0)  count++;   break;
        case  4:  if (respvars[recno].goodobs.goodEarnings == 0)  count++;   break;
        case  5:  if (respvars[recno].goodobs.goodSSstatus == 0)  count++;   break;
        case  6:  if (respvars[recno].goodobs.goodFTyears  == 0)  count++;   break;
        case  7:  if (respvars[recno].goodobs.goodSSearn   == 0)  count++;   break;
        case  8:  if (respvars[recno].goodobs.goodPens     == 0)  count++;   break;
        case  9:  if (respvars[recno].goodobs.goodSpouse   == 0)  count++;   break;
        case 10:  if (respvars[recno].goodobs.spouseIntv   == 0)  count++;   break;
        }
      }

    switch(type)
    { case  0:  wnprintf("\nNot married in 1992:                           ");   break;
      case  1:  wnprintf("\nChanged spouses after age 35 (or spouse died): ");   break;
      case  2:  wnprintf("\nNot a career worker:                           ");   break;
      case  3:  wnprintf("\nAge not consistent among surveys:              ");   break;
      case  4:  wnprintf("\nSS record missing and no good earnings:        ");   break;
      case  5:  wnprintf("\nSocial security status ambiguous:              ");   break;
      case  6:  wnprintf("\nNumber of full-time years ambiguous:           ");   break;
      case  7:  wnprintf("\nEarnings unclear from SS record alone:         ");   break;
      case  8:  wnprintf("\nNo Pension Provider record in last job:        ");   break;
      case  9:  wnprintf("\nSpouse observation not good:                   ");   break;
      case 10:  wnprintf("\nSecond respondent in family:                   ");   break;
      }

    wnprintf("   %5d              %5d", count, 12652 - badobs - count);
    }

  wnprintf("\n\n\n\n                                               Observations      Observations");
  wnprintf(      "\n                                                 Deleted           Remaining");

  for (type = 0; type < 9; type++)
  { totobs = 0;
    count = 0;

    for (recno = 0; recno < 12652; recno++)
    { caseid = respvars[recno].caseid;
      matchid = respvars[recno].matchid;

      if (10000 <= caseid && caseid < 20000 && 20000 <= matchid && matchid < 30000)
      { if (matchid != respvars[recno + 1].caseid)
        error("Couples not in adjacent records in combineSpouses");

        if (respvars[recno    ].goodobs.married != 0
         && respvars[recno + 1].goodobs.married != 0)
        goodobs = 1;
        else goodobs = 0;

        switch(type)
        { case  8:  if (respvars[recno    ].goodobs.goodSSearn   == 0
                     || respvars[recno + 1].goodobs.goodSSearn   == 0)  goodobs = 0;
          case  7:  if (respvars[recno    ].goodobs.goodFTyears  == 0
                     || respvars[recno + 1].goodobs.goodFTyears  == 0)  goodobs = 0;
          case  6:  if (respvars[recno    ].goodobs.goodSSstatus == 0
                     || respvars[recno + 1].goodobs.goodSSstatus == 0)  goodobs = 0;
          case  5:  if (respvars[recno    ].goodobs.goodEarnings == 0
                     || respvars[recno + 1].goodobs.goodEarnings == 0)  goodobs = 0;
          case  4:  if (respvars[recno    ].goodobs.goodAge      == 0
                     || respvars[recno + 1].goodobs.goodAge      == 0)  goodobs = 0;
          case  3:  if (respvars[recno    ].goodobs.goodCareer   == 0
                     || respvars[recno + 1].goodobs.goodCareer   == 0)  goodobs = 0;
          case  2:  if (respvars[recno    ].goodobs.sameSpouse   == 0
                     || respvars[recno + 1].goodobs.sameSpouse   == 0)  goodobs = 0;
          }

        if (goodobs == 1)
        { totobs = totobs + 1;

          switch(type)
          { case  1:  if (respvars[recno    ].goodobs.sameSpouse   == 0
                       || respvars[recno + 1].goodobs.sameSpouse   == 0)  count++;   break;
            case  2:  if (respvars[recno    ].goodobs.goodCareer   == 0
                       || respvars[recno + 1].goodobs.goodCareer   == 0)  count++;   break;
            case  3:  if (respvars[recno    ].goodobs.goodAge      == 0
                       || respvars[recno + 1].goodobs.goodAge      == 0)  count++;   break;
            case  4:  if (respvars[recno    ].goodobs.goodEarnings == 0
                       || respvars[recno + 1].goodobs.goodEarnings == 0)  count++;   break;
            case  5:  if (respvars[recno    ].goodobs.goodSSstatus == 0
                       || respvars[recno + 1].goodobs.goodSSstatus == 0)  count++;   break;
            case  6:  if (respvars[recno    ].goodobs.goodFTyears  == 0
                       || respvars[recno + 1].goodobs.goodFTyears  == 0)  count++;   break;
            case  7:  if (respvars[recno    ].goodobs.goodSSearn   == 0
                       || respvars[recno + 1].goodobs.goodSSearn   == 0)  count++;   break;
            case  8:  if (respvars[recno    ].goodobs.goodPens     == 0
                       || respvars[recno + 1].goodobs.goodPens     == 0)  count++;   break;
            }
          }
        }
      }

    switch(type)
    { case  0:  wnprintf("\nCouples with both spouses interviewed          ");   break;
      case  1:  wnprintf("\nChanged spouses after age 35 (or spouse died): ");   break;
      case  2:  wnprintf("\nNot a career worker:                           ");   break;
      case  3:  wnprintf("\nAge not consistent among surveys:              ");   break;
      case  4:  wnprintf("\nSS record missing and no good earnings:        ");   break;
      case  5:  wnprintf("\nSocial security status ambiguous:              ");   break;
      case  6:  wnprintf("\nNumber of full-time years ambiguous:           ");   break;
      case  7:  wnprintf("\nEarnings unclear from SS record alone:         ");   break;
      case  8:  wnprintf("\nNo Pension Provider record in last job:        ");   break;
      }

    if (type == 0)
    wnprintf("                      %5d", totobs);
    else wnprintf("   %5d              %5d", count, totobs - count);
    }

  }


/*---------------------------------------------------------------------------
			 SS CALC routine
			 calculates social security accruals
  ---------------------------------------------------------------------------*/

void sscalc(
  int    privatess,
  struct respdata *resph,
  struct respdata *respw,
  int    *ssbaseyear,
  float  *ssbase,
  float  *ssaccrualh,
  float  *ssaccrualw)

{ int   age, year, curyear;
  int   birthyearh, windfallflagh, lftageh, fretageh, retageh, ncpensyearh;
  int   birthyearw, windfallflagw, lftagew, fretagew, retagew, ncpensyearw;
  int   ssbaseageh, ssbaseagew;
  float piah, piaw;
  float ncpenh, ncpenw;
  float ncpensamth, ncpensamtw;
  float sspv, sspv0, sspv1;

  float survh[120], survw[120];
  float *earningsh, *earningsw;

  static float cpiind[42] = {
			  26.0,  26.5,  26.7,  26.9,  26.8,  27.2,  28.1,  28.9,  29.1,
	 29.6,  29.9,  30.2,  30.6,  31.0,  31.5,  32.4,  33.4,  34.8,  36.7,
	 38.8,  40.5,  41.8,  44.4,  49.3,  53.8,  56.9,  60.6,  65.2,  72.6,
	 82.4,  90.9,  96.5,  99.6, 103.9, 107.6, 109.6, 113.6, 118.3, 124.0,
	130.7, 136.2, 140.3};
  /* 1951-1992 CPI-U, Table B-59, 1995 ERP */

  static float inflationRate[29] = {
			 2.9,  2.8,  2.8,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,
	 3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,
	 3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0};
  /* CPI inflation rate, 1992-2020, in Table II.D1, p. 59, in the   */
  /* 1993 Annual Report of the Board of Trustees of Social Security */
  /* static float inflationRate[29] = {
			 2.9,  2.8,  2.5,  3.1,  3.2,  3.3,  3.4,  3.5,  3.7,
	 3.9,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,
	 4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0};
     CPI inflation rate, 1992-2020, in Table II.D1, p. 56, in the
     1995 Annual Report of the Board of Trustees of Social Security */

  static float sscontr[50] = {
	 0.01500, 0.01500, 0.01500, 0.02000, 0.02000,
	 0.02000, 0.02000, 0.02000, 0.02250, 0.02750,
	 0.02750, 0.02875, 0.03375, 0.03375, 0.03375,
	 0.03500, 0.03550, 0.03325, 0.03725, 0.03650,
	 0.04050, 0.04050, 0.04300, 0.04375, 0.04375,
	 0.04375, 0.04375, 0.04275, 0.04330, 0.04520,
	 0.04700, 0.04575, 0.04775, 0.05200, 0.05200,
	 0.05200, 0.05200, 0.05530, 0.05530, 0.05600,
	 0.05600, 0.05600, 0.05600, 0.05260, 0.05260,
	 0.05260, 0.05350, 0.05350, 0.05350, 0.05300};
  /* 1951-2000 Social Security AOSI contribution rates */
  /* from Ann Statistical Suppl, 1995 */


  for (age = 0; age < 75; age++)
  { ssaccrualh[age] = 0;
    ssaccrualw[age] = 0;
    }

  getSurvivalRates(resph->vint, 1, survh);
  getSurvivalRates(respw->vint, 2, survw);

  birthyearh    = resph->vint;
  windfallflagh = resph->windfallflag;
  earningsh     = resph->ssearnings;
  lftageh       = resph->lftage;
  fretageh      = resph->fretage;
  ncpensamth    = resph->ncpensamt;
  ncpensyearh   = resph->ncpensyear;

  birthyearw    = respw->vint;
  windfallflagw = respw->windfallflag;
  earningsw     = respw->ssearnings;
  lftagew       = respw->lftage;
  fretagew      = respw->fretage;
  ncpensamtw    = respw->ncpensamt;
  ncpensyearw   = respw->ncpensyear;

  if (lftageh == 0)
  retageh = fretageh;
  else if (fretageh == 99)
  retageh = lftageh;
  else retageh = ((lftageh + 1) + fretageh) / 2;

  if (lftagew == 0)
  retagew = fretagew;
  else if (fretagew == 99)
  retagew = lftagew;
  else retagew = ((lftagew + 1) + fretagew) / 2;
  /* wnprintf("   %2d %2d", retageh, retagew); */

  /* accruals for husband */

  ncpenw = ncpensamtw;

  if (0 < ncpensyearw && ncpensyearw < retagew)
  ncpenw = ncpenw + ncpencalc(birthyearw, 2, ncpensyearw, retagew, earningsw);

  for (age = 25; age < 75; age++)
  { curyear = birthyearh + age;

    if (privatess == 0)
    { /* present value if retire at current age */

      if (curyear > 1951)
      { piah = getSocialSecurityPIA(birthyearh, age, windfallflagh, earningsh,
                 birthyearw, retagew, windfallflagw, earningsw);
        piaw = getSocialSecurityPIA(birthyearw, retagew, windfallflagw, earningsw,
                 birthyearh, age, windfallflagh, earningsh);

        ncpenh = ncpensamth;

        if (0 < ncpensyearh && ncpensyearh < retageh)
        ncpenh = ncpenh + ncpencalc(birthyearh, 1, ncpensyearh, retageh, earningsh);

        sspv0 = getSocialSecurityPV(curyear, birthyearh, age, 1, piah,
                  ncpenh, birthyearw, retagew, 2, piaw, ncpenw);
        }
      else sspv0 = 0;

      /* present value if retire next year */

      if (curyear + 1 > 1951)
      { piah = getSocialSecurityPIA(birthyearh, age + 1, windfallflagh, earningsh,
                 birthyearw, retagew, windfallflagw, earningsw);
        piaw = getSocialSecurityPIA(birthyearw, retagew, windfallflagw, earningsw,
                 birthyearh, age + 1, windfallflagh, earningsh);

        ncpenh = ncpensamth;

        if (0 < ncpensyearh && ncpensyearh < retageh)
        ncpenh = ncpenh + ncpencalc(birthyearh, 1, ncpensyearh, retageh, earningsh);

        sspv1 = getSocialSecurityPV(curyear, birthyearh, age + 1, 1, piah,
                  ncpenh, birthyearw, retagew, 2, piaw, ncpenw);
        }
      else sspv1 = 0;

      sspv = sspv1 - sspv0;

      /* express in dollars at current age */

      if (curyear < 1992)
      { if (curyear < 1951)
	     sspv = sspv * (cpiind[1951 - 1951] / cpiind[1992 - 1951]);
	     else sspv = sspv * (cpiind[curyear - 1951] / cpiind[1992 - 1951]);
	     }
      else
      { for (year = 1992; year < curyear - 1; year++)
	     if (year < 2020)
	     sspv = sspv * (1 + 0.01 * inflationRate[year - 1992]);
	     else sspv = sspv * (1 + 0.01 * inflationRate[2020 - 1992]);
	     }
      }
    else
    { if (curyear <= 2000)
      sspv = 2 * earningsh[age] * sscontr[curyear - 1951];
      else sspv = 2 * earningsh[age] * sscontr[2000 - 1951];
      }

    ssaccrualh[age] = sspv;
    }

  /* accruals for wife */

  ncpenh = ncpensamth;

  if (0 < ncpensyearh && ncpensyearh < retageh)
  ncpenh = ncpenh + ncpencalc(birthyearh, 1, ncpensyearh, retageh, earningsh);

  for (age = 25; age < 75; age++)
  { if (privatess == 0)
    { curyear = birthyearw + age;

      /* present value if retire at current age */

      if (curyear > 1951)
      { piaw = getSocialSecurityPIA(birthyearw, age, windfallflagw, earningsw,
                 birthyearh, retageh, windfallflagh, earningsh);
        piah = getSocialSecurityPIA(birthyearh, retageh, windfallflagh, earningsh,
                 birthyearw, age, windfallflagw, earningsw);

        ncpenw = ncpensamtw;

        if (0 < ncpensyearw && ncpensyearw < retagew)
        ncpenw = ncpenw + ncpencalc(birthyearw, 1, ncpensyearw, retagew, earningsw);

        sspv0 = getSocialSecurityPV(curyear, birthyearw, age, 2, piaw,
                  ncpenw, birthyearh, retageh, 1, piah, ncpenh);
        }
      else sspv0 = 0;

      /* present value if retire next year */

      if (curyear + 1 > 1951)
      { piaw = getSocialSecurityPIA(birthyearw, age + 1, windfallflagw, earningsw,
                 birthyearh, retageh, windfallflagh, earningsh);
        piah = getSocialSecurityPIA(birthyearh, retageh, windfallflagh, earningsh,
                 birthyearw, age + 1, windfallflagw, earningsw);

        ncpenw = ncpensamtw;

        if (0 < ncpensyearw && ncpensyearw < retagew)
        ncpenw = ncpenw + ncpencalc(birthyearw, 1, ncpensyearw, retagew, earningsw);

        sspv1 = getSocialSecurityPV(curyear, birthyearw, age + 1, 2, piaw,
                  ncpenw, birthyearh, retageh, 1, piah, ncpenh);
        }
      else sspv1 = 0;

      sspv = sspv1 - sspv0;

      /* express in dollars at current age */

      if (curyear < 1992)
      { if (curyear < 1951)
	     sspv = sspv * (cpiind[1951 - 1951] / cpiind[1992 - 1951]);
	     else sspv = sspv * (cpiind[curyear - 1951] / cpiind[1992 - 1951]);
	     }
      else
      { for (year = 1992; year < curyear - 1; year++)
	     if (year < 2020)
	     sspv = sspv * (1 + 0.01 * inflationRate[year - 1992]);
	     else sspv = sspv * (1 + 0.01 * inflationRate[2020 - 1992]);
	     }
      }
    else
    { if (curyear <= 2000)
      sspv = 2 * earningsw[age] * sscontr[curyear - 1951];
      else sspv = 2 * earningsw[age] * sscontr[2000 - 1951];
      }

    ssaccrualw[age] = sspv;
    }

  /* get 1992 values for the base amount */

  if (privatess == 0)
  { *ssbaseyear = ((birthyearh + retageh) + (birthyearw + retagew)) / 2;
    ssbaseageh = *ssbaseyear - birthyearh;
    ssbaseagew = *ssbaseyear - birthyearw;

    piah = getSocialSecurityPIA(birthyearh, ssbaseageh, windfallflagh, earningsh,
             birthyearw, ssbaseagew, windfallflagw, earningsw);

    ncpenh = ncpensamth;

    if (0 < ncpensyearh && ncpensyearh < ssbaseageh)
    ncpenh = ncpenh + ncpencalc(birthyearh, 1, ncpensyearh, ssbaseageh, earningsh);

    piaw = getSocialSecurityPIA(birthyearw, ssbaseagew, windfallflagw, earningsw,
             birthyearh, ssbaseageh, windfallflagh, earningsh);

    ncpenw = ncpensamtw;

    if (0 < ncpensyearw && ncpensyearw < ssbaseagew)
    ncpenw = ncpenw + ncpencalc(birthyearw, 2, ncpensyearw, ssbaseagew, earningsw);

    *ssbase = getSocialSecurityPV(*ssbaseyear, birthyearh, ssbaseageh, 1, piah,
                ncpenh, birthyearw, ssbaseagew, 2, piaw, ncpenw);
    }

  }


/*---------------------------------------------------------------------------
			 GET SOCIAL SECURITY PIA routine
			 gets Social Security primary insurance amounts
  ---------------------------------------------------------------------------*/

int splitearnings = 0;  /* flag for splitting earnings between spouses */

float getSocialSecurityPIA(
  int   birthyear,
  int   piaage,
  int   windfallflag,
  float *earnings,
  int   spbirthyear,
  int   spretage,
  int   spwindfallflag,
  float *spearnings)

{ int   age;
  int   year, year60, year62;
  int   yearindx, replacementyear;
  int   coverage, coverageyears;
  float wage, aime, pia;
  float bend1, bend2, firstbracketpct;
  float bendindex, infladj;

  float ssearningsvec[35];

  static float cpiind[42] = {
			  26.0,  26.5,  26.7,  26.9,  26.8,  27.2,  28.1,  28.9,  29.1,
	 29.6,  29.9,  30.2,  30.6,  31.0,  31.5,  32.4,  33.4,  34.8,  36.7,
	 38.8,  40.5,  41.8,  44.4,  49.3,  53.8,  56.9,  60.6,  65.2,  72.6,
	 82.4,  90.9,  96.5,  99.6, 103.9, 107.6, 109.6, 113.6, 118.3, 124.0,
	130.7, 136.2, 140.3};
  /* 1951-1992 CPI-U, Table B-59, 1995 ERP */

  static float wageind[42] = {
			  57.86,  60.65,  63.76,  64.52,  67.72,  70.74,  73.33,  75.08,  78.78,
	80.67,  82.60,  85.91,  88.46,  91.33,  95.45,  98.82, 101.84, 107.73, 114.61,
  119.83, 127.31, 136.90, 145.39, 154.76, 163.53, 175.45, 189.00, 203.70, 219.91,
  235.10, 255.20, 267.26, 280.70, 292.86, 299.09, 304.85, 312.50, 322.02, 334.24,
  345.35, 353.98, 363.61};
  /* 1951-1992 average weekly earnings           */
  /* Table B41, 1986 ERP and Table B45, 1995 ERP */

  static float inflationRate[29] = {
			 2.9,  2.8,  2.8,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,
	 3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,
	 3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0};
  /* CPI inflation rate, 1992-2020, in Table II.D1, p. 59, in the   */
  /* 1993 Annual Report of the Board of Trustees of Social Security */
  /* static float inflationRate[29] = {
			 2.9,  2.8,  2.5,  3.1,  3.2,  3.3,  3.4,  3.5,  3.7,
	 3.9,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,
	 4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0};
     CPI inflation rate, 1992-2020, in Table II.D1, p. 56, in the
     1995 Annual Report of the Board of Trustees of Social Security */

  static float wGrowthRate[29] = {
			 4.0,  4.2,  4.8,  5.2,  4.9,  4.9,  4.8,  4.8,  4.9,
	 4.9,  5.0,  5.0,  5.0,  5.0,  4.9,  4.9,  4.9,  4.9,  4.8,
	 4.8,  4.8,  4.8,  4.8,  4.8,  4.7,  4.7,  4.7,  4.7,  4.7};
  /* Wage growth rate, 1992-2020, in Table II.D1, p. 59, in the 1993 */
  /* Annual Report of the Board of Trustees of Social Security    */
  /* static float wGrowthRate[29] = {
			 5.4,  1.3,  3.5,  4.0,  4.1,  4.3,  4.1,  4.2,  4.5,
	 4.7,  4.8,  4.9,  5.1,  5.1,  5.1,  5.1,  5.1,  5.1,  5.1,
	 5.1,  5.1,  5.1,  5.1,  5.1,  5.0,  5.0,  5.0,  5.0,  5.0};
     Wage growth rate, 1992-2020, in Table II.D1, p. 56, in the 1995
     Annual Report of the Board of Trustees of Social Security    */


  coverageyears = 0;

  for (age = max(0, 1951 - birthyear); age < piaage
   || (birthyear + age < spbirthyear + spretage && splitearnings != 0); age++)
  { year = birthyear + age;

    if (earnings[age] > 0)
    if ((windfallflag == 0 && (spwindfallflag == 0 || splitearnings == 0))
      || year < 1990)
	 coverageyears = coverageyears + 1;
    else
    { if (splitearnings == 0)
      wage = earnings[age];
      else
      { if (age < piaage && spbirthyear < birthyear + age
         && birthyear + age < spbirthyear + spretage)
        wage = (earnings[age] + spearnings[(age + birthyear) - spbirthyear]) / 2;
        else if (age < piaage)
        wage = earnings[age] / 2;
        else if (spbirthyear < birthyear + age && birthyear + age < spbirthyear + spretage)
        wage = spearnings[(age + birthyear) - spbirthyear] / 2;
        else wage = 0;
        }

		if (year <= 1992)
		wage = wage * wageind[1992 - 1951] / wageind[year - 1951];
      else
      { for (yearindx = 1992; yearindx < birthyear + age; yearindx++)
		  { if (yearindx < 2020)
		    wage = wage / (1 + 0.01 * wGrowthRate[yearindx - 1992]);
		    else wage = wage / (1 + 0.01 * wGrowthRate[2020 - 1992]);
          }
        }

      if (wage >= 10350)
	   coverageyears = coverageyears + 1;
      }
    }

  if (coverageyears >= 10)
  coverage = 1;
  else coverage = 0;

  if (coverage == 1)
  { for (year = 0; year < 35; year++)
    ssearningsvec[year] = 0;

    for (age = max(0, 1951 - birthyear); age < piaage; age++)
    { replacementyear = 0;

	   for (year = 1; year < 35; year++)
	   if (ssearningsvec[year] < ssearningsvec[replacementyear])
	   replacementyear = year;

	   year = birthyear + age;

      if (splitearnings == 0)
      wage = earnings[age];
      else
      { if (age < piaage && spbirthyear < birthyear + age
         && birthyear + age < spbirthyear + spretage)
        wage = (earnings[age] + spearnings[(age + birthyear) - spbirthyear]) / 2;
        else if (age < piaage)
        wage = earnings[age] / 2;
        else if (spbirthyear < birthyear + age && birthyear + age < spbirthyear + spretage)
        wage = spearnings[(age + birthyear) - spbirthyear] / 2;
        else wage = 0;
        }

	   if (age < 60)                  /* index wages to age 60 */
	   { year60  = birthyear + 60;

		  if (year <= 1992)
		  wage = wage * wageind[min(1992, year60) - 1951] / wageind[year - 1951];

		  for (yearindx = max(1992, year); yearindx < year60; yearindx++)
		  { if (yearindx < 2020)
		    wage = wage * (1 + 0.01 * wGrowthRate[yearindx - 1992]);
		    else wage = wage * (1 + 0.01 * wGrowthRate[2020 - 1992]);
          }
        }

	   if (wage > ssearningsvec[replacementyear])
	   ssearningsvec[replacementyear] = wage;
	   }

    /* for (year = 0; year < 35; year++)
    { if (year % 10 == 0) wnprintf("\n");
	   wnprintf(" %6.0f", ssearningsvec[year]);
	   } */

    aime = 0;

    for (year = 0; year < 35; year++)
    aime = aime + ssearningsvec[year];
    /* wnprintf("\n aime %5.0f", (aime / 35)); */

    aime = aime / (35 * 12);

    /* calculate pia as of age 62 and deflate it to 1992 */

    year62  = birthyear + 62;

    if (year62 < 1992)                  /* index bend points */
    { if (year62 < 1951)
	   bendindex = wageind[1951 - 1951] / wageind[1992 - 1951];
	   else bendindex = wageind[year62 - 1951] / wageind[1992 - 1951];
	   }
    else
    { bendindex = 1;

	   for (year = 1992; year < year62 - 1; year++)
	   if (year < 2020)
	   bendindex = bendindex * (1 + 0.01 * wGrowthRate[year - 1992]);
	   else bendindex = bendindex * (1 + 0.01 * wGrowthRate[2020 - 1992]);
	   }

    bend1 =  387 * bendindex;          /* 1992 bend points */
    bend2 = 2333 * bendindex;

    if (windfallflag == 1 && coverageyears < 30)
    { if (coverageyears > 20)
      firstbracketpct = 0.4 + 0.05 * (coverageyears - 20);
      else firstbracketpct = 0.4;
      }
    else firstbracketpct = 0.9;

    if (aime < bend1)                  /* pia in age62 dollars */
    pia = firstbracketpct * aime;
    else if (aime < bend2)
    pia = firstbracketpct * bend1 + 0.32 * (aime - bend1);
    else pia = firstbracketpct * bend1 + 0.32 * (bend2 - bend1) + 0.15 * (aime - bend2);

    pia = pia * 12;

    /* wnprintf(" age62 pia %5.0f", pia); */
    if (year62 < 1992)
    { if (year62 < 1951)
	   infladj = cpiind[1992 - 1951] / cpiind[1951 - 1951];
	   else infladj = cpiind[1992 - 1951] / cpiind[year62 - 1951];
	   }
    else
    { infladj = 1;

	   for (year = 1992; year < year62 - 1; year++)
	   if (year < 2020)
	   infladj = infladj / (1 + 0.01 * inflationRate[year - 1992]);
	   else infladj = infladj / (1 + 0.01 * inflationRate[2020 - 1992]);
	   }

    pia = pia * infladj;               /* pia in 1992 dollars */
    }
  else pia = 0;

  /* wnprintf("  p %d %5.0f", piaage, pia); pause(); */
  return(pia);

  }


/*---------------------------------------------------------------------------
			 GET SOCIAL SECURITY PV routine
			 gets Social Security present values of benefits
  ---------------------------------------------------------------------------*/

float getSocialSecurityPV(
  int   discyear,                 /* year to which benefits are discounted */
  int   birthyear,                /* year of birth */
  int   fstartage,                /* age benefits could start */
  int   gender,                   /* gender of respondent */
  float pia,                      /* pia in 1992 dollars */
  float ncpen,                    /* pension from non-social security jobs */
  int   spbirthyear,              /* spouse's birth year */
  int   fspstartage,              /* age spouse could start collecting benefits */
  int   spgender,                 /* spouse's gender */
  float spousepia,                /* spouse's pia in 1992 dollars */
  float spncpen)                  /* spouses pension from non-ss jobs */

{ int   year, mortyear;
  int   age, mortage, spmortage;
  int   startage, spstartage;
  int   curstartage, curspstartage;
  int   startagesp, spstartagesp;
  int   startyear, spstartyear;
  int   startyearsp, spstartyearsp;
  int   nrage, spnrage;
  float delayedret, spdelayedret;
  float adjown, spadjown;
  float adjsp, spadjsp;
  float ownbenefit, spownbenefit;
  float benefitsp, spbenefitsp;
  float mortprob, totben, maxtotben, survivorben;

  static float surv[120], spsurv[120];
  static float annval[120], spannval[120];
  static float df[150];

  static lastdiscyear = -1;
  static lastbirthyear = -1, lastspbirthyear = -1;
  static lastgender = -1, lastspgender = -1;

  static float cpi[42] = {
			  26.0,  26.5,  26.7,  26.9,  26.8,  27.2,  28.1,  28.9,  29.1,
	 29.6,  29.9,  30.2,  30.6,  31.0,  31.5,  32.4,  33.4,  34.8,  36.7,
	 38.8,  40.5,  41.8,  44.4,  49.3,  53.8,  56.9,  60.6,  65.2,  72.6,
	 82.4,  90.9,  96.5,  99.6, 103.9, 107.6, 109.6, 113.6, 118.3, 124.0,
	130.7, 136.2, 140.3};
  /* 1951-1992 CPI-U, Table B-59, 1995 ERP */

  static float inflationRate[19] = {
			 2.9,  2.8,  2.8,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,
	 3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0,  3.0};
  /* CPI inflation rate, 1992-2010, in Table II.D1, p. 59, in the   */
  /* 1993 Annual Report of the Board of Trustees of Social Security */
  /* static float inflationRate[19] = {
			 2.9,  2.8,  2.5,  3.1,  3.2,  3.3,  3.4,  3.5,  3.7,
	 3.9,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0,  4.0};
     CPI inflation rate, 1992-2010, in Table II.D1, p. 56, in the
     1995 Annual Report of the Board of Trustees of Social Security */

  static float pastInterestRate[41] = {
			  2.85,  2.85,  2.85,  2.40,  2.82,  3.18,  3.65,  3.32,  4.33,
	 4.12,  3.88,  3.95,  4.00,  4.19,  4.28,  4.92,  5.07,  5.65,  6.67,
	 7.35,  6.16,  6.21,  6.84,  7.56,  7.99,  7.61,  7.42,  8.41,  9.44,
	11.46, 13.91, 13.00, 11.10, 12.44, 10.62,  7.68,  8.39,  8.85,  8.49,
	 8.55,  7.86};
  /* 1951-1991 interest rate, 10 year bonds, in Table B-72, 1995 ERP */

  static float interestRate[19] = {
			 7.1,  6.3,  5.8,  5.9,  6.0,  6.0,  6.0,  6.0,  6.0,
	 6.1,  6.1,  6.1,  6.1,  6.1,  6.0,  6.0,  6.0,  6.0,  6.0};
  /* Interest rate, 1992-2010, in Table II.D1, p. 56, in the 1995 */
  /* Annual Report of the Board of Trustees of Social Security    */
  /* static float interestRate[19] = {
			 7.1,  6.1,  7.1,  7.7,  7.6,  7.6,  7.4,  7.2,  7.1,
	 7.0,  6.9,  6.7,  6.5,  6.5,  6.4,  6.4,  6.4,  6.3,  6.3};
     Interest rate, 1992-2010, in Table II.D1, p. 56, in the 1995
     Annual Report of the Board of Trustees of Social Security    */


  if (fstartage < 62)
  fstartage = 62;
  else if (fstartage > 70)
  fstartage = 70;

  if (fspstartage < 62)
  fspstartage = 62;
  else if (fspstartage > 70)
  fspstartage = 70;

  /* check to see if this is the same respondent as in the last call */

  if (discyear != lastdiscyear || birthyear != lastbirthyear || gender != lastgender
    || spbirthyear != lastspbirthyear || spgender != lastspgender)
  { /* calculate discount rates */

    if (lastdiscyear == -1)
    { df[1951 - 1951] = 1;

      for (year = 1951; year <= 1991; year++)
      df[(year + 1) - 1951] = df[year - 1951] * (cpi[(year + 1) - 1951] / cpi[year - 1951])
        / (1 + 0.01 * pastInterestRate[year - 1951]);

      for (year = 1992; year <= 2099; year++)
      if (year < 2010)
      df[(year + 1) - 1951] = df[year - 1951] / (1 + 0.01 * (interestRate[year - 1992]
						      - inflationRate[year - 1992]));
      else df[(year + 1) - 1951] = df[year - 1951] / (1 + 0.01 * (interestRate[2010 - 1992]
								     - inflationRate[2010 - 1992]));
      }

    /* calculate the annuity values of $1 streams starting in various years */

    memset(annval, 0, fstartage * sizeof(float));

    getSurvivalRates(birthyear, gender, surv);

    annval[119] = 1;

    for (age = 118; age >= fstartage; age--)
    { year = birthyear + age;

	   if (surv[age + 1] > 0)
	   annval[age] = 1 + annval[age + 1] * (df[(year + 1) - 1951] / df[year - 1951])
								  * (surv[age + 1] / surv[age]);
	   else annval[age] = 1;
	   }

    for (age = fstartage; age < 120; age++)
    { year = birthyear + age;

      annval[age] = annval[age] * (df[year - 1951] / df[discyear - 1951]);

      if (age > discyear - birthyear)
      annval[age] = annval[age] * surv[age] / surv[discyear - birthyear];
	   }

    /* for (age = fstartage; age < fstartage + 60; age++)
    { if (age % 10 == 0) wnprintf("\n");
	   wnprintf(" %6.3f", annval[age]);
	   } */

    if (spbirthyear > 0)
    { memset(spannval, 0, fspstartage * sizeof(float));

      getSurvivalRates(spbirthyear, spgender, spsurv);

	   spannval[119] = 1;

	   for (age = 118; age >= fspstartage; age--)
	   { year = spbirthyear + age;

		  if (spsurv[age + 1] > 0)
		  spannval[age] = 1 + spannval[age + 1] * (df[(year + 1) - 1951] / df[year - 1951])
								    * (spsurv[age + 1] / spsurv[age]);
		  else spannval[age] = 1;
		  }

	   for (age = fspstartage; age < 120; age++)
	   { year = spbirthyear + age;

        spannval[age] = spannval[age] * (df[year - 1951] / df[discyear - 1951]);

        if (age > discyear - spbirthyear && discyear - spbirthyear >= 0)
		  spannval[age] = spannval[age] * spsurv[age] / spsurv[discyear - spbirthyear];
        }

	   /* for (age = fspstartage; age < fspstartage + 60; age++)
	   { if (age % 10 == 0) wnprintf("\n");
		  wnprintf(" %6.3f", spannval[age]);
		  } */
      }

    lastdiscyear = discyear;
    lastbirthyear = birthyear;
    lastgender = gender;
    lastspbirthyear = spbirthyear;
    lastspgender = spgender;
	 }

  maxtotben = 0;

  for (curstartage = fstartage; curstartage <= 70; curstartage++)
  for (curspstartage = fspstartage; curspstartage <= 70; curspstartage++)
  { startage = curstartage;
    spstartage = curspstartage;

    /* get values of retirement ages and adjustment rates */

    /* wnprintf("\n   discyr %d   start %d %d", discyear, startage, spstartage); */
    startyear = birthyear + startage;

    if (birthyear <= 1939)
    nrage = 65;
    else if (birthyear <= 1956)
    nrage = 66;
    else nrage = 67;

    if (birthyear <= 1924)
    delayedret = 0.03;
    else if (birthyear >= 1943)
    delayedret = 0.08;
    else delayedret = 0.03 + 0.005 * ((birthyear - 1923) / 2);
    /* wnprintf("\n   nrage %d   delfact %6.3f",	nrage, delayedret); */

    if (spbirthyear > 0)
    { spstartyear = spbirthyear + spstartage;

      if (spbirthyear <= 1939)
	   spnrage = 65;
	   else if (spbirthyear <= 1956)
	   spnrage = 66;
	   else spnrage = 67;

	   if (spbirthyear <= 1924)
	   spdelayedret = 0.03;
	   else if (spbirthyear >= 1943)
	   spdelayedret = 0.08;
	   else spdelayedret = 0.03 + 0.005 * ((spbirthyear - 1923) / 2);
  	   /* wnprintf("\n spnrage %d spdelfact %6.3f",	spnrage, spdelayedret); */
	   }

    /* wnprintf("\n startage %d %d pia %5.0f %5.0f", startage, spstartage, pia, spousepia); */

    totben = 0;

    /* calculate own and spouse annual benefits */

    if (startage < 62)
    adjown = 1 - 0.2 - 0.05 * (nrage - 62);
    else if (startage < nrage - 3)
    adjown = 1 - 0.2 - 0.05 * (nrage - 3 - startage);
    else if (startage < nrage)
    adjown = 1 - 0.066667 * (nrage - startage);
    else adjown = 1 + delayedret * (startage - nrage);

    ownbenefit = pia * adjown;

    if (spbirthyear > 0)
    { /* respondent's potential benefits as a spouse */

      startyearsp = max(startyear, spstartyear);
      startagesp = startyearsp - birthyear;

      if (startagesp < 62)
      adjsp = 1 - 0.25 - 0.05 * (nrage - 62);
      else if (startagesp < nrage - 3)
      adjsp = 1 - 0.25 - 0.05 * (nrage - 3 - startagesp);
      else if (startagesp < nrage)
      adjsp = 1 - 0.083333 * (nrage - startagesp);
      else adjsp = 1;

      benefitsp = max(0.5 * spousepia * adjsp - ncpen, 0);
      /* wnprintf("\n adjown %6.3f ownben %5.0f adjsp %6.3f bensp %5.0f",
       adjown, ownbenefit, adjsp, benefitsp); */

      /* spouse's own benefits */

      if (spstartage < 62)
	   spadjown = 1 - 0.2 - 0.05 * (spnrage - 62);
	   else if (spstartage < spnrage - 3)
	   spadjown = 1 - 0.2 - 0.05 * (spnrage - 3 - spstartage);
	   else if (spstartage < spnrage)
	   spadjown = 1 - 0.066667 * (spnrage - spstartage);
	   else spadjown = 1 + spdelayedret * (spstartage - spnrage);

	   spownbenefit = spousepia * spadjown;

      /* spouse's benefits as a spouse */

	   spstartyearsp = max(startyear, spstartyear);
	   spstartagesp = spstartyearsp - spbirthyear;

	   if (spstartagesp < 62)
	   spadjsp = 1 - 0.25 - 0.05 * (spnrage - 62);
	   else if (spstartagesp < spnrage - 3)
	   spadjsp = 1 - 0.25 - 0.05 * (spnrage - 3 - spstartagesp);
	   else if (spstartagesp < spnrage)
	   spadjsp = 1 - 0.083333 * (spnrage - spstartagesp);
	   else spadjsp = 1;

	   spbenefitsp = max(0.5 * pia * spadjsp - spncpen, 0);
  	   /* wnprintf("\n spadjown %6.3f spownben %5.0f spadjsp %6.3f spbensp %5.0f",
	    spadjown, spownbenefit, spadjsp, spbenefitsp); */
	   }

    /* calculate present value of respondent's benefits */

    if (spbirthyear < 0 || splitearnings != 0)   /* not married */
    totben = totben + ownbenefit * annval[startage];
    else                                         /* married */
    { for (mortyear = max(discyear + 1, spbirthyear + 1); mortyear < min(birthyear + 119, spbirthyear + 120);
         mortyear++)                      /* year spouse dies */
	   { spmortage = mortyear - spbirthyear;

		  if (spmortage < 120)              /* probability of wife's death */
		  { if (discyear >= spbirthyear)
          mortprob = (spsurv[spmortage - 1] - spsurv[spmortage]) / spsurv[discyear - spbirthyear];
          else mortprob = spsurv[spmortage - 1] - spsurv[spmortage];
          }
		  else
        { if (discyear >= spbirthyear)
          mortprob = spsurv[spmortage - 1] / spsurv[discyear - spbirthyear];
          else mortprob = spsurv[spmortage - 1];
          }

		  /* period while spouse is alive before spouse starts benefits */

		  if (startyear < min(spstartyear, mortyear))
		  totben = totben + ownbenefit * mortprob
		    * (annval[startyear - birthyear] - annval[min(spstartyear, mortyear) - birthyear]);

 		  /* period while spouse is alive after spouse starts benefits */

		  if (max(startyear, spstartyear) < mortyear)
		  totben = totben + max(ownbenefit, benefitsp) * mortprob
		    * (annval[max(startyear, spstartyear) - birthyear]
            - annval[mortyear - birthyear]);

		  /* period after spouse has died */

		  survivorben = spousepia * max(0.825, spadjown);

		  if (max(startyear, mortyear) - birthyear < nrage)
		  survivorben = max(survivorben * (1 - 0.285
		    * ((float) (nrage - (max(startyear, mortyear) - birthyear)))
           / ((float) (nrage - 60))) - ncpen, 0);

		  totben = totben + max(ownbenefit, survivorben) * mortprob
		    * annval[max(startyear, mortyear) - birthyear];
		  }
      /* wnprintf("\n ben %6.0f", totben); */

      /* calculate present value of spouse's benefits */
      for (mortyear = discyear + 1; mortyear < min(spbirthyear + 119, birthyear + 120);
         mortyear++)                          /* year respondent dies */
	   { mortage = mortyear - birthyear;

		  if (mortage < 120)               /* probability of respondent's death */
        mortprob = (surv[mortage - 1] - surv[mortage]) / surv[discyear - birthyear];
		  else mortprob = surv[mortage - 1] / surv[discyear - birthyear];

		  /* period while spouse is alive before respondent starts benefits */

		  if (spstartyear < min(startyear, mortyear))
		  totben = totben + spownbenefit * mortprob
		    * (spannval[spstartyear - spbirthyear] - spannval[min(startyear, mortyear) - spbirthyear]);

		  /* period while respondent is alive after respondent starts benefits */

		  if (max(spstartyear, startyear) < mortyear)
		  totben = totben + max(spownbenefit, spbenefitsp) * mortprob
			   * (spannval[max(spstartyear, startyear) - spbirthyear]
              - spannval[mortyear - spbirthyear]);

		  /* period after respondent has died */

		  survivorben = pia * max(0.825, adjown);

		  if (max(spstartyear, mortyear) - spbirthyear < spnrage)
        survivorben = max(survivorben * (1 - 0.285
		    * ((float) (spnrage - (max(spstartyear, mortyear) - spbirthyear)))
			  / ((float) (spnrage - 60))) - spncpen, 0);

		  totben = totben + max(spownbenefit, survivorben) * mortprob
		    * spannval[max(spstartyear, mortyear) - spbirthyear];
		  }
      }

    if (totben > maxtotben)
    maxtotben = totben;

    /* wnprintf("  benf %6.0f  maxben %6.0f", totben, maxtotben); */
	 }

  /* if (maxtotben < 0 || maxtotben > 400000) pause(); */

  return(maxtotben);

  }


/*---------------------------------------------------------------------------
			 PRINT TABS
			 prints tabulations on relative retirement dates of husbands and wives
  ---------------------------------------------------------------------------*/

void printTabs(
  struct respdata *respvars,
  int    nobs,
  struct srmdata *srmvars)

{ int   recno, obs, surv;
  int   age, spouse, type;
  int   row, col;
  int   caseid, matchid;
  int   gender, genderp, genders;
  int   ftwork, lftsurvh, lftsurvw;
  int   birthyearh, birthyearw;
  int   agediff, retdiff;
  int   cohort, lftage, fretage;
  int   retsurv, spikeyear, dropyear;

  float *earnings;
  struct persdata *persvars;
  struct respdata *resp, *respp, *resps, *resph, *respw;

  int   tabs[2][2][33], tabs1[6][6], tabs2[21][7], tabs3[2][2][14][6];


  memset(tabs, 0, sizeof(int[2][2][33]));

  for (recno = 0; recno < 12651; recno++)
  { respp = &respvars[recno];
    resps = &respvars[recno + 1];

    caseid = respp->caseid;
    matchid = respp->matchid;

    genderp = respp->gender;
    genders = resps->gender;

    if (caseid < 20000 && matchid > 20000
     && matchid == resps->caseid && genderp != genders)
    if (respp->goodobs.sameSpouse == 1 && respp->goodobs.goodCareer == 1)
    if (resps->goodobs.sameSpouse == 1 && resps->goodobs.goodCareer == 1)
    { for (spouse = 0; spouse < 2; spouse++)
      { if (spouse == 0) resp = respp;
        else             resp = resps;

        gender = resp->gender;

        if (gender == 2)
        gender = 1;
        else gender = 0;

        for (surv = 0; surv < 5; surv++)
        { ftwork = resp->ftwork[surv];
          age = resp->survage[surv];

          if ((ftwork == 0 || ftwork == 1) && (0 < age && age < 95))
          { if (age < 45)
            age = 44;
            else if (age > 75)
            age = 76;

            if (ftwork == 1)
            tabs[gender][0][age - 44] = tabs[gender][0][age - 44] + 1;

            tabs[gender][1][age - 44] = tabs[gender][1][age - 44] + 1;
            }
          }
        }
      }
    }

  wnprintf("\n\n\n                  Retirement Status by Age");
  wnprintf(    "\n          Including Those with Bad Earnings Profiles");
  wnprintf(  "\n\n                       Percent Working");
  wnprintf(    "\n                Husbands               Wives");
  wnprintf(    "\n             Percent Count        Percent Count");

  for (age = 44; age < 77; age++)
  { if (age == 44)
    { wnprintf("\n  Age");
      wnprintf("\n  <45");
      }
    else if (age < 76)
    wnprintf("\n   %2d", age);
    else wnprintf("\n  >75");

    for (col = 0; col < 2; col++)
    { if (tabs[col][1][age - 44] > 0)
      wnprintf("%15.1f [%3d]", 100 * ((float) tabs[col][0][age - 44]
        / (float) tabs[col][1][age - 44]), tabs[col][1][age - 44]);
      else wnprintf("                    ");
      }
    }


  memset(tabs1, 0, sizeof(int[6][6]));
  memset(tabs2, 0, sizeof(int[21][7]));

  for (recno = 0; recno < 12651; recno++)
  { respp = &respvars[recno];
    resps = &respvars[recno + 1];

    caseid = respp->caseid;
    matchid = respp->matchid;

    genderp = respp->gender;
    genders = resps->gender;

    if (caseid < 20000 && matchid > 20000
     && matchid == resps->caseid && genderp != genders)
    if (respp->goodobs.sameSpouse == 1 && respp->goodobs.goodCareer == 1)
    if (resps->goodobs.sameSpouse == 1 && resps->goodobs.goodCareer == 1)
    { if (genderp == 1) resph = respp;
      else              resph = resps;

      if (genders == 1) respw = respp;
      else              respw = resps;

      lftsurvh = resph->lftsurv;
      lftsurvw = respw->lftsurv;

      if (-1 <= lftsurvh && lftsurvh <= 4 && -1 <= lftsurvw && lftsurvw <= 4)
      tabs1[lftsurvh + 1][lftsurvw + 1] = tabs1[lftsurvh + 1][lftsurvw + 1] + 1;

      if (0 <= lftsurvh && lftsurvh <= 3 && 0 <= lftsurvw && lftsurvw <= 3)
      { birthyearh = resph->vint;
        birthyearw = respw->vint;

        agediff = birthyearw - birthyearh;

        if (agediff < -10)
        agediff = -10;
        else if (agediff > 10)
        agediff = 10;

        retdiff = lftsurvh - lftsurvw;

        tabs2[agediff + 10][retdiff + 3] = tabs2[agediff + 10][retdiff + 3] + 1;
        }
      }
    }

  wnprintf("\n\n\n                               Retirement Tabulations by Year");
  wnprintf(    "\n                         Including Those with Bad Earnings Profiles");
  wnprintf(    "\n                                     Retirement of Wife");
  wnprintf(    "\n                   Before     1992-     1994-     1996-     1998-     After");
  wnprintf(    "\n                    1992      1994      1996      1998      2000      1998");
  wnprintf(    "\nRetirement of");
  wnprintf(    "\n   Husband");

  for (row = 0; row < 6; row++)
  { switch(row)
    { case  0:  wnprintf("\n Before 1992 ");    break;
      case  1:  wnprintf("\n 1992-1994   ");    break;
      case  2:  wnprintf("\n 1994-1996   ");    break;
      case  3:  wnprintf("\n 1996-1998   ");    break;
      case  4:  wnprintf("\n 1998-2000   ");    break;
      case  5:  wnprintf("\n After 2000  ");    break;
      }

    for (col = 0; col < 6; col++)
    wnprintf("%10d", tabs1[row][col]);
    }


  wnprintf("\n\n\n                                     Retirement Differences");
  wnprintf(    "\n                           Including Those with Bad Earnings Profiles");
  wnprintf(    "\n                            Difference in Retirement Surveys (Husband - Wife)");
  wnprintf(    "\n                     -3        -2        -1         0         1         2         3");
  wnprintf(    "\nAge Difference");
  wnprintf(    "\n  Husband - Wife");

  for (row = 0; row < 21; row++)
  { wnprintf("\n     %3d     ", row - 10);

    for (col = 0; col < 7; col++)
    wnprintf("%10d", tabs2[row][col]);
    }


  memset(tabs, 0, sizeof(int[2][2][33]));

  for (recno = 0; recno < 12651; recno++)
  { respp = &respvars[recno];
    resps = &respvars[recno + 1];

    caseid = respp->caseid;
    matchid = respp->matchid;

    genderp = respp->gender;
    genders = resps->gender;

    if (caseid < 20000 && matchid > 20000
     && matchid == resps->caseid && genderp != genders)
    if (respp->goodobs.married      == 1 && respp->goodobs.sameSpouse   == 1
     && respp->goodobs.goodCareer   == 1 && respp->goodobs.goodAge      == 1
     && respp->goodobs.goodEarnings == 1 && respp->goodobs.goodSSstatus == 1
     && respp->goodobs.goodFTyears  == 1 && respp->goodobs.goodSSearn   == 1
     && respp->goodobs.goodPens     == 1)
    if (resps->goodobs.married      == 1 && resps->goodobs.sameSpouse   == 1
     && resps->goodobs.goodCareer   == 1 && resps->goodobs.goodAge      == 1
     && resps->goodobs.goodEarnings == 1 && resps->goodobs.goodSSstatus == 1
     && resps->goodobs.goodFTyears  == 1 && resps->goodobs.goodSSearn   == 1
     && resps->goodobs.goodPens     == 1)
    { for (spouse = 0; spouse < 2; spouse++)
      { if (spouse == 0) resp = respp;
        else             resp = resps;

        gender = resp->gender;

        if (gender == 2)
        gender = 1;
        else gender = 0;

        for (surv = 0; surv < 5; surv++)
        { ftwork = resp->ftwork[surv];
          age = resp->survage[surv];

          if ((ftwork == 0 || ftwork == 1) && (0 < age && age < 95))
          { if (age < 45)
            age = 44;
            else if (age > 75)
            age = 76;

            if (ftwork == 1)
            tabs[gender][0][age - 44] = tabs[gender][0][age - 44] + 1;

            tabs[gender][1][age - 44] = tabs[gender][1][age - 44] + 1;
            }
          }
        }
      }
    }

  wnprintf("\n\n\n                  Retirement Status by Age");
  wnprintf(    "\n          Excluding Those with Bad Earnings Profiles");
  wnprintf(  "\n\n                       Percent Working");
  wnprintf(    "\n                Husbands               Wives");
  wnprintf(    "\n             Percent Count        Percent Count");

  for (age = 44; age < 77; age++)
  { if (age == 44)
    { wnprintf("\n  Age");
      wnprintf("\n  <45");
      }
    else if (age < 76)
    wnprintf("\n   %2d", age);
    else wnprintf("\n  >75");

    for (col = 0; col < 2; col++)
    { if (tabs[col][1][age - 44] > 0)
      wnprintf("%15.1f [%3d]", 100 * ((float) tabs[col][0][age - 44]
        / (float) tabs[col][1][age - 44]), tabs[col][1][age - 44]);
      else wnprintf("                    ");
      }
    }


  memset(tabs, 0, sizeof(int[2][2][33]));

  for (recno = 0; recno < 12651; recno++)
  { respp = &respvars[recno];
    resps = &respvars[recno + 1];

    caseid = respp->caseid;
    matchid = respp->matchid;

    genderp = respp->gender;
    genders = resps->gender;

    if (caseid < 20000 && matchid > 20000
     && matchid == resps->caseid && genderp != genders)
    if (respp->goodobs.married      == 1 && respp->goodobs.sameSpouse   == 1
     && respp->goodobs.goodCareer   == 1 && respp->goodobs.goodAge      == 1
     && respp->goodobs.goodEarnings == 1 && respp->goodobs.goodSSstatus == 1
     && respp->goodobs.goodFTyears  == 1 && respp->goodobs.goodSSearn   == 1
     && respp->goodobs.goodPens     == 1)
    if (resps->goodobs.married      == 1 && resps->goodobs.sameSpouse   == 1
     && resps->goodobs.goodCareer   == 1 && resps->goodobs.goodAge      == 1
     && resps->goodobs.goodEarnings == 1 && resps->goodobs.goodSSstatus == 1
     && resps->goodobs.goodFTyears  == 1 && resps->goodobs.goodSSearn   == 1
     && resps->goodobs.goodPens     == 1)
    { for (spouse = 0; spouse < 2; spouse++)
      { if (spouse == 0) resp = respp;
        else             resp = resps;

        gender = resp->gender;

        if (gender == 2)
        gender = 1;
        else gender = 0;

        lftage = resp->lftage;
        fretage = resp->fretage;

        for (surv = 0; surv < 5; surv++)
        { age = resp->survage[surv];

          if ((ftwork == 0 || ftwork == 1) && (0 < age && age < 95))
          { if (age < 45)
            age = 44;
            else if (age > 75)
            age = 76;

            if (age <= lftage)
            tabs[gender][0][age - 44] = tabs[gender][0][age - 44] + 1;

            if (age <= lftage || age >= fretage)
            tabs[gender][1][age - 44] = tabs[gender][1][age - 44] + 1;
            }
          }
        }
      }
    }

  wnprintf("\n\n\n                  Retirement Status by Age");
  wnprintf(    "\n          Excluding Those with Bad Earnings Profiles");
  wnprintf(    "\n                 Excluding Ambiguous Years");
  wnprintf(  "\n\n                       Percent Retired");
  wnprintf(    "\n                Husbands               Wives");
  wnprintf(    "\n             Percent Count        Percent Count");

  for (age = 44; age < 77; age++)
  { if (age == 44)
    { wnprintf("\n  Age");
      wnprintf("\n  <45");
      }
    else if (age < 76)
    wnprintf("\n   %2d", age);
    else wnprintf("\n  >75");

    for (col = 0; col < 2; col++)
    { if (tabs[col][1][age - 44] > 0)
      wnprintf("%15.1f [%3d]", 100 * ((float) tabs[col][0][age - 44]
        / (float) tabs[col][1][age - 44]), tabs[col][1][age - 44]);
      else wnprintf("                    ");
      }
    }


  memset(tabs1, 0, sizeof(int[6][6]));
  memset(tabs2, 0, sizeof(int[21][7]));

  for (recno = 0; recno < 12651; recno++)
  { respp = &respvars[recno];
    resps = &respvars[recno + 1];

    caseid = respp->caseid;
    matchid = respp->matchid;

    genderp = respp->gender;
    genders = resps->gender;

    if (caseid < 20000 && matchid > 20000
     && matchid == resps->caseid && genderp != genders)
    if (respp->goodobs.married      == 1 && respp->goodobs.sameSpouse   == 1
     && respp->goodobs.goodCareer   == 1 && respp->goodobs.goodAge      == 1
     && respp->goodobs.goodEarnings == 1 && respp->goodobs.goodSSstatus == 1
     && respp->goodobs.goodFTyears  == 1 && respp->goodobs.goodSSearn   == 1
     && respp->goodobs.goodPens     == 1)
    if (resps->goodobs.married      == 1 && resps->goodobs.sameSpouse   == 1
     && resps->goodobs.goodCareer   == 1 && resps->goodobs.goodAge      == 1
     && resps->goodobs.goodEarnings == 1 && resps->goodobs.goodSSstatus == 1
     && resps->goodobs.goodFTyears  == 1 && resps->goodobs.goodSSearn   == 1
     && resps->goodobs.goodPens     == 1)
    { if (genderp == 1) resph = respp;
      else              resph = resps;

      if (genders == 1) respw = respp;
      else              respw = resps;

      lftsurvh = resph->lftsurv;
      lftsurvw = respw->lftsurv;

      if (-1 <= lftsurvh && lftsurvh <= 4 && -1 <= lftsurvw && lftsurvw <= 4)
      tabs1[lftsurvh + 1][lftsurvw + 1] = tabs1[lftsurvh + 1][lftsurvw + 1] + 1;

      if (0 <= lftsurvh && lftsurvh <= 3 && 0 <= lftsurvw && lftsurvw <= 3)
      { birthyearh = resph->vint;
        birthyearw = respw->vint;

        agediff = birthyearw - birthyearh;

        if (agediff < -10)
        agediff = -10;
        else if (agediff > 10)
        agediff = 10;

        retdiff = lftsurvh - lftsurvw;

        tabs2[agediff + 10][retdiff + 3] = tabs2[agediff + 10][retdiff + 3] + 1;
        }
      }
    }


  wnprintf("\n\n\n                               Retirement Tabulations by Year");
  wnprintf(    "\n                         Excluding Those with Bad Earnings Profiles");
  wnprintf(    "\n                                     Retirement of Wife");
  wnprintf(    "\n                   Before     1992-     1994-     1996-     1998-     After");
  wnprintf(    "\n                    1992      1994      1996      1998      2000      1998");
  wnprintf(    "\nRetirement of");
  wnprintf(    "\n   Husband");

  for (row = 0; row < 6; row++)
  { switch(row)
    { case  0:  wnprintf("\n Before 1992 ");    break;
      case  1:  wnprintf("\n 1992-1994   ");    break;
      case  2:  wnprintf("\n 1994-1996   ");    break;
      case  3:  wnprintf("\n 1996-1998   ");    break;
      case  4:  wnprintf("\n 1998-2000   ");    break;
      case  5:  wnprintf("\n After 2000  ");    break;
      }

    for (col = 0; col < 6; col++)
    wnprintf("%10d", tabs1[row][col]);
    }


  wnprintf("\n\n\n                                     Retirement Differences");
  wnprintf(    "\n                           Excluding Those with Bad Earnings Profiles");
  wnprintf(    "\n                            Difference in Retirement Surveys (Husband - Wife)");
  wnprintf(    "\n                     -3        -2        -1         0         1         2         3");
  wnprintf(    "\nAge Difference");
  wnprintf(    "\n  Husband - Wife");

  for (row = 0; row < 21; row++)
  { wnprintf("\n     %3d     ", row - 10);

    for (col = 0; col < 7; col++)
    wnprintf("%10d", tabs2[row][col]);
    }


  memset(tabs3, 0, sizeof(int[2][2][14][6]));

  wnprintf("\n\n\n                                        Earnings");
  wnprintf(    "\n                Age  ----------------------------------------------- Last First");
  wnprintf(    "\n Obs 0=wf Birth at   Spike  Spike  Spike  Spike  Spike  Spike  Spike  ft   ret  Ret");
  wnprintf(    "\n  no 1=hb year spike  - 3    - 2    - 1   year    + 1    + 2    + 3   age  age survey");

  for (obs = 0; obs < nobs; obs++)
  for (spouse = 0; spouse < 2; spouse++)
  { if (spouse == 0)
    persvars = &(srmvars[obs].wifevars);
    else persvars = &(srmvars[obs].husbvars);

    cohort   = persvars->vint;
    lftage   = persvars->lftage;
    fretage  = persvars->fretage;
    earnings = persvars->earnings;

    spikeyear = -1;
    retsurv   = -1;

    for (age = 50; age < 74; age++)
    if (spikeyear < 0)
    if (earnings[age - 25] > 1.25 * earnings[(age - 1) - 25] && earnings[(age - 1) - 25] > 0
     && earnings[age - 25] > 1.25 * earnings[(age + 1) - 25] && earnings[(age + 1) - 25] > 0)
    { if (cohort + age < 1990)        spikeyear = 0;
      else if (cohort + age < 2001)   spikeyear = cohort + age - 1989;
      else                            spikeyear = 12;

      wnprintf("\n%4d  %2d  %4d  %2d  %6.0f %6.0f %6.0f %6.0f %6.0f %6.0f %6.0f",
        obs, spouse, cohort, age, earnings[age - 28], earnings[age - 27], earnings[age - 26],
        earnings[age - 25], earnings[age - 24], earnings[age - 23], earnings[age - 22]);
      }

    if (fretage == 99)
    retsurv = 5;
    else if (0 < lftage && lftage < fretage && fretage < 99)
    { for (surv = 0; surv < 4; surv++)
      if (1991 + 2 * surv <= cohort + lftage && cohort + lftage <= 1993 + 2 * surv
       && 1993 + 2 * surv <= cohort + fretage && cohort + fretage <= 1995 + 2 * surv)
      retsurv = surv + 1;
      }
    else if (lftage == 0)
    retsurv = 0;

    if (spikeyear >= 0) wnprintf("   %2d  %2d   %2d", lftage, fretage, retsurv + 1);

    if (retsurv >= 0)
    tabs3[0][spouse][spikeyear + 1][retsurv] = tabs3[0][spouse][spikeyear + 1][retsurv] + 1;

    if (spouse == 0)
    persvars = &(srmvars[obs].husbvars);
    else persvars = &(srmvars[obs].wifevars);

    cohort   = persvars->vint;
    lftage   = persvars->lftage;
    fretage  = persvars->fretage;

    if (fretage == 99)
    retsurv = 5;
    else if (0 < lftage && lftage < fretage && fretage < 99)
    { for (surv = 0; surv < 4; surv++)
      if (1991 + 2 * surv <= cohort + lftage && cohort + lftage <= 1993 + 2 * surv
       && 1993 + 2 * surv <= cohort + fretage && cohort + fretage <= 1995 + 2 * surv)
      retsurv = surv + 1;
      }
    else if (lftage == 0)
    retsurv = 0;

    if (retsurv >= 0)
    tabs3[1][1 - spouse][spikeyear + 1][retsurv] = tabs3[1][1 - spouse][spikeyear + 1][retsurv] + 1;
    }

  wnprintf("\n\n\n\n                                   Responses to Retirement Incentives");
  wnprintf(      "\n                                             Retirement Date");
  wnprintf(      "\n                      Wave 1      Wave 2      Wave 3      Wave 4      Wave 5      Later");

  for (type = 0; type < 2; type++)
  for (spouse = 0; spouse < 2; spouse++)
  { switch(spouse)
    { case  0:  wnprintf("\n\nTiming of Spike                                     Wives");      break;
      case  1:  wnprintf("\n\nTiming of Spike                                    Husbands");    break;
      }

    switch(type)
    { case  0:  wnprintf("\nof Own Earnings");       break;
      case  1:  switch(spouse)
                { case 0:  wnprintf("\nof Husband's Earnings");   break;
                  case 1:  wnprintf("\nof Wife's Earnings");      break;
                  }                                  break;
      }

    for (spikeyear = 0; spikeyear < 14; spikeyear++)
    { switch(spikeyear)
      { case  0:  wnprintf("\n  No spike    ");      break;
        case  1:  wnprintf("\n  Before 1990 ");      break;
        case  2:  wnprintf("\n  1990        ");      break;
        case  3:  wnprintf("\n  1991        ");      break;
        case  4:  wnprintf("\n  1992        ");      break;
        case  5:  wnprintf("\n  1993        ");      break;
        case  6:  wnprintf("\n  1994        ");      break;
        case  7:  wnprintf("\n  1995        ");      break;
        case  8:  wnprintf("\n  1996        ");      break;
        case  9:  wnprintf("\n  1997        ");      break;
        case 10:  wnprintf("\n  1998        ");      break;
        case 11:  wnprintf("\n  1999        ");      break;
        case 12:  wnprintf("\n  2000        ");      break;
        case 13:  wnprintf("\n  After 2000  ");      break;
        }

      for (retsurv = 0; retsurv < 6; retsurv++)
      wnprintf("%12d", tabs3[type][spouse][spikeyear][retsurv]);
      }
    }


  memset(tabs3, 0, sizeof(int[2][2][14][6]));

  wnprintf("\n\n\n                                        Earnings");
  wnprintf(    "\n                Age  ----------------------------------------------- Last First");
  wnprintf(    "\n Obs 0=wf Birth at   Drop   Drop   Drop   Drop   Drop   Drop   Drop   ft   ret  Ret");
  wnprintf(    "\n  no 1=hb year  drop  - 4    - 3    - 2    - 1   year    + 1    + 2   age  age survey");

  for (obs = 0; obs < nobs; obs++)
  for (spouse = 0; spouse < 2; spouse++)
  { if (spouse == 0)
    persvars = &(srmvars[obs].wifevars);
    else persvars = &(srmvars[obs].husbvars);

    cohort   = persvars->vint;
    lftage   = persvars->lftage;
    fretage  = persvars->fretage;
    earnings = persvars->earnings;

    dropyear = -1;
    retsurv   = -1;

    for (age = 50; age < 73; age++)
    if (dropyear < 0 && cohort + age >= 1993)
    if (earnings[(age - 1) - 25] < 1.1 * earnings[(age - 2) - 25]
     && earnings[(age - 1) - 25] < 1.1 * earnings[(age - 3) - 25]
     && earnings[(age - 1) - 25] > 1.25 * earnings[(age    ) - 25]
     && earnings[(age - 1) - 25] > 1.25 * earnings[(age + 1) - 25])
    { if (cohort + age < 2001)   dropyear = cohort + age - 1993;
      else                       dropyear = 8;

      wnprintf("\n%4d  %2d  %4d  %2d  %6.0f %6.0f %6.0f %6.0f %6.0f %6.0f %6.0f",
        obs, spouse, cohort, age, earnings[age - 29], earnings[age - 28], earnings[age - 27],
        earnings[age - 26], earnings[age - 25], earnings[age - 24], earnings[age - 22]);
      }

    if (fretage == 99)
    retsurv = 5;
    else if (0 < lftage && lftage < fretage && fretage < 99)
    { for (surv = 0; surv < 4; surv++)
      if (1991 + 2 * surv <= cohort + lftage && cohort + lftage <= 1993 + 2 * surv
       && 1993 + 2 * surv <= cohort + fretage && cohort + fretage <= 1995 + 2 * surv)
      retsurv = surv + 1;
      }
    else if (lftage == 0)
    retsurv = 0;

    if (dropyear >= 0) wnprintf("   %2d  %2d   %2d", lftage, fretage, retsurv + 1);

    if (retsurv >= 0)
    tabs3[0][spouse][dropyear][retsurv] = tabs3[0][spouse][dropyear][retsurv] + 1;

    if (spouse == 0)
    persvars = &(srmvars[obs].husbvars);
    else persvars = &(srmvars[obs].wifevars);

    cohort   = persvars->vint;
    lftage   = persvars->lftage;
    fretage  = persvars->fretage;

    if (fretage == 99)
    retsurv = 5;
    else if (0 < lftage && lftage < fretage && fretage < 99)
    { for (surv = 0; surv < 4; surv++)
      if (1991 + 2 * surv <= cohort + lftage && cohort + lftage <= 1993 + 2 * surv
       && 1993 + 2 * surv <= cohort + fretage && cohort + fretage <= 1995 + 2 * surv)
      retsurv = surv + 1;
      }
    else if (lftage == 0)
    retsurv = 0;

    if (retsurv >= 0)
    tabs3[1][1 - spouse][dropyear][retsurv] = tabs3[1][1 - spouse][dropyear][retsurv] + 1;
    }

  wnprintf("\n\n\n\n                                    Responses to Retirement Incentives");
  wnprintf(      "\n                                              Retirement Date");
  wnprintf(      "\n                      Wave 1      Wave 2      Wave 3      Wave 4      Wave 5      Later");

  for (type = 0; type < 2; type++)
  for (spouse = 0; spouse < 2; spouse++)
  { switch(spouse)
    { case  0:  wnprintf("\n\nTiming of Drop                                      Wives");      break;
      case  1:  wnprintf("\n\nTiming of Drop                                     Husbands");    break;
      }

    switch(type)
    { case  0:  wnprintf("\nof Own Earnings");       break;
      case  1:  switch(spouse)
                { case 0:  wnprintf("\nof Husband's Earnings");   break;
                  case 1:  wnprintf("\nof Wife's Earnings");      break;
                  }                                  break;
      }

    for (dropyear = 0; dropyear < 9; dropyear++)
    { switch(dropyear)
      { case  0:  wnprintf("\n  1993        ");      break;
        case  1:  wnprintf("\n  1994        ");      break;
        case  2:  wnprintf("\n  1995        ");      break;
        case  3:  wnprintf("\n  1996        ");      break;
        case  4:  wnprintf("\n  1997        ");      break;
        case  5:  wnprintf("\n  1998        ");      break;
        case  6:  wnprintf("\n  1999        ");      break;
        case  7:  wnprintf("\n  2000        ");      break;
        case  8:  wnprintf("\n  After 2000  ");      break;
        }

      for (retsurv = 0; retsurv < 6; retsurv++)
      wnprintf("%12d", tabs3[type][spouse][dropyear][retsurv]);
      }
    }

  }


/*---------------------------------------------------------------------------
			 WRITE DATA
			 writes the input file for the estimation program
  ---------------------------------------------------------------------------*/

void writeData(
  int   nobs,
  struct srmdata *srmvars)

{ int flength;

  char zeros[10000];

  FILE *outfile;
  int  handle;

  outfile = fopen("srm.dat", "wb");
  handle = fileno(outfile);

  write(handle, &nobs, sizeof(float));
  write(handle, srmvars, nobs * sizeof(struct srmdata));

  fclose(outfile);

  encrypt(1, "e:\\mrrc\\hrsfamrt\\srm.dat", "e:\\mrrc\\hrsfamrt\\srmdata.enc");

  outfile = fopen("e:\\mrrc\\hrsfamrt\\srm.dat", "wb");
  handle = fileno(outfile);

  flength = filelength(handle);

  memset(zeros, 0, 10000);

  while (flength > 0)
  { if (flength >= 10000)
    write(handle, zeros, 10000);
    else write(handle, zeros, flength);

    flength = flength - 10000;
    }

  chsize(handle, 0);
  fclose(outfile);
  unlink("e:\\mrrc\\hrsfamrt\\srm.dat");

  }


/*---------------------------------------------------------------------------
			 WAGE CALC routine
			 calculates annual wages from the wage structure in the HRS
  ---------------------------------------------------------------------------*/

float wagecalc(
  int wave,                 /* wave number */
  int wageloc,              /* variable number of wage variable     */
  int periodflag,           /* flag if wages are by varying periods */
  int hours,                /* usual hours per week                 */
  int weeks)                /* usual weeks per year                 */

{ int period, wage;

  static float wagemult[3][7] = { { 0, 1, 52, 26, 12,  4, 1},
                                  { 0, 1, 52, 26, 12, 24, 1},
                                  { 0, 1, 52, 26, 12, 24, 1}};

  static int rangecard[10] = {    250,    707,    1582,     5001,     22361,
										 111805, 500001, 3162278, 31622777, 316227767};
	  /* These are the geometric means of the intervals */

  wage = eval(wave, wageloc);        /* wage variable */
  /* wnprintf("\n    %d %d", wageloc, eval(wave, wageloc)); */

  if (wage == 0 || (wave == 1 && wage == 9999996
    && (wageloc == 2748 || wageloc == 2825 || wageloc == 2828)))
  return(0);                         /* no wage from this source */

  if (wage >= 9999990 || (periodflag == 0 && wage >= 99994))
  return(0);                         /* no or uncertain wage */

  if (wage >= 9999980)               /* wage from range card */
  wage = rangecard[wage - 9999980];

  if (periodflag == 1)
  period = eval(wave, wageloc + 1);  /* period variable  */
  else period = 1;                   /* period is hourly */

  if (period == 1)                   /* hourly wages     */
  { if ((0 < hours && hours < 98) && (0 < weeks && weeks < 98))
    if (wave == 1 || periodflag == 1)
	 return((wage / 100.0) * hours * weeks);
    else return(wage * hours * weeks);
    /* Note: 1994 hourly wages coded in dollars despite documentation */
	 }
  else if (2 <= period && period <= 5)
  { if (0 < weeks && weeks < 98)
	 return((wage * wagemult[wave][period] * weeks) / 52);
	 }
  else if (period == 6)              /* annual wages     */
  return(wage);

  return(0);                         /* hours or weeks missing */

  }


/*---------------------------------------------------------------------------
			 GET SS REC routine
			 gets a social security record
  ---------------------------------------------------------------------------*/

void getSSrec(
  int   codeid,             /* hrs identifier                     */
  int   *matchcode,         /* flag for record in SS file         */
  int   *qc,                /* total quarters of coverage         */
  float *ssearnings)        /* vector of social security earnings */

{ int recno, year;
  int earnings;

  unsigned char *earnrec;

  static int init = 0;
  static int sslocs[30000];
  static unsigned char ssdata[9539 * 42];

  if (init == 0)
  { initSSdata(sslocs, ssdata);
	 init = 1;
	 }

  recno = sslocs[codeid];

  if (recno >= 0)
  { *matchcode = 1;

	 earnrec = &ssdata[42 * recno];

	 *qc = earnrec[0];

	 for (year = 1951; year <= 1991; year++)
	 { if (year < 1966)
		earnings = earnrec[1 + (year - 1951)] & 0x3F;
		else if (year < 1980)
		earnings = earnrec[1 + (year - 1951)];
		else earnings = 4 * (earnrec[1 + (year - 1980)] & 0xC0)
							+  earnrec[1 + (year - 1951)];

		ssearnings[year - 1951] = 100 * earnings;
		}
	 }
  else
  { *matchcode = 0;
	 *qc = 0;

	 for (year = 1951; year <= 1991; year++)
	 ssearnings[year - 1951] = 0;
	 }

  }


/*---------------------------------------------------------------------------
			 INIT SS DATA routine
			 reads social security earnings records from file
  ---------------------------------------------------------------------------*/

void initSSdata(
  int  *sslocs,             /* locations by hrs identifiers     */
  unsigned char *ssdata)    /* social security earnings records */

{ int recno, flength;
  int codeid, year;
  int qc, totqc;
  int earnings;

  unsigned char *earnrec;
  char ssrec[444];
  char zeros[10000];

  FILE *ssfile, *compressedfile;
  int sshandle, comphandle;

  for (codeid = 0; codeid < 30000; codeid++)
  sslocs[codeid] = -1;

  memset(zeros, 0, 10000);

  if (access("e:\\mrrc\\hrsfamrt\\ssdata.enc", 0) < 0)
  { for (codeid = 0; codeid < 30000; codeid++)
	 sslocs[codeid] = -1;

	 ssfile = fopen("e:\\mrrc\\hrsfamrt\\ssaear3.da", "rb");

	 if (ssfile == NULL)
	 error("Social Security earnings file not found");

	 sshandle = fileno(ssfile);

	 for (recno = 0; recno < 9539; recno++)
	 { read(sshandle, ssrec, 444);

		sscanf(&ssrec[437], "%5d", &codeid);

      if (0 < codeid && codeid < 30000)
		sslocs[codeid] = recno;
      else wnprintf(" c%d", codeid);

		earnrec = &ssdata[42 * recno];

		sscanf(&ssrec[428], "%2d", &totqc);     /* 1947-50 quarters of coverage */

		for (year = 1951; year <= 1991; year++)
		{ sscanf(&ssrec[9 + (year - 1951)], "%1d", &qc);

		  totqc = totqc + qc;
		  }

		earnrec[0] = (char) totqc;

		for (year = 1951; year <= 1991; year++)
		{ sscanf(&ssrec[50 + 9 * (year - 1951)], "%5d", &earnings);

		  if (earnings == -1)
		  earnings = 0;

		  earnings = earnings / 100;

		  if (year > 1979)
		  { if (earnings > 511)
			 { earnings = earnings - 512;
				earnrec[1 + (year - 1980)] =
				  (unsigned char) (earnrec[1 + (year - 1980)] | 0x80);
				}
			 else if (earnings > 255)
			 { earnings = earnings - 256;
				earnrec[1 + (year - 1980)] =
				  (unsigned char) (earnrec[1 + (year - 1980)] | 0x40);
				}
			 }

		  earnrec[1 + (year - 1951)] = (unsigned char) earnings;
		  }
		}

	 fclose(ssfile);
	 pause();

	 compressedfile = fopen("e:\\mrrc\\hrsfamrt\\ssdata.cmp", "wb");
	 comphandle = fileno(compressedfile);

	 write(comphandle, sslocs, 30000 * sizeof(int));
	 write(comphandle, ssdata, 9539 * 42 * sizeof(char));

	 fclose(compressedfile);

	 encrypt(1, "e:\\mrrc\\hrsfamrt\\ssdata.cmp", "e:\\mrrc\\hrsfamrt\\ssdata.enc");

	 compressedfile = fopen("e:\\mrrc\\hrsfamrt\\ssdata.cmp", "wb");
	 comphandle = fileno(compressedfile);

    flength = filelength(comphandle);

    while (flength > 0)
    { if (flength >= 10000)
      write(comphandle, zeros, 10000);
      else write(comphandle, zeros, flength);

      flength = flength - 10000;
      }

    chsize(comphandle, 0);
	 fclose(compressedfile);
	 unlink("e:\\mrrc\\hrsfamrt\\ssdata.cmp");
	 }
  else
  { encrypt(0, "e:\\mrrc\\hrsfamrt\\ssdata.enc", "e:\\mrrc\\hrsfamrt\\ssdata.cmp");

	 compressedfile = fopen("e:\\mrrc\\hrsfamrt\\ssdata.cmp", "rb");
	 comphandle = fileno(compressedfile);

	 read(comphandle, sslocs, 30000 * sizeof(int));
	 read(comphandle, ssdata, 9539 * 42 * sizeof(char));

    rewind(compressedfile);
    flength = filelength(comphandle);

    while (flength > 0)
    { if (flength >= 10000)
      write(comphandle, zeros, 10000);
      else write(comphandle, zeros, flength);

      flength = flength - 10000;
      }

    chsize(comphandle, 0);

	 fclose(compressedfile);
	 unlink("e:\\mrrc\\hrsfamrt\\ssdata.cmp");
	 }

  }


/*---------------------------------------------------------------------------
			 ENCRYPT routine
			 encrypts and decrypts files
  ---------------------------------------------------------------------------*/

void encrypt(
  int  mode,				    	/* 1 = encrypt, 0 = decrypt */
  char *infilename,           /* input file name          */
  char *outfilename           /* output file name         */
  )

{ int i, k, m;
  int blocks, filelen, length;

  void *buffer;

  FILE *infile, *outfile;
  int inhandle, outhandle;

  static int a1, a2, a3, c1, c2, c3;
  static int m1, m2, m3, x1, x2, x3;
  static float fm2, z;
  static unsigned char r[97];
  static int init = 1;

  static char password[10];

  buffer = malloc(100000);

  infile = fopen(infilename, "rb");
  outfile = fopen(outfilename, "wb");

  inhandle = fileno(infile);
  outhandle = fileno(outfile);

  filelen = filelength(inhandle);

  if (init == 1)
  { init = 0;

	 password[0] = 0;

	 getPassword(password);

	 while (password[0] == 0)
	 getPassword(password);
	 }

  m1 = 259200;
  a1 = 7141;
  c1 = 54773;
  m2 = 134456;
  a2 = 8121;
  c2 = 28411;
  m3 = 243000;
  a3 = 4561;
  c3 = 51349;

  fm2 = m2;
  z = (m1 * fm2) / 256;

  x1 = (int) (* (short *) &password[0]);
  x2 = (int) (* (short *) &password[2]);
  x3 = (int) (* (short *) &password[4]);

  x1 = (a1 * x1 + c1) % m1;
  x2 = (a2 * x2 + c2) % m2;
  x3 = (a3 * x3 + c3) % m3;

  for (k = 0; k < 97; k++)
  { x1 = (a1 * x1 + c1) % m1;
	 x2 = (a2 * x2 + c2) % m2;
	 r[k] = (unsigned char) ((fm2 * x1 + x2) / z);
	 }

  if (mode == 0)
  { wnprintf("\nDecrypting file %s to file %s", infilename, outfilename);

	 read(inhandle, buffer, 6);

	 for (i = 0; i < 6; i++)
	 { x1 = (a1 * x1 + c1) % m1;
		x2 = (a2 * x2 + c2) % m2;
		x3 = (a3 * x3 + c3) % m3;

		m = (97 * x3) / m3;
		r[m] = (char) ((fm2 * x1 + x2) / z);

		((unsigned char *) buffer)[i] = ((unsigned char *) buffer)[i] ^ r[m];
		}

	 if (memcmp(buffer, password, 6) != 0)
	 { wnprintf("\ninvalid password");
		pause();
		exit(0);
		}

	 filelen = filelen - 6;
	 blocks = (filelen - 1) / 100000;

	 for (k = 0; k <= blocks; k++)
	 { if (k < blocks)
		length = 100000;
		else length = filelen % 100000;

		read(inhandle, buffer, length);

		for (i = 0; i < length; i++)
		{ x1 = (a1 * x1 + c1) % m1;
		  x2 = (a2 * x2 + c2) % m2;
		  x3 = (a3 * x3 + c3) % m3;

		  m = (97 * x3) / m3;
		  r[m] = (char) ((fm2 * x1 + x2) / z);

		  ((unsigned char *) buffer)[i] = ((unsigned char *) buffer)[i] ^ r[m];
		  }

		write(outhandle, buffer, length);
		wnprintf(".");
		}
	 }
  else
  { wnprintf("\nEncrypting file %s to file %s", infilename, outfilename);

	 memcpy(buffer, password, 6);

	 for (i = 0; i < 6; i++)
	 { x1 = (a1 * x1 + c1) % m1;
		x2 = (a2 * x2 + c2) % m2;
		x3 = (a3 * x3 + c3) % m3;

		m = (97 * x3) / m3;
		r[m] = (char) ((fm2 * x1 + x2) / z);

		((unsigned char *) buffer)[i] = ((unsigned char *) buffer)[i] ^ r[m];
		}

	 write(outhandle, buffer, 6);

	 blocks = (filelen - 1) / 100000;

	 for (k = 0; k <= blocks; k++)
	 { if (k < blocks)
		length = 100000;
		else length = filelen % 100000;

		read(inhandle, buffer, length);

		for (i = 0; i < length; i++)
		{ x1 = (a1 * x1 + c1) % m1;
		  x2 = (a2 * x2 + c2) % m2;
		  x3 = (a3 * x3 + c3) % m3;

		  m = (97 * x3) / m3;
		  r[m] = (char) ((fm2 * x1 + x2) / z);

		  ((unsigned char *) buffer)[i] = ((unsigned char *) buffer)[i] ^ r[m];
		  }

		write(outhandle, buffer, length);
		wnprintf(".");
		}
	 }

  fclose(infile);
  fclose(outfile);

  free(buffer);

  }


/*---------------------------------------------------------------------------
			 EVAL routine
			 gets a numeric-named variable from the HRS records
  ---------------------------------------------------------------------------*/

int eval(
  int  wave,
  int  varno)

{ char varname[9];

  switch(wave)
  { case  1:  varname[0] = 'V';      break;
    case  2:  varname[0] = 'W';      break;
    case  3:  varname[0] = 'E';      break;
    case  4:  varname[0] = 'Q';      break;
    case  5:  varname[0] = 'Q';      break;
    }

  sprintf(&varname[1], "%d", varno);

  return(evals(wave, varname));

  }


/*---------------------------------------------------------------------------
			 EVALS routine
			 gets a character-named variable from the HRS records
  ---------------------------------------------------------------------------*/

typedef struct
{ int  wave;
  char varname[8];
  int  loc;
  int  len;
  } VARDEF;


int evals(
  int  wave,
  char *vararg)

{ int loc, len, value;
  int varno, varmin, varmax, newvar;

  char var[8];

  static int varlims[5][2];
  static char varlocs[22865][12];

  static int init = 1;
  static char blanks[12] = "           ";

  if (init == 1)
  { dictinit(varlims, varlocs);
	 init = 0;
	 }

  memcpy(var, vararg, 8);

  for (loc = 1; loc < 8; loc++)
  if (var[loc - 1] == ' ' || var[loc] == '\0')
  var[loc] = ' ';

  varmin = varlims[wave - 1][0];
  varmax = varlims[wave - 1][1];

  while (varmin + 1 < varmax)
  { newvar = (varmin + varmax) / 2;

    if (strncmp(var, varlocs[newvar], 8) > 0)
    varmin = newvar;
    else varmax = newvar;
    }

  if (varmin == varlims[wave][0])
  { if (strncmp(var, varlocs[varmin], 8) == 0)
    varno = varmin;
    else varno = varmax;
    }
  else varno = varmax;

  if (strncmp(var, varlocs[varno], 8) != 0)
  { wnprintf("\nVariable %8.8s not in dictionary", var);
	 pause();
	 exit(0);
    }

  loc = * (unsigned short *) &varlocs[varno][ 8];
  len = * (unsigned short *) &varlocs[varno][10];

  if (rec[loc] > 0)
  { if (memcmp(&rec[loc], blanks, len) != 0)
    switch(len)
    { case  1:  sscanf(&rec[loc],  "%1d", &value);     break;
	   case  2:  sscanf(&rec[loc],  "%2d", &value);     break;
	   case  3:  sscanf(&rec[loc],  "%3d", &value);     break;
	   case  4:  sscanf(&rec[loc],  "%4d", &value);     break;
	   case  5:  sscanf(&rec[loc],  "%5d", &value);     break;
	   case  6:  sscanf(&rec[loc],  "%6d", &value);     break;
	   case  7:  sscanf(&rec[loc],  "%7d", &value);     break;
	   case  8:  sscanf(&rec[loc],  "%8d", &value);     break;
	   case  9:  sscanf(&rec[loc],  "%9d", &value);     break;
	   case 10:  sscanf(&rec[loc], "%10d", &value);     break;
	   case 11:  sscanf(&rec[loc], "%11d", &value);     break;
      }
    else return(-9);
	 }
  else return(-9999);

  return(value);

  }


/*---------------------------------------------------------------------------
			 DICT INIT routine
			 gets the HRS dictionaries to locate the variables
  ---------------------------------------------------------------------------*/

void dictinit(
  int  (*varlims)[2],
  char (*varlocs)[12])

{ int  wave, loc, len, var, varno;
  char linestring[120];

  void *varbuffer;
  VARDEF *vardefs;

  FILE *dictfile;

  varbuffer = malloc(22865 * sizeof(VARDEF));
  vardefs = (VARDEF *) varbuffer;

  memset(varlocs, 0, 22865 * 12);
  memset(vardefs, 0, 22865 * sizeof(VARDEF));

  dictfile = fopen("f:\\datasets\\hrs\\xwave\\panels\\hrs92-00\\hrs92-00.dic", "rt");

  if (dictfile == NULL)
  { wnprintf("\nMissing dictionary file");
    pause();
    exit(0);
    }

  var = 0;

  while(fgets(linestring, 120, dictfile) != NULL)
  { sscanf(&linestring[ 0], "%1d", &wave);
    sscanf(&linestring[67], "%5d", &loc);
	 sscanf(&linestring[73], "%3d", &len);

    vardefs[var].wave = wave;
    vardefs[var].loc  = loc - 1;
    vardefs[var].len  = len;

    strncpy(vardefs[var].varname, &linestring[2], 8);

    var = var + 1;
	 }

  fclose(dictfile);

  qsort(vardefs, var, sizeof(VARDEF), dictcomp);

  memset(varlims, 0, 10 * sizeof(int));

  for (varno = 0; varno < var; varno++)
  { strncpy(varlocs[varno], vardefs[varno].varname, 8);

    * (unsigned short *) &varlocs[varno][ 8] = (unsigned short) (vardefs[varno].loc);
	 * (unsigned short *) &varlocs[varno][10] = (unsigned short) (vardefs[varno].len);

    for (wave = 0; wave < 5; wave++)
    { if (vardefs[varno].wave - 1 < wave)
      varlims[wave][0] = varno + 1;

      if (vardefs[varno].wave - 1 <= wave)
      varlims[wave][1] = varno;
      }
    }

  }


/*---------------------------------------------------------------------------
			 DICT COMP routine
			 compare routine for qsort in the dictinit routine
  ---------------------------------------------------------------------------*/

int dictcomp(
  const void *elem1,
  const void *elem2)

{ if ((* (VARDEF *) elem1).wave < (* (VARDEF *) elem2).wave)
  return(-1);
  else if ((* (VARDEF *) elem1).wave > (* (VARDEF *) elem2).wave)
  return(1);

  if (strncmp((* (VARDEF *) elem1).varname, (* (VARDEF *) elem2).varname, 8) < 0)
  return(-1);
  if (strncmp((* (VARDEF *) elem1).varname, (* (VARDEF *) elem2).varname, 8) > 0)
  return(1);

  if ((* (VARDEF *) elem1).loc < (* (VARDEF *) elem2).loc)
  return(-1);
  else return(1);

  }


/*---------------------------------------------------------------------------
			 GET SURVIVAL RATES routine
			 gets cohort and gender specific survival rates
  ---------------------------------------------------------------------------*/

void getSurvivalRates(
  int cohort,                 /* year of birth            */
  int gender,                 /* sex of respondent        */
  float *surv)                /* vector of survival rates */

{ int fileno;
  int age, coh, gen, line;
  int agecheck, survprob;

  char filepath[40];
  char stringline[151];

  static int init = 1;
  static float survtable[91][2][120];

  static int startcohort[3] = { 0, 16, 56};
  static int endcohort[3]   = {15, 55, 90};
  static char infilename[3][12] = {"coh0015.95t", "coh1655.95t", "coh5690.95t"};

  FILE *infile, *outfile;
  int inhandle, outhandle;

  if (init == 1)
  { if (access("e:\\phtrends\\ssasurv.dat", 0) < 0)
	 { for (fileno = 0; fileno < 3; fileno++)
		{ strcpy(filepath, "e:\\phtrends\\");
		  strcat(filepath, infilename[fileno]);
		  infile = fopen(filepath, "r");

		  if (infile == NULL)
		  error("File not found in getSurvivalRates");

		  for (coh = startcohort[fileno]; coh <= endcohort[fileno]; coh++)
		  for (gen = 0; gen < 2; gen++)
		  for (age = 0; age < 120; age++)
		  { if (age % 40 == 0)
			 for (line = 0; line < 8; line++)
			 fgets(stringline, 150, infile);

			 fgets(stringline, 150, infile);

			 sscanf(&stringline[1], "%3d", &agecheck);
			 if (age != agecheck)
			 error("Bad input in getSurvivalRates");

			 sscanf(&stringline[17], "%6d", &survprob);
			 survtable[coh][gen][age] = survprob;

			 if (age % 5 == 4)
			 fgets(stringline, 150, infile);
			 }

		  fclose(infile);
		  }

		outfile = fopen("e:\\phtrends\\ssasurv.dat", "wb");
		outhandle = fileno(outfile);
		write(outhandle, survtable, sizeof(survtable));
		fclose(outfile);
		}
	 else
	 { infile = fopen("e:\\phtrends\\ssasurv.dat", "r");
		inhandle = fileno(infile);
		read(inhandle, survtable, sizeof(survtable));
		fclose(infile);
		}

	 init = 0;
	 }

  if (cohort < 1900 || cohort > 1990 || gender < 1 || gender > 2)
  { wnprintf("\nBad cohort or gender: cohort %d  gender %d", cohort, gender);
	 error("Bad cohort or gender in getSurvivalRates");
	 }

  for (age = 0; age < 120; age++)
  surv[age] = survtable[cohort - 1900][gender - 1][age];

  }

