# Comparison: Prediction using joint prior
# Predictive checks
# Mar 29, 2016
# iteration method adds on
# uvTweedie_WTLVmix.R still works for WLVmix iteration method because final product still takes the WTLVmix form

source("data_select2012.R")

source("profl_fun.R")
source("uvTweedie_WGLVmix.R") # Bayes rule (Tweedie formula) for u or v (marginal out v or u)
source("uvTweedie_WTLVmix.R") # Bayes rule for u or v (independence prior)
source("uTweedie_Bmix.R") # Bayes rule (Tweedie formula) for u or v (marginal out v or u)
#setwd("~/Projects/bball_profile/prediction_with_age")
#load("DP1.Rda") #Dirichelet Process output 1
#load("DP2.Rda") #Dirichelet Process output 2


load("indep_it.Rda")
fi = f_it # KW WLVmix mixture (indepedence prior-iteration)


bballt2012$HA <- asin(sqrt((bballt2012$H+0.25)/(bballt2012$AB + 0.5)))
sub1 <- bballt$id %in% bballt2012$id  # excludes players not in 2012
sub2 <- bballt2012$id %in% bballt$id  # excludes players only appear in 2012

pred_grid <- seq(0.01, 1, length = 500)


# WLVmix model without covariates
LVp <- uvTweedie_WTLVmix(f_it,ha,id,w)
LVpu <- LVp$u
LVpv <- LVp$v

# posterior predictive
LVfp <- postf_WTLVmix(f_it, ha, id, w)
# pred_grid <- seq(0.01, 1, length = 500)
LVpred <- predf_WTLVmix(pred_grid, LVfp$fpost[sub1,], LVfp$grid, bballt2012$AB[sub2])

#likelihood evalution for 2012 realization
lik_LV <- predlik_WTLVmix(bballt2012$HA[sub2], LVfp$fpost[sub1,], LVfp$grid, bballt2012$AB[sub2])
