# Comparison: Prediction using joint prior
# Predictive checks
# July 6, 2015
# Ref: ~/Projects/DP/baseball_compare
# no covariates for now
 
source("data_select2012.R")

source("profl_fun.R")
source("uvTweedie_WGLVmix.R") # Bayes rule (Tweedie formula) for u or v (marginal out v or u)
source("uvTweedie_WTLVmix.R") # Bayes rule for u or v (independence prior)
source("uTweedie_Bmix.R") # Bayes rule (Tweedie formula) for u or v (marginal out v or u)
#setwd("~/Projects/bball_profile/prediction_with_age")
#load("DP1.Rda") #Dirichelet Process output 1
#load("DP2.Rda") #Dirichelet Process output 2

load("joint.Rda")
load("indep.Rda")
fo = fuv2 #KW WGLVmix mixture with no covariates
fi = fuv0 # KW WTLVmix mixture (indepedence prior)
fb <- Bmix(bballt$Ht, bballt$ABt, m = 3000, rtol = 1e-10) # Binomial mixture (aggregated individual)


bballt2012$HA <- asin(sqrt((bballt2012$H+0.25)/(bballt2012$AB + 0.5)))
sub1 <- bballt$id %in% bballt2012$id  # excludes players not in 2012
sub2 <- bballt2012$id %in% bballt$id  # excludes players only appear in 2012



# WGLVmix model without covariates
NLVp <- uvTweedie_WGLVmix(fo, ha, id, w)
NLVpu <- NLVp$u
NLVpv <- NLVp$v

# posterior predictive
NLVfp <- postf_WGLVmix(fo, ha, id, w)
pred_grid <- seq(0.01, 1, length = 500)
NLVpred <- predf_WGLVmix(pred_grid, NLVfp$fpost[sub1,], NLVfp$grid, bballt2012$AB[sub2])

#likelihood evalution for 2012 realization
lik_NLV <- predlik_WGLVmix(bballt2012$HA[sub2], NLVfp$fpost[sub1,], NLVfp$grid, bballt2012$AB[sub2])

# tail prob 


# WTLVmix model without covariates
TLVp <- uvTweedie_WTLVmix(fi,ha,id,w)
TLVpu <- TLVp$u
TLVpv <- TLVp$v

# posterior predictive
TLVfp <- postf_WTLVmix(fi, ha, id, w)
# pred_grid <- seq(0.01, 1, length = 500)
TLVpred <- predf_WTLVmix(pred_grid, TLVfp$fpost[sub1,], TLVfp$grid, bballt2012$AB[sub2])

#likelihood evalution for 2012 realization
lik_TLV <- predlik_WTLVmix(bballt2012$HA[sub2], TLVfp$fpost[sub1,], TLVfp$grid, bballt2012$AB[sub2])


# Binomial mixture 
Bmixp <- uTweedie_Bmix(fb$x, fb$y,bballt$Htotal, bballt$ABtotal)$u

# posterior predictive
Bmixfp <- postf_Bmix(fb$x, fb$y, bballt$Htotal, bballt$ABtotal)
Bmixpred <- predf_Bmix(Bmixfp$fpost[sub1,], Bmixfp$grid, bballt2012$AB[sub2])

#likelihood evalution for 2012 realization
lik_Bmix <- predlik_Bmix(bballt2012$H[sub2], Bmixfp$fpost[sub1,], Bmixfp$grid, bballt2012$AB[sub2])


# DP mixture 
load("DP0.Rda")
load("DP1.Rda")
load("DP2.Rda")
#Prediction from DP (take predicted density as mixing and use Bayes rule for Bmix) 
DP0p <- uTweedie_Bmix(DP0$grid,DP0$densp.m,bballt$Htotal,bballt$ABtotal)$u
DP1p <- uTweedie_Bmix(DP1$grid,DP1$densp.m,bballt$Htotal,bballt$ABtotal)$u
DP2p <- uTweedie_Bmix(DP2$grid,DP2$densp.m,bballt$Htotal,bballt$ABtotal)$u

# posterior predictive DP0
DP0fp <- postf_Bmix(DP0$grid, DP0$densp.m, bballt$Htotal, bballt$ABtotal)
DP0pred <- predf_Bmix(DP0fp$fpost[sub1,], DP0fp$grid, bballt2012$AB[sub2])

#likelihood evalution for 2012 realization DP0
lik_DP0 <- predlik_Bmix(bballt2012$H[sub2], DP0fp$fpost[sub1,], DP0fp$grid, bballt2012$AB[sub2])

# posterior predictive DP1
DP1fp <- postf_Bmix(DP1$grid, DP1$densp.m, bballt$Htotal, bballt$ABtotal)
DP1pred <- predf_Bmix(DP1fp$fpost[sub1,], DP1fp$grid, bballt2012$AB[sub2])

#likelihood evalution for 2012 realization DP1
lik_DP1 <- predlik_Bmix(bballt2012$H[sub2], DP1fp$fpost[sub1,], DP1fp$grid, bballt2012$AB[sub2])

# posterior predictive DP2
DP2fp <- postf_Bmix(DP2$grid, DP2$densp.m, bballt$Htotal, bballt$ABtotal)
DP2pred <- predf_Bmix(DP2fp$fpost[sub1,], DP2fp$grid, bballt2012$AB[sub2])

#likelihood evalution for 2012 realization DP2
lik_DP2 <- predlik_Bmix(bballt2012$H[sub2], DP2fp$fpost[sub1,], DP2fp$grid, bballt2012$AB[sub2])


# If we only consider location mixture model, what is the estimate?
source("uTweedie_GLmix.R")
f00 = GLmix(t, sigma = sqrt(1/wsum),rtol=1e-10)
EST00 = uTweedie_GLmix(f00,t,sig= sqrt(1/wsum))$u

# posterior predictive
GLfp <- postf_GLmix(f00, t, sqrt(1/wsum))
GLpred <- predf_GLmix(pred_grid, GLfp$fpost[sub1,],GLfp$grid, bballt2012$AB[sub2])

#likelihood evalution for 2012 realization
lik_GLmix <- predlik_GLmix(bballt2012$HA[sub2], GLfp$fpost[sub1,], GLfp$grid, bballt2012$AB[sub2])
