load("prediction_2012_rev2_it.Rda")
LSModel_TSE_it = LSModel_TSE
BModel_TSEp_it = BModel_TSEp
LSModel_SSE_it = LSModel_SSE

load("prediction_2012_rev2.Rda")

Models = c(LSModel_TSE[1], LSModel_TSE_it[1], LSModel_TSE[2], LSModel_TSE[3], LSModel_TSE_it[2], LSModel_TSE[4], LSModel_TSE_it[3],LSModel_TSE[5:7],LModel_TSE[1:3])
names(Models) = c("LV-Indep", "LV-Indep-it","LV-Dep", "LV-Indep-Age", "LV-Indep-Age-it","LV-Indep-Age-Lag", "LV-Indep-Age-Lag-it","LV-Indep-Lag-AB", "Naive", "Lag", "L","L-AGE","L-AGE-Lag")
Models_TSE = round(Models , digits = 3)
Models_NSE = round(Models_TSE/Models_TSE[9], digits = 3)
Prediction = cbind(Models_TSE[c(1:7,9:13)], Models_NSE[c(1:7,9:13)])

Models2 = c(LSModel_SSE[1],LSModel_SSE_it[1],LSModel_SSE[2],LSModel_SSE[3],LSModel_SSE_it[2],LSModel_SSE[4],LSModel_SSE_it[3], LSModel_SSE[5:7], LModel_SSE[1:3])
names(Models2) = c("LV-Indep", "LV-Indep-it","LV-Dep", "LV-Indep-Age", "LV-Indep-Age-it","LV-Indep-Age-Lag", "LV-Indep-Age-Lag-it","LV-Indep-Lag-AB", "Naive", "Lag", "L","L-AGE","L-AGE-Lag")
Models_SSE = round(Models2 , digits = 3)
Models_NSSE = round(Models_SSE/Models_SSE[9], digits = 3)
Prediction2 = cbind(Models_SSE[c(1:7,9:13)], Models_NSSE[c(1:7,9:13)])

Pred = cbind(Prediction, Prediction2)

colnames(Pred) = c("TSE","RTSE", "NSE","RNSE")

# probability scale prediction
PModels = c(BModel_TSEp[1], BModel_TSEp_it[1], BModel_TSEp[2], BModel_TSEp[3], BModel_TSEp_it[2], BModel_TSEp[4], BModel_TSEp_it[3],BModel_TSEp[5:9],BModel_TSEp[c(12,13,15)])
PModels_NTSEp = PModels/PModels[8]
P = matrix(NA,15,6)
P[1:12,1:4] = Pred
P[,5:6] = round(cbind(PModels, PModels_NTSEp), digits = 3)
colnames(P) = c("TSE","RTSE", "NSE","RNSE","TSEp","RTSEp")
rownames(P) = c("LV-ISG", "LV-ING","LV-Dep", "LV-ISG-Age", "LV-ING-Age",
		"LV-ISG-Age-Lag", "LV-ING-Age-Lag", "Naive", "Lag", "L",
		"L-AGE","L-AGE-Lag","Bmix","DP-10","DP-0.01")
require(Hmisc)
cap <- "Predictive performance for various models.  Predictions based on models 
with heterogeneity in both location and scale are identified by the row label LV.  
Three variants of the LV models are compared:  LV-Dep refers to the unrestricted
joint distribution model, LV-ISG refers to the independent prior model estimated
with the Student/Gamma procedure, and LV-ING to the independent prior model
estimated with the Normal/Gamma iterative procedure.
Models with only location heterogeneity have prefix L.  Naive prediction refers to 
using only $Y_{i,2011}$ as a prediction for $Y_{i, 2012}$, 
Lag prediction refers to using only $\\bar Y_{2011}$ as a linear predictor for 
$Y_{i, 2012}$.  Models with additional covariate effects are identified by appended 
Age and/or Lag suffixes Binomial mixture models are labeled Bmix 
for predictions based on the NPMLE, and DP$-\\alpha$ for predictions based on a 
binomial mixture model with Dirichlet process prior and precision parameter $\\alpha$.  
The TSE, NSE and TSEp columns evaluate predictive performance on the transformed
and probability scales, respectively.  RTSE, RNSE and RTSEp evaluate performance 
relative to the Naive model."

Models <- P
latex(Models, file = "prediction.tex", row.label = "Models", caption = cap, caption.loc = "bottom", label = "tab.pred")
