# use only non-pitcher
# no restriction on support of mu


require(REBayes)
data(bball)

# Select Sample for Estimation
Bselect <- function(data){
	B <- data[data$year != 2012,]
	id <- B$id
	m <- tapply(id,id,length)
	B[m[id] > 3,] #remove players with less than 3 half-seasons
	}

Bselect_nonp <- function(data){
# non-pitchers, excluding 2012 (record of the last year)
	B <- data[data$year != 2012&data$pitcher==0,]
	id <- B$id
	m <- tapply(id,id,length)
	mm <- rep((m>3),m)
	B[mm,] #remove players with less than 3 half-seasons
	}
	
# Fit Gaussian Mixture Models to the Baseball Data
Gfit <- function(B, model = "V"){
	id <- B$id
	y <- B$HA
	w <- 4 * B$AB
	if(model == "fixed"){
		wsum <- tapply(w,id,sum)
		t <- tapply(w*ha,id,sum)/wsum #suff stats for location 
		S <- (tapply(w*ha^2, id, sum) - t^2*wsum)/(m-1) #suff stats for variance
		m <- tapply(id, id, length)
		v0 <- mean((m-1)*S/m) #MLE for variance 
		f <- WTLVmix(y, id, w, v = v0, verb = 5, rtol = 1e-10)
		}
	else	
		f <- WTLVmix(y,id,w, verb = 5, rtol = 1e-10)
	f
}

# Fit Bivariate Gaussian Mixture models to Baseball Data on 60 by 60 grid
Gfit_bi <- function(B, model = "V"){
	id <- B$id
	y <- B$HA
	w <- 4 * B$AB	
	f <- WGLVmix(y,id,w,u = 100, v = 100, verb = 5, rtol = 1e-10)
	f
}

C <- Bselect_nonp(bball)
fuv2 <- Gfit_bi(C)  # bivariate 
fuv0 <- Gfit(C)		# assumed independence between (alpha, theta)

save(fuv2,file = "joint.Rda")
save(fuv0,file = "indep.Rda")

