# Critical Value Table
require(Hmisc)
source("predictive_dista.R")

B <- rbind(tail_index,lik_index)
B[1,] <- round(B[1,],digits = 0)
B[2,] <- round(B[2,],digits = 1)
rlabs <- c("Tail Index","Log-Likelihood")
clabs <- c("LV-Dep","LV-ISG","LV-ING","G-L","B-KW","DP-0.01","DP-10")
dimnames(B) <- list(rlabs, clabs)
capG <- "Posterior log likelihood and $T_{ff}$ performance for various Gaussian transformation models:
LV-Dep refers to the location-scale Gaussian mixture model with the joint nonparametric prior, 
LV-ISG is the location-scale mixture model with independent prior on ($\\mu$, $\\theta$) estimated
by the Student/Gamma procedure, and LV-ING is the independent prior model estimated with the iterative
Normal/Gamma method.  G-L is location Gaussian mixture model that ignores over/under dispersion, but 
accounts for the differences in number of at bats in each period." 

capB <- "Posterior log likelihood and $T_{ff}$ performance for various binomial mixture models:
B-KW is the Binomial mixture model with aggregated data based on the Kiefer-Wolfowitz estimator 
for the mixing distribution. DP-0.01 is the binomial model with a Dirichlet Process prior 
and prior precision parameter $\\alpha = 0.01$. DP-10 is the same Dirichlet model with $\\alpha = 10$. "
TabG <- "tab.checkG"
TabB <- "tab.checkB"
BG <- B[,1:4]
BB <- B[,5:7]
latex(BG,file = "TabG.tex", rdec = c(0,1), rowlabel.just = "l", rowlabel = " ", 
      col.just = rep("c",ncol(BG)), caption.loc = "bottom", caption = capG,label = TabG)
latex(BB,file = "TabB.tex", rdec = c(0,1), rowlabel.just = "l", rowlabel = " ", 
      col.just = rep("c",ncol(BB)), caption.loc = "bottom", caption = capB,label = TabB)
