source("uvTweedie_WGLVmix.R")

load("joint_np.Rda")
y <- C$HA
id <- C$id
w <- 4*C$AB
name <- unique(C$name)
wsum <- tapply(w, id, "sum")
    t <- tapply(w * y, id, "sum")/wsum
    m <- tapply(y, id, "length")
    r <- (m - 1)/2
    s <- (tapply(w * y^2, id, "sum") - t^2 * wsum)/(m - 1)

fo = fuv2 #KW WGLVmix mixture with no covariates

# WGLVmix model without covariates
NLVp <- uvTweedie_WGLVmix(fo, y, id, w)
NLVpu <- NLVp$u
NLVpv <- NLVp$v


D <- data.frame(name,t,s,NLVpu,NLVpv)

lowtheta <- D[which(NLVpu>0.458&NLVpv<0.907),]
highmu <- D[which(NLVpu>0.59 & NLVpv>1),]

lowtheta <- lowtheta[order(lowtheta$NLVpv),]
lowtheta[,-1] <- round(lowtheta[,-1],digits = 3)
highmu<- highmu[order(highmu$NLVpu,decreasing = TRUE),]
highmu[,-1] <- round(highmu[,-1], digits = 3)

require(Hmisc)
rownames(lowtheta) <- NULL
clabs <- c("Name","$\\hat{\\mu}$","S","$\\delta_{\\mu}$","$\\delta_\\theta$") 
dimnames(lowtheta) <- list(as.character(lowtheta[,1]),clabs)
latex(lowtheta[,-1],file = "besthset1.tex", dec = 3, table.env = FALSE, center = "none",rowlabel.just = "l", rowlabel = "Name", col.just = rep("c",ncol(lowtheta)))

rownames(highmu) <- NULL
clabs <- c("Name","$\\hat{\\mu}$","S","$\\delta_{\\mu}$","$\\delta_\\theta$") 
dimnames(highmu) <- list(as.character(highmu[,1]),clabs)
capture.output(latex(highmu[,-1],file = "besthset2.tex", dec = 3, table.env = FALSE, center = "none",rowlabel.just = "l", rowlabel = "Name", col.just = rep("c",ncol(highmu))))


