uvTweedie_WGLVmix<-function(f,y,id,w){
    # Written for baseball data analysis (due to the special reweighting because of at bats)
    # f is the estimates from WGLVmix
	#The marginal Tweedie formula for location parameter in the location-scale mixture model
	#y is the transformed-to-normal hitting average
	#id is the player's id
	#w is the weights, specified as 4*AB
    #output: $u: Tweedie for location parameter marginalize out scale
    #        $v: Tweedie for scale parameter marginalize out location
    #        $g: likelihood \int int f(y,s|u,v)h(u,v)dudv

wsum <- tapply(w,id,"sum")
t <- tapply(w*y,id,"sum")/wsum
m <- tapply(y,id,"length")
r <- (m-1)/2
s <- (tapply(w*y^2,id,"sum") - t^2*wsum)/(m-1)
n <- length(s)

pu <- length(f$u)
pv <- length(f$v)
du <- c(diff(f$u)[1],diff(f$u))
dv <- c(diff(f$v)[1],diff(f$v))
R <- outer(r*s,f$v,"/")  
sgamma <- outer(s * gamma(r),rep(1,pv))
r <- outer(r, rep(1,pv))
Av <- outer((exp(-R) * R^r)/sgamma, rep(1,pu))
Au <- dnorm(outer(outer(t, f$u, "-") * outer(sqrt(wsum),rep(1,pu)), sqrt(f$v), "/"))
Au <- Au/outer(outer(1/sqrt(wsum),rep(1,pu)),sqrt(f$v)) # dim = n * pu * pv
Au <- aperm(Au,c(1,3,2)) # permute Au indices to align with those of Av
A <- matrix(Av * Au, n, pu * pv) * outer(rep(1,n),f$fuv)
A <- pmax(A,0)
buv_u  <- expand.grid(theta = rep(1,length(f$v)), alpha = f$u)
nuv_u  <- nrow(buv_u)
A <- A/apply(A, 1, sum)
uTweedie <- A%*%buv_u[,2]
buv_v <- expand.grid(theta = f$v, alpha = rep(1,length(f$u)))
nuv_v <- nrow(buv_v)
vTweedie <- A%*%buv_v[,1]
list(u=uTweedie,v=vTweedie)
}

postf_WGLVmix <- function(f, y, id, w){
# produces posterior density of (mu, theta) given (t, s) for each individual
wsum <- tapply(w,id,"sum")
t <- tapply(w*y,id,"sum")/wsum
m <- tapply(y,id,"length")
r <- (m-1)/2
s <- (tapply(w*y^2,id,"sum") - t^2*wsum)/(m-1)
n <- length(s)

pu <- length(f$u)
pv <- length(f$v)
du <- c(diff(f$u)[1],diff(f$u))
dv <- c(diff(f$v)[1],diff(f$v))
R <- outer(r*s,f$v,"/")  
sgamma <- outer(s * gamma(r),rep(1,pv))
r <- outer(r, rep(1,pv))
Av <- outer((exp(-R) * R^r)/sgamma, rep(1,pu))
Au <- dnorm(outer(outer(t, f$u, "-") * outer(sqrt(wsum),rep(1,pu)), sqrt(f$v), "/"))
Au <- Au/outer(outer(1/sqrt(wsum),rep(1,pu)),sqrt(f$v)) # dim = n * pu * pv
Au <- aperm(Au,c(1,3,2)) # permute Au indices to align with those of Av
A <- matrix(Av * Au, n, pu * pv) * outer(rep(1,n),f$fuv)
A <- pmax(A,0)
buv_u  <- expand.grid(theta = f$v, alpha = f$u)
nuv_u  <- nrow(buv_u)
A <- A/apply(A, 1, sum)
list(fpost = A, grid = buv_u)
}

predf_WGLVmix <- function(grid, fpost, postgrid, ab){
# produce predictive dist: f(y|D) = \int N(\mu, \theta/4ab) dH
# H is posterior dist of (mu, theta) produced from postf_WGLVmix function
# fpost is a matrix : N * M, N = number of individuals being predicted, M = grid length
# postgrid is a M * 2 matrix, first column theta, second column alpha
# grid is K * 1 grid for y
# ab is number of at bats: to be conditioned on for predictive dist
# output: matrix N * K
P <- matrix(0, nrow = nrow(fpost), ncol = length(grid))
for (i in 1:nrow(fpost)){
A <- matrix(0, length(grid), nrow(postgrid))
for (j in 1:length(grid)){
A[j,] <- dnorm(grid[j], mean = postgrid$alpha, sd = sqrt(postgrid$theta/(4*ab[i])))
}
P[i,] <- A %*% fpost[i,]
}
list (predf = P, grid = grid)
}

predlik_WGLVmix <- function(ynew, fpost, postgrid, ab){
# produce likelihood evaluation based on pred dist: f(y|D) = \int B(ab, p) dH
# H is posterior dist of (mu) produced from postf_WGLVmix function
# fpost is a matrix : N * M, N = number of individuals being predicted, M = grid length
# postgrid is a M * 2 matrix, first column theta, second column alpha
# grid is K * 1 grid for number of hits (caution, this can be rather large, hence designed to be depend on ab)
# ab is number of at bats: to be conditioned on for predictive dist
# output: matrix N * K
lik <- rep(0, length(ynew))
for (i in 1:nrow(fpost)){
A <- dnorm(ynew[i], mean = postgrid$alpha, sd = sqrt(postgrid$theta/(4*ab[i])))
lik[i] <- A %*% fpost[i,]
}
lik
}


