uTweedie_Bmix<-function(u, fu, hit,ab){
	# This is the Bayes rule for p (success probability)
	# u is the support of density of p
	# fu is the density weights of the p
	# hit is the number of successful trials
	# ab is the number of trials
A <- outer(hit,u,function(x,v,k) dbinom(x,size=k,prob=v),k=ab)
g <- A%*%(fu*diff(u)[1])
z<-rep(0,length(hit))
for (i in 1:(length(hit))){
	z[i] = (dbinom(hit[i],size=ab[i],prob=u)*u*diff(u)[1])%*%fu/g[i]
	}
list(u=z)
}

postf_Bmix <- function(u, fu, hit, ab){
A <- outer(hit,u,function(x,v,k) dbinom(x,size=k,prob=v),k=ab) * outer(rep(1,length(hit)),fu)
A <- A/apply(A,1,sum)
list(fpost = A, grid = u)
}

predf_Bmix <- function(fpost, postgrid, ab){
# produce predictive dist: f(y|D) = \int B(ab, p) dH
# H is posterior dist of (p) produced from postf_Bmix function
# fpost is a matrix : N * M, N = number of individuals being predicted, M = grid length
# postgrid is a M * 2 matrix, first column theta, second column alpha
# grid is K * 1 grid for number of hits (caution, this can be rather large, hence designed to be depend on ab)
# ab is number of at bats: to be conditioned on for predictive dist
# output: matrix N * K
P <- matrix(0, nrow = nrow(fpost), ncol = 500)
grid <- matrix(0, nrow = nrow(fpost), ncol = 500)
for (i in 1:nrow(fpost)){
g <- round(ab[i] * seq(0.001, 0.999, length = 500), digit = 0)
A <- outer(g,postgrid,function(x,v,k) dbinom(x,size=k,prob=v),k=ab[i])
P[i,] <- A %*% fpost[i,]
grid[i,] <- g
}
list (predf = P, grid = grid)
}

predlik_Bmix <- function(ynew, fpost, postgrid, ab){
# produce likelihood evaluation based on pred dist: f(y|D) = \int B(ab, p) dH
# H is posterior dist of (p) produced from postf_Bmix function
# fpost is a matrix : N * M, N = number of individuals being predicted, M = grid length
# postgrid is a M * 2 matrix, first column theta, second column alpha
# ab is number of at bats: to be conditioned on for predictive dist
# output: matrix N * K
lik <- rep(0, length(ynew))
for (i in 1:nrow(fpost)){
A <- outer(ynew[i],postgrid,function(x,v,k) dbinom(x,size=k,prob=v),k=ab[i])
lik[i] <- A %*% fpost[i,]
}
lik
}

