# Non-pitchers with 2002-2011 data 
# Compare joint dist of (alpha, theta) and the indepdent (alpha, theta)

load("joint.Rda")
load("indep.Rda")


require(hexbin)  # notice this depends on the seed, below we consider dependence measure
fuv <- fuv2$fuv
v <- fuv2$v
u <- fuv2$u
du <- diff(u)[1]
dv <- diff(v)[1]
g = expand.grid(v = v, u = u)
fuv <- pmax(0,fuv)
g$fuv = fuv/sum(fuv)
M <- nrow(g)
n <- 100000
s <- sample(1:M, n, replace = TRUE, prob = g$fuv)
G <- g[s,1:2] + cbind(runif(n,0,dv), runif(n,0,du))
H <- hexbin(G$u, G$v, xbins = 100)
#P <- plot(H,colramp = function(n) BTC(n,150,1), legend = FALSE,   xlab = expression(alpha),ylab = expression(theta))

cor.test(g[s,1],g[s,2],method="s") # spearman's rho (this depends on the seed)

# simulated Spearman's rho
R = 1000
set.seed(12)
spear <- rep(0,R)
for (i in 1:R){
s <- sample(1:M, n, replace = TRUE, prob = g$fuv)
spear[i] <- cor.test(g[s,1],g[s,2],method="s")$estimate # spearman's rho (this depends on the seed)
}



require(lattice)

# 3D plot
par(mfrow=c(1,2))
G0 <- g[s,1:2] 
H0 <- hexbin(G0$u, G0$v, xbins = 60)
P0 <- plot(H0,colramp = function(n) BTC(n,150,1), legend = FALSE,
    xlab = expression(mu),ylab = expression(theta))
    
pl <- cloud(fuv ~ u * v , data = g,
     type = "h", lwd = 2, zlim = c(0, max(g$fuv)), scales =list(arrows = FALSE),
      xlab = expression(mu), ylab = expression(theta), zlab = expression(h(mu,theta)),
screen = list(z = 10,    x = -70))
print(pl)

pdf("3dplotfuv.pdf")
print(pl)
dev.off()

pdf("2dplotfuv.pdf")
 plot(H0,colramp = function(n) BTC(n,150,1), legend = FALSE,
    xlab = expression(mu),ylab = expression(theta))
dev.off()

pdf("indepdent_np.pdf",height = 5, width = 8)
par(mfrow=c(1,2))
plot(fuv0$u,fuv0$fu/sum(fuv0$fu),type="l", xlab = expression(mu), ylab = expression(h(mu)))
plot(fuv0$v,fuv0$fv/sum(fuv0$fv),type="l",xlab = expression(theta), ylab = expression(h(theta)))
dev.off()
