
require(REBayes)
data(bball)

# Select Sample for Estimation
Bselect <- function(data){
	B <- data[data$year != 2012,]
	id <- B$id
	m <- tapply(id,id,length)
	B[m[id] > 3,] #remove players with less than 3 half-seasons
	}

Bselect_nonp <- function(data){
# non-pitchers, excluding 2012 (record of the last year)
	B <- data[data$year != 2012&data$pitcher==0,]
	id <- B$id
	m <- tapply(id,id,length)
	mm <- rep((m>3),m)
	B[mm,] #remove players with less than 3 half-seasons
	}

C <- Bselect_nonp(bball)
ha = C$HA
id <- C$id
w <- 4 * C$AB
age <- C$age
	
source("profl_fun.R")

# Now do profile likelihood to get age and age^2 coefficients,using pre-2012 data (1072 players)


bs2 <- cbind(c(-35:-5/200),c(-50:-20/20))
pl2 <- matrix(0, nrow= nrow(bs2),ncol = nrow(bs2))
for (i in 1:nrow(bs2)){
    for (j in 1:nrow(bs2)){
        y = ha - bs2[,1][i] *(age-30)/100 - bs2[,2][j]*(age-30)^2/10000
        f <- WLVmix(y, id, w = w, rtol = 1e-10,maxit = 2)
        pl2[i,j] <- f$logLik[length(f$logLik)]
    print(j)
    }
    print(i)
}

