#Estimation: Dirichlet Process NPBayesian 
#DPpackages in R
#Binomial based

require(DPpackage)
source("data_select2012.R")

y <- cbind(bballt$Htotal, bballt$ABtotal)
prior0 <- list(alpha = 10, a1 = 1, b1 = 1)
prior1 <- list(alpha = 1,a1 = 1,b1 = 1)
prior2 <- list(alpha = 0.01,a1 = 1,b1 = 1)
mcmc <- list(nburn = 5000,nsave = 10000,nskip = 3,ndisplay = 100)
state <- NULL


DP0 <- DPbetabinom(y = y,ngrid = 3000, prior = prior0, mcmc = mcmc, state = state, status = TRUE)

DP1 <- DPbetabinom(y = y,ngrid = 3000, prior = prior1, mcmc = mcmc, state = state, status = TRUE)

DP2 <- DPbetabinom(y = y,ngrid = 3000, prior = prior2, mcmc = mcmc, state = state, status = TRUE)

save(DP0, file = "DP0.Rda")
save(DP1,file="DP1.Rda")
save(DP2,file="DP2.Rda")

