# include only pitchers

require(REBayes)
data(bball)
B = bball
B <- B[B$pitcher==0,]

bball2012 <- B[B$year == 2012,]
bball <- B[B$year !=2012,]

#selection: trim away players that have <=3 records pre-2012 (so that we can estimate location-scale mixture)
list <- (table(bball$id)<=3)
list <- as.numeric(names(which(list)))
arrow <- NULL
for (i in 1:length(list)){
	arrow <- c(arrow,which(bball$id==list[i]))
}
bball <- bball[-arrow,]

ha <- bball$HA #batting average(transformed normal variable)
id <- bball$id
age <- bball$age
w <- (4*bball$AB) #Weight due to binomial. NoteToSelf:4n_it, instead of 1/4n_it
m<-tapply(ha,id,"length")
r <- (m-1)/2
wsum <- tapply(w,id,"sum")
t <- tapply(w*ha,id,"sum")/wsum #sufficient stat for location para
s <- (tapply(w*ha^2,id,"sum") - t^2*wsum)/(m-1) #sufficient stat for scale para

MLEsigma <- mean((m-1)*s/m) #MLE for scale para

#collapse panel (for Binomial Mixture estimation)
ABt <- tapply(bball$AB,bball$id,"sum")
walkst <- tapply(bball$BB,bball$id,"sum")
Ht <- tapply(bball$H,bball$id,"sum")
idt <- tapply(bball$id, bball$id, "mean")
bballt <- as.data.frame(cbind(idt,ABt,Ht,walkst))
colnames(bballt) <- c("id","ABtotal","Htotal","walkstotal")
u <- unique(bball$name)
bballt$name <- as.character(paste(u))

#2012 prediction set (sum up two half seasons)
ABt2012 <- tapply(bball2012$AB,bball2012$id,"sum")
Ht2012 <- tapply(bball2012$H,bball2012$id,"sum")
walkst2012 <- tapply(bball2012$BB,bball2012$id,"sum")
id2012 <- tapply(bball2012$id,bball2012$id,"mean")
age2012 <- tapply(bball2012$age,bball2012$id,"mean")
age2012 <- round(age2012,digits = 0)
pitcher2012 <- tapply(bball2012$pitcher,bball2012$id,"mean")
bballt2012 <- as.data.frame(cbind(id2012,ABt2012,Ht2012,walkst2012,pitcher2012,age2012))
colnames(bballt2012) <- c("id","AB","H","walk","pitcher","age")
u2012 <- unique(bball2012$name)
bballt2012$name <- as.character(paste(u2012))

#selected players (non-pitchers) to be predict
#>40 At Bats in 2012

bballt2012 <- bballt2012[bballt2012$AB>40,]
bballt2012 <- bballt2012[bballt2012$pitcher==0,]

