
load("indep_it.Rda")

require(REBayes)
data(bball)
Bselect_nonp <- function(data){
# non-pitchers, excluding 2012 (record of the last year)
	B <- data[data$year != 2012&data$pitcher==0,]
	id <- B$id
	m <- tapply(id,id,length)
	mm <- rep((m>3),m)
	B[mm,] #remove players with less than 3 half-seasons
	}
C = Bselect_nonp(bball)	

#Estimate the binomial mixture (use aggregated AB and Hits over 2002 - 2011)
ABt = tapply(C$AB, C$id, sum)
Ht = tapply(C$H, C$id, sum)
fb <- Bmix(Ht, ABt, v = seq(0.15, 0.33, length= 300),rtol = 1e-12)



# Figure for fu and fv based on the 2002-11 baseball data estimation

pdf("binp_it.pdf", height = 5, width = 8)
par(mfrow = c(1,2))
u <- sin(f_it$u)^2
fu <- f_it$fu/(2*sqrt(u*(1-u)))
main <- "Gaussian Model"
plot(u,fu/sum(fu),xlim = c(0.1,.4), type = "l", xlab = expression(p), ylab = expression(f(p)),main = main)
main <- "Binomial Model"
plot(fb$x,fb$y/sum(fb$y),xlim = c(0.1,.4),type = "l", xlab = expression(p), ylab = expression(f(p)),main = main)

dev.off()
