source("data_select2012.R")
source("profl_fun.R")
source("uvTweedie_WGLVmix.R") # Bayes rule (Tweedie formula) for u or v (marginal out v or u)
source("uvTweedie_WTLVmix.R") # Bayes rule for u or v (independence prior)
source("uTweedie_Bmix.R") # Bayes rule (Tweedie formula) for u or v (marginal out v or u)
#load("DP1.Rda") #Dirichelet Process output 1
#load("DP2.Rda") #Dirichelet Process output 2

load("joint.Rda")
load("indep.Rda")
fo = fuv2 #KW WGLVmix mixture with no covariates
fi = fuv0 # KW WTLVmix mixture (indepedence prior)
fb <- Bmix(bballt$Ht, bballt$ABt, m = 3000, rtol = 1e-10) # Binomial mixture (aggregated individual)


bballt2012$HA <- asin(sqrt((bballt2012$H+0.25)/(bballt2012$AB + 0.5)))
sub1 <- bballt$id %in% bballt2012$id  # excludes players not in 2012
sub2 <- bballt2012$id %in% bballt$id  # excludes players only appear in 2012



# WGLVmix model without covariates
NLVp <- uvTweedie_WGLVmix(fo, ha, id, w)
NLVpu <- NLVp$u
NLVpv <- NLVp$v

pdf("Brule.pdf",height = 5, width = 5)
plot(NLVpu, NLVpv, cex = 0.2, xlab = expression(paste("E(",mu,"|",hat(mu) , ", S)",sep="")), ylab = expression(paste("E(",theta, "|", hat(mu), ", S)",sep = "")))
dev.off()
