#Get data from web by year (2002 to 2012) for all MLB teams.

require(XML)

string=c("ari","atl","bal","bos","chc","chw","cin","cle","col","det","hou","kc","laa","lad","mia","mil","min","nym","nyy","oak","phi","pit","sd","sf","sea","stl","tb","tex","tor","wsh") #abbreviation for teams
month=c("40","41","42","43","44","45","77") #40 is for April, so on so forth, 77 is for position as pitcher indicator
year=c("2002","2003","2004","2005","2006","2007","2008","2009","2010","2011","2012")
team=c("arizona-diamondbacks","atlanta-braves","baltimore-orioles","boston-red-sox","chicago-cubs","chicago-white-sox","cincinnati-reds","cleveland-indians","colorado-rockies","detriot-tigers","houston-astros","kansas-city-royals","los-angeles-angels","los-angeles-dodgers","miami-marlins","milwaukee-brewers","minnesota-twins","new-york-mets","new-york-yankees","oakland-atheletics","philadelphia-phillies","pittsburgh-pirates","san-diego-padres","san-francisco-giants","seattle-mariners","st-louis-cardinals","tampa-bay-rays","texas-rangers","toronto-blue-jays","washington-nationals")

for (i in 1:11){
A<-NULL
for (k in 1:30){
	url=rep(0,7)
		for (j in 1:7){
		url[j]=paste("http://espn.go.com/mlb/team/stats/batting/_/name/",string[k],"/year/",year[i],"/seasontype/2/split/",month[j],"/",team[k],sep="")
}
Asub<-readHTMLTable(url[1],header=F)
Asub<-as.data.frame(Asub[[1]])
Asub<-Asub[3:(dim(Asub)[1]-2),c(1,3,5,11,15)]
Asub[,5] <- factor(Asub[,5], levels = c(levels(Asub[,5]),0))
colnames(Asub)=c("name","AB(4)","H(4)","BB(4)","OBP(4)")
	for (j in 2:6){
	B<-readHTMLTable(url[j],header=F)
	B<-as.data.frame(B[[1]])
	B<-B[3:(dim(B)[1]-2),c(1,3,5,11,15)]
	B[,5] <- factor(B[,5],levels = c(levels(B[,5]),0))
	colnames(B)=c("name",paste("AB","(",j+3,")",sep=""),paste("H","(",j+3,")",sep=""),paste("BB","(",j+3,")",sep=""),paste("OBP","(",j+3,")",sep=""))
	Asub<-merge(Asub,B,by="name",all=TRUE)
	}
	C<-readHTMLTable(url[7],header=F)
	C<-as.data.frame(C[[1]])
	C<-C[3:(dim(C )[1]-1),1:2]
	colnames(C )=c("name","pitcher")
	C$pitcher=1
	Asub<-merge(Asub,C,by="name",all=TRUE)
	
	Asub[is.na(Asub)]<-0  #webdata 0 display as NA
	Asub$year=year[i]
	Asub$team=team[k]
colnames(Asub)=c("name","AB(4)","H(4)","BB(4)","OBP(4)","AB(5)","H(5)","BB(5)","OBP(5)","AB(6)","H(6)","BB(6)","OBP(6)","AB(7)","H(7)","BB(7)","OBP(7)","AB(8)","H(8)","BB(8)","OBP(8)","AB(9)","H(9)","BB(9)","OBP(9)","pitcher","year")
A<-rbind(A,Asub)
}
save(A,file=paste("~/A_",year[i],".Rda",sep=""))
}
