% ----------------------------------------------------------------------- %
%      Tranforms the dates in order to plot the different components      %
% ----------------------------------------------------------------------- %
function [Dates_string, Dates_num] = transform_dates(Dates)
    T = size(Dates,1);
    Dates_string=[];
    for i=1:T;
        N = Dates(i);
        S = sprintf('%d', N,15);
        D = [S(5:6), '/', S(7:8), '/', S(1:4)];
        Dates_string = [Dates_string;D];
    end
    Dates_num=datenum(Dates_string,'mm/dd/yyyy');
end
