% ----------------------------------------------------------------------- %
% Plots different quantities such as filtered estimates of the parameters %
% ----------------------------------------------------------------------- %
function plot_TV_parameters(beta,t0,betaOLS,SE_OLS,Dates)
    [K,T]=size(beta);
    figure(2);
    for i = 1:2:K
        if mod(K,2) == 0;
            subplot(K/2, 2,i)
        else
            subplot((K+1)/2, 2,i)
        end
        plot(Dates(t0:end),beta(i,t0:end)','k');
        hold on
        plot(Dates(t0:end),repmat(betaOLS(i),T-t0+1,1),'b--');
        hold on
        plot(Dates(t0:end),repmat(betaOLS(i)+1.96*SE_OLS(i),T-t0+1,1),'r:');
        hold on
        plot(Dates(t0:end),repmat(betaOLS(i)-1.96*SE_OLS(i),T-t0+1,1),'r:');
        datetick('x', 'yyyy');
        axis tight;
        M_b = max(beta(i,t0:end));
        m_b = min(beta(i,t0:end));
        ylim([min(m_b - 0.1 * M_b, betaOLS(i)-2.5*SE_OLS(i)),max(M_b,betaOLS(i)+2.5*SE_OLS(i))]);
    end
    hold on
    for i = 2:2:K
        if mod(K,2) == 0;
            subplot(K/2, 2,i)
        else
            subplot((K+1)/2, 2,i)
        end
        plot(Dates(t0:end),beta(i,t0:end)','k');
        hold on
        plot(Dates(t0:end),repmat(betaOLS(i),T-t0+1,1),'b--');
        hold on
        plot(Dates(t0:end),repmat(betaOLS(i)+1.96*SE_OLS(i),T-t0+1,1),'r:');
        hold on
        plot(Dates(t0:end),repmat(betaOLS(i)-1.96*SE_OLS(i),T-t0+1,1),'r:');
        datetick('x', 'yyyy');
        axis tight;
        M_b = max(beta(i, t0:end));
        m_b = min(beta(i, t0:end));
        ylim([min(m_b-0.1*abs(m_b),betaOLS(i)-2.5*SE_OLS(i)),max(M_b+0.1*abs(M_b),betaOLS(i)+2.5*SE_OLS(i))]);
    end
end