% ----------------------------------------------------------------------- %
%                        Plots each subfigure of Figure 2                 %
% ----------------------------------------------------------------------- %
function plot_TV_components(beta, H, Dep, vErr, varsigma, kappa, t0, betaOLS, SE_OLS, Dates, grid_varsigma)
    [K,T] = size(beta);
    figure(1);
    subplot(3, 2, 1)
    plot(Dates(t0:end), beta(1, t0:end)','k');
    hold on
    plot(Dates(t0:end), repmat(betaOLS(1), T-t0+1,1),'b--');
    hold on
    plot(Dates(t0:end), repmat(betaOLS(1) + 1.96 * SE_OLS(1), T-t0+1, 1),'r:');
    hold on
    plot(Dates(t0:end),repmat(betaOLS(1) - 1.96 * SE_OLS(1), T-t0+1,1),'r:');
    datetick('x', 'yyyy');
    axis tight;
    M_b = max(beta(1, t0:end));
    m_b = min(beta(1, t0:end));
    ylim([min(m_b - 0.1 * abs(m_b), betaOLS(1) - 2.5*SE_OLS(1)),max(M_b+0.1*abs(M_b),betaOLS(1)+2.5*SE_OLS(1))]);
    hold on
    title('\alpha_t')
    subplot(3, 2 ,2)
    if K>= 2
        plot(Dates(t0:end), beta(2,t0:end)', 'k');
        hold on
        plot(Dates(t0:end), repmat(betaOLS(2), T-t0+1,1), 'b--');
        hold on
        plot(Dates(t0:end),repmat(betaOLS(2)+1.96*SE_OLS(2),T-t0+1,1),'r:');
        hold on
        plot(Dates(t0:end),repmat(betaOLS(2)-1.96*SE_OLS(2),T-t0+1,1),'r:');
        datetick('x', 'yyyy');
        axis tight;
        M_b = max(beta(2,t0:end));
        m_b = min(beta(2,t0:end));
        ylim([min(m_b - 0.1 * abs(m_b), betaOLS(2) - 2.5*SE_OLS(2)),max(M_b+0.1*abs(M_b),betaOLS(2)+2.5*SE_OLS(2))]);     
    end
    hold on
    title('\gamma_t')
    subplot(3, 2, 3)         
    plot(Dates(t0:end), H(t0:end)', 'k')
    datetick('x', 'yyyy');
    axis tight;
    hold on
    title('H_t')
    subplot(3, 2, 4)
    plot(Dates(t0-1:end), Dep(t0:end), 'k');
    hold on
    plot(Dates(t0-1:end),Dep(t0:end)-vErr(t0-1:end),'r-');
    datetick('x', 'yyyy');
    axis tight;
    title('Signal and Error')
                 
    subplot(3, 2, 5)
    plot(Dates(t0:end), varsigma(t0:end),'r')
    datetick('x', 'yyyy');
    axis tight;
    hold on
    title('\varsigma')
    ylim([min(grid_varsigma), max(grid_varsigma)]);
                 
    subplot(3, 2, 6)
    plot(Dates(t0:end),kappa(t0:end),'r')
    datetick('x', 'yyyy');
    axis tight;
    hold on
    title('\kappa')
    ylim([0.9,1]);
end
