% ----------------------------------------------------------------------- %
%      SP normalized given certain values of the tuning parameters        %
% ----------------------------------------------------------------------- %
function [mbetat, veta, vPredLik, dLogLik,amPt,Mean,Variance] = funcSPx(vy,mx,dbeta,dkappa)
    [cT, cK] = size(mx);
    amPt = zeros(cK, cK, cT);
    mbetat = zeros(cK, cT);
    vbeta0 = zeros(cK, 1);
    mP0 = eye(cK);
    veta = zeros(cT, 1);
    vR = zeros(cT, 1);
    vPredLik = zeros(cT, 1);
    Mean = zeros(cT, 1);
    Variance = zeros(cT, 1);
    dLogF = 0;
    dSumSquares = 0;
    for i=1:cT
       if i==1
          vbetatm1 = vbeta0;  
          mPtm1 = mP0;   
       else
           vbetatm1 = mbetat(:, i - 1);
           mPtm1 = squeeze(amPt(:, :, i - 1)); 
       end
       veta(i) = vy(i) - mx(i, :) * vbetatm1; 
       if i<2
          vR(i) = veta(i).^2;
          mterm = zeros(size(vbetatm1, 1), size(vbetatm1, 1));     
       else
          vR(i) = dkappa * vR(i - 1) + (1 - dkappa) * veta(i)^2;
          dx = ((veta(i).^2)/vR(i) - 1);
          mterm = dbeta * max(0, floor(dx)) * eye(size(vbetatm1, 1));
       end
       dF = vR(i) + mx(i, :) * mPtm1 * mx(i, :)';
       %------------------ ML Quantity -----------------%
       dLogF = dLogF + log(dF);
       dSumSquares = dSumSquares + (veta(i)^2)/dF;
       %------------------ End ML Quantity -------------% 
       vPredLik(i) = mvnpdfs(vy(i), mx(i,:) * vbetatm1, vR(i) + mx(i, :) * mPtm1 * mx(i, :)');
       Mean(i) = mx(i,:) * vbetatm1;
       Variance(i) = vR(i) + mx(i, :) * mPtm1 * mx(i, :)';
       mbetat(:, i) = vbetatm1 + mPtm1 * mx(i, :)' * inv(dF) * veta(i);   
       amPt(:, :, i) = mPtm1 - mPtm1 * mx(i,:)'* inv(dF) * mx(i,:) * mPtm1+mterm;
    end
    %------------------ Calculate the likelihood -------------------------%
    dLogLik = 0.5*((cT)*log(2 * pi)+ dLogF + dSumSquares);
end
