% ----------------------------------------------------------------------- %
%    Function with SP normalized using the optimal values of the tuning   %
%    parameters to perform estimation in order to obtain point and        %
%    density forecasts                                                    %
% ----------------------------------------------------------------------- %
function [mbetat, veta, vR, vpdf, Mean, Variance] = funcSPtop(vy, mx, vbeta, vkappa)
    [cT, cK] = size(mx);
    amPtp1 = zeros(cK, cK, cT);
    amPt = zeros(cK, cK, cT);
    mbetat = zeros(cK, cT);
    vbeta0 = zeros(cK, 1);
    mP0 = eye(cK);
    veta = zeros(cT,1);
    vR = zeros(cT, 1);
    vpdf = zeros(cT, 1);
    Mean = zeros(cT, 1);
    Variance = zeros(cT, 1);
    for i=1:cT
       if i==1  
          vbetatm1 = vbeta0;  
          mPtm1 = mP0; 
       else
           vbetatm1 = mbetat(:, i-1);
           mPtm1 = squeeze(amPt(:, :, i-1)); 
       end
       veta(i, 1) = vy(i, 1) - mx(i, :) * vbetatm1; 
       if i<2
           vR(i, 1) = veta(i, 1).^2;
           mterm = zeros(size(vbetatm1, 1), size(vbetatm1, 1));
       else
           vR(i, 1) = vkappa(i, 1) * vR(i-1) + (1 - vkappa(i, 1)) * veta(i, 1)^2;
           dx = ((veta(i).^2)/vR(i)-1);
           mterm = vbeta(i, 1) * max(0, floor(dx)) * eye(size(vbetatm1, 1));
       end
       vpdf(i, 1) = normpdf(vy(i,1),mx(i,:)*vbetatm1,sqrt(vR(i)+mx(i,:)*mPtm1*mx(i,:)'));
       Mean(i) = mx(i,:) * vbetatm1;
       Variance(i) = vR(i) + mx(i, :) * mPtm1 * mx(i, :)';
       mbetat(:, i) = vbetatm1 + mPtm1 * mx(i, :)'/(vR(i, 1) + mx(i, :) * mPtm1 * mx(i, :)') * veta(i);  
       amPt(:, :, i) = mPtm1 - mPtm1 * mx(i, :)'/(vR(i, 1) + mx(i, :) * mPtm1 * mx(i, :)') * mx(i, :) * mPtm1 + mterm;
       amPtp1(:, :, i) = mPtm1;
    end
end
