% ----------------------------------------------------------------------- %
%  Function with SP that performs estimation, model averaging using       %
%  exogenous predictors and  realized volatility (RV) in the              %
%  conditional volatility                                                 %
% ----------------------------------------------------------------------- %
function [vPredlik_DMS, vtopMmpt, vOutputBestModel, mComb_opt, vMean_DMS, ...
    vVariance_DMS, vPredlik_DMA, vMean_DMA, vVariance_DMA] = SPKF_Selection_X_RV(vY, mX, vBeta, vKappa, dAlpha, RV)
    warning off;
    [cT, cK] = size(mX);
    N = cK;
    comb = cell(N,1);
    for nn = 1:N
    % 'comb' has N cells with all possible combinations for each N
        comb{nn, 1} = combntns(1:N, nn);
    end
    K = 2.^N;  %Total number of models
    index = cell(K,1);
    dim = zeros(1, N + 1);
    for nn=1:N
        dim(:, nn + 1) = size(comb{nn, 1}, 1);
        for jj = 1:size(comb{nn, 1}, 1)
            index{jj + sum(dim(:, 1:nn)), 1} = comb{nn, 1}(jj, :);
        end
    end
    % Make combination such that we can do less loops. This approach is faster and we do not have to 
    % work with 5 dimensional arrays in the DMA part. Note that we have 2
    % tuning parameters so we have a lot of model combinations and we also
    % perform DMA. This way we can also use parfor to speed up computation
    vBetaC = num2cell(vBeta);
    vKappaC = num2cell(vKappa);
    mComb =allcomb(vBetaC, vKappaC, index);
    iM = size(mComb, 1);
    omega_predict = ones(1, iM)./iM;
    mpmt = zeros(cT, iM);
    mPredLik = zeros(cT, iM);
    mMeans=zeros(cT, iM);
    mVariance=zeros(cT, iM);
    vOutputBeta = zeros(cT, 1);
    vOutputKappa = zeros(cT, 1);
    vtopMmpt = zeros(cT, 1);
    vOutputBestModel = zeros(cT, 1);
    vOutputBeta(1, 1) = vBeta(1, 1);
    vOutputKappa(1, 1) = vKappa(1, 1);
    vtopMmpt(1, 1) = 1;
    vOutputBestModel(1, 1) = omega_predict(1, 1);
    mPost_Omega = zeros(cT, iM);
    parfor z = 1:size(mComb, 1);
        index = mComb{z,3};
        mXX = [ones(cT, 1), mX(:,index)]; % Obtain predictive likelihood for each model combination.
        [~, ~, mPredLik(:, z), ~, ~, mMeans(:, z), mVariance(:, z)] = funcSPx_RV(vY, mXX, mComb{z, 1}, mComb{z, 2}, RV);
    end  
    for i = 1:cT % Perform averagning
        if i == 1
           omega_predict = ones(1, iM)./iM;
        else
           dsumprob = sum(vOmega_Update.^dAlpha);
           omega_predict = (vOmega_Update.^dAlpha + 1e-9)./(dsumprob + 1e-9);
        end
        w_t = (mPredLik(i, :).* omega_predict);
        vSum_W = sum(w_t, 2);
        vOmega_Update = (w_t + 1e-9)./(vSum_W + 1e-9);
        mPost_Omega(i, :) = vOmega_Update;
        mpmt(i, :) = vOmega_Update;
        vmodel = 1:1:iM;
        vmodel = [vmodel', vOmega_Update'];
        vselect = (vmodel == max(vmodel(:, 2)));
        vselect = vmodel(:, 1).*vselect(:, 2);
        dBestModel = vselect(vselect~=0, :);
        if size(dBestModel, 1) > 1
           dBestModel = dBestModel(end, 1);
        end
        vtopMmpt(i) = max(vOmega_Update); 
        vOutputBestModel(i) = dBestModel(end, 1);
        vOutputBeta(i) = mComb{dBestModel, 1};
        vOutputKappa(i) = mComb{dBestModel, 2};
    end
    mComb_opt = num2cell(zeros(rows(vOutputBestModel), 1));
    vPredlik_DMA = zeros(rows(vOutputBestModel), 1);
    vMean_DMA = zeros(rows(vOutputBestModel), 1);
    vVariance_DMA = zeros(rows(vOutputBestModel), 1);
    vPredlik_DMS = zeros(rows(vOutputBestModel), 1);
    vMean_DMS = zeros(rows(vOutputBestModel), 1); 
    vVariance_DMS = zeros(rows(vOutputBestModel), 1);
    for i=1:rows(vOutputBestModel);
        mComb_opt{i, :}= mComb{vOutputBestModel(i), 3};
        % ======================= DMS part ============================== %
        vPredlik_DMS(i) = mPredLik(i, vOutputBestModel(i));
        vMean_DMS(i) = mMeans(i, vOutputBestModel(i));
        vVariance_DMS(i) = mVariance(i, vOutputBestModel(i));
        % ======================= DMA part ============================== %
        vPredlik_DMA(i) = mPost_Omega(i, :) * mPredLik(i, :)';
        vMean_DMA(i) = mPost_Omega(i, :) *  mMeans(i, :)';
        vVariance_DMA(i) = mPost_Omega(i, :) *  mVariance(i,:)';   
    end
end