% ----------------------------------------------------------------------- %
%         Function with SP that performs model estimation using realized  %
%         volatility (RV) in the conditional volatility without           %
%         exogenous predictors                                            %
% ----------------------------------------------------------------------- %
function [mBetaOutput, vError, mH, vPredLik, vOutputBeta, vOutputKappa,...
    vMean, vVariance] = SPKF_Selection_RV(vY, mX, vBeta, vKappa, dAlpha,RV)
    % Make combination such that we can do less loops. This approach is faster and we do not have to 
    % work with 5 dimensional arrays in the DMA part. Note that we have 2
    % tuning parameters so we have a lot of model combinations and we also
    % perform DMA. This way we can also use parfor to speed up computation
    [cT, cK] = size(mX);
    mComb = combvec(vBeta', vKappa')'; 
    iM = size(mComb, 1);
    omega_predict = ones(1, iM)./iM;
    mpmt = zeros(cT, iM);
    mPredLik = zeros(cT, iM);
    vOutputBeta = zeros(cT, 1);
    vOutputKappa = zeros(cT, 1);
    vtopMmpt = zeros(cT, 1);
    vOutputBestModel = zeros(cT, 1);
    vOutputBeta(1, 1) = vBeta(1, 1);
    vOutputKappa(1, 1) = vKappa(1, 1);
    vtopMmpt(1, 1) = 1;
    vOutputBestModel(1, 1) = omega_predict(1, 1);
    for z=1:size(mComb, 1); % Obtain predictive likelihood for each model combination.
        [~, ~,  mPredLik(:, z),~] = funcSPx_RV(vY, mX, mComb(z, 1), mComb(z, 2), RV);
    end  
    for i = 1:cT % Perform averagning
        if i == 1
           omega_predict = ones(1, iM)./iM;
        else
           dsumprob = sum(vOmega_Update.^dAlpha);
           omega_predict = (vOmega_Update.^dAlpha + 1e-9)./(dsumprob + 1e-9);
        end
        w_t = (mPredLik(i, :).* omega_predict);
        vSum_W = sum(w_t, 2);
        vOmega_Update = (w_t + 1e-9)./(vSum_W + 1e-9);
        mpmt(i, :) = vOmega_Update;
        vmodel = 1:1:iM;
        vmodel = [vmodel', vOmega_Update'];
        vselect = (vmodel == max(vmodel(:, 2)));
        vselect = vmodel(:, 1).*vselect(:, 2);
        dBestModel = vselect(vselect~=0, :);
        if size(dBestModel, 1) > 1
           dBestModel = dBestModel(end, 1);
        end
        vtopMmpt(i) = max(vOmega_Update);
        vOutputBestModel(i) = dBestModel(end, 1);
        vOutputBeta(i) = mComb(dBestModel, 1);
        vOutputKappa(i) = mComb(dBestModel, 2);
    end
    [mBetaOutput, vError, mH, vPredLik, vMean, vVariance] = funcSPtop_RV(vY, mX,vOutputBeta, vOutputKappa,RV);
end