% ----------------------------------------------------------------------- %
% Grassi. Stefano, Paolo Santucci de Magistris, and Nima . Nonejad. 2016. 
% " Forecasting with the Standardized Self-Perturbed Kalman Filter", 
% Journal of Applied Econometrics, forthcoming.
% The data used in this article were downloaded from  Amit Goyal's website
% http://www.hec.unil.ch/agoyal/ associated with the following paper:
% "A Comprehensive Look at the Empirical Performance of Equity Premium
% Prediction". 2008. Review of Financial Studies 21(4) 1455-1508.
% This program replicate the model 9 and 10 if Table 3
% Note: To run the programs you need to download the LM package 
% (elwcode10.zip) of Katsumi Shimotsu freely available  at 
% http://shimotsu.web.fc2.com/Site/Matlab_Codes.html and the Econometric 
% package of  James P. LeSage freely available at http://www.spatial-econometrics.com/.
% ----------------------------------------------------------------------- %
clear all;
clc;
load Database
[Dates_string,Dates_num]=transform_dates(yyyymm);
T = size(Dep, 1);
RV_dtr = dmtrend(sqrt(RV));	% demeaned & detrended data
infl_dtr = dmtrend(infl);	% demeaned & detrended data
m = fix(T^0.6);             % m is the number of frequencies used in estimation.
options = optimset('fminbnd');
d_RV = felw2st(RV_dtr,m,3,10);						% 2-step ELW w/ detrending
d_Infl = felw2st(infl_dtr,m,3,10);
fprintf(1,'Estimate of d: 2-step ELW estimator w/ detrending %7.5f  \n', d_RV);
fprintf(1,'Estimate of d: 2-step ELW estimator w/ detrending %7.5f  \n', d_Infl);
D_RV = fracdiff(RV_dtr,d_RV);
D_infl = fracdiff(infl_dtr,d_Infl);
D_dy = [0;diff(dy)];
D_ep = [0;diff(ep)];
D_dpayr = [0;diff(dpayr)];
D_bm = [0;diff(bm)];
D_tbl = [0;diff(tbl)];
D_lty = [0;diff(lty)];
D_dfr = [0;diff(dfr)];
D_ntis = [0;diff(ntis)];
D_dfy = [0;diff(dfy)];
X = [D_RV, D_dy, D_ep, D_dpayr, D_bm, D_ntis, D_tbl, D_lty, ltr, D_dfy, D_dfr, D_infl];

X = standardize(X);
mu_Dep = mean(Dep);
sigma_Dep = std(Dep);
Dep = standardize(Dep);
cT = size(Dep(2:end),1);
results = ols(Dep(2:end), [ones(cT, 1), X(1:end-1,:)]);
beta_OLS = results.beta;
SE_OLS = results.bstd;
Ve = results.sige;
OLS_errors = results.resid;
RV_tilde = RV * mean(Ve)/mean(RV);
varsigma = [(var(Dep(2:cT)))/( cT):(200 * (var(Dep(2:cT)))/cT):((var(Dep(2:cT))))]'/1000;
vkappa = [0.94:0.01:0.99]';
[vPredlik_DMS, vtopMmpt, vOutputBestModel, mComb_opt, vMean_DMS,vVariance_DMS, vPredlik_DMA, vMean_DMA, vVariance_DMA] = ...
    SPKF_Selection_X(Dep(2:end), [X(1:end-1, :)], varsigma, vkappa, 0.95);
save Output_9_10