% ----------------------------------------------------------------------- %
% Grassi. Stefano, Paolo Santucci de Magistris, and Nima . Nonejad. 2016. 
% " Forecasting with the Standardized Self-Perturbed Kalman Filter", 
% Journal of Applied Econometrics, forthcoming.
% The data used in this article were downloaded from  Amit Goyal's website
% http://www.hec.unil.ch/agoyal/ associated with the following paper:
% "A Comprehensive Look at the Empirical Performance of Equity Premium
% Prediction". 2008. Review of Financial Studies 21(4) 1455-1508.
% This program replicate the results in the papers. Specifically,
% this file replicates figure 4. To run the program you need Output10 and 
% Output 9. Those are available from running Main_Models_9_10.m and 
% Main_Models_11_12.m
% Note: To run the programs you need to download the LM package 
% (elwcode10.zip) of Katsumi Shimotsu freely available  at 
% http://shimotsu.web.fc2.com/Site/Matlab_Codes.html and the Econometric 
% package of  James P. LeSage freely available at http://www.spatial-econometrics.com/.
% ----------------------------------------------------------------------- %

clear all ;
clc;
load Output_11_12.mat
Fr = zeros(rows(mComb_opt),1);
SS = zeros(rows(mComb_opt),1);
for i = 1:rows(mComb_opt); 
    if isempty(mComb_opt{i,1});
      Fr(i) = 0;
    else
      A = mComb_opt{i,1};
      SS(i) = cols(mComb_opt{i,1});
      Fr(i) = max(A==1);
    end
end

load Output_9_10.mat
Fr_9 = zeros(rows(mComb_opt),1);
SS_9 = zeros(rows(mComb_opt),1);
for i = 1:rows(mComb_opt); 
    if isempty(mComb_opt{i,1});
        Fr(i)=0;
    else
        A = mComb_opt{i,1};
        SS_9(i)=cols(mComb_opt{i,1});
        Fr_9(i) = max(A==1);
    end;
end;
t0=120;
diff_plus=zeros(rows(Fr),1);
diff_minus=zeros(rows(Fr),1);
diff_equal=zeros(rows(Fr),1);
for i=1:rows(Fr)
    if (Fr(i)-Fr_9(i))>0;
        diff_equal(i)=NaN;
        diff_plus(i)=1;
        diff_minus(i)=NaN;
    elseif (Fr(i)-Fr_9(i))<0;
        diff_equal(i)=NaN;
        diff_plus(i)=NaN;
        diff_minus(i)=-1;
    elseif (Fr(i)-Fr_9(i))==0;
        diff_plus(i)=NaN;
        diff_minus(i)=NaN;
    end
end
subplot(3, 1, 1)
plot(Dates_num(t0:end),[SS(t0-1:end)],'k-')
datetick('x','yyyy')
axis tight
ylim([0 12])
subplot(3, 1, 2)
plot(Dates_num(t0:end),Fr_9(t0-1:end),'ko')
datetick('x','yyyy')
axis tight
recessionplot
subplot(3, 1, 3)
plot(Dates_num(t0:end),diff_equal(t0-1:end),'ro')
hold on
plot(Dates_num(t0:end),diff_plus(t0-1:end),'go')
hold on
plot(Dates_num(t0:end),diff_minus(t0-1:end),'bo')
datetick('x','yyyy')
axis tight
ylim([-1.2 1.2])
recessionplot