% Grassi. Stefano, Paolo Santucci de Magistris, and Nima Nonejad 2016. 
% " Forecasting with the Standardized Self-Perturbed Kalman Filter", 
% Journal of Applied Econometrics, forthcoming.
% The data used in this article were downloaded from  Amit Goyal's website
% http://www.hec.unil.ch/agoyal/ associated with the following paper:
% "A Comprehensive Look at the Empirical Performance of Equity Premium
% Prediction". 2008. Review of Financial Studies 21(4) 1455-1508.
% This program replicate the results in the papers. Specifically,
% one can consider the models in Table 3 of the paper and by commenting
% the lines associated with each model replicate the results. For instance,
% one can replicate Figure 2 by running model 6.
% Note: To run the programs you need to download the LM package 
% (elwcode10.zip) of Katsumi Shimotsu freely available  at 
% http://shimotsu.web.fc2.com/Site/Matlab_Codes.html and the Econometric 
% package of  James P. LeSage freely available at http://www.spatial-econometrics.com/.

% Load  the data
clear all;
clc;
load Database
[Dates_string, Dates_num] = transform_dates(yyyymm);
% Perform the necessary transformations to RV and infl
T = size(Dep, 1);
RV_dtr = dmtrend(sqrt(RV));	% Demeaned & detrended data
infl_dtr = dmtrend(infl);	% Demeaned & detrended data
m = fix(T^0.6);		% m is the number of frequencies used in estimation.
options = optimset('fminbnd');
d_RV = felw2st(RV_dtr, m, 3, 10);						% 2-step ELW w/ detrending
d_Infl = felw2st(infl_dtr, m, 3, 10);
fprintf(1,'Estimate of d: 2-step ELW estimator w/ detrending %7.5f  \n', d_RV);
fprintf(1,'Estimate of d: 2-step ELW estimator w/ detrending %7.5f  \n', d_Infl);
D_RV = fracdiff(RV_dtr, d_RV);
D_infl = fracdiff(infl_dtr, d_Infl);
D_dy = [0; diff(dy)];
D_ep = [0; diff(ep)];
D_dpayr = [0; diff(dpayr)];
D_bm = [0; diff(bm)];
D_tbl = [0; diff(tbl)];
D_lty = [0; diff(lty)];
D_dfr = [0; diff(dfr)];
X = [D_dy, D_ep, D_dpayr, sqrt(RV), D_bm, ntis, D_tbl, D_lty, ltr, dfy, D_dfr, D_infl];
[T,k]=size(X);
X = standardize(X);
Dep = standardize(Dep);
D_RV = standardize(D_RV);
cT = rows(Dep(2:end));
results = ols(Dep(2:end),[ones(cT,1),D_RV(1:end-1)]);
beta_OLS = results.beta;
SE_OLS = results.bstd;
Ve = results.sige;
OLS_errors = results.resid;
RV = RV * Ve/mean(RV);
varsigma = [(var(Dep(2:cT)))/( cT):(200 * (var(Dep(2:cT)))/cT):((var(Dep(2:cT))))]'/1000;
vkappa = [0.94:0.01:0.99]';

[mBetaOutput, vError, mH, vPredLik,vOutputVarsigma, vOutputKappa, vMean, vVariance] ...
    = SPKF_Selection_RV(Dep(2:end), [ones(cT, 1), D_RV(1:end-1)], varsigma, vkappa, 0.95, RV(2:end));

t0 = 75; 
Dates_sample = Dates_num(end - cols(mBetaOutput) + 1:end);
plot_TV_components(mBetaOutput, mH, Dep, vError, vOutputVarsigma, vOutputKappa, t0, beta_OLS, SE_OLS, Dates_sample, varsigma);