% ----------------------------------------------------------------------- %
%       Function that calculates the SSP-KF of the paper.
% ----------------------------------------------------------------------- %
function [mbetat] = funcSPx(y, Zt, dbeta, dkappa)
    [T, m] = size(Zt);
    amPt = zeros(m, m, T);
    mbetat = zeros(m, T);
    vR = zeros(T, 1);
    theta_tt = zeros(m,1); 
    P_tt = 4 * eye(m);
    for irep=1:T
        theta_ttm1 = theta_tt;
        P_ttm1 = P_tt;        
        % Update step
        v_t = y(irep, :) - Zt(irep, :) * theta_ttm1;
        if irep==1
           vR(irep) = v_t.^2 ;
           mterm = zeros(size(theta_ttm1, 1), size(theta_ttm1, 1));     
        else
           vR(irep) = dkappa * vR(irep - 1) + (1 - dkappa) * v_t^2;
           dx = ((v_t.^2)/vR(irep) - 1);
           mterm = dbeta * max(0, floor(dx)) * eye(size(theta_ttm1, 1));
        end
        F_ttm1 = Zt(irep, :) * P_ttm1 * Zt(irep, :)' + vR(irep);
        theta_tt = theta_ttm1 + P_ttm1 * Zt(irep, :)' * inv(F_ttm1) * v_t;
        P_tt = P_ttm1 - P_ttm1 * Zt(irep,:)' * inv(F_ttm1) * Zt(irep, :) * P_ttm1 + mterm;
        mbetat(:, irep) = theta_tt;
        amPt(:, :, irep) = P_tt; 
    end
end
