% ----------------------------------------------------------------------- %
%       Function that calcualte the KK with forgetting factor.
% ----------------------------------------------------------------------- %
function [mbetat] =  funcKK(y, Zt, lambda, dkappa)
    [T, m] = size(Zt);
    amPt = reshape(repmat(eye(m, m) * 10, T, 1), m, m, T);
    mbetat = zeros(m, T);
    vR = zeros(T, 1);
    theta_tt = zeros(m,1); 
    P_tt = 4 * eye(m);
    for irep = 1:T           
        theta_ttm1 = theta_tt;
        P_ttm1 = (1./lambda)*P_tt;        
        % Update
        v_t = y(irep,:) - Zt(irep,:) * theta_ttm1;
        if irep==1
           vR(irep) = v_t.^2 ;
        else
           vR(irep) = dkappa * vR(irep - 1) + (1 - dkappa) * v_t^2;
        end
        F_ttm1 = Zt(irep, :) * P_ttm1 * Zt(irep,:)' + vR(irep);
        theta_tt = theta_ttm1 + P_ttm1 * Zt(irep, :)' * inv(F_ttm1) * v_t;
        P_tt = P_ttm1 - P_ttm1 * Zt(irep, :)' * inv(F_ttm1) * Zt(irep, :) * P_ttm1;
        mbetat(:, irep) = theta_tt;
        amPt(:, :, irep) = P_tt;
    end  
end