## This file defines a function that automatise the exports of figures

library(cmrutils)
par0 <- par()

FiguresCreation <- function(file,plotfunction,...) {
  postscript(file       = paste(c(paste(c(file[1],"Sans-serif/",file[2]),collapse=""),".eps"),collapse=""),
             horizontal = F,
             family     = "sans",
             ...)
  eval(plotfunction)()
  dev.off()
  postscript(file       = paste(c(paste(c(file[1],"Times/",file[2]),collapse=""),".eps"),collapse=""),
             horizontal = F,
             family     = "Times",
             ...)
  eval(plotfunction)()
  dev.off()
  makefig(plotfun       = eval(plotfunction),
          device        = "pdf",
          filename      = paste(c(file[1],"Sans-serif/",file[2]),collapse=""),
          family        = "CMSans",
          scale         = 1,
          ...)
  makefig(plotfun       = eval(plotfunction),
          device        = "pdf",
          filename      = paste(c(file[1],"Times/",file[2]),collapse=""),
          family        = "Times",
          scale         = 1,
          ...)
  png(filename      = paste(c(file[1],"Times/",file[2],".png"),collapse=""),
      family        = "serif",
      units         = "in",
      type          = "cairo",
      res           = 300,
      ...)
  eval(plotfunction)()
  dev.off()
  png(filename      = paste(c(file[1],"Sans-serif/",file[2],".png"),collapse=""),
      family        = "sans",
      units         = "in",
      type          = "cairo",
      res           = 300,
      ...)
  eval(plotfunction)()
  dev.off()
}
