# Create the ns restricted cubic basis spline matrices for MATLAB
library(R.matlab)
library(splines)

# Choose knots for the 1900-2011 Price
PYear <- 1900:2011
Pknots3 <- c(1911,1956,2000)
Pknots4 <- c(1905,1939,1970,2006)
Pknots5 <- c(1905,1930,1956,1981,2006)

PriceBS3 <- ns(PYear,knots=Pknots3[2]  ,Boundary.knots = Pknots3[c(1,3)])
PriceBS4 <- ns(PYear,knots=Pknots4[2:3],Boundary.knots = Pknots4[c(1,4)])
PriceBS5 <- ns(PYear,knots=Pknots5[2:4],Boundary.knots = Pknots5[c(1,5)])

# Save the Basis matrices
writeMat("../Analysis/Basis/PricensBSM3.mat",Basis=PriceBS3)
writeMat("../Analysis/Basis/PricensBSM4.mat",Basis=PriceBS4)
writeMat("../Analysis/Basis/PricensBSM5.mat",Basis=PriceBS5)
