#
# D. Bunnag and M. Sun, "Genetic algorithm for constrained global optimization in continuous variables",
# Applied Mathematics and Computation, 171 (2005) 604-636
#
# Problem 15
#

param u{1..10};
param c{1..10};
param v{1..10};
param d{1..10};
param b{1..10};
param a{1..10,1..20};

var x{1..20}, >=0, <=100;

minimize fx:
    -0.5*sum{i in 1..10} (d[i]*(x[i]-u[i])^2)+0.5*sum{i in 1..10} (c[i]*(x[i+10]-v[i])^2);

subject to con {i in 1..10}:
    sum{j in 1..20} (x[j]*a[i,j])<=b[i];


data;

param u :=
1 -19
2 -27
3 -23
4 -53
5 -42
6 26
7 -33
8 -23
9 41
10 19;

param v :=
1 -52
2 -3
3 81
4 30
5 -85
6 68
7 27
8 -81
9 97
10 -73;

param d :=
1 63
2 15
3 44
4 91
5 45
6 50
7 89
8 58
9 86
10 82;

param b :=
1 380
2 415
3 385
4 405
5 470
6 415
7 400
8 460
9 400
10 200;

param c :=
1 42
2 98
3 48
4 91
5 11
6 63
7 61
8 61
9 38
10 26;

param a: 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 :=
1 3 5 5 6 4 4 5 6 4 4 8 2 4 1 1 1 2 1 7 3
2 5 4 5 4 1 4 4 2 5 2 3 6 1 7 7 5 8 7 2 1
3 1 5 2 4 7 3 1 5 7 6 1 7 2 4 7 5 3 4 1 2
4 3 2 6 3 2 1 6 1 7 3 7 7 8 2 3 4 5 8 1 2
5 6 6 6 4 5 2 2 4 3 2 7 5 3 6 7 5 8 4 6 3
6 5 5 2 1 3 5 5 7 4 3 4 1 7 3 8 3 1 6 2 8
7 3 6 6 3 1 6 1 6 7 1 4 3 1 4 3 6 4 6 5 4
8 1 2 1 7 8 7 6 5 8 7 2 3 5 5 4 5 4 2 2 8
9 8 5 2 5 3 8 1 3 3 5 4 5 5 6 1 7 1 2 2 4
10 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1;


# solution (0; 0; 0; 0; 0; 4:348; 0; 0; 0; 0; 0; 0; 0; 62:609; 0; 0; 0; 0; 0; 0) f=49318
