function [ComPrices,Com,Year,T,t,Residuals,Aobs,options,solveroptions,N,mina,maxa,r,delta] = OverallInitialization()
% OVERALLINITIALIZATION Initializes all the general parameters for the estimations

%% Load list of commodities and prices
Com = {'Banana';
       'Cocoa';
       'Coffee';
       'Copper';
       'Cotton';
       'Jute';
       'Maize';
       'Palmoil';
       'Rice';
       'Sugar';
       'Tea';
       'Tin';
       'Wheat'};

ComPrices = readtable(fullfile('..','Data','ComPrices-1900-2011.csv'),'ReadRowNames',true);
ComPrices = ComPrices(:,Com);

Year      = str2num(cell2mat(ComPrices.Properties.RowNames));
T         = length(Year);
t         = (1:1:T)'/T;
Residuals = array2table(NaN(T,length(Com)),...
                        'RowNames',ComPrices.Properties.RowNames,...
                        'VariableNames',Com);
Aobs      = Residuals;

%% Options
fminconoptions = optimoptions('fmincon'      , ...
                              'Algorithm'    , 'sqp',...
                              'DiffMinChange', eps^(1/3),...
                              'Display'      , 'iter-detailed',...
                              'FinDiffType'  , 'central',...
                              'MaxFunEvals'  , 1E4,...
                              'TolFun'       , 1e-6,...
                              'TolX'         , 1e-6,...
                              'UseParallel'  , true);

pswarmoptions = struct('CPTolerance', 1e-6,...
                       'MaxIter'    , 700,...
                       'MaxObj'     , 5E5,...
                       'Size'       , 700);

solveroptions = struct('fmincon'      , fminconoptions,...
                       'pswarm'       , pswarmoptions);

options = struct('cov'          , 2,...
                 'Display'      , 0,...
                 'estimator'    , 'UML',...
                 'InterpMethod' , 'spline',...
                 'MaxIter'      , 1E3,...
                 'ncpu'         , 8,...
                 'numhessianoptions',struct('FinDiffRelStep'  , 1E-3,...
                                            'UseParallel'     , true),...
                 'seed'         , 1,...
                 'TolX'         , 1E-10,...
                 'UseParallel'  , 'never',...
                 'Vectorized'   ,'on');
options.solver = {'PSwarm' 'fmincon'};
options.solveroptions = {pswarmoptions fminconoptions};

%% Define the grid of interpolation (equally space points)
N                  = 1000;  % number of points on the approximation grid
mina               = -2;    % lower limit of the grid
maxa               = 20;    % upper limit of the grid

r                  = 0.05;  % Interest rate assumed exogenous and fixed
delta              = 0;     % Decay rate assumed exogenous and fixed at zero
