
ComPrices = readtable(fullfile('..','Data','ComPrices-1900-2011.csv'),'ReadRowNames',true);

% ComList  = {'Copper','Cotton','Rice'};
ComList = {'Banana';
       'Cocoa';
       'Coffee';
       'Copper';
       'Cotton';
       'Jute';
       'Maize';
       'Palmoil';
       'Rice';
       'Sugar';
       'Tea';
       'Tin';
       'Wheat'};
Maize  = ComPrices.Maize;
Rice   = ComPrices.Rice;
Copper = ComPrices.Copper;
Cotton = ComPrices.Maize;

% Maize
HP4   = HPFilter(Maize,4);
HP100 =  HPFilter(Maize,100);
HP400 =  HPFilter(Maize,400);
HP4000 =  HPFilter(Maize,4000);
plot(1900:2011,[Maize HP4 HP100 HP400 HP4000])

% save('HPExamples.mat','Maize','HP4','HP100','HP400','HP4000','-v6')

% Copper, Cotton and Rice (multiplicative trend)  

% Allocate memory for the descritive statistics
Tableau  = NaN(length(ComList),8);

for i = 1: length(ComList)
    
 % Observed prices

  Pobs      = table2array(ComPrices(:,ComList{i}));

% Detrend prices (multplicative trend)
  Ptrend  =  HPFilter(log(Pobs),400);

  Psto = Pobs.*exp(-Ptrend);

  Prices(i).commodity = ComList{i};
  Prices(i).Pobs      = Pobs;
  Prices(i).Psto      = Psto;
  Prices(i).Ptrend    = exp(Ptrend);
  Tableau(i,:)        = [autocor(Pobs) std(Pobs)/mean(Pobs) skewness(Pobs')...
                         autocor(Psto) std(Psto)/mean(Psto) skewness(Psto')]; 
end
save(fullfile('..','Results','CompaHPCom.mat'),'Tableau');
save(fullfile('..','Results','HPCom.mat'),'Prices','-v6')
% Export Results

fid = fopen(fullfile('..','Article','Tables','CompaHPCom.tex'), 'w');
for i = 1:length(ComList)
  fprintf(fid,'%s',ComList{i});
  for j = 1:size(Tableau,2)
      fprintf(fid,'&%4.2f',Tableau(i,j));
  end
  fprintf(fid,'\\\\ \n');
end
fclose(fid);