function ExportResults(results,FileName,Com,nparams,pstar)

switch FileName
    case 'Linear'
   TrendParams   = {'G', 'g1' 'g2' 'g3'};
   TrendParamsSD = {'SD_G' 'SD_g1' 'SD_g2' 'SD_g3'};
   Params        = [TrendParams(1:nparams+1) {'a' 'b' 'k'}];
   ParamsSD      = [TrendParamsSD(1:nparams+1) {'SD_a' 'SD_b' 'SD_k'}];
    case {'Without','Quadratic','Cubic','RCS3','RCS4'}
        
   TrendParams   = {'g1' 'g2' 'g3'};
   TrendParamsSD = {'SD_g1' 'SD_g2' 'SD_g3'};     
   Params        = [TrendParams(1:nparams) {'a' 'b' 'k'}];
   ParamsSD      = [TrendParamsSD(1:nparams) {'SD_a' 'SD_b' 'SD_k'}];
end

if pstar
  Params = [Params {'ML' 'pstar' 'NBstockouts'}];
else
  Params = [Params {'ML' 'NBstockouts'}];
end

fid = fopen(fullfile('..','Article','Tables',[FileName '.tex']), 'w');
for i = 1:length(Com)
  fprintf(fid,'%s',Com{i});
  for j = Params
    if results{i,j{1}}==0 || strcmp(j{1},'NBstockouts')
      fprintf(fid,'&%1g',results{i,j{1}});
    else
      fprintf(fid,'&%4.4f',results{i,j{1}});
    end
  end
  fprintf(fid,'\\\\ \n');
  for j= ParamsSD
    if isnan(results{i,j{1}})
      fprintf(fid,'&--');
    else
      fprintf(fid,'&(%4.4f)',results{i,j{1}});
    end
  end
  if pstar, fprintf(fid,'&'); end
  fprintf(fid,'&&\\\\ \n');
end
fclose(fid);
