/* BOUNDSC
** Computes bounds for outcome censoring and regressor censoring, with
** external information about repeat rates.
** Optionally tabulates the results.
**
** INPUTS:  nam     5x1     variable names for cat|Dp|Sp|Dc|Sc (p previous, c current)
**          wnam    1x1     variable name for weight or ""
**          aa      1x1     lower bound on repeat rate
**          bb      1x1     upper bound on repeat rate
**          out     1x1     0 no output, 1 tabulate results
**          mthd    1x1     1 compute as in paper, else do grid search over t0,t1,t2,t7
**          verify  1x1     1 verify feasibility of bounds, else do nothing
**
** GLOBALS: data,dnam
**
** Note: If the flag "verify" is set, the procedure verifies feasibility of the
** calculated bounds; that is, that the bounds are attainable for some values
** of the unidentified parameters (the thetas). This should not be necessary.
**
*/
proc(2)=BOUNDSC(nam,wnam,aa,bb,out,mthd,verify);
local nn,dec,ncat,iicat,icat,nt,tol,tol2,tol3,t1a,t1z,t2a,t2z,ii,jj,aax,bbx,wgt,cat,Dp,Sp,Dc,Sc,cmat,xmat,tmp1,t1,t2,den,f1,f2,f3,f4,mx,lb,ub,tmp2,tmp3,t6,t8;
local i1,i2,t0a,t0z,t7a,t7z,t0,t7;
nn=rows(data); nt=101; tol=1e-4; tol2=1e-7; tol3=1e-12;
if ismiss(indcv(nam,dnam));
  "BOUNDSC-ERROR  variables not found:";
  format /rd 12,3;
  $selif(nam,indcv(nam,dnam).==miss(0,0));
  end;
endif;
if wnam$/="";
  if ismiss(indcv(wnam,dnam));
    "BOUNDSC-ERROR  weight not found:";
    format /rd 12,3;
    $wnam;
    end;
  endif;
  wgt=data[.,indcv(wnam,dnam)];
  dec=1;
else;
  dec=0;
endif;
cat=data[.,indcv(nam[1],dnam)];
Dp=data[.,indcv(nam[2],dnam)];
Sp=data[.,indcv(nam[3],dnam)];
Dc=data[.,indcv(nam[4],dnam)];
Sc=data[.,indcv(nam[5],dnam)];
cmat=unique(cat,1);
ncat=rows(cmat);
xmat=miss(zeros(ncat,9+6+3),0);
for iicat (1,ncat,1);
  icat=iicat;
  if wnam$/="";
    tmp1=(cat.==cmat[icat]).*wgt;
  else;
    tmp1=(cat.==cmat[icat]);
  endif;
  xmat[icat,1]=sumc(tmp1.*(Dp.==0)          .*(Dc.==0));
  xmat[icat,2]=sumc(tmp1.*(Dp.==0)          .*(Dc.==1));
  xmat[icat,3]=sumc(tmp1.*(Dp.==0)          .*(Dc.==1).*(Sc.==1));
  xmat[icat,4]=sumc(tmp1.*(Dp.==1).*(Sp.==1));
  xmat[icat,5]=sumc(tmp1.*(Dp.==1).*(Sp.==1).*(Dc.==1));
  xmat[icat,6]=sumc(tmp1.*(Dp.==1).*(Sp.==1).*(Dc.==1).*(Sc.==1));
  xmat[icat,7]=sumc(tmp1.*(Dp.==1).*(Sp.==0).*(Dc.==1).*(Sc.==1));
  xmat[icat,8]=sumc(tmp1.*(Dp.==1).*(Sp.==0));
  xmat[icat,9]=sumc(tmp1.*(Dp.==1).*(Sp.==0).*(Dc.==1));
  /* data info aa*: smallest bb with feasible (t1,t2) */
  xmat[icat,17]=xmat[icat,7]/(xmat[icat,8]+xmat[icat,2]-xmat[icat,3]+xmat[icat,1]);
  /* data info bb*: largest aa with feasible (t1,t2) */
  xmat[icat,18]=(xmat[icat,8]+xmat[icat,3]+xmat[icat,1]+xmat[icat,7]-xmat[icat,9])
    /(xmat[icat,8]+xmat[icat,3]+xmat[icat,1]);
  if bb<aa;
    continue;
  endif;
  aax=aa;
  bbx=bb;
    /* COMPUTE LOWER BOUND */
  t1a=0; t1z=1; t2a=0; t2z=1;
  do while abs(t1z-t1a)>tol or abs(t2z-t2a)>tol;
    if mthd==1;
      gosub ABC;
    else;
      gosub ABCDEF;
    endif;
    tmp1=reshape(t1.*ones(1,nt),nt*nt,1);
    tmp2=reshape(ones(nt,1).*t2,nt*nt,1);
    tmp3=reshape(lb,nt*nt,1);
    jj=minindc(tmp3);
    if scalmiss(tmp3[jj]);
      t1a=0; t1z=0; t2a=0; t2z=0;
    else;
      xmat[icat,10]=tmp1[jj];
      ii=indcv(tmp1[jj],t1);
      t1a=t1[maxc(1|ii-1)];
      t1z=t1[minc(nt|ii+1)];
      xmat[icat,11]=tmp2[jj];
      ii=indcv(tmp2[jj],t2');
      t2a=t2[maxc(1|ii-1)];
      t2z=t2[minc(nt|ii+1)];
      if maxc(maxc(abs(lb-lb[1,.]).>tol2))==0;
        if t1a==0 and t1z==1;
          xmat[icat,10]=2;
        endif;
        t1a=0; t1z=0;
        if t2a==0 and t2z==1;
          xmat[icat,11]=2;
        endif;
        t2a=0; t2z=0;
      endif;
      xmat[icat,12]=tmp3[jj];
    endif;
  endo;
    /* CHECK FEASIBILITY OF LOWER BOUND */
  if verify==1;
    t1=minc(1|xmat[icat,10]);
    t2=minc(1|xmat[icat,11]);
    tmp3=reshape(f3,nt*nt,1);
    t8=tmp3[jj];
    call BOUNDSC_CHECK(t1,t2,t8,aax,bbx,icat,cmat,xmat,12);
  endif;
    /* COMPUTE UPPER BOUND */
  t1a=0; t1z=1; t2a=0; t2z=1;
  do while abs(t1z-t1a)>tol or abs(t2z-t2a)>tol;
    if mthd==1;
      gosub ABC;
    else;
      gosub ABCDEF;
    endif;
    tmp1=reshape(t1.*ones(1,nt),nt*nt,1);
    tmp2=reshape(ones(nt,1).*t2,nt*nt,1);
    tmp3=reshape(ub,nt*nt,1);
    jj=maxindc(tmp3);
    if scalmiss(tmp3[jj]);
      t1a=1; t1z=1; t2a=1; t2z=1;
    else;
      xmat[icat,13]=tmp1[jj];
      ii=indcv(tmp1[jj],t1);
      t1a=t1[maxc(1|ii-1)];
      t1z=t1[minc(nt|ii+1)];
      xmat[icat,14]=tmp2[jj];
      ii=indcv(tmp2[jj],t2');
      t2a=t2[maxc(1|ii-1)];
      t2z=t2[minc(nt|ii+1)];
      if maxc(maxc(abs(ub-ub[1,.]).>tol2))==0;
        if t1a==0 and t1z==1;
          xmat[icat,13]=2;
        endif;
        t1a=1; t1z=1;
        if t2a==0 and t2z==1;
          xmat[icat,14]=2;
        endif;
        t2a=1; t2z=1;
      endif;
      xmat[icat,15]=tmp3[jj];
    endif;
  endo;
  xmat[icat,16]=missex(xmat[icat,6]/(xmat[icat,5]+(xmat[icat,5]==0)),xmat[icat,5]==0);
    /* CHECK FEASIBILITY OF UPPER BOUND */
  if verify==1;
    t1=minc(1|xmat[icat,13]);
    t2=minc(1|xmat[icat,14]);
    tmp3=reshape(f4,nt*nt,1);
    t8=tmp3[jj];
    call BOUNDSC_CHECK(t1,t2,t8,aax,bbx,icat,cmat,xmat,15);
  endif;
endfor;
if not out;
  retp(cmat,xmat);
endif;
    /* TABULATE */
?;
format /rd 8,1;
$nam';
if wnam$/="";
  tmp1=0$+"weight"|wnam; $tmp1';
endif;
format /rd 8,3;
tmp1=0$+"aa"|"bb"; $tmp1';
aa bb;
format /rd 7,1;
tmp1=0$+" cat"|"Dp=0"|"Dp=0"|"Dp=0"|"Dp=1"|"Dp=1"|"Dp=1"|"Dp=1"|"Dp=1"|"Dp=1"|" LB"|" LB"|" LB"|" UB"|" UB"|" UB"|"Prb"|"aa*"|"bb*"; $tmp1';
tmp1=0$+"    "|"    "|"    "|"    "|"Sp=1"|"Sp=1"|"Sp=1"|"Sp=0"|"Sp=0"|"Sp=0"|" t1"|" t2"|"Prb"|" t1"|" t2"|"Prb"|"ran"|"min"|"max"; $tmp1';
tmp1=0$+"    "|"Dc=0"|"Dc=1"|"Dc=1"|"    "|"Dc=1"|"Dc=1"|"Dc=1"|"    "|"Dc=1"|"   "|"   "|"   "|"   "|"   "|"   "|"cen"|" bb"|" aa"; $tmp1';
tmp1=0$+"    "|"    "|"    "|"Sc=1"|"    "|"    "|"Sc=1"|"Sc=1"|"    "|"    "|"   "|"   "|"   "|"   "|"   "|"   "|"   "|"   "|"   "; $tmp1';
for icat (1,ncat,1);
  format /rd 7,0;
  cmat[icat];;
  format /rd 7,dec;
  xmat[icat,1:9];;
  format /rd 7,1;
  xmat[icat,10:18]*100;
endfor;
retp(cmat,xmat);
        /* SUBROUTINE */
ABC:
if t1a<t1z;
  t1=seqa(t1a,(t1z-t1a)/(nt-1),nt); t1[rows(t1)]=t1z;
elseif t1a==t1z;
  t1=t1a;
else;
  "t1a>t1z"; format /re 10,1; t1a t1z; stop;
endif;
if t2a<t2z;
  t2=seqa(t2a,(t2z-t2a)/(nt-1),nt)'; t2[cols(t2)]=t2z;
elseif t2a==t2z;
  t2=t2a;
else;
  "t2a>t2z"; format /re 10,1; t2a t2z; stop;
endif;
f1=xmat[icat,8]+(1-t1)*xmat[icat,2]+(1-t2)*xmat[icat,1];
f2=xmat[icat,8]+(1-t2)*xmat[icat,1]-xmat[icat,9];
tmp1=(xmat[icat,3]/(xmat[icat,2]+(xmat[icat,2]==0))-(1-t1))./(t1+(t1.==0));
tmp1=substute(tmp1,(xmat[icat,2]==0).or(t1.==0).or(tmp1.<0),0);
f3=((xmat[icat,3]-(bbx*f1-xmat[icat,7]))/(xmat[icat,2]+(xmat[icat,2]==0)))./(t1+(t1.==0));
f3=substute(f3,(xmat[icat,2]==0).or(t1.==0),0);
f3=substute(tmp1,tmp1.<f3,f3);
tmp1=(xmat[icat,3]/(xmat[icat,2]+(xmat[icat,2]==0)))./(t1+(t1.==0));
tmp1=substute(tmp1,(xmat[icat,2]==0).or(t1.==0).or(tmp1.>1),1);
f4=((xmat[icat,3]-(aax*f1-xmat[icat,7]-f2))/(xmat[icat,2]+(xmat[icat,2]==0)))./(t1+(t1.==0));
f4=substute(f4,(xmat[icat,2]==0).or(t1.==0),1);
f4=substute(tmp1,tmp1.>f4,f4);
den=xmat[icat,4]+t1*xmat[icat,2]+t2*xmat[icat,1];
lb=(xmat[icat,6]+f3.*(t1*xmat[icat,2]))./den;
ub=(xmat[icat,6]+f4.*(t1*xmat[icat,2])+xmat[icat,4]+t2*xmat[icat,1]-xmat[icat,5])./den;
tmp1=(f3.>1).or(f4.<0).or(f3.>f4);
lb=missex(lb,tmp1); @ invalid (t1,t2), t8 out of range @
ub=missex(ub,tmp1); @ invalid (t1,t2), t8 out of range @
    /* footnote 12+13 (bounds on t6) */
tmp1=(xmat[icat,3]/(xmat[icat,2]+(xmat[icat,2]==0))-t1)./(1-t1+(t1.==1));
tmp1=substute(tmp1,(xmat[icat,2]==0).or(t1.==1).or(tmp1.<0),0);
tmp2=(aax*f1-xmat[icat,7]-f2)/(xmat[icat,2]+(xmat[icat,2]==0))./(1-t1+(t1.==1));
tmp2=substute(tmp2,(xmat[icat,2]==0).or(t1.==1).or(tmp2.<0),0);
tmp2=substute(tmp2,tmp1.>tmp2,tmp1);
tmp1=(xmat[icat,3]/(xmat[icat,2]+(xmat[icat,2]==0)))./(1-t1+(t1.==1));
tmp1=substute(tmp1,(xmat[icat,2]==0).or(t1.==1).or(tmp1.>1),1);
tmp3=(bbx*f1-xmat[icat,7])/(xmat[icat,2]+(xmat[icat,2]==0))./(1-t1+(t1.==1));
tmp3=substute(tmp3,(xmat[icat,2]==0).or(t1.==1).or(tmp3.>1),1);
tmp3=substute(tmp3,tmp1.<tmp3,tmp1);
tmp1=(tmp2.>1).or(tmp3.<0).or(tmp2.>tmp3);
lb=missex(lb,tmp1); @ invalid (t1,t2), t6 out of range @
ub=missex(ub,tmp1); @ invalid (t1,t2), t6 out of range @
    /* xmat[icat,2]=0 (implies xmat[icat,3]=0) */
tmp2=(bbx*f1).<(xmat[icat,7]+xmat[icat,3]+0*f2); @ -t8*t1*xmat[icat,2] @
tmp3=(aax*f1).>(xmat[icat,7]+xmat[icat,3]+1*f2);
tmp1=(xmat[icat,2]==0).and((tmp2.==1).or(tmp3.==1));
lb=missex(lb,tmp1); @ invalid (t1,t2), t0 out of range @
ub=missex(ub,tmp1); @ invalid (t1,t2), t0 out of range @
    /* final check */
tmp1=lb-ub;
if sumc(sumc(tmp1.>tol2));
  "BOUNDSC-ERROR  lb.>ub problem";
  format /rd 12,0; sumc(sumc(tmp1.>tol2));
  format /re 10,1; minc(minc(lb-ub)) maxc(maxc(lb-ub));
  @stop;@
endif;
return;
ABCDEF:
t0a=aax; t0z=bbx; t7a=0; t7z=1;
t0=seqa(t0a,(t0z-t0a)/(nt-1),nt); t0[rows(t0)]=t0z;
if t1a<t1z;
  t1=seqa(t1a,(t1z-t1a)/(nt-1),nt); t1[rows(t1)]=t1z;
elseif t1a==t1z;
  t1=t1z;
else;
  "t1a>t1z"; format /re 10,1; t1a t1z; stop;
endif;
if t2a<t2z;
  t2=seqa(t2a,(t2z-t2a)/(nt-1),nt)'; t2[cols(t2)]=t2z;
elseif t2a==t2z;
  t2=t2a;
else;
  "t2a>t2z"; format /re 10,1; t2a t2z; stop;
endif;
t7=seqa(t7a,(t7z-t7a)/(nt-1),nt); t7[rows(t7)]=t7z;
mx=zeros(nt,nt);
f3=zeros(nt,nt);
f4=ones(nt,nt);
if xmat[icat,2]>0; @ no information in (2) otherwise @
  i1=0; do while i1<rows(t1); i1=i1+1;
    if t1[i1]==0;
      @ t6=(xmat[icat,3]/xmat[icat,2]), t8=any, solve eqn (4) for t0 @
      f1=xmat[icat,8]+(1-t1[i1])*xmat[icat,2]+(1-t2)*xmat[icat,1];
      f2=xmat[icat,8]+(1-t2)*xmat[icat,1]-xmat[icat,9];
      tmp1=xmat[icat,3]+xmat[icat,7]+t7*f2; @ t0*f1 @
      tmp1=(aax*f1.<=tmp1).and(tmp1.<=f1*bbx);
      mx[i1,.]=maxc(tmp1)'.==0; @ no value of t0 within bounds @
    else;
      @ solve eqns (2), (4) for t8 @
      tmp1=((xmat[icat,3]/xmat[icat,2])-(1-t1[i1]))./t1[i1];
      tmp2=(xmat[icat,3]/xmat[icat,2])./t1[i1];
      i2=0; do while i2<cols(t2); i2=i2+1;
        f1=xmat[icat,8]+(1-t1[i1])*xmat[icat,2]+(1-t2[i2])*xmat[icat,1];
        f2=xmat[icat,8]+(1-t2[i2])*xmat[icat,1]-xmat[icat,9];
        tmp3=(xmat[icat,3]-t0*f1+xmat[icat,7]+t7'*f2)./(t1[i1]*xmat[icat,2]);
        tmp3=reshape(tmp3,nt*nt,1);
        f3[i1,i2]=maxc(0|tmp1|minc(tmp3));
        f4[i1,i2]=minc(1|tmp2|maxc(tmp3));
      endo;
    endif;
  endo;
  mx=substute(mx,(f3.>1).or(f4.<0).or(f3.>f4),1);
else;
  @ solve eqn (4) for t0, sort of (xmat[icat,2]=0 implies xmat[icat,3]=0) @
  f1=xmat[icat,8]+(1-t1)*xmat[icat,2]+(1-t2)*xmat[icat,1];
  f2=xmat[icat,8]+(1-t2)*xmat[icat,1]-xmat[icat,9];
  tmp1=xmat[icat,3]+xmat[icat,7]; @ lower bound on t0*f1 (t7=0) @
  tmp2=xmat[icat,3]+xmat[icat,7]+f2; @ upper bound on t0*f1 (t7=1) @
  mx=(aax*f1.>tmp2).or(bbx*f1.<tmp1); @ no value of t0 within bounds @
endif;
den=xmat[icat,4]+t1*xmat[icat,2]+t2*xmat[icat,1];
lb=(xmat[icat,6]+f3.*(t1*xmat[icat,2]))./den;
ub=(xmat[icat,6]+f4.*(t1*xmat[icat,2])+xmat[icat,4]+t2*xmat[icat,1]-xmat[icat,5])./den;
lb=missex(lb,mx); @ invalid (t1,t2) @
ub=missex(ub,mx); @ invalid (t1,t2) @
    /* final check */
tmp1=lb-ub;
if sumc(sumc(tmp1.>tol2));
  "BOUNDSC-ERROR [D]  lb.>ub problem";
  format /rd 12,0; sumc(sumc(tmp1.>tol2));
  format /re 10,1; minc(minc(lb-ub)) maxc(maxc(lb-ub));
  @stop;@
endif;
return;
endp;

proc(1)=BOUNDSC_CHECK(t1,t2,t8,aa,bb,icat,cmat,xmat,pnt);
local tol2,nt,err,t7,f1,f2,tmp,ii;
tol2=1e-7; nt=201;
err=0;
if xmat[icat,2]>0;
  tmp=xmat[icat,3]/xmat[icat,2]-t8*t1; @ t6*(1-t1) @
  if tmp<0 or tmp>1-t1;
    err=err+1;
    if not scalmiss(xmat[icat,pnt]);
      "BOUNDSC_CHECK-ERROR  Eqn (2) violated (x2>0)           ";;
      format /rd 6,0; icat cmat[icat];;
      format /rd 8,4; t1 t2 t8 aa bb;
    endif;
  endif;
endif;
t7=seqa(0,1/(nt-1),nt); t7[rows(t7)]=1;
f1=xmat[icat,8]+(1-t1)*xmat[icat,2]+(1-t2)*xmat[icat,1];
f2=xmat[icat,8]+(1-t2)*xmat[icat,1]-xmat[icat,9];
tmp=xmat[icat,7]+xmat[icat,3]-t8*t1*xmat[icat,2]+t7*f2; @ t0*f1 @
ii=sumc((0*f1.<=tmp+(1e-12)).and(tmp-(1e-12).<=1*f1));
if ii==0 and not scalmiss(xmat[icat,pnt]);
  err=err+2;
  if not scalmiss(xmat[icat,pnt]);
    "BOUNDSC_CHECK-ERROR  Eqn (4) violated (not 0<=t0<=1)   ";;
    format /rd 6,0; icat cmat[icat];;
    format /rd 8,4; t1 t2 t8 aa bb minc(minc(tmp/f1)) maxc(maxc(tmp/f1));
    format /rd 8,1; f1 minc(minc(tmp)) maxc(maxc(tmp));
  endif;
else;
  ii=sumc((aa*f1.<=tmp+(1e-12)).and(tmp-(1e-12).<=bb*f1));
  if ii==0;
    err=err+4;
    if not scalmiss(xmat[icat,pnt]);
      "BOUNDSC_CHECK-ERROR  Eqn (4) violated (not aa<=t0<=bb)   ";;
      format /rd 6,0; icat cmat[icat];;
      format /re 12,3; t1 t2 t8 aa bb minc(minc(tmp/f1)) maxc(maxc(tmp/f1));;
      format /rd 8,1; f1 minc(minc(tmp)) maxc(maxc(tmp));
    endif;
  endif;
endif;
if scalmiss(xmat[icat,pnt]) and err==0;
  "BOUNDSC_CHECK-ERROR  bound is missing, but shouldn't be!?";;
  format /rd 6,0; icat cmat[icat];;
  format /rd 8,4; t1 t2 t8 aa bb minc(minc(tmp/f1)) maxc(maxc(tmp/f1));;
  format /rd 8,1; f1 minc(minc(tmp)) maxc(maxc(tmp));
  err=err+8;
endif;
retp(err);
endp;
