clear
clear mata
capture: clear matrix
set memory 20m
cap log close
set more off
cd "C:\Stata\Yogo"  /* Folder where data is stored and where the log file will be saved */
log using "yogo_2004_Restat_replication_$S_DATE.log", replace /* Start Log File */

/* Paper Yogo Restat 2004 replication */
/* Data available at http://www.nber.org/~myogo/data/EIS_Data.zip */

/* Convergence of GMM estimators */
/* There are 4 cases of no convergence: SWTQ  with instrument set 7   */
/* 										USAQ2 with instrument set 9	 */
/* 										AULQ  with instrument set 10 */
/* 										USAY  with instrument set 12 */
/* These computations are not conducted here. If you want to conduct them, */
/* change the value of the scalar convergenceonly from 1 to 0 */

scalar convergenceonly = 1


/* Values for 2 instruments */
local country USAQ AULQ CANQ FRQ GERQ ITAQ JAPQ NTHQ SWDQ SWTQ UKQ USAQ2 SWDY UKY USAY 
set maxiter 1500

/* The following used in calculating the tests reported in Column 1 come from Yogo(2004) */

forvalues u=1(1)12{    /* Instruments loop */
scalar tslsbias = 0  /* Not defined */
scalar tslssize = 10.468612
scalar biasfullerk = 4.1656215
scalar sizeliml = 2.7867807

	if `u'==1{
		local instruments z1 z2 z3 z4  /* Original Yogo (2004) instruments */
		scalar tslsbias = 5.0281002
		scalar tslssize = 16.414252
		scalar biasfullerk = 2.2803846 
		scalar sizeliml =  1.6763210
	}
	if `u'==2{
		local instruments z1 z2 z3 /* Combinations of Yogo Instruments */
		/* Values for 3 instruments */
		scalar tslsbias = 3.7064013
		scalar tslssize = 13.633026
		scalar biasfullerk = 2.9224748
		scalar sizeliml = 2.0086330 
	}
	if `u'==3{
		local instruments z1 z2 z4 /* Combinations of Yogo Instruments */
		/* Values for 3 instruments */
		scalar tslsbias = 3.7064013
		scalar tslssize = 13.633026
		scalar biasfullerk = 2.9224748
		scalar sizeliml = 2.0086330 
	}
	if `u'==4{
		local instruments z1 z3 z4 /* Combinations of Yogo Instruments */
		/* Values for 3 instruments */
		scalar tslsbias = 3.7064013
		scalar tslssize = 13.633026
		scalar biasfullerk = 2.9224748
		scalar sizeliml = 2.0086330 
	}
	if `u'==5{
		local instruments z2 z3 z4  /* Combinations of Yogo Instruments */
		/* Values for 3 instruments */
		scalar tslsbias = 3.7064013
		scalar tslssize = 13.633026
		scalar biasfullerk = 2.9224748
		scalar sizeliml = 2.0086330 
	}
	if `u'==6{ 				/* Campbell (2003) instruments */
		local instruments z1 z4 z5   
		/* Values for 3 instruments */
		scalar tslsbias = 3.7064013
		scalar tslssize = 13.633026
		scalar biasfullerk = 2.9224748
		scalar sizeliml = 2.0086330 
	}
	if `u'==7{
		local instruments z1 z2  /* Combinations of Yogo Instruments */
	}
	if `u'==8{
		local instruments z1 z3 /* Combinations of Yogo Instruments */
	}
	if `u'==9{
		local instruments z1 z4  /* Combinations of Yogo Instruments */
	}
	if `u'==10{
		local instruments z2 z3  /* Combinations of Yogo Instruments */
	}
	if `u'==11{
		local instruments z2 z4 /* Combinations of Yogo Instruments */
	}
	if `u'==12{
		local instruments z3 z4 /* Combinations of Yogo Instruments */
	}
	
	
	foreach d of local country {
		quiet{ 
			if "`d'" == "USAQ2" {
				insheet using USAQ.txt, clear /* Import data to be used */
			drop if date <1970.3 
			}
			else{
				local file "`d'.txt"
				insheet using `file', clear /* Import data to be used */
			}
		
			generate z5 = z2-z3 /* Campbell (2004) real interest rate instrument */
	
			/* table 2 - EIS estimates - 1/Psi */
		
			ivreg2 rrf (dc = `instruments'), first		
			/* Estimated coefficient and std error goes on table 2 */
			/*The following statistics go on Table 1 for rf */
			/* F-statistc from 1st stage estimate, and  */
			scalar inv_psi_rf_TSLS_`d'_`u' = _b[dc]
			scalar seinv_psi_rf_TSLS_`d'_`u' = _se[dc]
			scalar F_rf_`d'_`u' = e(widstat)
			scalar rf_dof = e(ardf)
			scalar p_tsls_bias_rf_`d'_`u' = 1-nchi2(rf_dof, rf_dof*tslsbias, F_rf_`d'_`u'*rf_dof)  
			scalar p_tsls_size_rf_`d'_`u' = 1-nchi2(rf_dof, rf_dof*tslssize, F_rf_`d'_`u'*rf_dof)
			scalar sargan_rf_`d'_`u'   = e(sargan)
			scalar sarganp_rf_`d'_`u'  = e(sarganp)

			ivreg2 rrf (dc = `instruments'), first fuller(1)	
			scalar inv_psi_rf_fuller_`d'_`u' = _b[dc]
			scalar seinv_psi_rf_fuller_`d'_`u' = _se[dc]
			scalar rrf_f = e(widstat)
			scalar rrf_dof = e(ardf)
			scalar p_fuller_bias_rf_`d'_`u' = 1-nchi2(rrf_dof, rrf_dof*biasfullerk , rrf_f*rrf_dof)
			scalar sargan_fuller_rf_`d'_`u' = e(sargan)
			scalar sarganp_fuller_rf_`d'_`u' = e(sarganp)
			
			ivreg2 rrf (dc = `instruments'), first liml		
			scalar inv_psi_rf_liml_`d'_`u' = _b[dc]
			scalar seinv_psi_rf_liml_`d'_`u' = _se[dc]
			scalar rrf_f = e(widstat)
			scalar rrf_dof = e(ardf)
			scalar p_LIML_bias_rf_`d'_`u' = 1-nchi2(rrf_dof, rrf_dof*sizeliml, rrf_f*rrf_dof)
			scalar sargan_liml_rrf_`d'_`u' = e(sargan)
			scalar sarganp_liml_rrf_`d'_`u' = e(sarganp)
			
			/* Table 2 - psi estimates */
			ivreg2 dc (rrf  = `instruments'), first		
			scalar psi_rf_TSLS_`d'_`u' = _b[rrf]
			scalar se_psi_rf_TSLS_`d'_`u' = _se[rrf]
			scalar F_dc_`d'_`u' = e(widstat)
			scalar dc_dof = e(ardf)
			scalar p_tsls_bias_dc_`d'_`u' = 1-nchi2(dc_dof, dc_dof*tslsbias, F_dc_`d'_`u'*dc_dof)
			scalar p_tsls_size_dc_`d'_`u' = 1-nchi2(dc_dof, dc_dof*tslssize, F_dc_`d'_`u'*dc_dof)
			scalar sargan_dc_`d'_`u'   = e(sargan)
			scalar sarganp_dc_`d'_`u'  = e(sarganp)

			ivreg2 dc (rrf  = `instruments'), first fuller(1)	
			scalar psi_rf_fuller_`d'_`u' = _b[rrf]
			scalar se_psi_rf_fuller_`d'_`u' = _se[rrf]
			scalar dc_f = e(widstat)
			scalar dc_dof = e(ardf)
			scalar p_fuller_bias_dc_`d'_`u' = 1-nchi2(dc_dof, dc_dof*biasfullerk , dc_f*dc_dof)
			scalar sargan_fuller_dc_`d'_`u'   = e(sargan)
			scalar sarganp_fuller_dc_`d'_`u'  = e(sarganp)
			

			ivreg2 dc (rrf  = `instruments'), first liml	
			scalar psi_rf_liml_`d'_`u' = _b[rrf]
			scalar se_psi_rf_liml_`d'_`u' = _se[rrf]
			scalar dc_f = e(widstat)
			scalar dc_dof = e(ardf)
			scalar p_liml_bias_dc_`u'_`d' = 1-nchi2(dc_dof, dc_dof*sizeliml, dc_f*dc_dof)
			scalar sargan_liml_dc_`d'_`u' = e(sargan)
			scalar sarganp_liml_dc_`d'_`u' = e(sarganp)
		
			
			/* Table 4 - EIS estimates using stock return */
			/*1/psi */

			ivreg2 rr (dc = `instruments'), first		/* TSLS - Similar coefficient, slightly different stderror */
			scalar invpsi_dc_rr_TSLS_`d'_`u' = _b[dc]
			scalar se_invpsi_dc_rr_TSLS_`d'_`u' = _se[dc]
			scalar sargan_rrdc_`d'_`u'   = e(sargan)
			scalar sarganp_rrdc_`d'_`u'  = e(sarganp)
						
			ivreg2 rr (dc = `instruments'), first fuller(1)	/* Fuller-k - Similar coefficient, slightly different stderror */
			scalar invpsi_dc_rr_fuller_`d'_`u' = _b[dc]
			scalar se_invpsi_dc_rr_fuller_`d'_`u' = _se[dc]
			scalar sargan_rrdc_fuller_`d'_`u' = e(sargan)
			scalar sarganp_rrdc_fuller_`d'_`u' = e(sarganp)
					
			ivreg2 rr (dc = `instruments'), first liml		/* LIML - Similar coefficient, slightly different stderror */
			scalar invpsi_dc_rr_liml_`d'_`u' = _b[dc]
			scalar se_invpsi_dc_rr_liml_`d'_`u' = _se[dc]
			scalar sargan_rrdc_liml_`d'_`u' = e(sargan)
			scalar sarganp_rrdc_liml_`d'_`u' = e(sarganp)
			
			/* psi */

			ivreg2 dc (rr  = `instruments'), first		
			scalar psi_rr_TSLS_`d'_`u' = _b[rr]
			scalar se_psi_rr_TSLS_`d'_`u' = _se[rr]
			scalar F_rr_`d'_`u' = e(widstat)
			scalar rr_dof = e(ardf)
			scalar p_tsls_bias_rr_`d'_`u' = 1-nchi2(rr_dof, rr_dof*tslsbias, F_rr_`d'_`u'*rr_dof)
			scalar p_tsls_size_rr_`d'_`u' = 1-nchi2(rr_dof, rr_dof*tslssize, F_rr_`d'_`u'*rr_dof)
			scalar sargan_rr_`d'_`u'   = e(sargan)
			scalar sarganp_rr_`d'_`u'  = e(sarganp)
					
			ivreg2 dc (rr  = `instruments'), first fuller(1)	
			scalar psi_rr_fuller_`d'_`u' = _b[rr]
			scalar se_psi_rr_fuller_`d'_`u' = _se[rr]
			scalar dc_f = e(widstat)
			scalar dc_dof = e(ardf)
			scalar p_fuller_bias_rr_`d'_`u' = 1-nchi2(dc_dof, dc_dof*biasfullerk , dc_f*dc_dof)
			scalar sargan_rr_fuller_`d'_`u' = e(sargan)
			scalar sarganp_rr_fuller_`d'_`u' = e(sarganp)
		
			ivreg2 dc (rr  = `instruments'), first liml	
			scalar psi_rr_liml_`d'_`u' = _b[rr]
			scalar se_psi_rr_liml_`d'_`u' = _se[rr]
			scalar dc_f = e(widstat)
			scalar dc_dof = e(ardf)
			scalar p_liml_bias_rr_`d'_`u' = 1-nchi2(dc_dof, dc_dof*sizeliml, dc_f*dc_dof)
			scalar sargan_rr_liml_`d'_`u' = e(sargan)
			scalar sarganp_rr_liml_`d'_`u' = e(sarganp)
					
	
			/* Table 6 */
			/* Convergence only decision */
			scalar decision = 1
			if ("`d'"=="AULQ" & `u'==10){
				scalar decision = 0
			}
			if ("`d'"=="USAQ2" & `u'==9){
				scalar decision = 0
			}
			if ("`d'"=="SWTQ" & `u'==7){
				scalar decision = 0
			}
			if ("`d'"=="USAY" & `u'==12){
				scalar decision = 0
			}				
			
			if convergenceonly==0{
				/* interest rate */
				ivreg2 dc (rrf  = `instruments'), gmm2s robust	
				scalar psi_rf_gmm_`d'_`u' = _b[rr]
				scalar se_psi_rf_gmm_`d'_`u' = _se[rr]
				scalar J_rf_gmm_`d'_`u' = e(j)
				scalar Jp_rf_gmm_`d'_`u' = e(jp) 
				
				ivreg2 dc (rrf  = `instruments'), cue robust	/* CUE - similar to paper */
				scalar psi_rf_cue_`d'_`u' = _b[rr]
				scalar se_psi_cue_gmm_`d'_`u' = _se[rr]
				scalar J_cue_gmm_`d'_`u' = e(j)
				scalar Jp_cue_gmm_`d'_`u' = e(jp) 
				
			
				/* Interest rate and stock return */
				gmm (dc - {b1}*rrf - {b0}) (dc - {b1}*rr - {b2}), instruments(`instruments') winitial(identity) twostep wmatrix(robust)  conv_maxiter(300)  
				scalar psi_rfrr_gmm_`d'_`u' = _b[/b1]
				scalar se_psi_rfrr_gmm_`d'_`u' = _se[/b1]
				scalar J_rfrr_gmm_`d'_`u' = e(J)
				scalar Jdof_rfrr_gmm_`d'_`u' = e(J_df)
				scalar Jp_rfrr_gmm_`d'_`u' = chi2tail(Jdof_rfrr_gmm_`d'_`u', J_rfrr_gmm_`d'_`u') 
						
				gmm (dc - {b1}*rrf - {b0}) (dc - {b1}*rr - {b2}), instruments(`instruments') winitial(identity) igmm wmatrix(robust) igmmeps(0.001) conv_maxiter(300)
				scalar psi_rfrr_cue_`d'_`u' = _b[/b1]
				scalar se_psi_rfrr_cue_`d'_`u' = _se[/b1]
				scalar J_rfrr_cue_`d'_`u' = e(J)
				scalar Jdof_rfrr_cue_`d'_`u' = e(J_df)
				scalar Jp_rfrr_cue_`d'_`u' = chi2tail(Jdof_rfrr_cue_`d'_`u', J_rfrr_cue_`d'_`u') 
			}
			else {
				if (convergenceonly==1 & decision==0) {
					scalar psi_rf_gmm_`d'_`u' = .
					scalar se_psi_rf_gmm_`d'_`u' = .
					scalar J_rf_gmm_`d'_`u' = .
					scalar Jp_rf_gmm_`d'_`u' = .
					scalar psi_rf_cue_`d'_`u' = .
					scalar se_psi_cue_gmm_`d'_`u' = .
					scalar J_cue_gmm_`d'_`u' = .
					scalar Jp_cue_gmm_`d'_`u' = .
					scalar psi_rfrr_gmm_`d'_`u' = .
					scalar se_psi_rfrr_gmm_`d'_`u' = .
					scalar J_rfrr_gmm_`d'_`u' = .
					scalar Jdof_rfrr_gmm_`d'_`u' = .
					scalar Jp_rfrr_gmm_`d'_`u' = .
					scalar psi_rfrr_cue_`d'_`u' = .
					scalar se_psi_rfrr_cue_`d'_`u' = .
					scalar J_rfrr_cue_`d'_`u' = .
					scalar Jdof_rfrr_cue_`d'_`u' = .
					scalar Jp_rfrr_cue_`d'_`u' = .
				}
				if (convergenceonly==1 & decision==1){ 
					/* interest rate */
					ivreg2 dc (rrf  = `instruments'), gmm2s robust	
					scalar psi_rf_gmm_`d'_`u' = _b[rr]
					scalar se_psi_rf_gmm_`d'_`u' = _se[rr]
					scalar J_rf_gmm_`d'_`u' = e(j)
					scalar Jp_rf_gmm_`d'_`u' = e(jp) 
				
					ivreg2 dc (rrf  = `instruments'), cue robust	/* CUE - similar to paper */
					scalar psi_rf_cue_`d'_`u' = _b[rr]
					scalar se_psi_cue_gmm_`d'_`u' = _se[rr]
					scalar J_cue_gmm_`d'_`u' = e(j)
					scalar Jp_cue_gmm_`d'_`u' = e(jp) 
			
					/* Interest rate and stock return */
					gmm (dc - {b1}*rrf - {b0}) (dc - {b1}*rr - {b2}), instruments(`instruments') winitial(identity) twostep wmatrix(robust)  
					scalar psi_rfrr_gmm_`d'_`u' = _b[/b1]
					scalar se_psi_rfrr_gmm_`d'_`u' = _se[/b1]
					scalar J_rfrr_gmm_`d'_`u' = e(J)
					scalar Jdof_rfrr_gmm_`d'_`u' = e(J_df)
					scalar Jp_rfrr_gmm_`d'_`u' = chi2tail(Jdof_rfrr_gmm_`d'_`u', J_rfrr_gmm_`d'_`u') 
							
					gmm (dc - {b1}*rrf - {b0}) (dc - {b1}*rr - {b2}), instruments(`instruments') winitial(identity) igmm wmatrix(robust) igmmeps(0.001) 
					scalar psi_rfrr_cue_`d'_`u' = _b[/b1]
					scalar se_psi_rfrr_cue_`d'_`u' = _se[/b1]
					scalar J_rfrr_cue_`d'_`u' = e(J)
					scalar Jdof_rfrr_cue_`d'_`u' = e(J_df)
					scalar Jp_rfrr_cue_`d'_`u' = chi2tail(Jdof_rfrr_cue_`d'_`u', J_rfrr_cue_`d'_`u') 			
				}	
			} 
			/* Build Tables */
			if `u'< 7 {
				if "`d'"=="USAQ" {
					/* Table 1 */
					matrix table1_`u' = (F_rf_`d'_`u', p_tsls_bias_rf_`d'_`u', p_tsls_size_rf_`d'_`u', p_fuller_bias_rf_`d'_`u', p_LIML_bias_rf_`d'_`u' \  ///
						F_dc_`d'_`u' , p_tsls_bias_dc_`d'_`u', p_tsls_size_dc_`d'_`u', p_fuller_bias_dc_`d'_`u', p_liml_bias_dc_`u'_`d' \ ///
						F_rr_`d'_`u' , p_tsls_bias_rr_`d'_`u', p_tsls_size_rr_`d'_`u', p_fuller_bias_rr_`d'_`u', p_liml_bias_rr_`d'_`u')		
				}
				else {
					matrix table1_`u' = (table1_`u' \ F_rf_`d'_`u', p_tsls_bias_rf_`d'_`u', p_tsls_size_rf_`d'_`u', p_fuller_bias_rf_`d'_`u', p_LIML_bias_rf_`d'_`u' \  ///
						F_dc_`d'_`u' , p_tsls_bias_dc_`d'_`u', p_tsls_size_dc_`d'_`u', p_fuller_bias_dc_`d'_`u', p_liml_bias_dc_`u'_`d' \ ///
						F_rr_`d'_`u' , p_tsls_bias_rr_`d'_`u', p_tsls_size_rr_`d'_`u', p_fuller_bias_rr_`d'_`u', p_liml_bias_rr_`d'_`u')		
				}
			}
			else {
				if "`d'"=="USAQ" {
					/* Table 1 */
					matrix table1_`u' = (F_rf_`d'_`u', . , p_tsls_size_rf_`d'_`u', p_fuller_bias_rf_`d'_`u', p_LIML_bias_rf_`d'_`u' \  ///
						F_dc_`d'_`u' , . , p_tsls_size_dc_`d'_`u', p_fuller_bias_dc_`d'_`u', p_liml_bias_dc_`u'_`d' \ ///
						F_rr_`d'_`u' , . , p_tsls_size_rr_`d'_`u', p_fuller_bias_rr_`d'_`u', p_liml_bias_rr_`d'_`u')		
					matrix colnames table1_`u' = F TSLSBias TSLSsize Fullerk LIML
				}
				else {
						matrix table1_`u' = (table1_`u' \ F_rf_`d'_`u', . , p_tsls_size_rf_`d'_`u', p_fuller_bias_rf_`d'_`u', p_LIML_bias_rf_`d'_`u' \  ///
							F_dc_`d'_`u' , . , p_tsls_size_dc_`d'_`u', p_fuller_bias_dc_`d'_`u', p_liml_bias_dc_`u'_`d' \ ///
							F_rr_`d'_`u' , . , p_tsls_size_rr_`d'_`u', p_fuller_bias_rr_`d'_`u', p_liml_bias_rr_`d'_`u')		
				}
			}	
				 	
			if "`d'"=="USAQ" {
				/* Table 2 */
				matrix table2_`u' = ( inv_psi_rf_TSLS_`d'_`u', inv_psi_rf_fuller_`d'_`u', inv_psi_rf_liml_`d'_`u', psi_rf_TSLS_`d'_`u', psi_rf_fuller_`d'_`u', psi_rf_liml_`d'_`u' \  /// 
					seinv_psi_rf_TSLS_`d'_`u', seinv_psi_rf_fuller_`d'_`u', seinv_psi_rf_liml_`d'_`u', se_psi_rf_TSLS_`d'_`u' , se_psi_rf_fuller_`d'_`u' , se_psi_rf_liml_`d'_`u' )
				matrix colnames table2_`u' = TSLS Fullerk LIML Psi_TSLS Psi_Fullerk Psi_LIML
				matrix rownames table2_`u' = Coefficient SE	

				/* Table 4 */
				matrix table4_`u' = ( invpsi_dc_rr_TSLS_`d'_`u', invpsi_dc_rr_fuller_`d'_`u', invpsi_dc_rr_liml_`d'_`u' , psi_rr_TSLS_`d'_`u' , psi_rr_fuller_`d'_`u', psi_rr_liml_`d'_`u' \  /// 
					se_invpsi_dc_rr_TSLS_`d'_`u', se_invpsi_dc_rr_fuller_`d'_`u', se_invpsi_dc_rr_liml_`d'_`u' ,se_psi_rr_TSLS_`d'_`u', se_psi_rr_fuller_`d'_`u', se_psi_rr_liml_`d'_`u')
				matrix colnames table4_`u' = TSLS Fullerk LIML Psi_TSLS Psi_Fullerk Psi_LIML
				matrix rownames table4_`u' = Coefficient SE

				/* Table 6 */
				
				matrix table6_`u' = ( psi_rf_gmm_`d'_`u', psi_rf_cue_`d'_`u', psi_rfrr_gmm_`d'_`u', psi_rfrr_cue_`d'_`u' \  ///
					se_psi_rf_gmm_`d'_`u', se_psi_cue_gmm_`d'_`u', se_psi_rfrr_gmm_`d'_`u', se_psi_rfrr_cue_`d'_`u' )
				matrix colnames table6_`u' = IR_GMM IR_CUE IRSR_GMM IR_SR_CUE
				matrix rownames table6_`u' = Coefficient SE
					
				/* Table 2 - Overidentification */
				matrix table2_overid_`u' = ( sargan_rf_`d'_`u',sargan_fuller_rf_`d'_`u' , sargan_liml_rrf_`d'_`u', sargan_dc_`d'_`u', sargan_fuller_dc_`d'_`u' , sargan_liml_dc_`d'_`u'  \ ///
					 sarganp_rf_`d'_`u',sarganp_fuller_rf_`d'_`u' , sarganp_liml_rrf_`d'_`u', sarganp_dc_`d'_`u',sarganp_fuller_dc_`d'_`u' ,sarganp_liml_dc_`d'_`u'  )
				matrix colnames table2_overid_`u' = TSLS Fullerk LIML Psi_TSLS Psi_Fullerk Psi_LIML	 
				matrix rownames table2_overid_`u' = Statistic p_value
					
				/* Table 4 - Overidentification */
				matrix table4_overid_`u' = (sargan_rrdc_`d'_`u', sargan_rrdc_fuller_`d'_`u',sargan_rrdc_liml_`d'_`u', sargan_rr_`d'_`u', sargan_rr_fuller_`d'_`u', sargan_rr_liml_`d'_`u' \ sarganp_rrdc_`d'_`u', ///
					sarganp_rrdc_fuller_`d'_`u', sarganp_rrdc_liml_`d'_`u',sarganp_rr_`d'_`u', sarganp_rr_fuller_`d'_`u', sarganp_rr_liml_`d'_`u' )
				matrix colnames table4_overid_`u' = TSLS Fullerk LIML Psi_TSLS Psi_Fullerk Psi_LIML	 
				matrix rownames table4_overid_`u' = Statistic p_value
				
				/* Table 6 - Overidentification */
				matrix table6_overid_`u' = (J_rf_gmm_`d'_`u', J_cue_gmm_`d'_`u', J_rfrr_gmm_`d'_`u',J_rfrr_cue_`d'_`u'\ ///
					 Jp_rf_gmm_`d'_`u',Jp_cue_gmm_`d'_`u', Jp_rfrr_gmm_`d'_`u', Jp_rfrr_cue_`d'_`u')	
				matrix colnames table6_overid_`u' = IR_GMM IR_CUE IRSR_GMM IR_SR_CUE
				matrix rownames table6_overid_`u' = J_statistic p_value
			}
			else{				
						 		
				/* Table 2 */
				matrix table2_`u' = ( table2_`u' \ inv_psi_rf_TSLS_`d'_`u', inv_psi_rf_fuller_`d'_`u', inv_psi_rf_liml_`d'_`u', psi_rf_TSLS_`d'_`u', psi_rf_fuller_`d'_`u', psi_rf_liml_`d'_`u' \  /// 
					seinv_psi_rf_TSLS_`d'_`u', seinv_psi_rf_fuller_`d'_`u', seinv_psi_rf_liml_`d'_`u', se_psi_rf_TSLS_`d'_`u' , se_psi_rf_fuller_`d'_`u' , se_psi_rf_liml_`d'_`u' )
		
				/* Table 4 */
				matrix table4_`u' = ( table4_`u' \ invpsi_dc_rr_TSLS_`d'_`u', invpsi_dc_rr_fuller_`d'_`u', invpsi_dc_rr_liml_`d'_`u' , psi_rr_TSLS_`d'_`u' , psi_rr_fuller_`d'_`u', psi_rr_liml_`d'_`u' \  /// 
					se_invpsi_dc_rr_TSLS_`d'_`u', se_invpsi_dc_rr_fuller_`d'_`u', se_invpsi_dc_rr_liml_`d'_`u' ,se_psi_rr_TSLS_`d'_`u', se_psi_rr_fuller_`d'_`u', se_psi_rr_liml_`d'_`u')		
		
				/* Table 6 */
				matrix table6_`u' = ( table6_`u' \ psi_rf_gmm_`d'_`u', psi_rf_cue_`d'_`u', psi_rfrr_gmm_`d'_`u', psi_rfrr_cue_`d'_`u' \  ///
					se_psi_rf_gmm_`d'_`u', se_psi_cue_gmm_`d'_`u', se_psi_rfrr_gmm_`d'_`u', se_psi_rfrr_cue_`d'_`u' )
		
				/* Table 2 - Overidentification */
				
				matrix table2_overid_`u' = ( table2_overid_`u' \ sargan_rf_`d'_`u',sargan_fuller_rf_`d'_`u' , sargan_liml_rrf_`d'_`u', sargan_dc_`d'_`u', sargan_fuller_dc_`d'_`u' , sargan_liml_dc_`d'_`u'  \ ///
					sarganp_rf_`d'_`u',sarganp_fuller_rf_`d'_`u' , sarganp_liml_rrf_`d'_`u', sarganp_dc_`d'_`u',sarganp_fuller_dc_`d'_`u' ,sarganp_liml_dc_`d'_`u'  )
		
				/* Table 4 - Overidentification */
				matrix table4_overid_`u' = (table4_overid_`u' \ sargan_rrdc_`d'_`u', sargan_rrdc_fuller_`d'_`u',sargan_rrdc_liml_`d'_`u', sargan_rr_`d'_`u', sargan_rr_fuller_`d'_`u', sargan_rr_liml_`d'_`u' \ ///
					sarganp_rrdc_`d'_`u',sarganp_rrdc_fuller_`d'_`u', sarganp_rrdc_liml_`d'_`u',sarganp_rr_`d'_`u', sarganp_rr_fuller_`d'_`u', sarganp_rr_liml_`d'_`u' )

				/* Table 6 - Overidentification */
				matrix table6_overid_`u' = (table6_overid_`u' \ J_rf_gmm_`d'_`u', J_cue_gmm_`d'_`u', J_rfrr_gmm_`d'_`u',J_rfrr_cue_`d'_`u'\ ///
					 Jp_rf_gmm_`d'_`u',Jp_cue_gmm_`d'_`u', Jp_rfrr_gmm_`d'_`u', Jp_rfrr_cue_`d'_`u')	
			}
		}	/* End of Quiet  */	
	} /* Dataset loop */
		di
		di "Instruments"
		di
		di " z1 = Twice lagged log dividend-price ratio"
		di " z2 = Twice lagged nominal interest rate"
		di " z3 = Twice lagged inflation "
		di " z4 = Twice lagged consumption growth"
		di " z5 = z2-z3 = Twice lagged real interest rate"
		
		if `u'==1 {
			di " Yogo (2004) Results, instruments: `instruments' "
		}
		else {
			di " Additional results using instrument combination`u', `instruments' "
		}
	
	quiet: matrix rownames table1_`u' = USAQ_dc rf re AULQ_dc rf re CANQ_dc rf re FRQ_dc rf re GERQ_dc rf re ITAQ_dc rf re JAP_dc rf re NTHQ_dc rf re ///
		SWDQ_dc rf re SWTQ_dc rf re UKQ_dc rf re USAQ2_dc rf re SWDY_dc rf re UKY_dc rf re USAY_dc rf re 

	di "Table 1"
	matrix list table1_`u'
	di
	quiet: matrix rownames table2_`u' = USAQ_Coefficient se AULQ_Coefficient se CANQ_Coefficient se FRQ_Coefficient se GERQ_Coefficient se ITAQ_Coefficient se /// 
		JAPQ_Coefficient se NTHQ_Coefficient se SWDQ_Coefficient se SWTQ_Coefficient se UKQ_Coefficient se USAQ2_Coefficient se SWDY_Coefficient se UKY_Coefficient se USAY_Coefficient se
	di "Table 2"
	matrix list table2_`u'
			
	di
quiet: matrix rownames table4_`u' = USAQ_Coefficient se AULQ_Coefficient se CANQ_Coefficient se FRQ_Coefficient se GERQ_Coefficient se ITAQ_Coefficient se /// 
	JAPQ_Coefficient se NTHQ_Coefficient se SWDQ_Coefficient se SWTQ_Coefficient se UKQ_Coefficient se USAQ2_Coefficient se SWDY_Coefficient se UKY_Coefficient se USAY_Coefficient se
	di "Table 4"
	matrix list table4_`u'
			
	di
	quiet: matrix rownames table6_`u' = USAQ_Coefficient se AULQ_Coefficient se CANQ_Coefficient se FRQ_Coefficient se GERQ_Coefficient se ITAQ_Coefficient se /// 
		JAPQ_Coefficient se NTHQ_Coefficient se SWDQ_Coefficient se SWTQ_Coefficient se UKQ_Coefficient se USAQ2_Coefficient se SWDY_Coefficient se UKY_Coefficient se USAY_Coefficient se
	di "Table 6"
	matrix list table6_`u'
			
	di "Overidentification tests "
	di
	quiet: matrix rownames table2_overid_`u' = USAQ_Statistic p_value AULQ_Statistic p_value CANQ_Statistic p_value FRQ_Statistic p_value GERQ_Statistic p_value ITAQ_Statistic p_value JAPQ_Statistic p_value ///
			 NTHQ_Statistic p_value SWDQ_Statistic p_value SWTQ_Statistic p_value UKQ_Statistic p_value USAQ2_Statistic p_value SWDY_Statistic p_value UKY_Statistic p_value USAY_Statistic p_value 
	di "For Table 2 "
	matrix list table2_overid_`u'
			
	di
	quiet: matrix rownames table4_overid_`u' = USAQ_Statistic p_value AULQ_Statistic p_value CANQ_Statistic p_value FRQ_Statistic p_value GERQ_Statistic p_value ITAQ_Statistic p_value JAPQ_Statistic p_value ///
			 NTHQ_Statistic p_value SWDQ_Statistic p_value SWTQ_Statistic p_value UKQ_Statistic p_value USAQ2_Statistic p_value SWDY_Statistic p_value UKY_Statistic p_value USAY_Statistic p_value 
	di "For Table 4 "
	matrix list table4_overid_`u'
			
	di
	quiet: matrix rownames table6_overid_`u' = USAQ_Statistic p_value AULQ_Statistic p_value CANQ_Statistic p_value FRQ_Statistic p_value GERQ_Statistic p_value ITAQ_Statistic p_value JAPQ_Statistic p_value ///
			 NTHQ_Statistic p_value SWDQ_Statistic p_value SWTQ_Statistic p_value UKQ_Statistic p_value USAQ2_Statistic p_value SWDY_Statistic p_value UKY_Statistic p_value USAY_Statistic p_value 
	di "For Table 6 "
	matrix list table6_overid_`u'
			
	
	di "Instrument set `u' concluded"
} /* Instrument set loop */
log close
