/* 
Nicole Maestas
July 16, 2007

Create estimate of pension wealth for HRS respondents 65+ in 1998
(67+ in 2000) for JPubE referees. Strategy is to just take
self-reported pension income and calculate expected present discounted
value of that flow.  Sample is old enough that virtually all pension
wealth will have been claimed. May have to restrict sample to couples
where both spouses are at least 65 for robustness checks including
pension wealth since a younger spouse may not have yet claimed SSA
benefits. Note that I am unable to use the pension calculator because
I'm using the geographic identifiers.
*/


options linesize=79 pagesize=60 compress=no nocenter replace mprint
 nodate nonumber formdlim=' ';

*this directory doesn't exist, not sure where my files went;
libname out '/zeno/b/zeno_b_orig/maestas/hmo';
libname out '.';

libname hrsdata '/homer/e/RANDHRS/VerG/';
libname library "/homer/e/RANDHRS/VerG";

%include "epdv.sas";
%include "initialize.sas";

data out.penwealth; 
set hrsdata.rndhrs_g(keep=hhidpn rabdate ragender r4agey_e r4mstat
r5mstat r4isret s4isret r4ipena s4ipena r5isret s5isret r5ipena
s5ipena);

if r4agey_e>=65;

married4=r4mstat in (1,2,3);
married5=r5mstat in (1,2,3);

pvdate=mdy(1,1,1999);

array annual r4isret s4isret r4ipena s4ipena r5isret s5isret r5ipena
s5ipena;
array monthly r4isretm s4isretm r4ipenam s4ipenam r5isretm s5isretm r5ipenam
s5ipenam;

do i=1 to 8;
  monthly{i}=annual{i}/12;
end;

*note pension vars refer to pension income in previous calendar year;
%epdv(pvdate,pvdate,rabdate,ragender,3,r5isretm,epdv=r5sswlth,yr=1999);
%epdv(pvdate,pvdate,rabdate,ragender,3,s5isretm,epdv=s5sswlth,yr=1999);
%epdv(pvdate,pvdate,rabdate,ragender,3,r5ipenam,epdv=r5penwlth,yr=1999);
%epdv(pvdate,pvdate,rabdate,ragender,3,s5ipenam,epdv=s5penwlth,yr=1999);

pvdate=mdy(1,1,1997);

%epdv(pvdate,pvdate,rabdate,ragender,3,r4isretm,epdv=r4sswlth,yr=1997);
%epdv(pvdate,pvdate,rabdate,ragender,3,s4isretm,epdv=s4sswlth,yr=1997);
%epdv(pvdate,pvdate,rabdate,ragender,3,r4ipenam,epdv=r4penwlth,yr=1997);
%epdv(pvdate,pvdate,rabdate,ragender,3,s4ipenam,epdv=s4penwlth,yr=1997);

/*
*there are a few extremely high values;
proc univariate;
var r4ipena s4ipena r5ipena s5ipena r5sswlth s5sswlth r5penwlth s5penwlth;

proc means;
var r5isret s5isret r5ipena s5ipena r5sswlth s5sswlth r5penwlth s5penwlth;
*/

keep hhidpn r5sswlth s5sswlth r5penwlth s5penwlth r4sswlth s4sswlth
r4penwlth s4penwlth; 
proc sort; by hhidpn;



