clear
set matsize 800
capture log close
log using "C:\Stata8\CMS\Abby\merges\merge98.log", replace

set memory 40m
set more off



* Notes
* Manassass city, VA is coded as 49563
* Manassas Park City, VA is coded as 49565
* All of Los Angeles, CA is coded as 05200 (Los Angeles covers 05200 and 05210)
* South Boston City, VA is coded as 49867
* Kalawao, HI is coded as 12030
* Alaska county coding are not reliable since the state changes county definitions

* Want to Merge st/cty with st/cty/plan file and FIPs, but must first collapse

* Take numplans and numplans_risk from st/cty/plan file
	use "C:\Stata8\CMS\Abby\stctyplan\cms98", clear
	rename sccode SCcode
	drop if SCcode==99999
	list if elig==.
	drop if elig==.
	sort SCcode
	gen numplans=1
	preserve
	gen numplans_risk=(plantype=="M+C")
	list SCcode ctyname orgname plantype in 1/20
	collapse (sum) numplans numplans_risk, by (ctyname stname SCcode elig)
	sort SCcode
	save cms98b.dta, replace
* Test
	list numplans numplans_risk ctyname in 1/10 
	restore	
	
* Want beneficiaries summed by organization*****PROBLEM*******
*	sort SCcode orgname
*	collapse (sum) benes, by (ctyname stname SCcode elig)
*	merge SCcode using cms98b.dta, update replace
*	rename benes benes2
*	save cms98b.dta, replace

*Test 
*	list SCcode benes2 elig in 1/10
*	restore

*  Now take numplans_org from st/cty/plan file and merge it back together with numplans and numplans_risk
	rename orgname Orgname
	sort SCcode Orgname
	by SCcode Orgname:  drop if _n>1
	collapse (sum) numplans_org=numplans, by (ctyname stname SCcode elig)
	sort SCcode
	list numplans_org SCcode in 1/10
	merge SCcode using cms98b.dta, update replace
	tab _merge
	drop _merge
	rename elig elig2
	sort SCcode
* Test
	list numplans numplans_org numplans_risk in 1/10 
	save cms98b.dta, replace


* Now take beneficiaries and eligibles from st/cty file and merge together with the above files
	use "C:\Stata8\CMS\Abby\stcty\cms1998", clear
	list if elig==.
	drop if elig==.
	rename sccode SCcode
	sort SCcode
	merge SCcode using cms98b.dta


	tab _merge

* _merge==1 represents those counties with zero enrollees
	drop if _merge==2
	drop _merge

* Note:  in some data los angeles has two state county codes, combine them here -- not relevant for 2002, 2001, 2000
	replace elig=elig+85460  if SCcode==5200
	replace benes=benes+38919  if SCcode==5200
	replace pctpen=benes/elig if SCcode==5200
	drop if SCcode==5210
	sort SCcode
	save cms98b.dta, replace

*  Finally want to include Fips codes as well, so merge ssafipscrosswalk with above data files 
	use "C:\Stata8\CMS\CMS-HRS Merge\ssafipscrosswalk.dta", clear
	drop if ssa_cty=="999"
	gen str5 SCcode=ssa_st+ssa_cty					
	destring SCcode, replace
	sort SCcode
	merge SCcode using cms98b.dta
	gen yr="98"
	drop if ssa_st=="05" & ssa_cty=="210"
	tab _merge
	list if _merge==1
	drop if _merge==2
	rename _merge merge_cms98
	rename fips_st StFIPS
	rename fips_cty CtyFPS

	
* one final correction
	replace numplans=0 if benes==0
   	replace numplans_risk=0 if benes==0
	replace numplans_org=0 if benes==0
	save merge98.dta, replace

*Test
	sort SCcode
	list SCcode numplans numplans_org numplans_risk elig elig2 benes in 1/10

	log close



