/*
Program Name: initialize.sas

This program is for use with oasiben.sas. It contains the values of
key inputs into the %oasiben benefit calculator: Social Security
Average Wage Index, Social Security Cost-of-Living Adjustments, Normal
Retirement Ages, Delayed Retirement Credits.

This program should be updated annually.
Last updated: December 2, 2004 by Nicole Maestas
Updated: Jun.6, 2006 by Xiaoyan Li
*/

proc format;

/* Annual average wage  
Social Security Average Wage Index: Through 2004, historic average
wages used from http://www.ssa.gov/OACT/COLA/awiseries.html. From 2004
and beyond, projected average wages based on 2006 OASDI Trustees
Report Intermediate assumptions for growth in average annual wages in
covered employement (Table V.C1, col. 2).
In the table the projected wages of year 2005-2015 are provided,
the wages after 2015 are projected assuming the constant increase rate from 2014-2015,
that is, 3.86796% 

Updated: Xiaoyan Li. Jun.2007---

Average wage in 2005 is replaced by the actual amount of that year. 
(http://www.ssa.gov/OACT/COLA/awiseries.html)
From 2006 to 2016, projected average wages are based on 2007 OASDI Trustees Report 
Intermediate assumptions for growth in average annual wages in covered employment 
(Table V.C1, col. 2).
2020, 2025, 2030, 2035, 2040 values come from 2007 OASDI Trustees Report Table VI.F6, col.2. 
Other values between 2016-2040 are imputed assuming the rate within each interval of
2016-2020; 2020-2025; 2025-2030; 2030-2035; 2035-2040 is constant. 
2041-2060 projection is conducted with increase rate of 3.9% according to Table II.C1 and V.B1. 
 */
 
value avgwagei
1951="2799.16"   
1952="2973.32"   
1953="3139.44"   
1954="3155.64"   
1955="3301.44"   
1956="3532.36"   
1957="3641.72"   
1958="3673.8"    
1959="3855.8"    
1960="4007.12"   
1961="4086.76"   
1962="4291.4"    
1963="4396.64"   
1964="4576.32"   
1965="4658.72"   
1966="4938.36"   
1967="5213.44"   
1968="5571.76"   
1969="5893.76"   
1970="6186.24"   
1971="6497.08"   
1972="7133.8"    
1973="7580.16"   
1974="8030.76"
1975="8630.92"
1976="9226.48"
1977="9779.44"
1978="10556.03"
1979="11479.46"     
1980="12513.46"     
1981="13773.1"     
1982="14531.34"    
1983="15239.24"    
1984="16135.07"    
1985="16822.51"    
1986="17321.82"    
1987="18426.51"    
1988="19334.04"    
1989="20099.55"    
1990="21027.98"    
1991="21811.6"     
1992="22935.42"    
1993="23132.67"    
1994="23753.53"    
1995="24705.66"    
1996="25913.9"     
1997="27426"    
1998="28861.44"  
1999="30469.84"  
2000="32154.82"  
2001="32921.92"
2002="33252.09"
2003="34064.95"
2004="35648.55"
2005="36952.94"
2006="38726.37"
2007="40461.69"
2008="42286.35"
2009="44100.37"
2010="45946.76"
2011="47830.33"
2012="49809.01"	
2013="51785.43"
2014="53759.30"
2015="55820.55"
2016="57963.56"
2017="60216.37"
2018="62556.74"
2019="64988.07"
2020="67513.90"
2021="70126.98"
2022="72841.19"
2023="75660.46"
2024="78588.84"
2025="81630.57"
2026="84799.42"
2027="88091.29"
2028="91510.95"
2029="95063.35"
2030="98753.66"
2031="102619.12"
2032="106635.89"
2033="110809.88"
2034="115147.25"
2035="119654.40"
2036="124366.88"
2037="129264.95"
2038="134355.93"
2039="139647.42"
2040="145147.30"
2041="150808.04"
2042="156689.56"
2043="162800.45"
2044="169149.67"
2045="175746.51"
2046="182600.62"
2047="189722.04"
2048="197121.20"
2049="204808.93"
2050="212796.48"
2051="221095.54"
2052="229718.27"
2053="238677.28"
2054="247985.69"
2055="257657.14"
2056="267705.76"
2057="278146.29"
2058="288993.99"
2059="300264.76"
2060="311975.09"
other="ERROR";

/* 
Cost of Living Adjustments: as reported in RS 00601.120 from SSA's
Program Operations Manual System. Projections for 2005 and beyond come
from 2006 Annual Report of OASDI Trustees projections of the CPI-W 
(based on the intermediate assumption).

Initially, the COLA for 1999 was set at 2.5 instead of 2.4 to reflect
the addition of .01 due to BLS error in the CPI computation. SSA paid
benefits based on the incorrect COLA, then once the mistake was
discovered, made a compensatory lump-sum payment in 7/2001 to those
eligible (i.e., age 62) before 2000. Those retiring in and before 2001
got the old 2.4 COLA, whereas those retiring after 2001 got the new
2.5 COLA. I have set the 1999 COLA equal to 2.5, but this will differ
slightly from the ANYPIA program for respondents who retire prior to
2002. 

Updated: Xiaoyan Li. Jun.2007---
Actual 2006 COLA=3.3 
(http://www.ssa.gov/cola/)
Projections for 2007 and beyond come from 2007 Annual Report of OASDI 
Trustees projections of the CPI-W (Table V.B1)
*/

value costladj 
       1975 ="8"     
       1976 ="6.4"   
       1977 ="5.9"   
       1978 ="6.5"   
       1979 ="9.9"   
       1980 ="14.3"  
       1981 ="11.2"  
       1982 ="7.4"   
       1983 ="3.5"   
       1984 ="3.5"   
       1985 ="3.1"   
       1986 ="1.3"   
       1987 ="4.2"   
       1988 ="4"     
       1989 ="4.7"   
       1990 ="5.4"   
       1991 ="3.7"   
       1992 ="3"     
       1993 ="2.6"   
       1994 ="2.8"   
       1995 ="2.6"   
       1996 ="2.9"   
       1997 ="2.1"   
       1998 ="1.3"   
       1999 ="2.4"   
       2000 ="3.5"   
       2001 ="2.6"   
       2002 ="1.4"
       2003 ="2.1"
       2004 ="2.7"
       2005 ="4.1"
       2006 ="3.3"
       2007 ="1.9"
       2008 ="2.4"
       2009 ="2.7"
       2010-high ="2.8";

/* 
Normal Retirement Ages: From http://www.ssa.gov/OACT/ProgData/nra.html.
Shows Normal Retirement Ages by year of birth, in SAS date variable format (i.e. in days).
*/

value nra
low-1937="23741	"	/*65	*/
1938	="23802	"	/*65 2 months	*/
1939	="23863	"	/*65 4 months	*/
1940	="23924	"	/*65 6 months	*/
1941	="23985	"	/*65 8 months	*/
1942	="24046	"	/*65 10 months	*/
1943	="24107	"	/*66    */
1944	="24107	"	/*66	*/
1945	="24107	"	/*66	*/
1946	="24107	"	/*66	*/
1947	="24107	"	/*66	*/
1948	="24107	"	/*66	*/
1949	="24107	"	/*66	*/
1950	="24107	"	/*66	*/
1951	="24107	"	/*66	*/
1952	="24107	"	/*66	*/
1953	="24107	"	/*66	*/
1954	="24107	"	/*66	*/
1955	="24167	"	/*66 2 months	*/
1956	="24228	"	/*66 4 months	*/
1957	="24289	"	/*66 6 months	*/
1958	="24350	"	/*66 8 months	*/
1959	="24411	"	/*66 10 months	*/
1960-high="24472";	/*67	*/

/* 
Delayed Retirement Credits: From http://www.ssa.gov/retire2/delayret.htm. 
Delayed Retirement Credits for individuals turning 62 in specified year. 
Credit is the monthly percentage increase for those first claiming benefits beyond the NRA.
*/

value drc
1987="0.002916667"
1988="0.002916667"
1989="0.003333333"
1990="0.003333333"
1991="0.00375"
1992="0.00375"
1993="0.004166667"
1994="0.004166667"
1995="0.004583333"
1996="0.004583333"
1997="0.005"
1998="0.005"
1999="0.005416667"
2000="0.005416667"
2001="0.005833333"
2002="0.005833333"
2003="0.00625"
2004="0.00625"
2005-high="0.006666667";


/*
CPI-W
The Consumer Price Index for Urban Wage Earners and Clerical Workers (CPI-W) 
is used to annually adjust benefits to Social Security beneficiaries.

1974-2005 values are actual amounts
http://www.socialsecurity.gov/OACT/STATS/cpiw.html (updated May 17, 2006)
which is produced by the Bureau of Labor Statistics (BLS)

2006 forward values are projected amounts
based on 2006 OASDI Trustees Report Table V.B1.-Principal Economic Assumptions.

Intermediate assumptions are used. 
For those assumptions, the annual change in the CPI will be:
2006: 2.9%
2007: 2.3%
2008: 2.6%
2009-2060: 2.8% 

Updated: Xiaoyan Li. Jun.2007---
2006 value is true value now. 
2007-2060 values are projected
Source: 2007 OASDI Trustees Report Table V.B1.-Principal Economic Assumptions-Intermediate assumptions
2007: 1.9%
2008: 2.4%
2009: 2.7%
2010-: 2.8% 

*/

value cpiw
1974="49.6"
1975="54.1"
1976="57.2"
1977="60.9"
1978="65.6"
1979="73.1"
1980="82.9"
1981="91.4"
1982="96.9"
1983="99.8"
1984="103.3"
1985="106.9"
1986="108.6"
1987="112.5"
1988="117"
1989="122.6"
1990="129"
1991="134.3"
1992="138.2"
1993="142.1"
1994="145.6"
1995="149.8"
1996="154.1"
1997="157.6"
1998="159.7"
1999="163.2"
2000="168.9"
2001="173.5"
2002="175.9"
2003="179.8"
2004="184.5"
2005="191"
2006="197.1"
2007="200.9"
2008="205.7"
2009="211.3"
2010="217.2"
2011="223.3"
2012="229.5"
2013="235.9"
2014="242.5"
2015="249.3"
2016="256.3"
2017="263.5"
2018="270.9"
2019="278.5"
2020="286.3"
2021="294.3"
2022="302.5"
2023="311.0"
2024="319.7"
2025="328.6"
2026="337.8"
2027="347.3"
2028="357.0"
2029="367.0"
2030="377.3"
2031="387.9"
2032="398.7"
2033="409.9"
2034="421.4"
2035="433.2"
2036="445.3"
2037="457.8"
2038="470.6"
2039="483.7"
2040="497.3"
2041="511.2"
2042="525.5"
2043="540.2"
2044="555.4"
2045="570.9"
2046="586.9"
2047="603.3"
2048="620.2"
2049="637.6"
2050="655.5"
2051="673.8"
2052="692.7"
2053="712.1"
2054="732.0"
2055="752.5"
2056="773.6"
2057="795.2"
2058="817.5"
2059="840.4"
2060="863.9"
other="ERROR";

/*life tables: age = # surviving to this age
lx1992m-lx2003m: for male
lx1992w-lx2003w: for female

1992,1993,1994,1995,1996,1998,2000,2002,2003 values are from RAND HRS Ver F formats

1997, 1999, 2001 values come from National Vital Statistics Report 
(from NCHS, CDC)
http://www.cdc.gov/nchs/products/pubs/pubd/lftbls/life/1966.htm

*/
  value lx1992m
    0  ="100000"
    1  ="99062" 
    2  ="98993" 
    3  ="98943" 
    4  ="98906" 
    5  ="98875" 
    6  ="98847" 
    7  ="98821" 
    8  ="98797" 
    9  ="98775" 
    10 ="98757" 
    11 ="98743" 
    12 ="98728" 
    13 ="98706" 
    14 ="98668" 
    15 ="98608" 
    16 ="98523" 
    17 ="98415" 
    18 ="98288" 
    19 ="98151" 
    20 ="98008" 
    21 ="97861" 
    22 ="97709" 
    23 ="97552" 
    24 ="97392" 
    25 ="97230" 
    26 ="97066" 
    27 ="96900" 
    28 ="96730" 
    29 ="96554" 
    30 ="96369" 
    31 ="96174" 
    32 ="95969" 
    33 ="95754" 
    34 ="95529" 
    35 ="95294" 
    36 ="95047" 
    37 ="94789" 
    38 ="94519" 
    39 ="94238" 
    40 ="93945" 
    41 ="93640" 
    42 ="93320" 
    43 ="92985" 
    44 ="92634" 
    45 ="92266" 
    46 ="91878" 
    47 ="91486" 
    48 ="91028" 
    49 ="90558" 
    50 ="90053" 
    51 ="89509" 
    52 ="88922" 
    53 ="88285" 
    54 ="87592" 
    55 ="86835" 
    56 ="86011" 
    57 ="85115" 
    58 ="84142" 
    59 ="83086" 
    60 ="81943" 
    61 ="80710" 
    62 ="79383" 
    63 ="77958" 
    64 ="76431" 
    65 ="74798" 
    66 ="73058" 
    67 ="71211" 
    68 ="69258" 
    69 ="67203" 
    70 ="65049" 
    71 ="62800" 
    72 ="60457" 
    73 ="58020" 
    74 ="55489" 
    75 ="52865" 
    76 ="50152" 
    77 ="47360" 
    78 ="44499" 
    79 ="41580" 
    80 ="38616" 
    81 ="35619" 
    82 ="32601" 
    83 ="29573" 
    84 ="26546" 
    85 ="23532" 
    other="ERROR";

value lx1992w
    0  ="100000"
    1  ="99241" 
    2  ="99188" 
    3  ="99147" 
    4  ="99114" 
    5  ="99088" 
    6  ="99066" 
    7  ="99048" 
    8  ="99032" 
    9  ="99018" 
    10 ="99005" 
    11 ="98993" 
    12 ="98980" 
    13 ="98964" 
    14 ="98943" 
    15 ="98916" 
    16 ="98882" 
    17 ="98841" 
    18 ="98795" 
    19 ="98747" 
    20 ="98699" 
    21 ="98652" 
    22 ="98604" 
    23 ="98555" 
    24 ="98505" 
    25 ="98452" 
    26 ="98396" 
    27 ="98338" 
    28 ="98277" 
    29 ="98213" 
    30 ="98145" 
    31 ="98073" 
    32 ="97996" 
    33 ="97915" 
    34 ="97828" 
    35 ="97735" 
    36 ="97635" 
    37 ="97527" 
    38 ="97412" 
    39 ="97289" 
    40 ="97159" 
    41 ="97020" 
    42 ="96871" 
    43 ="96711" 
    44 ="96538" 
    45 ="96351" 
    46 ="96149" 
    47 ="95929" 
    48 ="95689" 
    49 ="95425" 
    50 ="95133" 
    51 ="94811" 
    52 ="94457" 
    53 ="94068" 
    54 ="93641" 
    55 ="93172" 
    56 ="92660" 
    57 ="92100" 
    58 ="91490" 
    59 ="90826" 
    60 ="90105" 
    61 ="89324" 
    62 ="88478" 
    63 ="87566" 
    64 ="86584" 
    65 ="85530" 
    66 ="84400" 
    67 ="83190" 
    68 ="81894" 
    69 ="80504" 
    70 ="79013" 
    71 ="77416" 
    72 ="75710" 
    73 ="73894" 
    74 ="71969" 
    75 ="69935" 
    76 ="67788" 
    77 ="65523" 
    78 ="63131" 
    79 ="60605" 
    80 ="57938" 
    81 ="55123" 
    82 ="52154" 
    83 ="49026" 
    84 ="45736" 
    85 ="42282" 
    other="ERROR"
    ;

  value lx1993m
      0="100000"
      1 ="99077"
      2 ="99005"
      3 ="98954"
      4 ="98916"
      5 ="98886"
      6 ="98859"
      7 ="98834"
      8 ="98810"
      9 ="98789"
     10 ="98771"
     11 ="98755"
     12 ="98739"
     13 ="98715"
     14 ="98675"
     15 ="98613"
     16 ="98525"
     17 ="98414"
     18 ="98285"
     19 ="98145"
     20 ="97999"
     21 ="97847"
     22 ="97690"
     23 ="97529"
     24 ="97366"
     25 ="97200"
     26 ="97035"
     27 ="96868"
     28 ="96698"
     29 ="96519"
     30 ="96329"
     31 ="96127"
     32 ="95914"
     33 ="95689"
     34 ="95454"
     35 ="95211"
     36 ="94958"
     37 ="94696"
     38 ="94422"
     39 ="94136"
     40 ="93837"
     41 ="93522"
     42 ="93192"
     43 ="92846"
     44 ="92484"
     45 ="92107"
     46 ="91713"
     47 ="91296"
     48 ="90854"
     49 ="90380"
     50 ="89868"
     51 ="89315"
     52 ="88716"
     53 ="88066"
     54 ="87362"
     55 ="86600"
     56 ="85772"
     57 ="84872"
     58 ="83899"
     59 ="82848"
     60 ="81718"
     61 ="80503"
     62 ="79198"
     63 ="77787"
     64 ="76257"
     65 ="74599"
     66 ="72803"
     67 ="70873"
     68 ="68825"
     69 ="66677"
     70 ="64442"
     71 ="62120"
     72 ="59703"
     73 ="57190"
     74 ="54578"
     75 ="51870"
     76 ="49069"
     77 ="46182"
     78 ="43221"
     79 ="40200"
     80 ="37136"
     81 ="34051"
     82 ="30967"
     83 ="27909"
     84 ="24905"
     85 ="21986"
     86 ="19182"
     87 ="16525"
     88 ="14043"
     89 ="11761"
     90 =" 9697"
     91 =" 7862"
     92 =" 6261"
     93 =" 4891"
     94 =" 3744"
     95 =" 2804"
     96 =" 2053"
     97 =" 1469"
     98 =" 1027"
     99 ="  702"
    100 ="  468"
    101 ="  304"
    102 ="  193"
    103 ="  118"
    104 ="   70"
    105 ="   41"
    106 ="   22"
    107 ="   12"
    108 ="    6"
    109 ="    3"
    110 ="    1"
    111 ="    1"
    112-150=" 0"
   other="ERROR"
   ;

value lx1993w  
   0="100000"
   1 ="99258"
   2 ="99194"
   3 ="99153"
   4 ="99127"
   5 ="99104"
   6 ="99083"
   7 ="99063"
   8 ="99044"
   9 ="99026"
   10="99009"
   11="98994"
   12="98979"
   13="98963"
   14="98941"
   15="98913"
   16="98878"
   17="98835"
   18="98788"
   19="98738"
   20="98689"
   21="98640"
   22="98591"
   23="98541"
   24="98490"
   25="98435"
   26="98378"
   27="98318"
   28="98255"
   29="98189"
   30="98118"
   31="98044"
   32="97965"
   33="97881"
   34="97792"
   35="97696"
   36="97593"
   37="97482"
   38="97364"
   39="97238"
   40="97105"
   41="96963"
   42="96812"
   43="96649"
   44="96473"
   45="96280"
   46="96070"
   47="95840"
   48="95588"
   49="95314"
   50="95014"
   51="94686"
   52="94328"
   53="93936"
   54="93507"
   55="93038"
   56="92524"
   57="91962"
   58="91350"
   59="90684"
   60="89963"
   61="89183"
   62="88338"
   63="87422"
   64="86426"
   65="85344"
   66="84168"
   67="82895"
   68="81529"
   69="80080"
   70="78550"
   71="76931"
   72="75212"
   73="73385"
   74="71442"
   75="69375"
   76="67172"
   77="64824"
   78="62334"
   79="59706"
   80="56943"
   81="54041"
   82="51000"
   83="47825"
   84="44529"
   85="41129"
   86="37649"
   87="34121"
   88="30582"
   89="27075"
   90="23647"
   91="20348"
   92="17227"
   93="14327"
   94="11688"
   95="9337 "
   96="7299 "
   97="5580 "
   98="4170 "
   99="3046 "
   100="2176" 
   101="1517" 
   102="1030" 
   103="680 " 
   104="435 " 
   105="269 " 
   106="160 " 
   107="91  " 
   108="50  " 
   109="26  " 
   110="13  " 
   111="6   " 
   112="2   " 
   113="1   " 
   114-150="0"
   other="ERROR"
   ; 

value lx1994m
    0  ="100000"
    1  ="99121" 
    2  ="99051" 
    3  ="99002" 
    4  ="98966" 
    5  ="98936" 
    6  ="98910" 
    7  ="98885" 
    8  ="98861" 
    9  ="98840" 
    10 ="98823" 
    11 ="98809" 
    12 ="98794" 
    13 ="98772" 
    14 ="98733" 
    15 ="98671" 
    16 ="98583" 
    17 ="98471" 
    18 ="98340" 
    19 ="96198" 
    20 ="98050" 
    21 ="97897" 
    22 ="97738" 
    23 ="97576" 
    24 ="97412" 
    25 ="97247" 
    26 ="97083" 
    27 ="96919" 
    28 ="96751" 
    29 ="96574" 
    30 ="96385" 
    31 ="96183" 
    32 ="95967" 
    33 ="95739" 
    34 ="95501" 
    35 ="95254" 
    36 ="94998" 
    37 ="94731" 
    38 ="94452" 
    39 ="94161" 
    40 ="93856" 
    41 ="93535" 
    42 ="93197" 
    43 ="92843" 
    44 ="92475" 
    45 ="92093" 
    46 ="91696" 
    47 ="91280" 
    48 ="90840" 
    49 ="90368" 
    50 ="89857" 
    51 ="89303" 
    52 ="88703" 
    53 ="88054" 
    54 ="87357" 
    55 ="86609" 
    56 ="85808" 
    57 ="84948" 
    58 ="84016" 
    59 ="82998" 
    60 ="81883" 
    61 ="80665" 
    62 ="79343" 
    63 ="77919" 
    64 ="76399" 
    65 ="74785" 
    66 ="73079" 
    67 ="71277" 
    68 ="69375" 
    69 ="67367" 
    70 ="65249" 
    71 ="63022" 
    72 ="60690" 
    73 ="58259" 
    74 ="55738" 
    75 ="53136" 
    76 ="50457" 
    77 ="47707" 
    78 ="44888" 
    79 ="42004" 
    80 ="39061" 
    81 ="36065" 
    82 ="33024" 
    83 ="29948" 
    84 ="26850" 
    85 ="23744" 
    other="ERROR"
    ;

value lx1994w
    0  ="100000"
    1  ="99281" 
    2  ="99229" 
    3  ="99189" 
    4  ="99157" 
    5  ="99132" 
    6  ="99111" 
    7  ="99093" 
    8  ="99077" 
    9  ="99062" 
    10 ="99048" 
    11 ="99035" 
    12 ="99021" 
    13 ="99004" 
    14 ="98983" 
    15 ="98956" 
    16 ="98921" 
    17 ="98880" 
    18 ="98833" 
    19 ="98784" 
    20 ="98735" 
    21 ="98686" 
    22 ="98637" 
    23 ="98587" 
    24 ="98535" 
    25 ="98481" 
    26 ="98424" 
    27 ="98364" 
    28 ="98300" 
    29 ="98232" 
    30 ="98160" 
    31 ="98084" 
    32 ="98003" 
    33 ="97916" 
    34 ="97823" 
    35 ="97724" 
    36 ="97617" 
    37 ="97502" 
    38 ="97379" 
    39 ="97249" 
    40 ="97112" 
    41 ="96968" 
    42 ="96815" 
    43 ="96652" 
    44 ="96476" 
    45 ="96284" 
    46 ="96075" 
    47 ="95847" 
    48 ="95596" 
    49 ="95327" 
    50 ="95030" 
    51 ="94706" 
    52 ="94351" 
    53 ="93963" 
    54 ="93540" 
    55 ="93080" 
    56 ="92580" 
    57 ="92036" 
    58 ="91443" 
    59 ="90794" 
    60 ="90082" 
    61 ="89303" 
    62 ="88454" 
    63 ="87535" 
    64 ="86546" 
    65 ="85488" 
    66 ="84357" 
    67 ="83148" 
    68 ="81853" 
    69 ="80463" 
    70 ="78969" 
    71 ="77364" 
    72 ="75647" 
    73 ="73816" 
    74 ="71870" 
    75 ="69809" 
    76 ="67628" 
    77 ="65322" 
    78 ="62884" 
    79 ="60308" 
    80 ="57586" 
    81 ="54913" 
    82 ="51683" 
    83 ="48494" 
    84 ="45142" 
    85 ="41625" 
    other="ERROR"
    ;

value lx1995m   
      0="100000"
      1 ="99169"
      2 ="99103"
      3 ="99057"
      4 ="99023"
      5 ="98994"
      6 ="98969"
      7 ="98945"
      8 ="98922"
      9 ="98901"
     10 ="98883"
     11 ="98867"
     12 ="98851"
     13 ="98827"
     14 ="98788"
     15 ="98728"
     16 ="98645"
     17 ="98541"
     18 ="98419"
     19 ="98285"
     20 ="98145"
     21 ="97998"
     22 ="97845"
     23 ="97687"
     24 ="97527"
     25 ="97366"
     26 ="97206"
     27 ="97046"
     28 ="96881"
     29 ="96708"
     30 ="96524"
     31 ="96325"
     32 ="96114"
     33 ="95891"
     34 ="95657"
     35 ="95415"
     36 ="95163"
     37 ="94900"
     38 ="94626"
     39 ="94338"
     40 ="94036"
     41 ="93717"
     42 ="93381"
     43 ="93029"
     44 ="92660"
     45 ="92274"
     46 ="91870"
     47 ="91445"
     48 ="90993"
     49 ="90512"
     50 ="89995"
     51 ="89439"
     52 ="88839"
     53 ="88194"
     54 ="87501"
     55 ="86758"
     56 ="85959"
     57 ="85096"
     58 ="84165"
     59 ="83157"
     60 ="82065"
     61 ="80887"
     62 ="79614"
     63 ="78237"
     64 ="76744"
     65 ="75127"
     66 ="73377"
     67 ="71497"
     68 ="69504"
     69 ="67418"
     70 ="65254"
     71 ="63009"
     72 ="60673"
     73 ="58240"
     74 ="55704"
     75 ="53061"
     76 ="50314"
     77 ="47468"
     78 ="44533"
     79 ="41525"
     80 ="38459"
     81 ="35355"
     82 ="32235"
     83 ="29123"
     84 ="26049"
     85 ="23046"
     86 ="20146"
     87 ="17383"
     88 ="14789"
     89 ="12392"
     90 ="10214"
     91 =" 8272"
     92 =" 6573"
     93 =" 5118"
     94 =" 3899"
     95 =" 2902"
     96 =" 2109"
     97 =" 1495"
     98 =" 1034"
     99 ="  698"
    100 ="  460"
    101 ="  295"
    102 ="  184"
    103 ="  111"
    104 ="   65"
    105 ="   37"
    106 ="   20"
    107 ="   10"
    108 ="    5"
    109 ="    2"
    110 ="    1"
    111-150=" 0"
   other="ERROR"
   ;

   value lx1995w
   0="100000"
   1="99321 "
   2="99265 "
   3="99230 "
   4="99202 "
   5="99179 "
   6="99160 "
   7="99142 "
   8="99126 "
   9="99111 "
   10="99096 "
   11="99082 "
   12="99067 "
   13="99050 "
   14="99027 "
   15="98999 "
   16="98962 "
   17="98919 "
   18="98871 "
   19="98821 "
   20="98772 "
   21="98724 "
   22="98676 "
   23="98628 "
   24="98577 "
   25="98524 "
   26="98468 "
   27="98408 "
   28="98345 "
   29="98278 "
   30="98206 "
   31="98130 "
   32="98049 "
   33="97962 "
   34="97869 "
   35="97769 "
   36="97662 "
   37="97546 "
   38="97423 "
   39="97292 "
   40="97152 "
   41="97004 "
   42="96845 "
   43="96675 "
   44="96493 "
   45="96298 "
   46="96088 "
   47="95861 "
   48="95615 "
   49="95345 "
   50="95048 "
   51="94723 "
   52="94366 "
   53="93975 "
   54="93548 "
   55="93085 "
   56="92580 "
   57="92030 "
   58="91431 "
   59="90779 "
   60="90071 "
   61="89301 "
   62="88467 "
   63="87560 "
   64="86574 "
   65="85504 "
   66="84340 "
   67="83080 "
   68="81728 "
   69="80292 "
   70="78775 "
   71="77167 "
   72="75458 "
   73="73641 "
   74="71709 "
   75="69655 "
   76="67464 "
   77="65129 "
   78="62650 "
   79="60031 "
   80="57275 "
   81="54377 "
   82="51335 "
   83="48154 "
   84="44845 "
   85="41424 "
   86="37918 "
   87="34358 "
   88="30784 "
   89="27239 "
   90="23774 "
   91="20439 "
   92="17284 "
   93="14355 "
   94="11692 "
   95="9322  "
   96="7271  "
   97="5544  "
   98="4131  "
   99="3009  "
   100="2142"
   101="1488"
   102="1006"
   103="661 "
   104="421 "
   105="259 "
   106="153 "
   107="87  "
   108="47  "
   109="24  "
   110="12  "
   111="5   "
   112="2   "
   113="1   "
   114-150="0   "
   other="ERROR"
   ;

value lx1996m
    0  ="100000"
    1  ="99198" 
    2  ="99138" 
    3  ="99094" 
    4  ="99060" 
    5  ="99032" 
    6  ="99007" 
    7  ="98983" 
    8  ="98960" 
    9  ="98939" 
    10 ="98922" 
    11 ="98908" 
    12 ="98893" 
    13 ="98872" 
    14 ="98837" 
    15 ="98782" 
    16 ="98706" 
    17 ="98609" 
    18 ="98495" 
    19 ="98370" 
    20 ="98237" 
    21 ="98097" 
    22 ="97950" 
    23 ="97798" 
    24 ="97646" 
    25 ="97495" 
    26 ="97347" 
    27 ="97201" 
    28 ="97054" 
    29 ="96902" 
    30 ="96740" 
    31 ="96567" 
    32 ="96384" 
    33 ="96191" 
    34 ="95989" 
    35 ="95778" 
    36 ="95557" 
    37 ="95325" 
    38 ="95081" 
    39 ="94823" 
    40 ="94551" 
    41 ="94263" 
    42 ="93957" 
    43 ="93633" 
    44 ="93291" 
    45 ="92930" 
    46 ="92548" 
    47 ="92143" 
    48 ="91710" 
    49 ="91246" 
    50 ="90748" 
    51 ="90210" 
    52 ="89630" 
    53 ="89004" 
    54 ="88330" 
    55 ="87604" 
    56 ="86824" 
    57 ="85984" 
    58 ="85073" 
    59 ="84076" 
    60 ="82982" 
    61 ="81784" 
    62 ="80482" 
    63 ="79081" 
    64 ="77590" 
    65 ="76016" 
    66 ="74361" 
    67 ="72620" 
    68 ="70780" 
    69 ="68823" 
    70 ="66738" 
    71 ="64521" 
    72 ="62179" 
    73 ="59726" 
    74 ="57180" 
    75 ="54555" 
    76 ="51860" 
    77 ="49098" 
    78 ="46268" 
    79 ="43370" 
    80 ="40406" 
    81 ="37382" 
    82 ="34308" 
    83 ="31198" 
    84 ="28071" 
    85 ="24949" 
    other="ERROR"
    ;
    
   value lx1996w
    0  ="100000"
    1  ="99341" 
    2  ="99295" 
    3  ="99259" 
    4  ="99230" 
    5  ="99207" 
    6  ="99187" 
    7  ="99170" 
    8  ="99154" 
    9  ="99139" 
    10 ="99125" 
    11 ="99112" 
    12 ="99098" 
    13 ="99081" 
    14 ="99060" 
    15 ="99033" 
    16 ="98998" 
    17 ="98956" 
    18 ="98910" 
    19 ="98862" 
    20 ="98815" 
    21 ="98769" 
    22 ="98723" 
    23 ="98676" 
    24 ="98627" 
    25 ="98576" 
    26 ="98522" 
    27 ="98464" 
    28 ="98403" 
    29 ="98338" 
    30 ="98269" 
    31 ="98195" 
    32 ="98116" 
    33 ="98032" 
    34 ="97942" 
    35 ="97846" 
    36 ="97743" 
    37 ="97632" 
    38 ="97513" 
    39 ="97386" 
    40 ="97251" 
    41 ="97107" 
    42 ="96952" 
    43 ="96786" 
    44 ="96608" 
    45 ="96417" 
    46 ="96212" 
    47 ="95990" 
    48 ="95749" 
    49 ="95484" 
    50 ="95193" 
    51 ="94871" 
    52 ="94517" 
    53 ="94130" 
    54 ="93710" 
    55 ="93255" 
    56 ="92765" 
    57 ="92235" 
    58 ="91656" 
    59 ="91019" 
    60 ="90317" 
    61 ="89542" 
    62 ="88693" 
    63 ="87773" 
    64 ="86788" 
    65 ="85740" 
    66 ="84627" 
    67 ="83443" 
    68 ="82174" 
    69 ="80805" 
    70 ="79323" 
    71 ="77720" 
    72 ="75995" 
    73 ="74150" 
    74 ="72190" 
    75 ="70116" 
    76 ="67925" 
    77 ="65612" 
    78 ="63167" 
    79 ="60582" 
    80 ="57849" 
    81 ="54961" 
    82 ="51914" 
    83 ="48707" 
    84 ="45339" 
    85 ="41813" 
    other="ERROR"
    ;

value lx1997m
0="100000"
1="99205"
2="99145"
3="99105"
4="99072"
5="99047"
6="99024"
7="99002"
8="98982"
9="98963"
10="98947"
11="98933"
12="98918"
13="98897"
14="98862"
15="98809"
16="98735"
17="98644"
18="98536"
19="98418"
20="98293"
21="98160"
22="98019"
23="97872"
24="97725"
25="97581"
26="97440"
27="97301"
28="97163"
29="97022"
30="96875"
31="96721"
32="96562"
33="96395"
34="96221"
35="96039"
36="95849"
37="95649"
38="95439"
39="95216"
40="94978"
41="94723"
42="94449"
43="94156"
44="93841"
45="93502"
46="93137"
47="92742"
48="92318"
49="91863"
50="91379"
51="90860"
52="90304"
53="89706"
54="89062"
55="88363"
56="87604"
57="86774"
58="85867"
59="84880"
60="83809"
61="82649"
62="81395"
63="80042"
64="78587"
65="77032"
66="75386"
67="73651"
68="71818"
69="69865"
70="67780"
71="65560"
72="63218"
73="60763"
74="58212"
75="55576"
76="52870"
77="50101"
78="47267"
79="44361"
80="41374"
81="38299"
82="35148"
83="31952"
84="28763"
85="25630"
86="22586"
87="19675"
88="16922"
89="14354"
90="11991"
91="9854"
92="7958"
93="6313"
94="4916"
95="3755"
96="2813"
97="2065"
98="1485"
99="1045"
100="720"
other="ERROR"
;

value lx1997w
0="100000"
1="99383"
2="99333"
3="99302"
4="99276"
5="99256"
6="99238"
7="99220"
8="99204"
9="99188"
10="99174"
11="99161"
12="99147"
13="99131"
14="99110"
15="99083"
16="99049"
17="99009"
18="98963"
19="98916"
20="98868"
21="98821"
22="98773"
23="98725"
24="98675"
25="98624"
26="98571"
27="98517"
28="98460"
29="98400"
30="98336"
31="98268"
32="98196"
33="98118"
34="98035"
35="97945"
36="97847"
37="97743"
38="97631"
39="97511"
40="97381"
41="97241"
42="97089"
43="96926"
44="96750"
45="96561"
46="96356"
47="96134"
48="95894"
49="95632"
50="95346"
51="95035"
52="94694"
53="94321"
54="93915"
55="93471"
56="92985"
57="92449"
58="91861"
59="91217"
60="90515"
61="89751"
62="88918"
63="88016"
64="87044"
65="86006"
66="84905"
67="83738"
68="82491"
69="81142"
70="79677"
71="78089"
72="76381"
73="74555"
74="72611"
75="70550"
76="68375"
77="66082"
78="63659"
79="61087"
80="58348"
81="55444"
82="52380"
83="49158"
84="45779"
85="42258"
86="38655"
87="35000"
88="31337"
89="27711"
90="24167"
91="20758"
92="17541"
93="14569"
94="11879"
95="9495"
96="7430"
97="5685"
98="4251"
99="3105"
100="2214"
other="ERROR"
;

value lx1998m
  0  ="100000"
  1  ="99215" 
  2  ="99158" 
  3  ="99118" 
  4  ="99089" 
  5  ="99066" 
  6  ="99044" 
  7  ="99022" 
  8  ="99002" 
  9  ="98983" 
  10 ="98967" 
  11 ="98953" 
  12 ="98938" 
  13 ="98918" 
  14 ="98885" 
  15 ="98834" 
  16 ="98765" 
  17 ="98679" 
  18 ="98578" 
  19 ="98466" 
  20 ="98346" 
  21 ="98217" 
  22 ="98079" 
  23 ="97935" 
  24 ="97790" 
  25 ="97648" 
  26 ="97511" 
  27 ="97377" 
  28 ="97244" 
  29 ="97109" 
  30 ="96970" 
  31 ="96826" 
  32 ="96676" 
  33 ="96520" 
  34 ="96356" 
  35 ="96184" 
  36 ="96003" 
  37 ="95812" 
  38 ="95610" 
  39 ="95395" 
  40 ="95163" 
  41 ="94914" 
  42 ="94647" 
  43 ="94359" 
  44 ="94050" 
  45 ="93717" 
  46 ="93356" 
  47 ="92966" 
  48 ="92546" 
  49 ="92096" 
  50 ="91616" 
  51 ="91104" 
  52 ="90556" 
  53 ="89968" 
  54 ="89334" 
  55 ="88646" 
  56 ="87899" 
  57 ="87084" 
  58 ="86197" 
  59 ="85232" 
  60 ="84188" 
  61 ="83056" 
  62 ="81829" 
  63 ="80502" 
  64 ="79075" 
  65 ="77547" 
  66 ="75926" 
  67 ="74211" 
  68 ="72392" 
  69 ="70450" 
  70 ="68375" 
  71 ="66170" 
  72 ="63850" 
  73 ="61423" 
  74 ="58899" 
  75 ="56288" 
  76 ="53600" 
  77 ="50847" 
  78 ="48024" 
  79 ="45121" 
  80 ="42127" 
  81 ="39032" 
  82 ="35846" 
  83 ="32606" 
  84 ="29377" 
  85 ="26219" 
  86 ="23135" 
  87 ="20167" 
  88 ="17351" 
  89 ="14723" 
  90 ="12310" 
  91 ="10133" 
  92 ="8204"  
  93 ="6528"  
  94 ="5100"  
  95 ="3910"  
  96 ="2938"  
  97 ="2163"  
  98 ="1558"  
  99 ="1098"  
  100="757"   
  other="ERROR"
   ;
   
value lx1998w
    0  ="100000"
    1  ="99345"
    2  ="99294"
    3  ="99263"
    4  ="99239"
    5  ="99220"
    6  ="99202"
    7  ="99186"
    8  ="99171"
    9  ="99157"
    10 ="99144"
    11 ="99132"
    12 ="99119"
    13 ="99104"
    14 ="99084"
    15 ="99059"
    16 ="99027"
    17 ="98988"
    18 ="98946"
    19 ="98901"
    20 ="98857"
    21 ="98812"
    22 ="98768"
    23 ="98722"
    24 ="98675"
    25 ="98627"
    26 ="98577"
    27 ="98525"
    28 ="98470"
    29 ="98412"
    30 ="98350"
    31 ="98284"
    32 ="98213"
    33 ="98137"
    34 ="98054"
    35 ="97964"
    36 ="97867"
    37 ="97762"
    38 ="97649"
    39 ="97528"
    40 ="97398"
    41 ="97257"
    42 ="97106"
    43 ="96944"
    44 ="96770"
    45 ="96582"
    46 ="96381"
    47 ="96163"
    48 ="95928"
    49 ="95671"
    50 ="95392"
    51 ="95087"
    52 ="94754"
    53 ="94390"
    54 ="93994"
    55 ="93562"
    56 ="93089"
    57 ="92570"
    58 ="92000"
    59 ="91378"
    60 ="90700"
    61 ="89959"
    62 ="89150"
    63 ="88268"
    64 ="87314"
    65 ="86288"
    66 ="85193"
    67 ="84025"
    68 ="82769"
    69 ="81407"
    70 ="79926"
    71 ="78324"
    72 ="76605"
    73 ="74771"
    74 ="72824"
    75 ="70761"
    76 ="68589"
    77 ="66303"
    78 ="63888"
    79 ="61319"
    80 ="58573"
    81 ="55646"
    82 ="52547"
    83 ="49278"
    84 ="45854"
    85 ="42297"
    86 ="38658"
    87 ="34982"
    88 ="31315"
    89 ="27709"
    90 ="24214"
    91 ="20878"
    92 ="17746"
    93 ="14856"
    94 ="12238"
    95 ="9911"
    96 ="7883"
    97 ="6154"
    98 ="4711"
    99 ="3533"
    100="2594"
    other="ERROR"
    ;   
    
value lx1999m
0="100000"
1="99228"
2="99170"
3="99129"
4="99099"
5="99075"
6="99053"
7="99033"
8="99013"
9="98995"
10="98980"
11="98967"
12="98954"
13="98936"
14="98904"
15="98855"
16="98788"
17="98704"
18="98605"
19="98496"
20="98379"
21="98254"
22="98121"
23="97982"
24="97842"
25="97704"
26="97569"
27="97435"
28="97303"
29="97168"
30="97030"
31="96887"
32="96739"
33="96585"
34="96423"
35="96253"
36="96074"
37="95886"
38="95686"
39="95473"
40="95244"
41="94998"
42="94733"
43="94449"
44="94141"
45="93808"
46="93445"
47="93050"
48="92624"
49="92168"
50="91683"
51="91168"
52="90620"
53="90033"
54="89399"
55="88710"
56="87957"
57="87134"
58="86239"
59="85271"
60="84232"
61="83115"
62="81913"
63="80619"
64="79226"
65="77730"
66="76135"
67="74437"
68="72628"
69="70695"
70="68632"
71="66448"
72="64157"
73="61759"
74="59256"
75="56651"
76="53954"
77="51180"
78="48333"
79="45410"
80="42406"
81="39312"
82="36136"
83="32905"
84="29672"
85="26487"
86="23377"
87="20382"
88="17542"
89="14889"
90="12453"
91="10254"
92="8305"
93="6611"
94="5168"
95="3963"
96="2980"
97="2195"
98="1583"
99="1116"
100="770"
other="ERROR"
;

value lx1999w
0="100000"
1="99364"
2="99316"
3="99285"
4="99261"
5="99242"
6="99224"
7="99208"
8="99192"
9="99178"
10="99165"
11="99153"
12="99141"
13="99127"
14="99108"
15="99082"
16="99050"
17="99011"
18="98968"
19="98922"
20="98876"
21="98830"
22="98784"
23="98736"
24="98688"
25="98639"
26="98588"
27="98535"
28="98480"
29="98422"
30="98361"
31="98297"
32="98229"
33="98156"
34="98075"
35="97987"
36="97891"
37="97787"
38="97674"
39="97553"
40="97422"
41="97281"
42="97129"
43="96965"
44="96789"
45="96599"
46="96393"
47="96171"
48="95929"
49="95668"
50="95384"
51="95077"
52="94744"
53="94381"
54="93986"
55="93554"
56="93079"
57="92556"
58="91982"
59="91356"
60="90677"
61="89939"
62="89134"
63="88259"
64="87310"
65="86283"
66="85179"
67="83991"
68="82711"
69="81331"
70="79843"
71="78251"
72="76555"
73="74747"
74="72813"
75="70741"
76="68535"
77="66199"
78="63726"
79="61104"
80="58317"
81="55365"
82="52249"
83="48965"
84="45518"
85="41923"
86="38253"
87="34551"
88="30865"
89="27248"
90="23749"
91="20419"
92="17302"
93="14434"
94="11845"
95="9553"
96="7564"
97="5875"
98="4473"
99="3335"
100="2433"
other="ERROR"
;

  value lx2000m
  0  ="100000"
  1  ="99241"
  2  ="99184"
  3  ="99146"
  4  ="99118"
  5  ="99096"
  6  ="99076"
  7  ="99056"
  8  ="99037"
  9  ="99020"
  10 ="99006"
  11 ="98993"
  12 ="98980"
  13 ="98961"
  14 ="98930"
  15 ="98882"
  16 ="98817"
  17 ="98735"
  18 ="98639"
  19 ="98531"
  20 ="98413"
  21 ="98285"
  22 ="98148"
  23 ="98005"
  24 ="97859"
  25 ="97716"
  26 ="97575"
  27 ="97437"
  28 ="97300"
  29 ="97164"
  30 ="97025"
  31 ="96883"
  32 ="96739"
  33 ="96589"
  34 ="96432"
  35 ="96266"
  36 ="96090"
  37 ="95904"
  38 ="95705"
  39 ="95493"
  40 ="95264"
  41 ="95018"
  42 ="94754"
  43 ="94470"
  44 ="94161"
  45 ="93826"
  46 ="93460"
  47 ="93061"
  48 ="92629"
  49 ="92166"
  50 ="91674"
  51 ="91153"
  52 ="90599"
  53 ="90007"
  54 ="89372"
  55 ="88687"
  56 ="87943"
  57 ="87134"
  58 ="86256"
  59 ="85307"
  60 ="84286"
  61 ="83188"
  62 ="82002"
  63 ="80727"
  64 ="79359"
  65 ="77897"
  66 ="76344"
  67 ="74695"
  68 ="72940"
  69 ="71063"
  70 ="69055"
  71 ="66926"
  72 ="64688"
  73 ="62343"
  74 ="59887"
  75 ="57321"
  76 ="54658"
  77 ="51912"
  78 ="49088"
  79 ="46183"
  80 ="43192"
  81 ="40107"
  82 ="36936"
  83 ="33705"
  84 ="30465"
  85 ="27265"
  86 ="24132"
  87 ="21107"
  88 ="18229"
  89 ="15531"
  90 ="13045"
  91 ="10791"
  92 ="8784"
  93 ="7031"
  94 ="5529"
  95 ="4268"
  96 ="3231"
  97 ="2398"
  98 ="1744"
  99 ="1241"
  100="864"
  other="ERROR"
   ;
   
   value lx2000w
    0  ="100000"
    1  ="99376"
    2  ="99330"
    3  ="99300"
    4  ="99280"
    5  ="99261"
    6  ="99245"
    7  ="99229"
    8  ="99215"
    9  ="99202"
    10 ="99189"
    11 ="99177"
    12 ="99165"
    13 ="99150"
    14 ="99132"
    15 ="99107"
    16 ="99076"
    17 ="99039"
    18 ="98998"
    19 ="98954"
    20 ="98909"
    21 ="98863"
    22 ="98817"
    23 ="98769"
    24 ="98720"
    25 ="98671"
    26 ="98619"
    27 ="98566"
    28 ="98511"
    29 ="98453"
    30 ="98392"
    31 ="98329"
    32 ="98261"
    33 ="98188"
    34 ="98108"
    35 ="98021"
    36 ="97926"
    37 ="97824"
    38 ="97712"
    39 ="97591"
    40 ="97460"
    41 ="97317"
    42 ="97162"
    43 ="96995"
    44 ="96816"
    45 ="96623"
    46 ="96415"
    47 ="96191"
    48 ="95948"
    49 ="95684"
    50 ="95398"
    51 ="95088"
    52 ="94751"
    53 ="94387"
    54 ="93991"
    55 ="93561"
    56 ="93091"
    57 ="92574"
    58 ="92007"
    59 ="91389"
    60 ="90716"
    61 ="89982"
    62 ="89180"
    63 ="88308"
    64 ="87363"
    65 ="86344"
    66 ="85251"
    67 ="84076"
    68 ="82812"
    69 ="81450"
    70 ="79983"
    71 ="78415"
    72 ="76745"
    73 ="74961"
    74 ="73044"
    75 ="70983"
    76 ="68781"
    77 ="66446"
    78 ="63974"
    79 ="61351"
    80 ="58563"
    81 ="55608"
    82 ="52486"
    83 ="49195"
    84 ="45741"
    85 ="42145"
    86 ="38471"
    87 ="34763"
    88 ="31071"
    89 ="27445"
    90 ="23936"
    91 ="20595"
    92 ="17464"
    93 ="14582"
    94 ="11978"
    95 ="9669"
    96 ="7665"
    97 ="5961"
    98 ="4544"
    99 ="3393"
    100="2479"
    other="ERROR"
    ;

value lx2001m
0="100000"
1="99249"
2="99193"
3="99155"
4="99126"
5="99102"
6="99083"
7="99066"
8="99051"
9="99035"
10="99019"
11="99001"
12="98983"
13="98963"
14="98938"
15="98906"
16="98860"
17="98791"
18="98700"
19="98580"
20="98444"
21="98311"
22="98163"
23="98023"
24="97888"
25="97752"
26="97624"
27="97489"
28="97359"
29="97224"
30="97092"
31="96954"
32="96818"
33="96677"
34="96522"
35="96359"
36="96180"
37="95997"
38="95791"
39="95569"
40="95337"
41="95087"
42="94825"
43="94542"
44="94229"
45="93892"
46="93529"
47="93142"
48="92713"
49="92254"
50="91768"
51="91247"
52="90707"
53="90127"
54="89527"
55="88839"
56="88161"
57="87382"
58="86542"
59="85600"
60="84654"
61="83582"
62="82458"
63="81231"
64="79920"
65="78506"
66="76988"
67="75391"
68="73665"
69="71830"
70="69875"
71="67824"
72="65652"
73="63335"
74="60880"
75="58335"
76="55655"
77="52874"
78="50001"
79="47012"
80="43928"
81="40856"
82="37568"
83="34457"
84="31192"
85="27975"
86="24820"
87="21766"
88="18852"
89="16113"
90="13580"
91="11277"
92="9218"
93="7412"
94="5857"
95="4546"
96="3462"
97="2586"
98="1893"
99="1357"
100="953"
other="ERROR"
;

value lx2001w
0="100000"
1="99386"
2="99339"
3="99310"
4="99287"
5="99269"
6="99254"
7="99240"
8="99226"
9="99214"
10="99200"
11="99189"
12="99176"
13="99161"
14="99145"
15="99124"
16="99099"
17="99062"
18="99019"
19="98977"
20="98933"
21="98889"
22="98842"
23="98798"
24="98750"
25="98702"
26="98651"
27="98601"
28="98547"
29="98488"
30="98428"
31="98363"
32="98299"
33="98224"
34="98144"
35="98057"
36="97963"
37="97859"
38="97747"
39="97619"
40="97481"
41="97332"
42="97178"
43="97009"
44="96822"
45="96620"
46="96403"
47="96175"
48="95929"
49="95671"
50="95381"
51="95075"
52="94755"
53="94392"
54="94002"
55="93563"
56="93127"
57="92619"
58="92062"
59="91437"
60="90795"
61="90082"
62="89315"
63="88466"
64="87542"
65="86550"
66="85488"
67="84339"
68="83093"
69="81760"
70="80332"
71="78809"
72="77173"
73="75423"
74="73533"
75="71532"
76="69392"
77="67093"
78="64671"
79="62066"
80="59311"
81="56422"
82="53296"
83="50185"
84="46795"
85="43267"
86="39650"
87="35986"
88="32320"
89="28703"
90="25184"
91="21812"
92="18632"
93="15684"
94="12998"
95="10596"
96="8489"
97="6680"
98="5157"
99="3904"
100="2896"
other="ERROR"
;

  value lx2002m
  0  ="100000"
  1  ="99236"
  2  ="99184"
  3  ="99148"
  4  ="99120"
  5  ="99097"
  6  ="99079"
  7  ="99063"
  8  ="99047"
  9  ="99030"
  10 ="99014"
  11 ="98997"
  12 ="98980"
  13 ="98957"
  14 ="98932"
  15 ="98900"
  16 ="98857"
  17 ="98783"
  18 ="98693"
  19 ="98574"
  20 ="98436"
  21 ="98299"
  22 ="98157"
  23 ="98021"
  24 ="97882"
  25 ="97746"
  26 ="97614"
  27 ="97479"
  28 ="97352"
  29 ="97225"
  30 ="97091"
  31 ="96954"
  32 ="96813"
  33 ="96678"
  34 ="96526"
  35 ="96367"
  36 ="96196"
  37 ="96016"
  38 ="95823"
  39 ="95610"
  40 ="95381"
  41 ="95128"
  42 ="94859"
  43 ="94577"
  44 ="94266"
  45 ="93929"
  46 ="93569"
  47 ="93171"
  48 ="92755"
  49 ="92296"
  50 ="91809"
  51 ="91286"
  52 ="90722"
  53 ="90138"
  54 ="89505"
  55 ="88850"
  56 ="88102"
  57 ="87369"
  58 ="86542"
  59 ="85644"
  60 ="84637"
  61 ="83612"
  62 ="82483"
  63 ="81255"
  64 ="79946"
  65 ="78556"
  66 ="77071"
  67 ="75501"
  68 ="73809"
  69 ="72012"
  70 ="70087"
  71 ="68039"
  72 ="65864"
  73 ="63621"
  74 ="61202"
  75 ="58680"
  76 ="56028"
  77 ="53251"
  78 ="50398"
  79 ="47454"
  80 ="44370"
  81 ="41252"
  82 ="38102"
  83 ="34798"
  84 ="31719"
  85 ="28478"
  86 ="25296"
  87 ="22212"
  88 ="19266"
  89 ="16494"
  90 ="13925"
  91 ="11585"
  92 ="9490"
  93 ="7648"
  94 ="6059"
  95 ="4715"
  96 ="3601"
  97 ="2698"
  98 ="1982"
  99 ="1426"
  100="1005"
  other="ERROR"
   ;
   
   value lx2002w
   0  ="100000"
   1  ="99373"
   2  ="99331"
   3  ="99303"
   4  ="99284"
   5  ="99267"
   6  ="99250"
   7  ="99238"
   8  ="99226"
   9  ="99212"
   10 ="99199"
   11 ="99187"
   12 ="99174"
   13 ="99160"
   14 ="99141"
   15 ="99120"
   16 ="99095"
   17 ="99057"
   18 ="99013"
   19 ="98967"
   20 ="98922"
   21 ="98877"
   22 ="98827"
   23 ="98781"
   24 ="98736"
   25 ="98688"
   26 ="98639"
   27 ="98589"
   28 ="98539"
   29 ="98483"
   30 ="98424"
   31 ="98362"
   32 ="98296"
   33 ="98225"
   34 ="98148"
   35 ="98064"
   36 ="97970"
   37 ="97869"
   38 ="97759"
   39 ="97640"
   40 ="97500"
   41 ="97355"
   42 ="97194"
   43 ="97023"
   44 ="96830"
   45 ="96627"
   46 ="96405"
   47 ="96176"
   48 ="95928"
   49 ="95654"
   50 ="95364"
   51 ="95059"
   52 ="94724"
   53 ="94380"
   54 ="93989"
   55 ="93572"
   56 ="93095"
   57 ="92629"
   58 ="92084"
   59 ="91491"
   60 ="90826"
   61 ="90138"
   62 ="89374"
   63 ="88552"
   64 ="87657"
   65 ="86680"
   66 ="85631"
   67 ="84512"
   68 ="83281"
   69 ="81982"
   70 ="80556"
   71 ="79026"
   72 ="77410"
   73 ="75666"
   74 ="73802"
   75 ="71800"
   76 ="69639"
   77 ="67366"
   78 ="64935"
   79 ="62372"
   80 ="59621"
   81 ="56681"
   82 ="53660"
   83 ="50324"
   84 ="47075"
   85 ="43542"
   86 ="39919"
   87 ="36246"
   88 ="32571"
   89 ="28943"
   90 ="25411"
   91 ="22024"
   92 ="18828"
   93 ="15862"
   94 ="13158"
   95 ="10737"
   96 ="8613"
   97 ="6785"
   98 ="5245"
   99 ="3977"
   100="2954"
   other="ERROR"
    ;

  value lx2003m
  0  ="100000"
  1  ="99239"
  2  ="99187"
  3  ="99151"
  4  ="99122"
  5  ="99100"
  6  ="99081"
  7  ="99064"
  8  ="99049"
  9  ="99034"
  10 ="99020"
  11 ="99002"
  12 ="98986"
  13 ="98964"
  14 ="98939"
  15 ="98906"
  16 ="98863"
  17 ="98793"
  18 ="98704"
  19 ="98584"
  20 ="98450"
  21 ="98313"
  22 ="98174"
  23 ="98032"
  24 ="97896"
  25 ="97762"
  26 ="97632"
  27 ="97500"
  28 ="97371"
  29 ="97244"
  30 ="97112"
  31 ="96976"
  32 ="96839"
  33 ="96692"
  34 ="96546"
  35 ="96392"
  36 ="96225"
  37 ="96045"
  38 ="95852"
  39 ="95648"
  40 ="95424"
  41 ="95182"
  42 ="94916"
  43 ="94627"
  44 ="94321"
  45 ="93984"
  46 ="93629"
  47 ="93228"
  48 ="92799"
  49 ="92342"
  50 ="91848"
  51 ="91318"
  52 ="90756"
  53 ="90154"
  54 ="89540"
  55 ="88851"
  56 ="88142"
  57 ="87340"
  58 ="86569"
  59 ="85678"
  60 ="84710"
  61 ="83640"
  62 ="82549"
  63 ="81324"
  64 ="80050"
  65 ="78674"
  66 ="77222"
  67 ="75675"
  68 ="74010"
  69 ="72257"
  70 ="70359"
  71 ="68359"
  72 ="66286"
  73 ="64037"
  74 ="61682"
  75 ="59223"
  76 ="56590"
  77 ="53844"
  78 ="51011"
  79 ="48099"
  80 ="45076"
  81 ="41936"
  82 ="38763"
  83 ="35608"
  84 ="32260"
  85 ="29190"
  86 ="26161"
  87 ="23204"
  88 ="20351"
  89 ="17631"
  90 ="15073"
  91 ="12702"
  92 ="10539"
  93 ="8598"
  94 ="6889"
  95 ="5414"
  96 ="4166"
  97 ="3135"
  98 ="2303"
  99 ="1650"
  100="1150"
  other="ERROR"
   ;
   

   value lx2003w
   0  ="100000"
   1  ="99392"
   2  ="99351"
   3  ="99322"
   4  ="99299"
   5  ="99282"
   6  ="99268"
   7  ="99255"
   8  ="99242"
   9  ="99230"
   10 ="99217"
   11 ="99203"
   12 ="99190"
   13 ="99177"
   14 ="99161"
   15 ="99143"
   16 ="99119"
   17 ="99084"
   18 ="99045"
   19 ="98996"
   20 ="98950"
   21 ="98902"
   22 ="98853"
   23 ="98803"
   24 ="98754"
   25 ="98704"
   26 ="98655"
   27 ="98601"
   28 ="98545"
   29 ="98491"
   30 ="98430"
   31 ="98369"
   32 ="98303"
   33 ="98235"
   34 ="98156"
   35 ="98073"
   36 ="97977"
   37 ="97875"
   38 ="97763"
   39 ="97644"
   40 ="97512"
   41 ="97364"
   42 ="97204"
   43 ="97030"
   44 ="96848"
   45 ="96642"
   46 ="96424"
   47 ="96184"
   48 ="95933"
   49 ="95666"
   50 ="95375"
   51 ="95064"
   52 ="94730"
   53 ="94367"
   54 ="93992"
   55 ="93569"
   56 ="93124"
   57 ="92615"
   58 ="92108"
   59 ="91508"
   60 ="90858"
   61 ="90133"
   62 ="89398"
   63 ="88562"
   64 ="87674"
   65 ="86692"
   66 ="85658"
   67 ="84553"
   68 ="83351"
   69 ="82062"
   70 ="80693"
   71 ="79169"
   72 ="77579"
   73 ="75860"
   74 ="74033"
   75 ="72070"
   76 ="69969"
   77 ="67715"
   78 ="65298"
   79 ="62764"
   80 ="60059"
   81 ="57151"
   82 ="54120"
   83 ="50960"
   84 ="47526"
   85 ="44201"
   86 ="40792"
   87 ="37328"
   88 ="33839"
   89 ="30363"
   90 ="26939"
   91 ="23607"
   92 ="20410"
   93 ="17387"
   94 ="14575"
   95 ="12005"
   96 ="9702"
   97 ="7680"
   98 ="5945"
   99 ="4491"
   100="3306"
   other="ERROR"
    ;
