clear
set matsize 800
global datadir "H:\CMS-HRS Merge"
global resultdir "H:\CMS-HRS Merge"

cd "$datadir"
capture log close
log using hrs_cms_merge.log, replace

set memory 100m
set more off

use "ssafipscrosswalk.dta", clear
drop if ssa_cty=="999"
sort ssa_st ssa_cty
di _N
tab ssa_st
save "ssafipscrosswalkNew.dta", replace

use "countymaster.dta", clear
drop if ssa_st=="05" & ssa_cty=="210"
rename year yr
recode yr 1993=93 1994=94 1995=95 1996=96 1997=97 1998=98
sort ssa_st ssa_cty
sum
merge ssa_st ssa_cty using ssafipscrosswalkNew, update

tab _merge
list if _merge==2
* drop if _merge==2
rename _merge merge_cms
rename fips_st StFIPS
rename fips_cty CtyFPS
sort StFIPS CtyFPS yr
save "countymasterNew.dta", replace

/* 1994 */
infile using "H:\CMS-HRS Merge\County\Stata\hrs2cty.dct", clear
gen yr = 94
sort HHID PN
save "hrs_cms_94.dta", replace

/* Merge State variables into county data */
infile using "H:\CMS-HRS Merge\State\Stata\hrs2st.dct", clear
sort HHID PN
merge HHID PN using hrs_cms_94.dta
tab _merge
drop _merge
sort HHID PN
save "hrs_cms_94.dta", replace

/* Merge Zipcode into the dataset */
infile using "H:\CMS-HRS Merge\Zipcode\Stata\hrs2zip.dct", clear
sort HHID PN
merge HHID PN using hrs_cms_94.dta
tab _merge
drop _merge

/* Merge CMS into HRS */
sort StFIPS CtyFPS yr
merge StFIPS CtyFPS yr using  countymasterNew
tab _merge
drop if _merge==2
rename _merge merge94
save "hrs_cms_94.dta", replace
count if merge_cms==2

/* 1996 */
infile using "H:\CMS-HRS Merge\County\Stata\hrs3cty.dct", clear
gen yr = 96
sort HHID PN
save "hrs_cms_96.dta", replace

/* Merge State variables into the dataset */
infile using "H:\CMS-HRS Merge\State\Stata\hrs3st.dct", clear
sort HHID PN
merge HHID PN using hrs_cms_96.dta
tab _merge
drop _merge
sort HHID PN
save "hrs_cms_96.dta", replace

/* Merge Zipcode into the dataset */
infile using "H:\CMS-HRS Merge\Zipcode\Stata\hrs3zip.dct", clear
sort HHID PN
merge HHID PN using hrs_cms_96.dta
tab _merge
drop _merge

/* correcting errors */
replace StFIPS = "51" if State=="Virginia"
replace StFIPS = "12" if State=="Florida"
replace StFIPS = "43" if State=="Puerto Rico"

/* Merge CMS into HRS */
sort StFIPS CtyFPS yr
merge StFIPS CtyFPS yr using countymasterNew
tab _merge
drop if _merge==2
rename _merge merge96
save "hrs_cms_96.dta", replace
count if merge_cms==2

/* 1998 */
infile using "H:\CMS-HRS Merge\County\Stata\hrs98cty.dct", clear
gen yr = 98
sort HHID PN
save "hrs_cms_98.dta", replace

/* Merge State variables into the dataset */
infile using "H:\CMS-HRS Merge\State\Stata\hrs98st.dct", clear
sort HHID PN
merge HHID PN using hrs_cms_98.dta
tab _merge
drop _merge
sort HHID PN
save "hrs_cms_98.dta", replace

/* Merge Zipcode into the dataset */
infile using "H:\CMS-HRS Merge\Zipcode\Stata\hrs98zip.dct", clear
sort HHID PN
merge HHID PN using hrs_cms_98.dta
tab _merge
drop _merge

/* correcting errors */
replace StFIPS = "43" if State=="Puerto Rico"
replace CtyFPS = "025" if State=="Florida" & County=="Dade"

/* Merge CMS into HRS */
sort StFIPS CtyFPS yr
merge StFIPS CtyFPS yr using "H:\CMS-HRS Merge\CMS2000\cms9800.dta"
tab _merge
drop if _merge==2
rename _merge merge98
save "hrs_cms_98.dta", replace
count if merge_cms==2

/* 2000 */
infile using "H:\CMS-HRS Merge\County\Stata\hrs00cty.dct", clear
gen yr = 0
sort HHID PN
save "hrs_cms_00.dta", replace

/* Merge State variables into the dataset */
infile using "H:\CMS-HRS Merge\State\Stata\hrs00st.dct", clear
sort HHID PN
merge HHID PN using hrs_cms_00.dta
tab _merge
drop _merge
sort HHID PN
save "hrs_cms_00.dta", replace

/* Merge Zipcode into the dataset */
infile using "H:\CMS-HRS Merge\Zipcode\Stata\hrs00zip.dct", clear
sort HHID PN
merge HHID PN using hrs_cms_00.dta
tab _merge
drop _merge

/* correcting errors */
replace StFIPS = "43" if State=="Puerto Rico"
replace CtyFPS = "025" if State=="Florida" & County=="Dade"

/* Merge CMS into HRS */
sort StFIPS CtyFPS yr
merge StFIPS CtyFPS yr using "H:\CMS-HRS Merge\CMS2000\cms9800.dta"
tab _merge
drop if _merge==2
rename _merge merge00
save "hrs_cms_00.dta", replace
count if merge_cms==1
count if merge_cms==2

append using hrs_cms_94.dta
append using hrs_cms_96.dta
append using hrs_cms_98.dta
gen str9 HHIDPN = HHID + PN
save "hrs_cms_long.dta", replace

drop merge1 merge2 merge94 merge96 merge98 merge_cms

* missing==1: observations with missing 2000 HRS 
rename merge00 missing
drop ctyname stname MatchTyp
sort HHID PN yr
by HHID PN yr: drop if _n==2
#d ;
reshape wide StFIPS StUSPS ZipCode State CtyFPS StCty County UrbRural ssa_st ssa_cty
tempmm tanpay testab emp1 emp2 emp3 emp4 emp5 emp6 emp7 emp8 emp9 elig basprem prempos 
totprtab benes pctpen numplans numrx RISK hmopen flaghmo flagrx NOTRISK prta prtb SCcode
numplans_org numplans_risk benes2 elig2 missing, i(HHID PN) j(yr);
#d cr

destring HHIDPN, generate (hhidpn)
sort hhidpn
save "hrs_cms_wide.dta", replace

use "E:\HRS\age6598.dta", clear
sort hhidpn
merge hhidpn using hrs_cms_wide
tab _merge
drop if _merge==2
rename _merge merge98
sort hhidpn
save "hrs_cms_wide65.dta", replace

* sort hrs file
use "E:\HRS\age6500.dta", clear
sort hhidpn
save "E:\HRS\age6500.dta", replace
use "hrs_cms_wide65.dta", clear

merge hhidpn using "E:\HRS\age6500.dta"
tab _merge

drop missing*
drop if _merge==2
rename _merge merge00
save "hrs_cms_wide65.dta", replace

log close
