/*
Nicole Maestas
November 18, 2002

This program works with h00.sas7bdat data file, which contains health
insurance vars from the RAND Flat File merged with RAND HRS data for
all cohorts (HRS, AHEAD, War Babies, CODA) and all waves. This data
file was created by program h00.sas.

Although my health insurance vars are coded (and only relevant) for
those age 65+, the other data files contain data on everyone. Must
re-invoke age selection. Best var to use is my age_yr var, for
consistency with sample selection used for health insurance vars.

Note sample conditions on those making it to Wave 5.
Note sample of interest is HRS 1998.

Note this is a respondent level file with spouse info on each record,
which means married households are in the file twice, once for each spouse.
Except spouse as respondent won't be on the file if younger than 65.
*/

options linesize=120 pagesize=60 compress=no nocenter replace mprint
 nodate nonumber formdlim=' ';

%let fmtlib=/homer/a/Retire/Pgmlib00c/Fmt/;

%let fmtlib=/homer/d/RANDHRS/VerC/Sas8/; *has formats.sas7bdat;
libname library  "&fmtlib"; 

libname out '/zeno/a/baoping/HRS';

%include "/homer/a/Retire/Pgmlib00a/Mac/wvlist.mac";
%include "/homer/a/Retire/Pgmlib00a/Mac/wvlabel.mac";
%include "/homer/a/Retire/Pgmlib00a/Mac/addsp.mac";

proc format;
   %include "/zeno/b/maestas/hmo/h00.fmt";

%macro asinh(invar,outvar);
  &outvar=log( &invar + (sqrt((&invar**2) + 1)) );
%mend;

%macro sinh(invar,outvar);
  &outvar=.5*( exp(&invar)-exp(-&invar) );
%mend;
run;


data out.age6500;
set out.h00new;

*IMPOSE AGE 65 RESTRICTION;
*some discrepancies in age vars between flat file and rand hrs files;
*if r5age65=1; /*based on flat file var coded in hinsur1.sas*/
*if r5agey_e>=65; /*rand hrs var--age at end of interview*/

s5age65x=(s5agey_e>=65); /*s5age65 is version based on flat file*/
r5age65x=(r5agey_e>=65); /*r5age65 is version based on flat file*/

*age squared;
r5agesq=r5agey_e**2;
s5agesq=s5agey_e**2;

*dummy for married at wave 5;
r5marr=(r5mstat<=3);
*male=(ragender=1);

*wave4 log wealth and income;
if h4atota>0 then h4logtota=log(h4atota); /*log net hh wealth*/
if h4itot>0 then h4logitot=log(h4itot); /*log total hh income*/
%asinh(h4atota,h4ashtota); /*asinh net hh wealth*/
%asinh(h4itot,h4ashitot); /*asinh net hh income*/
*asinh portfolio values;
%asinh(h4achck,h4ashchck); /*asinh value checking, savings, mm accts*/
%asinh(h4astck,h4ashstck); /*asinh value stocks, mf, invest trusts*/


*portfolio shares;
*denominator h4atotf is net financial wealth;
*do not use debt, endogenous because includes medical debts;
if h4atotf >0 then do;
  h4pctstck=h4astck/h4atotf; /*pct stocks, mutual funds, invest. trusts*/
  h4pctchck=h4achck/h4atotf; /*pct checking, savings, money market acts*/
  h4pctcd=h4acd/h4atotf; /*pct CDs, gov savings bonds, T-bills*/
  h4pctbond=h4abond/h4atotf; /*pct bonds and bond funds*/

  *h4pctdebt=h4adebt/h4atotf; /*pct other debt--credit card bals, medical
    debts, loans fr. relatives and life ins*/
end;

*denominator h4atotn is net non-housing and financial wealth;
if h4atotn >0 then do;
  h4pctrles=h4arles/h4atotn; /*pct real estate excl. primary residence*/
  h4pctbsns=h4absns/h4atotn; /*pct businesses*/
end;


*NEW CODE FOR PORTFOLIO SHARES;
*need to add versions with life insurance and DC plans;
*a few versions of the denominator--total financial assets;
*about 14% of households have zero financial assets. seems too high;
h4totfass1=h4astck+h4abond+h4achck+h4acd; *stock, bonds, checking, cd's/tbills;
h4totfass2=h4astck+h4abond+h4achck+h4acd+h4aira; *plus iras;
h4totfass3=h4astck+h4abond+h4achck+h4acd+h4aira+h4arles; *plus non-prim real est;
h4totfass4=h4astck+h4abond+h4achck+h4acd+h4aira+h4arles+h4absns; *plus business;

h4safeass=h4achck+h4acd;
h4riskass1=h4astck+h4abond;
h4riskass2=h4astck+h4abond+h4aira;
h4riskass3=h4astck+h4abond+h4aira+h4arles;
h4riskass4=h4astck+h4abond+h4aira+h4arles+h4absns;

*portfolio share not defined for those with zero financial assets;
if h4totfass1 ne 0 then h4risky1=h4riskass1/h4totfass1;
if h4totfass2 ne 0 then h4risky2=h4riskass2/h4totfass2;
if h4totfass3 ne 0 then h4risky3=h4riskass3/h4totfass3;
if h4totfass4 ne 0 then h4risky4=h4riskass4/h4totfass4;
if h4totfass1 ne 0 then h4safe1=h4safeass/h4totfass1;

h4anystck=(h4astck>0);
h4anybond=(h4abond>0);
h4anychck=(h4achck>0);
h4anycd=(h4acd>0);
h4anyira=(h4aira>0);
h4anyrles=(h4arles>0);
h4anybus=(h4absns>0);

*wave5 log wealth and income;
if h5atota>0 then h5logtota=log(h5atota); /*log net hh wealth*/
if h5itot>0 then h5logitot=log(h5itot); /*log total hh income*/
%asinh(h5atota,h5ashtota); /*asinh net hh wealth*/
%asinh(h5itot,h5ashitot); /*asinh net hh income*/
*asinh portfolio values;
%asinh(h5achck,h5ashchck); /*asinh value checking, savings, mm accts*/
%asinh(h5astck,h5ashstck); /*asinh value stocks, mf, invest trusts*/


*portfolio shares;
*denominator h5atotf is net financial wealth;
*do not use debt, endogenous because includes medical debts;
if h5atotf >0 then do;
  h5pctstck=h5astck/h5atotf; /*pct stocks, mutual funds, invest. trusts*/
  h5pctchck=h5achck/h5atotf; /*pct checking, savings, money market acts*/
  h5pctcd=h5acd/h5atotf; /*pct CDs, gov savings bonds, T-bills*/
  h5pctbond=h5abond/h5atotf; /*pct bonds and bond funds*/

  *h5pctdebt=h5adebt/h5atotf; /*pct other debt--credit card bals, medical
    debts, loans fr. relatives and life ins*/
end;

*denominator h5atotn is net non-housing and financial wealth;
if h5atotn >0 then do;
  h5pctrles=h5arles/h5atotn; /*pct real estate excl. primary residence*/
  h5pctbsns=h5absns/h5atotn; /*pct businesses*/
end;


*NEW CODE FOR PORTFOLIO SHARES;
*need to add versions with life insurance and DC plans;
*a few versions of the denominator--total financial assets;
*about 14% of households have zero financial assets. seems too high;
h5totfass1=h5astck+h5abond+h5achck+h5acd; *stock, bonds, checking, cd's/tbills;
h5totfass2=h5astck+h5abond+h5achck+h5acd+h5aira; *plus iras;
h5totfass3=h5astck+h5abond+h5achck+h5acd+h5aira+h5arles; *plus non-prim real est;
h5totfass4=h5astck+h5abond+h5achck+h5acd+h5aira+h5arles+h5absns; *plus business;

h5safeass=h5achck+h5acd;
h5riskass1=h5astck+h5abond;
h5riskass2=h5astck+h5abond+h5aira;
h5riskass3=h5astck+h5abond+h5aira+h5arles;
h5riskass4=h5astck+h5abond+h5aira+h5arles+h5absns;

*portfolio share not defined for those with zero financial assets;
if h5totfass1 ne 0 then h5risky1=h5riskass1/h5totfass1;
if h5totfass2 ne 0 then h5risky2=h5riskass2/h5totfass2;
if h5totfass3 ne 0 then h5risky3=h5riskass3/h5totfass3;
if h5totfass4 ne 0 then h5risky4=h5riskass4/h5totfass4;
if h5totfass1 ne 0 then h5safe1=h5safeass/h5totfass1;

h5anystck=(h5astck>0);
h5anybond=(h5abond>0);
h5anychck=(h5achck>0);
h5anycd=(h5acd>0);
h5anyira=(h5aira>0);
h5anyrles=(h5arles>0);
h5anybus=(h5absns>0);

*labor supply dummies, mutually exclusive;
r5wkft=(r5lbrf=1);
r5wkpt=(r5lbrf=2);
r5ptret=(r5lbrf=4);
r5ret=(r5lbrf=5);
r5disab=(r5lbrf=6);
r5notwkr=(r5lbrf in (3,7)); /*includes 34 unemployed obs*/

proc contents;
proc means;
endsas;

******************************************************;
%let labsup=wkft wkpt ptret ret disab; /*ref group is notwkr*/

proc freq;
tables any:;

proc contents;


proc freq;
tables r5marr male r5agey_e r5agesq rablack rahisp
  raother r4shlt r4iadlza r4adla r4conde r4cesd &labsup notwkr;
format r4shlt shlt.;

proc freq;
tables chkrace risk risk*cohort  r1risk*cohort r4age65x /missing;
format cohort cohortf.;

proc univariate;
var h4atota h4ashtota h4logtota h4itot h4ashitot h4logitot h4pctstck
  h4pctchck h4pctcd h4pctbond h4pctrles h4pctbsns;

proc sort; by cohort;
proc means; by cohort;
var h4atota h4ashtota h4itot h4ashitot h4pctchck risk
  r4liv85r;
format cohort cohortf.;

proc freq;
where r4inscat=1 and cohort ne 1;
tables risk*r4hmo;

proc freq;
where cohort ne 1;
tables risk*smoke;
format smoke smokef.;

proc freq;
tables r4inscat*r4hmo ragender*r4inscat r4marr*r4inscat
 ragender*r4marr*r4inscat;
format r4inscat catf. ragender gender. r4marr marrf.;


*change self-reported health to set of dummies?;
*figure out why no valid data on r4liv85r and add back in--in w4,
 question skipped if R older than 65 (see RAND HRS documentation);
*omitting r4cesd for now due to missing data--impute and add dummy;
*should income and wealth imputes have dummy?;
*add weights;
*missing values are coming from portfolio share vars that condition on
 positive financial assets;

proc freq;
tables cohort*(r4hmo r4inscat risk);
format cohort cohortf.;

proc freq;
where r4inscat=1;
tables cohort*(r4hmo);
format cohort cohortf.;


proc reg;
model h4ashchck=&riskvars;
proc reg;
model h4ashstck=&riskvars;

************************************************************;
*NONLINEAR MODELS of HMO CHOICE;

proc sort; by r4inscat;

/*
*not right: want categorical vars, not dummies on class statement;
proc probit;
  where cohort ne 1 and r4inscat=1;
  class r4hmo r4marr male rablack rahisp raother &labsup;
  model r4hmo = r4marr male r4agey_e r4agesq rablack rahisp
        raother h4ashtota h4ashitot h4pctchck r4shlt
        r4iadlza r4adla r4conde &labsup;
  format r4inscat catf.;
run;
*/

proc logistic descending;
  where r4inscat=1; *mcare only, no cohort restriction;
  model r4hmo = r4marr male r4agey_e r4agesq rablack rahisp
        raother h4ashtota h4ashitot r4shlt;
  format r4inscat catf.;
run;

proc logistic descending;
  where cohort ne 1 and r4inscat=1; *mcare only, drop ahead cohort;
  model r4hmo = r4marr male r4agey_e r4agesq rablack rahisp
        raother h4ashtota h4ashitot r4shlt;
  format r4inscat catf.;
run;

proc logistic descending;
  where r4inscat=1; *mcare only, no cohort restriction;
  model r4hmo = r4marr male r4agey_e r4agesq rablack rahisp
        raother h4ashtota h4ashitot h4ashchck &riskvars r4shlt
        r4iadlza r4adla r4conde &labsup;
  format r4inscat catf.;
run;

/*
*redundant: including risk vars is equivalent to dropping ahead cohort;
proc logistic descending;
  where cohort ne 1 and r4inscat=1; *drop ahead cohort;
  model r4hmo = r4marr male r4agey_e r4agesq rablack rahisp
        raother h4ashtota h4ashitot h4ashchck &riskvars r4shlt
        r4iadlza r4adla r4conde &labsup;
  format r4inscat catf.;
run;
*/

*no portfolio vars, just risk vars;
proc logistic descending;
  where r4inscat=1; *mcare only, no cohort restriction;
  model r4hmo = r4marr male r4agey_e r4agesq rablack rahisp
        raother h4ashtota h4ashitot
        &riskvars r4shlt r4iadlza r4adla r4conde &labsup;
  format r4inscat catf.;
run;

*no risk vars, just portfolio vars--implicitly brings back ahead?;
proc logistic descending;
  where r4inscat=1; *mcare only, no cohort restriction;
  model r4hmo = r4marr male r4agey_e r4agesq rablack rahisp
        raother h4ashtota h4ashitot h4ashstck
        r4shlt r4iadlza r4adla r4conde &labsup;
  format r4inscat catf.;
run;


*include asinh values of checking, stocks and debt;
proc logistic descending;
  where r4inscat=1; *mcare only, no cohort restriction;
  model r4hmo = r4marr male r4agey_e r4agesq rablack rahisp
        raother h4ashtota h4ashitot h4ashchck h4ashstck
        &riskvars r4shlt r4iadlza r4adla r4conde &labsup;
  format r4inscat catf.;
run;



endsas;
****************************************************************;
*LINEAR MODELS;
proc sort; by r4inscat;
proc glm;
  where cohort ne 1; /*drop ahead cohort, cuts sample by ~5000*/
  by r4inscat;
  model r4hmo = r4marr male r4agey_e r4agesq rablack rahisp
        raother h4ashtota h4ashitot h4pctchck h4pctdebt r4shlt
        r4iadlza r4adla r4conde &labsup;
  format r4inscat catf.;
run;

proc glm;
      where r4inscat=1;
      model r4hmo = r4marr ;
      format r4inscat catf.;
   run;

/*
proc glm;
      by r4inscat;
      model r4hmo = r4marr male rablack rahisp raother r4age_yr
        h4atota h4itot r4shlt;
      format r4inscat catf.;
   run;
*/

endsas;

proc summary data=age65;
class r4inscat r4marr ragender;
var r4hmo;
output out=save1 mean=;
proc print data=save1;
var r4inscat r4marr ragender _freq_ r4hmo;
format r4inscat catf. ragender gender. r4marr marrf.;

proc summary data=age65;
class r4inscat rahispan ragender;
var r4hmo;
output out=save2 mean=;
proc print data=save2;
var r4inscat rahispan ragender _freq_ r4hmo;
format r4inscat catf. ragender gender. rahispan hispanic.;

proc summary data=age65;
class r4inscat raracem ragender;
var r4hmo;
output out=save3 mean=;
proc print data=save3;
var r4inscat raracem ragender _freq_ r4hmo;
format r4inscat catf. ragender gender. raracem racem.;

proc summary data=age65;
class r4inscat raeduc ragender;
var r4hmo;
output out=save4 mean=;
proc print data=save4;
var r4inscat raeduc ragender _freq_ r4hmo;
format r4inscat catf. raeduc educ. ragender gender.;

proc summary data=age65;
class r4inscat r4shlt ragender;
var r4hmo;
output out=save5 mean=;
proc print data=save5;
var r4inscat r4shlt ragender _freq_ r4hmo;
format r4inscat catf. r4shlt shlt. ragender gender.;

proc summary data=age65;
class r4inscat r4age_yr ragender;
var r4hmo;
format r4age_yr agef.;
output out=save6 mean=;
proc print data=save6;
var r4inscat r4age_yr ragender _freq_ r4hmo;
format r4inscat catf. r4shlt shlt. r4age_yr agef.;

proc summary data=age65;
where r4marr=1;
class r4inscat s4age65x;
var r4hmo;
output out=save7 mean=;
proc print data=save7;
var r4inscat s4age65x _freq_ r4hmo;
format r4inscat catf. s4age65x age65f. r4age_yr agef.;


endsas;

proc freq;
   table infrom in00w in00i in00res inw5 g482 gfinr gr_inhh*gn_inhh
         r5proxy r5iwend raovrlap ragender ragendrf rabyear rabflag
         raeduc raedyrs raedegrm raedegrf raracem rahispan
         %wvlist(r,mstat shlt) r5hltc
         h1af: r1if: s1if: h1if:
         h2af: r2if: s2if: h2if:
         h3af: r3if: s3if: h3if:
         h4af: r4if: s4if: h4if:
         h5af: r5if: s5if: h5if:
         %wvlist(r,work lbrf sayret retsat ryrcmp rbadin) rarbadin
         %wvlist(s,gender shlt work lbrf sayret)
         %wvlist(r,inscat getsps mdcr mdcd part anycov esup eprm
         empins age65 hmo insctx eprhmo, begwv=4, endwv=4)
         %wvlist(s,inscat getsps mdcr mdcd part anycov esup eprm
         empins age65 hmo insctx eprhmo, begwv=4, endwv=4)
         ;
format r5iwend monyy5. g482 cohort. ;
format raracem racem. rahispan hispanic. rabflag rabflag.
       raeduc educ. raedyrs edyrs. raedegrm edegrm. raedegrf edegrf.
       r5mstat mstatus. ragender gender. ragendrf gendrf.
       r5proxy proxy. r5shlt shlt. r5hltc hltc. r5work work. ;
format h1af: h2af: h3af: h4af: h5af: assetf.
       r1if: r2if: r3if: r4if: r5if: s1if: s2if: s3if: s4if: s5if: h5if:
       incf.;
format %wvlist(r,retsat) retsat. %wvlist(r,ryrcmp) ryrcmp.
       %wvlist(r,rbadin) rarbadin rbad. %wvlist(r,sayret) sayret.;
run;
proc means data=out.h00;
   var rabyear %wvlist(r,retmon retyr rplnyr) r1rplnya
       %wvlist(r,rplnya,begwv=3)
       %wvlist(s,hhidpn byear agey_e retmon retyr rplnyr) s1rplnya
       %wvlist(s,rplnya,begwv=3)
       h5a: i5a:
       r5i: s5i: h5i: ir5: is5: ih5:
       w5: x5: y5:
       r4age_yr r4wgthh;
run;




