/*
Nicole Maestas
November 18, 2002

This program works with h00.sas7bdat data file, which contains health
insurance vars from the RAND Flat File merged with RAND HRS data for
all cohorts (HRS, AHEAD, War Babies, CODA) and all waves. This data
file was created by program h00.sas.

Although my health insurance vars are coded (and only relevant) for
those age 65+, the other data files contain data on everyone. Must
re-invoke age selection. Best var to use is my age_yr var, for
consistency with sample selection used for health insurance vars.

Note sample conditions on those making it to Wave 5.
Note sample of interest is HRS 1998.

Note this is a respondent level file with spouse info on each record,
which means married households are in the file twice, once for each spouse.
Except spouse as respondent won't be on the file if younger than 65.
*/

options linesize=120 pagesize=60 compress=no nocenter replace mprint
 nodate nonumber formdlim=' ';

%let fmtlib=/homer/a/Retire/Pgmlib00c/Fmt/;

%let fmtlib=/homer/d/RANDHRS/VerC/Sas8/; *has formats.sas7bdat;
libname library  "&fmtlib"; 


libname out '/zeno/a/baoping/HRS';

%include "/homer/a/Retire/Pgmlib00a/Mac/wvlist.mac";
%include "/homer/a/Retire/Pgmlib00a/Mac/wvlabel.mac";
%include "/homer/a/Retire/Pgmlib00a/Mac/addsp.mac";

proc format;
   %include "/zeno/b/maestas/hmo/h00.fmt";

%macro asinh(invar,outvar);
  &outvar=log( &invar + (sqrt((&invar**2) + 1)) );
%mend;

%macro sinh(invar,outvar);
  &outvar=.5*( exp(&invar)-exp(-&invar) );
%mend;
run;


data out.ageall98;
set out.h00;

*IMPOSE AGE 65 RESTRICTION;
*some discrepancies in age vars between flat file and rand hrs files;
*if r4age65=1; /*based on flat file var coded in hinsur1.sas*/
*if r4agey_e>=65; /*rand hrs var--age at end of interview*/

s4age65x=(s4agey_e>=65); /*s4age65 is version based on flat file*/
r4age65x=(r4agey_e>=65); /*r4age65 is version based on flat file*/

*age squared;
r4agesq=r4agey_e**2;
s4agesq=s4agey_e**2;

r1valid=(r1risk>0);

/*
proc freq;
tables cohort*(r4valid r2valid r5valid r1valid) r4riske r4risk
 r5riske r5risk r2riske r2risk r1risk;
format cohort cohortf.;
*/

*dummy for married at wave 4;
r4marr=(r4mstat<=3);
male=(ragender=1);


*race dummies;
*need to deal with missing on raracem;
rahisp=(rahispan=1);
rablack=(rahispan<=0 and raracem=2);
raother=(rahispan<=0 and raracem=3);
rawhite=(rahispan<=0 and raracem=1);
chkrace=rahisp+rablack+raother+rawhite;

*r4smoking vars;
if r4smoken=1 then r4smoke=2; *smoke now;
else if r4smokev=1 and r4smoken=0 then r4smoke=1; *smoked, but quit;
else if r4smokev=0 then r4smoke=0; *never smoked;

*r5smoking vars;
if r5smoken=1 then r5smoke=2; *smoke now;
else if r5smokev=1 and r5smoken=0 then r5smoke=1; *smoked, but quit;
else if r5smokev=0 then r5smoke=0; *never smoked;

*combine risk vars: hrs cohort has r1risk and coda/wb cohort has r4risk;
*these risk vars do not exist for ahead cohort;
if r1risk ne . then risk=r1risk;
else risk=r4risk;

*risk dummies;
if risk ne . then do;
 rskav4=(risk=4); /*most risk averse*/
 rskav3=(risk=3);
 rskav2=(risk=2);
 rskav1=(risk=1); /*least risk averse*/
end;

%let riskvars=rskav4 rskav3 rskav2; /*ref group is least risk averse*/

*labor supply dummies, mutually exclusive;
r4wkft=(r4lbrf=1);
r4wkpt=(r4lbrf=2);
r4ptret=(r4lbrf=4);
r4ret=(r4lbrf=5);
r4disab=(r4lbrf=6);
r4notwkr=(r4lbrf in (3,7)); /*includes 34 unemployed obs*/

proc means;

endsas;

proc freq;
tables any:;

proc means;
var risky: safe:;

proc univariate;
*useful bc tells fraction missing;
var totfass: riskass: safeass risky: safe:;


%let labsup=wkft wkpt ptret ret disab; /*ref group is notwkr*/

proc format;
value smokef
0='never smoked'
1='quit smoking'
2='smokes now'
;

******************************************************;

proc freq;
tables r4marr male r4agey_e r4agesq rablack rahisp
  raother r4shlt r4iadlza r4adla r4conde r4cesd &labsup notwkr;
format r4shlt shlt.;

proc freq;
tables chkrace risk risk*cohort  r1risk*cohort r4age65x /missing;
format cohort cohortf.;

proc univariate;
var h4atota h4ashtota h4logtota h4itot h4ashitot h4logitot h4pctstck
  h4pctchck h4pctcd h4pctbond h4pctrles h4pctbsns;

proc sort; by cohort;
proc means; by cohort;
var h4atota h4ashtota h4itot h4ashitot h4pctchck risk
  r4liv85r;
format cohort cohortf.;

proc freq;
where r4inscat=1 and cohort ne 1;
tables risk*r4hmo;

proc freq;
where cohort ne 1;
tables risk*smoke;
format smoke smokef.;

proc freq;
tables r4inscat*r4hmo ragender*r4inscat r4marr*r4inscat
 ragender*r4marr*r4inscat;
format r4inscat catf. ragender gender. r4marr marrf.;


*change self-reported health to set of dummies?;
*figure out why no valid data on r4liv85r and add back in--in w4,
 question skipped if R older than 65 (see RAND HRS documentation);
*omitting r4cesd for now due to missing data--impute and add dummy;
*should income and wealth imputes have dummy?;
*add weights;
*missing values are coming from portfolio share vars that condition on
 positive financial assets;

proc freq;
tables cohort*(r4hmo r4inscat risk);
format cohort cohortf.;

proc freq;
where r4inscat=1;
tables cohort*(r4hmo);
format cohort cohortf.;


proc reg;
model h4ashchck=&riskvars;
proc reg;
model h4ashstck=&riskvars;

************************************************************;
*NONLINEAR MODELS of HMO CHOICE;

proc sort; by r4inscat;

/*
*not right: want categorical vars, not dummies on class statement;
proc probit;
  where cohort ne 1 and r4inscat=1;
  class r4hmo r4marr male rablack rahisp raother &labsup;
  model r4hmo = r4marr male r4agey_e r4agesq rablack rahisp
        raother h4ashtota h4ashitot h4pctchck r4shlt
        r4iadlza r4adla r4conde &labsup;
  format r4inscat catf.;
run;
*/

proc logistic descending;
  where r4inscat=1; *mcare only, no cohort restriction;
  model r4hmo = r4marr male r4agey_e r4agesq rablack rahisp
        raother h4ashtota h4ashitot r4shlt;
  format r4inscat catf.;
run;

proc logistic descending;
  where cohort ne 1 and r4inscat=1; *mcare only, drop ahead cohort;
  model r4hmo = r4marr male r4agey_e r4agesq rablack rahisp
        raother h4ashtota h4ashitot r4shlt;
  format r4inscat catf.;
run;

proc logistic descending;
  where r4inscat=1; *mcare only, no cohort restriction;
  model r4hmo = r4marr male r4agey_e r4agesq rablack rahisp
        raother h4ashtota h4ashitot h4ashchck &riskvars r4shlt
        r4iadlza r4adla r4conde &labsup;
  format r4inscat catf.;
run;

/*
*redundant: including risk vars is equivalent to dropping ahead cohort;
proc logistic descending;
  where cohort ne 1 and r4inscat=1; *drop ahead cohort;
  model r4hmo = r4marr male r4agey_e r4agesq rablack rahisp
        raother h4ashtota h4ashitot h4ashchck &riskvars r4shlt
        r4iadlza r4adla r4conde &labsup;
  format r4inscat catf.;
run;
*/

*no portfolio vars, just risk vars;
proc logistic descending;
  where r4inscat=1; *mcare only, no cohort restriction;
  model r4hmo = r4marr male r4agey_e r4agesq rablack rahisp
        raother h4ashtota h4ashitot
        &riskvars r4shlt r4iadlza r4adla r4conde &labsup;
  format r4inscat catf.;
run;

*no risk vars, just portfolio vars--implicitly brings back ahead?;
proc logistic descending;
  where r4inscat=1; *mcare only, no cohort restriction;
  model r4hmo = r4marr male r4agey_e r4agesq rablack rahisp
        raother h4ashtota h4ashitot h4ashstck
        r4shlt r4iadlza r4adla r4conde &labsup;
  format r4inscat catf.;
run;


*include asinh values of checking, stocks and debt;
proc logistic descending;
  where r4inscat=1; *mcare only, no cohort restriction;
  model r4hmo = r4marr male r4agey_e r4agesq rablack rahisp
        raother h4ashtota h4ashitot h4ashchck h4ashstck
        &riskvars r4shlt r4iadlza r4adla r4conde &labsup;
  format r4inscat catf.;
run;



endsas;
****************************************************************;
*LINEAR MODELS;
proc sort; by r4inscat;
proc glm;
  where cohort ne 1; /*drop ahead cohort, cuts sample by ~5000*/
  by r4inscat;
  model r4hmo = r4marr male r4agey_e r4agesq rablack rahisp
        raother h4ashtota h4ashitot h4pctchck h4pctdebt r4shlt
        r4iadlza r4adla r4conde &labsup;
  format r4inscat catf.;
run;

proc glm;
      where r4inscat=1;
      model r4hmo = r4marr ;
      format r4inscat catf.;
   run;

/*
proc glm;
      by r4inscat;
      model r4hmo = r4marr male rablack rahisp raother r4age_yr
        h4atota h4itot r4shlt;
      format r4inscat catf.;
   run;
*/

endsas;

proc summary data=age65;
class r4inscat r4marr ragender;
var r4hmo;
output out=save1 mean=;
proc print data=save1;
var r4inscat r4marr ragender _freq_ r4hmo;
format r4inscat catf. ragender gender. r4marr marrf.;

proc summary data=age65;
class r4inscat rahispan ragender;
var r4hmo;
output out=save2 mean=;
proc print data=save2;
var r4inscat rahispan ragender _freq_ r4hmo;
format r4inscat catf. ragender gender. rahispan hispanic.;

proc summary data=age65;
class r4inscat raracem ragender;
var r4hmo;
output out=save3 mean=;
proc print data=save3;
var r4inscat raracem ragender _freq_ r4hmo;
format r4inscat catf. ragender gender. raracem racem.;

proc summary data=age65;
class r4inscat raeduc ragender;
var r4hmo;
output out=save4 mean=;
proc print data=save4;
var r4inscat raeduc ragender _freq_ r4hmo;
format r4inscat catf. raeduc educ. ragender gender.;

proc summary data=age65;
class r4inscat r4shlt ragender;
var r4hmo;
output out=save5 mean=;
proc print data=save5;
var r4inscat r4shlt ragender _freq_ r4hmo;
format r4inscat catf. r4shlt shlt. ragender gender.;

proc summary data=age65;
class r4inscat r4age_yr ragender;
var r4hmo;
format r4age_yr agef.;
output out=save6 mean=;
proc print data=save6;
var r4inscat r4age_yr ragender _freq_ r4hmo;
format r4inscat catf. r4shlt shlt. r4age_yr agef.;

proc summary data=age65;
where r4marr=1;
class r4inscat s4age65x;
var r4hmo;
output out=save7 mean=;
proc print data=save7;
var r4inscat s4age65x _freq_ r4hmo;
format r4inscat catf. s4age65x age65f. r4age_yr agef.;


endsas;

proc freq;
   table infrom in00w in00i in00res inw5 g482 gfinr gr_inhh*gn_inhh
         r5proxy r5iwend raovrlap ragender ragendrf rabyear rabflag
         raeduc raedyrs raedegrm raedegrf raracem rahispan
         %wvlist(r,mstat shlt) r5hltc
         h1af: r1if: s1if: h1if:
         h2af: r2if: s2if: h2if:
         h3af: r3if: s3if: h3if:
         h4af: r4if: s4if: h4if:
         h5af: r5if: s5if: h5if:
         %wvlist(r,work lbrf sayret retsat ryrcmp rbadin) rarbadin
         %wvlist(s,gender shlt work lbrf sayret)
         %wvlist(r,inscat getsps mdcr mdcd part anycov esup eprm
         empins age65 hmo insctx eprhmo, begwv=4, endwv=4)
         %wvlist(s,inscat getsps mdcr mdcd part anycov esup eprm
         empins age65 hmo insctx eprhmo, begwv=4, endwv=4)
         ;
format r5iwend monyy5. g482 cohort. ;
format raracem racem. rahispan hispanic. rabflag rabflag.
       raeduc educ. raedyrs edyrs. raedegrm edegrm. raedegrf edegrf.
       r5mstat mstatus. ragender gender. ragendrf gendrf.
       r5proxy proxy. r5shlt shlt. r5hltc hltc. r5work work. ;
format h1af: h2af: h3af: h4af: h5af: assetf.
       r1if: r2if: r3if: r4if: r5if: s1if: s2if: s3if: s4if: s5if: h5if:
       incf.;
format %wvlist(r,retsat) retsat. %wvlist(r,ryrcmp) ryrcmp.
       %wvlist(r,rbadin) rarbadin rbad. %wvlist(r,sayret) sayret.;
run;
proc means data=out.h00;
   var rabyear %wvlist(r,retmon retyr rplnyr) r1rplnya
       %wvlist(r,rplnya,begwv=3)
       %wvlist(s,hhidpn byear agey_e retmon retyr rplnyr) s1rplnya
       %wvlist(s,rplnya,begwv=3)
       h5a: i5a:
       r5i: s5i: h5i: ir5: is5: ih5:
       w5: x5: y5:
       r4age_yr r4wgthh;
run;




