/*
Nicole Maestas
October 21, 2002
Codes Medicare insurance status for sample age 65 and over
Modification of Program by Julie Zissimopoulos
*/

options linesize=120 pagesize=60 compress=yes nocenter replace;
* nodate nonumber
 mprint formdlim=' ';

libname dirnm '/zeno/a/baoping/HRS';

data dirnm.step200; 
set dirnm.step100;

/*note mcrsup is those with individual medigap policies, whereas
 mdgap is those with a medigap policy thru their employer. in the case
 of the latter, better to use empins, since not all employer policies
 will be of the medigap form;
 add to mcrsup those self-employed with insurance thru business and
 ignore jz's 'othrins' variable since skip patterns omit that question
 for those with medicare, medicaid, champus or any employer
 policy (medigap/nonmedigap) */;

if semp_ins=1 then mcrsup=1;

*dummy for currently receiving medicaid;
mdcd=(mdcd_nw=1);

*98.7% of 65+ pop have some form of coverage, including medicare,
 medicaid, employer-based insurance, champus/military,
 supplemental/medigap, or other individually purchased insurance. note
 that none of the non-medicare categories are redundant with medicare
 in the data;
*95.5% of 65+ pop has Medicare. Most of the difference from percent
 with any coverage is people age 65+ reporting employer
 coverage but no medicare; 

anycov=(mdcr or mcrsup or empins or champus or mdcd or othrins);
 
*proc freq;
*tables mdcr anycov mcrsup mdcr*(mdcd champus mcrsup);

*medicare part A and B coverage;

if mdcr=1 then do;
 if mdcrb=0 then part=1; *part A only;
 else if mdcrb=1 then part=2; *A and B;
 else if mdcrb=. then part=3; *does not know B;
else part=.;
end;

*dummy for those with both medicare and medicaid;

if mdcr=1 and mdcd=1 then mdcrcd=1;
else if mdcr=1 and mdcd=0 then mdcrcd=0;

*about 300 don't knows on the medicare hmo question. revise hmo_cdcr
such that those in medicare but answering dk if hmo are coded as no
hmo. note missing on mdcrcd gets those either not in or missing on
medidcare question;

if mdcr<=0 then hmo_cdcr=.;
else if hmo_cdcr=. then hmo_cdcr=0;

*proc freq;
*tables mdcr*mdcrb part /missing;


*DETERMINE MEDICARE SUPPLEMENTAL STATUS;

*mdgap variable gives whether employer insurance is primary or
supplementary. hmo status was not asked if answer to mdgap was
missing. if the employer is supplementary, then hmo question is not
relevant (and was not asked). if employer is primary, then hmo
question is relevant. assume that if getting coverage through current
employer, the employer coverage is primary (medicare is secondary). if
getting it through former employer, then assume employer is secondary
(medicare is primary). most missing on mdgap are due to fact that
those getting coverage through spouse were skipped out of the
sequence. this suggests could pick up hmo status from spouse's
record. note that most of this group will be classified as having
supplemental coverage through spouse's former employer, so hmo status
will not be relevant. for only 121 obs will i need to go to the
spouse's record for hmo status (counts are conditional on having
medicare);

*make dummies taking into account missing values;
*note these vars are conditional on medicare status since only those
with medicare were asked if employer policy a supplement (mdgap var);

if empins=1 and mdgap=1 then esup=1;
else if empins=1 and mdgap=0 then esup=0; 

if empins=1 and mdgap=0 then eprm=1;
else if empins=1 and mdgap=1 then eprm=0;

*augment esup and eprm with inference about those missing mdgap based
on source of coverage. note get valid esup/eprm coding for all but 10
obs reporting employer insurance;

if mdgap=. then do;
  if whosemp in (1,4,7,9) then do;
    eprm=1; *insur thru current empl;
    esup=0;
  end;
  else if whosemp in (2,3,5,6,8) then do;
    esup=1; *insur thru former empl; 
    eprm=0;
  end;
end;

*label for hmo_mdgp is incorrect, should be "employer coverage an hmo?";

*hmo status for those with employer primary. assumes if dk, then not
in hmo. note 'no hmo' category also includes 121 obs missing hmo
status because need to get from spouse's record after merge
files. check by tabbing eprmhmo by getsps (created below);

if eprm=1 and hmo_mdgp=1 then eprmhmo=1;
else if eprm=1 and hmo_mdgp<=0 then eprmhmo=0; 

*flag obs needing hmo status from spouses record--use getsps. note
these obs currently coded as no on hmo status (eprmhmo=0). go back and
recode once merge files ;
*obs getting employer insur who were skipped out of employer
supp/medigap question bc get it thru spouse and therefore were not
asked hmo question. misshmo does not distinguish btwn those getting
insurance through spouse's current or former employer, which
determines whether need to go to spouse's record for hmo
status. getsps takes this last step and flags subset of obs getting
insurance through spouse's current employer which by assumption deems
the employer primary and hmo status relevant;

misshmo=(empins=1 and mdgap=. and hmo_mdgp=. and whosemp in (4,5,6));
getsps=(misshmo and eprm); *key var;

*all obs getting any insur thru spouse. not useful variable for this
analysis since has excess obs on account of not excluding those who
were asked mdgap question but and answered dk. also doesn't condition
on medicare status;

esps=(whosemp in (4,5,6));

*individual medigap insurance. question not asked if reports employer
supplemental insurance. those with employer primary or no employer
insurance were asked about individual medigap;

isup=(mcrsup=1);

*confirm who was asked about individual medigap (isup);

if empins=1 and mdgap<=0 then askisup=1;
else if empins<=0 then askisup=1;
else if empins=1 and mdgap=1 then askisup=0;

if esup=1 and isup=1 then twosups=1;
else if (esup=1 and isup=0) or esup=0 then twosups=0;

*have 171 people with both isup and esup. problem stems from use of
whosemp to determine sup/nonsup status. all but 7 get employer
insurance through their spouse. note all 171 are on medicare, and 163
get insurance through spouse's former employer. problem with using
this information is that those getting employer insurance on their own
record (as opposed to their spouse's) were directly asked whether the
insurance was primary or supplementary. if they answered
supplementary, they were not asked if they also have individual
medigap. on the other hand, those who did not answer whether the
insurance was primary or supplementary (because getting it through
spouse) were skipped into the question about individual medigap. thus
the presence of two supplements will misleadingly vary by whether one
gets insurance through self or spouse. i will let employer supp
dominate individual supp insurance for the purposes of classifying
obs, and will consider that we just don't have complete information
about the extent to which people hold multiple (and possibly
redundant) supplemental coverages. note it would not be helpful to go
back to spouse's record for information about primary/secondary status
of employer insurance because all obs are on medicare, so either way,
the individual coverage appears redundant;

*for people without medicare or medicaid, whether have individual
primary insurance, and if so if through hmo. note 6 people have both
individual primary and individual supplementary. this is ok.;

iprm=(othrins=1); 
iprmhmo=(hmo_othr=1);


*insurance status in four categories, doesn't distinguish whether
employer insurance is supplementary or primary;
*hierarchy for those reporting multiple sources is medicaid, employer
insurance, individual supp;

if mdcr=1 then do;
  if mdcrcd=1 then inscat=4; *mcare + mdcaid;
  else if empins=1 then inscat=2; *mcare + employer ins;
  else if isup=1 then inscat=3; *mcare + indiv supp;
  else inscat=1; *mcare only;
end;

*five categories, breaks out employer insurance by primary or
supplementary. note this variable is not complete yet as it needs to
be updated by the spouse's record. coding for inscatx=5 reflects
allocation of 10 obs reporting employer insurance but not
supplementary/primary status to employer primary. note for inscatx=2
don't need to condition on empins=1 since esup already does this;

if mdcr=1 then do;
  if mdcrcd=1 then inscatx=4; *mcare + mdcaid;
  else if esup=1 then inscatx=2; *mcare + employer supp;
  else if empins=1 and esup<=0 then inscatx=5; *mcare + employer primary;
  else if isup=1 then inscatx=3; *mcare + indiv supp;
  else inscatx=1; *mcare only;
end;

*RENAME VARS to R5 PREFIX;
*rename key vars to r5 prefix in order to merge with demoraphic data
from patty's files, and create spouse file;

%macro rename;
%let vars=inscat getsps mdcr mdcd part anycov esup eprm empins age_yr age65;
%let i=1;
%let nxtv=%scan(&vars,&i);
%do %while (%length(&nxtv)>0);
  r5&nxtv=&nxtv;  
  %let i=%eval(&i+1);
  %let nxtv=%scan(&vars,&i);
%end;
%mend;

%rename;
*process vars with long names outside of the macro;
r5hmo=hmo_cdcr;
r5insctx=inscatx;
r5eprhmo=eprmhmo;
r5wgthh=gwgthh;
r5wgtr=gwgtr;
r5whoemp=whosemp;
r5mcrsup=mcrsup;

*r5emppay=empin_py;
*r5empamt=empin_am;
*r5empper=empin_pr;

*FORMATS;
proc format;
  value catf
    1='mcare only'
    2='mcare + employer ins'
    3='mcare + indiv supp'
    4='mcare + mdcaid'
    ;

  value catxf
    1='mcare only'
    2='mcare + employer supp'
    3='mcare + indiv supp'
    4='mcare + mdcaid'
    5='mcare + employer prim'
    ;

 value cohortf
    1='Ahead'
    2='CODA'
    3='HRS'
    4='War Babies'
    ;

proc contents;
proc means;

endsas;

/*
*check missing values on risk vars for coda cohort--about 18 percent
missing, but mostly due to item nonresponse;
proc freq;
where cohort=2;
tables F4614 F4615 F4616 F4617 F4618;

proc freq;
tables cohort*(r4valid r2valid r5valid) r4rndm*r4valid r4riske r4risk
 r5riske r5risk r2riske r2risk r4riske*r4risk r5riske*r5risk
 r2riske*r2risk;
format cohort cohortf.;

proc freq;
where age65=1;
tables r4valid r2valid r5valid cohort*(r4valid r2valid r5valid);
format cohort cohortf.;
*/


 
*check coding of inscat and inscatx;
/*
proc freq;
where inscatx=5 and hmo_cdcr=1;
tables getsps;
proc freq;
tables  mdcd*mdcr*empins mdcd*mdcr*esup*isup /missing;
*/

proc freq;
tables anycov*(nohinsr hashins1 hashins2) eprm*hmo_mdgp /missing;
proc freq;
tables hmo_cdcr*wdrw_hmo;

proc freq;
tables inscat*hmo_cdcr inscatx*hmo_cdcr;
format inscat catf. inscatx catxf.;

proc freq;
tables mdcr mdcrcd hmo_cdcr empins esup*eprm eprmhmo eprm*eprmhmo
eprmhmo*getsps isup esup*isup isup*iprm iprmhmo part /missing;

*proc freq;
*tables twosups*esps whosemp*twosups askisup*isup esup*isup eprm*misshmo
 /missing;


